/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.BytecodeFragments;
import dioscuri.module.cpu32.ClassFile;
import dioscuri.module.cpu32.ConstantPoolSymbol;
import dioscuri.module.cpu32.CountingOutputStream;
import dioscuri.module.cpu32.ExceptionHandler;
import dioscuri.module.cpu32.JavaOpcode;
import dioscuri.module.cpu32.MicrocodeNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public abstract class RPNNode {
    private int id;
    private int count;
    private int useCount;
    private int subtreeIndex;
    private List<RPNNode> argLinks;
    private int writeCount = 0;
    private int writeCountMax = 0;
    private int[] writeCountIndex = new int[100];
    private MicrocodeNode parent;
    private ExceptionHandler exceptionHandler;
    private static int counter = 0;
    private boolean reset;

    public RPNNode(int n, MicrocodeNode microcodeNode) {
        this.id = n;
        this.parent = microcodeNode;
        this.useCount = 0;
        this.subtreeIndex = -1;
        this.argLinks = new Vector<RPNNode>();
        this.count = counter++;
        this.writeCount = 0;
        this.writeCountMax = 0;
    }

    public abstract boolean hasExternalEffect();

    public abstract boolean canThrowException();

    protected abstract Object[] getByteCodes();

    public int getX86Index() {
        return this.parent.getX86Index();
    }

    public int getX86Position() {
        return this.parent.getX86Position();
    }

    public int getImmediate() {
        return this.parent.getImmediate();
    }

    public boolean hasImmediate() {
        return this.parent.hasImmediate();
    }

    public int getID() {
        return this.id;
    }

    public int getMicrocode() {
        if (this.parent == null) {
            return -1;
        }
        return this.parent.getMicrocode();
    }

    public boolean hasLinks() {
        return this.argLinks.size() > 0;
    }

    public void linkTo(RPNNode rPNNode) {
        this.argLinks.add(rPNNode);
    }

    public int markSubtrees(int n) {
        ++this.useCount;
        if (this.id != 43 && this.id != 44 && this.id != 45 && this.subtreeIndex < 0 && (this.useCount > 1 || this.hasExternalEffect())) {
            if (n == 256) {
                throw new IllegalStateException("Compilation ran out of local variables");
            }
            this.subtreeIndex = n++;
        }
        if (this.useCount == 1) {
            for (int i = 0; i < this.argLinks.size(); ++i) {
                n = this.argLinks.get(i).markSubtrees(n);
            }
        }
        return n;
    }

    public void attachExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void print(String string) {
        System.out.println(string + "[" + this.id + "] by " + MicrocodeNode.getName(this.getMicrocode()) + "  {" + this.count + " used " + this.useCount + "}");
        if (this.argLinks.size() == 0) {
            return;
        }
        System.out.println(string + "{");
        for (int i = 0; i < this.argLinks.size(); ++i) {
            this.argLinks.get(i).print(string + " ");
        }
        System.out.println(string + "}");
    }

    public void print() {
        this.print("");
    }

    public static void writeBytecodes(CountingOutputStream countingOutputStream, ClassFile classFile, Object[] objectArray) throws IOException {
        int n = -1;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof Integer) {
                n = (Integer)object;
                if (i + 1 < objectArray.length && (object = objectArray[i + 1]) instanceof ConstantPoolSymbol) {
                    int n2 = classFile.addToConstantPool(((ConstantPoolSymbol)object).poolEntity());
                    if (n2 > 255 && n == 18) {
                        n = 19;
                    }
                    countingOutputStream.write(n);
                    switch (JavaOpcode.getConstantPoolIndexSize(n)) {
                        case 1: {
                            countingOutputStream.write(n2 & 0xFF);
                            break;
                        }
                        case 2: {
                            countingOutputStream.write(n2 >>> 8);
                            countingOutputStream.write(n2 & 0xFF);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    ++i;
                    continue;
                }
                countingOutputStream.write(n);
                continue;
            }
            throw new IllegalStateException(object.toString() + "    " + BytecodeFragments.X86LENGTH + "     " + BytecodeFragments.IMMEDIATE);
        }
    }

    public void write(CountingOutputStream countingOutputStream, ClassFile classFile, boolean bl) throws IOException {
        this.reset = false;
        ++this.writeCount;
        try {
            this.writeCountIndex[this.writeCount] = countingOutputStream.position();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int[] nArray = new int[this.writeCountIndex.length * 2];
            System.arraycopy(this.writeCountIndex, 0, nArray, 0, this.writeCountIndex.length);
            nArray[this.writeCount] = countingOutputStream.position();
            this.writeCountIndex = nArray;
        }
        this.writeCountMax = Math.max(this.writeCountMax, this.writeCount);
        if (this.writeCount == 1 || this.subtreeIndex < 0 || this.subtreeIndex > 255) {
            int n;
            if (this.writeCount > 1 && (this.id == 43 || this.id == 44 || this.id == 45)) {
                return;
            }
            for (n = 0; n < this.argLinks.size(); ++n) {
                this.argLinks.get(n).write(countingOutputStream, classFile, true);
            }
            n = countingOutputStream.position();
            RPNNode.writeBytecodes(countingOutputStream, classFile, this.getByteCodes());
            int n2 = countingOutputStream.position();
            if (this.exceptionHandler != null) {
                this.exceptionHandler.assignRange(n, n2);
            }
            if (this.subtreeIndex >= 0 && this.subtreeIndex <= 255) {
                switch (this.id) {
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 37: 
                    case 42: {
                        if (bl) {
                            countingOutputStream.write(89);
                            countingOutputStream.write(58);
                            countingOutputStream.write(this.subtreeIndex);
                            break;
                        }
                        countingOutputStream.write(58);
                        countingOutputStream.write(this.subtreeIndex);
                        break;
                    }
                    default: {
                        if (bl) {
                            countingOutputStream.write(89);
                            countingOutputStream.write(54);
                            countingOutputStream.write(this.subtreeIndex);
                            break;
                        }
                        countingOutputStream.write(54);
                        countingOutputStream.write(this.subtreeIndex);
                    }
                    case 43: 
                    case 44: 
                    case 45: 
                }
            }
        } else {
            if (!bl) {
                return;
            }
            switch (this.id) {
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 37: 
                case 42: {
                    countingOutputStream.write(25);
                    countingOutputStream.write(this.subtreeIndex);
                    break;
                }
                default: {
                    countingOutputStream.write(21);
                    countingOutputStream.write(this.subtreeIndex);
                }
                case 43: 
                case 44: 
                case 45: 
            }
        }
    }

    public void writeExceptionCleanup(CountingOutputStream countingOutputStream, ClassFile classFile, boolean bl) throws IOException {
        this.reset = false;
        ++this.writeCount;
        if (this.writeCount > 1 && this.subtreeIndex >= 0 && this.subtreeIndex <= 255) {
            if (!bl) {
                return;
            }
            switch (this.id) {
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 37: 
                case 42: {
                    countingOutputStream.write(25);
                    countingOutputStream.write(this.subtreeIndex);
                    break;
                }
                default: {
                    countingOutputStream.write(21);
                    countingOutputStream.write(this.subtreeIndex);
                    break;
                }
                case 43: 
                case 44: 
                case 45: {
                    break;
                }
            }
        } else {
            if (this.writeCount > 1 && (this.id == 43 || this.id == 44 || this.id == 45)) {
                return;
            }
            for (int i = 0; i < this.argLinks.size(); ++i) {
                this.argLinks.get(i).writeExceptionCleanup(countingOutputStream, classFile, true);
            }
            RPNNode.writeBytecodes(countingOutputStream, classFile, this.getByteCodes());
            if (this.subtreeIndex >= 0 && this.subtreeIndex <= 255) {
                switch (this.id) {
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 37: 
                    case 42: {
                        if (bl) {
                            countingOutputStream.write(89);
                            countingOutputStream.write(58);
                            countingOutputStream.write(this.subtreeIndex);
                            break;
                        }
                        countingOutputStream.write(58);
                        countingOutputStream.write(this.subtreeIndex);
                        break;
                    }
                    default: {
                        if (bl) {
                            countingOutputStream.write(89);
                            countingOutputStream.write(54);
                            countingOutputStream.write(this.subtreeIndex);
                            break;
                        }
                        countingOutputStream.write(54);
                        countingOutputStream.write(this.subtreeIndex);
                    }
                    case 43: 
                    case 44: 
                    case 45: 
                }
            }
        }
    }

    public void reset(int n) {
        if (this.reset) {
            return;
        }
        this.reset = true;
        this.writeCount = Arrays.binarySearch(this.writeCountIndex, n);
        if (this.writeCount < 0) {
            this.writeCount ^= 0xFFFFFFFF;
        }
        this.writeCount = Math.max(this.writeCount - 1, 0);
        for (int i = 0; i < this.argLinks.size(); ++i) {
            this.argLinks.get(i).reset(n);
        }
    }
}

