/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_OR_EvGv
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceValue = new byte[2];
    byte[] destinationRegister = new byte[2];
    byte[] logicalORResult = new byte[2];

    public Instruction_OR_EvGv() {
    }

    public Instruction_OR_EvGv(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.cpu.flags[11] = false;
        this.cpu.flags[0] = false;
        this.cpu.flags[4] = false;
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, (this.addressByte & 0x38) >> 3);
        if ((this.addressByte >> 6 & 3) == 3) {
            this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
            this.destinationRegister[0] = (byte)(this.destinationRegister[0] | this.sourceValue[0]);
            this.destinationRegister[1] = (byte)(this.destinationRegister[1] | this.sourceValue[1]);
            this.cpu.flags[6] = this.destinationRegister[0] == 0 && this.destinationRegister[1] == 0;
            this.cpu.flags[7] = this.destinationRegister[0] < 0;
            this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
        } else {
            this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
            byte[] byArray = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
            this.logicalORResult[0] = (byte)(byArray[0] | this.sourceValue[0]);
            this.logicalORResult[1] = (byte)(byArray[1] | this.sourceValue[1]);
            this.cpu.setWordInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.logicalORResult);
            this.cpu.flags[6] = this.logicalORResult[0] == 0 && this.logicalORResult[1] == 0;
            this.cpu.flags[7] = this.logicalORResult[0] < 0;
            this.cpu.flags[2] = Util.checkParityOfByte(this.logicalORResult[1]);
        }
    }
}

