/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.exception.CPUInstructionException;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_ShiftGRP2_EbCL
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = false;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte registerHighLow = 0;
    byte[] sourceValue = new byte[2];
    int bitShift = 0;
    long shiftResult = 0L;
    int carryBit = 0;
    int newCarryBit = 0;
    byte[] tempResult = new byte[2];

    public Instruction_ShiftGRP2_EbCL() {
    }

    public Instruction_ShiftGRP2_EbCL(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() throws CPUInstructionException {
        this.sourceValue = new byte[2];
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        this.bitShift = (byte)(this.cpu.cx[1] & 0x1F);
        switch ((this.addressByte & 0x38) >> 3) {
            case 0: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.registerHighLow = 1;
                    this.sourceValue[this.registerHighLow] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.carryBit = (this.sourceValue[this.registerHighLow] & 0x80) == 128 ? 1 : 0;
                for (int i = 0; i < this.bitShift; ++i) {
                    this.carryBit = (this.sourceValue[this.registerHighLow] & 0x80) == 128 ? 1 : 0;
                    this.sourceValue[this.registerHighLow] = (byte)(this.sourceValue[this.registerHighLow] << 1 | this.carryBit);
                }
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue[this.registerHighLow]);
                }
                boolean bl = this.cpu.flags[0] = this.carryBit == 1;
                if (this.bitShift != 1) break;
                this.cpu.flags[11] = (this.carryBit ^ ((this.sourceValue[this.registerHighLow] & 0x80) == 128 ? 1 : 0)) == 1;
                break;
            }
            case 1: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.registerHighLow = 0;
                    this.sourceValue[this.registerHighLow] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                for (int i = 0; i < this.bitShift; ++i) {
                    this.sourceValue[this.registerHighLow] = (byte)(this.sourceValue[this.registerHighLow] >> 1 & 0x7F | this.sourceValue[this.registerHighLow] << 7);
                }
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue[this.registerHighLow]);
                }
                boolean bl = this.cpu.flags[0] = (this.sourceValue[this.registerHighLow] & 0x80) == 128;
                if (this.bitShift != 1) break;
                this.cpu.flags[11] = this.cpu.flags[0] ^ (this.sourceValue[this.registerHighLow] & 0x40) == 64;
                break;
            }
            case 2: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.registerHighLow = 0;
                    this.sourceValue[this.registerHighLow] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.carryBit = this.cpu.flags[0] ? 1 : 0;
                for (int i = 0; i < this.bitShift; ++i) {
                    this.newCarryBit = (this.sourceValue[this.registerHighLow] & 0x80) == 128 ? 1 : 0;
                    this.sourceValue[this.registerHighLow] = (byte)(this.sourceValue[this.registerHighLow] << 1 | this.carryBit);
                    this.carryBit = this.newCarryBit;
                }
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue[this.registerHighLow]);
                }
                boolean bl = this.cpu.flags[0] = this.carryBit == 1;
                if (this.bitShift != 1) break;
                this.cpu.flags[11] = (this.carryBit ^ ((this.sourceValue[this.registerHighLow] & 0x80) == 128 ? 1 : 0)) == 1;
                break;
            }
            case 3: {
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.registerHighLow = 0;
                    this.sourceValue[this.registerHighLow] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.carryBit = this.cpu.flags[0] ? 1 : 0;
                for (int i = 0; i < this.bitShift; ++i) {
                    this.newCarryBit = (this.sourceValue[this.registerHighLow] & 1) == 1 ? 1 : 0;
                    this.sourceValue[this.registerHighLow] = (byte)(this.sourceValue[this.registerHighLow] >> 1 & 0x7F | this.carryBit << 7);
                    this.carryBit = this.newCarryBit;
                }
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue[this.registerHighLow]);
                }
                boolean bl = this.cpu.flags[0] = this.carryBit == 1;
                if (this.bitShift != 1) break;
                this.cpu.flags[11] = (this.carryBit ^ ((this.sourceValue[this.registerHighLow] & 0x80) == 128 ? 1 : 0)) == 1;
                break;
            }
            case 4: {
                if (this.bitShift <= 0) break;
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.registerHighLow = 0;
                    this.sourceValue[this.registerHighLow] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.carryBit = (this.sourceValue[this.registerHighLow] << this.bitShift - 1 & 0x80) == 128 ? 1 : 0;
                this.sourceValue[this.registerHighLow] = (byte)(this.sourceValue[this.registerHighLow] << this.bitShift);
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue[this.registerHighLow]);
                }
                this.cpu.flags[4] = false;
                this.cpu.flags[0] = this.carryBit == 1;
                this.cpu.flags[11] = !(this.cpu.flags[0] && this.sourceValue[this.registerHighLow] >> 7 == 1 || !this.cpu.flags[0] && this.sourceValue[this.registerHighLow] >> 7 == 0);
                this.cpu.flags[6] = this.sourceValue[this.registerHighLow] == 0;
                this.cpu.flags[7] = this.sourceValue[this.registerHighLow] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.sourceValue[this.registerHighLow]);
                break;
            }
            case 5: {
                if (this.bitShift <= 0) break;
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.registerHighLow = 0;
                    this.sourceValue[this.registerHighLow] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                this.cpu.flags[11] = this.bitShift == 1 ? (this.sourceValue[this.registerHighLow] & 0x80) == 128 : false;
                this.shiftResult = this.sourceValue[this.registerHighLow] & 0xFF;
                this.shiftResult >>= this.bitShift - 1;
                this.cpu.flags[0] = (this.shiftResult & 1L) == 1L;
                this.shiftResult >>= 1;
                this.sourceValue[this.registerHighLow] = (byte)this.shiftResult;
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue[this.registerHighLow]);
                }
                this.cpu.flags[4] = false;
                this.cpu.flags[6] = this.sourceValue[this.registerHighLow] == 0;
                this.cpu.flags[7] = this.sourceValue[this.registerHighLow] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.sourceValue[this.registerHighLow]);
                break;
            }
            case 6: {
                throw new CPUInstructionException("Shift Group 2 (0xD2/6) illegal reg bits");
            }
            case 7: {
                if (this.bitShift <= 0) break;
                if ((this.addressByte >> 6 & 3) == 3) {
                    this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
                    this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
                } else {
                    this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
                    this.registerHighLow = 0;
                    this.sourceValue[this.registerHighLow] = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
                }
                boolean bl = this.cpu.flags[0] = (this.sourceValue[this.registerHighLow] & 1) == 1;
                this.cpu.flags[11] = this.bitShift == 1 ? (this.sourceValue[this.registerHighLow] & 0x80) == 128 : false;
                this.sourceValue[this.registerHighLow] = (byte)(this.sourceValue[this.registerHighLow] >> this.bitShift);
                if ((this.addressByte >> 6 & 3) != 3) {
                    this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceValue[this.registerHighLow]);
                }
                this.cpu.flags[4] = false;
                this.cpu.flags[6] = this.sourceValue[this.registerHighLow] == 0;
                this.cpu.flags[7] = this.sourceValue[this.registerHighLow] < 0;
                this.cpu.flags[2] = Util.checkParityOfByte(this.sourceValue[this.registerHighLow]);
                break;
            }
            default: {
                throw new CPUInstructionException("Shift Group 2 (0xD2/6) no case match");
            }
        }
    }
}

