/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.clock.Clock;
import dioscuri.module.cpu32.AbstractBasicCompiler;
import dioscuri.module.cpu32.InstructionSource;
import dioscuri.module.cpu32.ProtectedModeCodeBlock;
import dioscuri.module.cpu32.ProtectedModeUBlock;
import dioscuri.module.cpu32.RealModeCodeBlock;
import dioscuri.module.cpu32.RealModeUBlock;
import dioscuri.module.cpu32.Virtual8086ModeCodeBlock;
import dioscuri.module.cpu32.Virtual8086ModeUBlock;

public class OptimisedCompiler
extends AbstractBasicCompiler {
    private Clock clock;

    public OptimisedCompiler(Clock clock) {
        this.clock = clock;
    }

    @Override
    public RealModeCodeBlock getRealModeCodeBlock(InstructionSource instructionSource) {
        this.buildCodeBlockBuffers(instructionSource);
        int[] nArray = new int[this.bufferOffset];
        int[] nArray2 = new int[this.bufferOffset];
        System.arraycopy(this.bufferMicrocodes, 0, nArray, 0, this.bufferOffset);
        System.arraycopy(this.bufferPositions, 0, nArray2, 0, this.bufferOffset);
        return new RealModeUBlock(nArray, nArray2, this.clock);
    }

    @Override
    public ProtectedModeCodeBlock getProtectedModeCodeBlock(InstructionSource instructionSource) {
        this.buildCodeBlockBuffers(instructionSource);
        int[] nArray = new int[this.bufferOffset];
        int[] nArray2 = new int[this.bufferOffset];
        System.arraycopy(this.bufferMicrocodes, 0, nArray, 0, this.bufferOffset);
        System.arraycopy(this.bufferPositions, 0, nArray2, 0, this.bufferOffset);
        return new ProtectedModeUBlock(nArray, nArray2);
    }

    @Override
    public Virtual8086ModeCodeBlock getVirtual8086ModeCodeBlock(InstructionSource instructionSource) {
        this.buildCodeBlockBuffers(instructionSource);
        int[] nArray = new int[this.bufferOffset];
        int[] nArray2 = new int[this.bufferOffset];
        System.arraycopy(this.bufferMicrocodes, 0, nArray, 0, this.bufferOffset);
        System.arraycopy(this.bufferPositions, 0, nArray2, 0, this.bufferOffset);
        return new Virtual8086ModeUBlock(nArray, nArray2);
    }
}

