/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.CodeBlockCompiler;
import dioscuri.module.cpu32.InstructionSource;

public abstract class AbstractBasicCompiler
implements CodeBlockCompiler {
    protected int bufferOffset = 0;
    protected int[] bufferMicrocodes = new int[100];
    protected int[] bufferPositions = new int[100];

    protected void buildCodeBlockBuffers(InstructionSource instructionSource) {
        this.bufferOffset = 0;
        int n = 0;
        while (instructionSource.getNext()) {
            int n2 = instructionSource.getLength();
            int n3 = instructionSource.getX86Length();
            n += n3;
            for (int i = 0; i < n2; ++i) {
                int n4 = instructionSource.getMicrocode();
                try {
                    this.bufferMicrocodes[this.bufferOffset] = n4;
                    this.bufferPositions[this.bufferOffset] = n;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    int[] nArray = new int[this.bufferMicrocodes.length * 2];
                    int[] nArray2 = new int[this.bufferMicrocodes.length * 2];
                    System.arraycopy(this.bufferMicrocodes, 0, nArray, 0, this.bufferMicrocodes.length);
                    System.arraycopy(this.bufferPositions, 0, nArray2, 0, this.bufferPositions.length);
                    this.bufferMicrocodes = nArray;
                    this.bufferPositions = nArray2;
                    this.bufferMicrocodes[this.bufferOffset] = n4;
                    this.bufferPositions[this.bufferOffset] = n;
                }
                ++this.bufferOffset;
            }
        }
    }
}

