/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_INC_AX
implements Instruction {
    private CPU cpu;
    private byte[] temp;
    private byte[] oldDestWord;
    private byte[] oldDestDoubleWord;
    private byte[] incWord;

    public Instruction_INC_AX() {
    }

    public Instruction_INC_AX(CPU cPU) {
        this.cpu = cPU;
        this.temp = new byte[2];
        this.oldDestWord = new byte[2];
        this.oldDestDoubleWord = new byte[2];
        this.incWord = new byte[]{0, 1};
    }

    @Override
    public void execute() {
        if (this.cpu.doubleWord) {
            System.arraycopy(this.cpu.ax, 0, this.oldDestWord, 0, this.cpu.ax.length);
            System.arraycopy(this.cpu.eax, 0, this.oldDestDoubleWord, 0, this.cpu.eax.length);
            this.temp = Util.addWords(this.cpu.ax, this.incWord, 0);
            this.cpu.ax[0] = this.temp[0];
            this.cpu.ax[1] = this.temp[1];
            if (Util.test_CF_ADD(this.cpu.ax, this.incWord, 0)) {
                this.temp = Util.addWords(this.cpu.eax, this.incWord, 0);
                this.cpu.eax[0] = this.temp[0];
                this.cpu.eax[1] = this.temp[1];
            }
            this.cpu.flags[4] = Util.test_AF_ADD(this.oldDestWord[1], this.cpu.ax[1]);
            this.cpu.flags[11] = Util.test_OF_ADD(this.oldDestDoubleWord, this.incWord, this.cpu.eax, 0);
            this.cpu.flags[6] = this.cpu.eax[0] == 0 && this.cpu.eax[1] == 0 && this.cpu.ax[0] == 0 && this.cpu.ax[1] == 0;
            this.cpu.flags[7] = this.cpu.eax[0] < 0;
            this.cpu.flags[2] = Util.checkParityOfByte(this.cpu.ax[1]);
        } else {
            System.arraycopy(this.cpu.ax, 0, this.oldDestWord, 0, this.cpu.ax.length);
            this.temp = Util.addWords(this.cpu.ax, this.incWord, 0);
            this.cpu.ax[0] = this.temp[0];
            this.cpu.ax[1] = this.temp[1];
            this.cpu.flags[4] = Util.test_AF_ADD(this.oldDestWord[1], this.cpu.ax[1]);
            this.cpu.flags[11] = Util.test_OF_ADD(this.oldDestWord, this.incWord, this.cpu.ax, 0);
            this.cpu.flags[6] = this.cpu.ax[0] == 0 && this.cpu.ax[1] == 0;
            this.cpu.flags[7] = this.cpu.ax[0] < 0;
            this.cpu.flags[2] = Util.checkParityOfByte(this.cpu.ax[1]);
        }
    }
}

