/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ConstantPoolInfo {
    public static final int CLASS = 7;
    public static final int FIELDREF = 9;
    public static final int METHODREF = 10;
    public static final int INTERFACEMETHODREF = 11;
    public static final int STRING = 8;
    public static final int INTEGER = 3;
    public static final int FLOAT = 4;
    public static final int LONG = 5;
    public static final int DOUBLE = 6;
    public static final int NAMEANDTYPE = 12;
    public static final int UTF8 = 1;

    public abstract int getTag();

    public abstract void write(DataOutputStream var1) throws IOException;

    public abstract boolean equals(Object var1);

    public static ConstantPoolInfo construct(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        switch (n) {
            case 7: {
                return new ClassInfo(dataInputStream);
            }
            case 9: {
                return new FieldRefInfo(dataInputStream);
            }
            case 10: {
                return new MethodRefInfo(dataInputStream);
            }
            case 11: {
                return new InterfaceMethodRefInfo(dataInputStream);
            }
            case 8: {
                return new StringInfo(dataInputStream);
            }
            case 3: {
                return new IntegerInfo(dataInputStream);
            }
            case 4: {
                return new FloatInfo(dataInputStream);
            }
            case 5: {
                return new LongInfo(dataInputStream);
            }
            case 6: {
                return new DoubleInfo(dataInputStream);
            }
            case 12: {
                return new NameAndTypeInfo(dataInputStream);
            }
            case 1: {
                return new Utf8Info(dataInputStream);
            }
        }
        return null;
    }

    public int hashCode() {
        int n = 3;
        return n;
    }

    public static class Utf8Info
    extends ConstantPoolInfo {
        private final String bytes;
        private final int hashCode;

        Utf8Info(DataInputStream dataInputStream) throws IOException {
            this.bytes = dataInputStream.readUTF();
            this.hashCode = this.getClass().hashCode() * 31 ^ this.bytes.hashCode() * 37;
        }

        Utf8Info(String string) {
            this.bytes = string;
            this.hashCode = this.getClass().hashCode() * 31 ^ this.bytes.hashCode() * 37;
        }

        @Override
        public int getTag() {
            return 1;
        }

        public String getBytes() {
            return this.bytes;
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(this.bytes);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Utf8Info)) {
                return false;
            }
            return this.getBytes().equals(((Utf8Info)object).getBytes());
        }

        public String toString() {
            return "CONSTANT_Utf8_info : value=" + this.getBytes();
        }
    }

    public static class NameAndTypeInfo
    extends ConstantPoolInfo {
        private final int nameIndex;
        private final int descriptorIndex;
        private final int hashCode;

        NameAndTypeInfo(DataInputStream dataInputStream) throws IOException {
            this.nameIndex = dataInputStream.readUnsignedShort();
            this.descriptorIndex = dataInputStream.readUnsignedShort();
            this.hashCode = this.getClass().hashCode() * 31 ^ this.nameIndex * 37 ^ this.descriptorIndex * 41;
        }

        NameAndTypeInfo(int n, int n2) {
            this.nameIndex = n;
            this.descriptorIndex = n2;
            this.hashCode = this.getClass().hashCode() * 31 ^ n * 37 ^ n2 * 41;
        }

        @Override
        public int getTag() {
            return 12;
        }

        public int getNameIndex() {
            return this.nameIndex;
        }

        public int getDescriptorIndex() {
            return this.descriptorIndex;
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(12);
            dataOutputStream.writeShort(this.nameIndex);
            dataOutputStream.writeShort(this.descriptorIndex);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof NameAndTypeInfo)) {
                return false;
            }
            return this.getNameIndex() == ((NameAndTypeInfo)object).getNameIndex() && this.getDescriptorIndex() == ((NameAndTypeInfo)object).getDescriptorIndex();
        }

        public String toString() {
            return "CONSTANT_NameAndType_info : descriptor=" + this.getDescriptorIndex() + " : name=" + this.getNameIndex();
        }
    }

    public static class DoubleInfo
    extends ConstantPoolInfo {
        private final double bytes;
        private final int hashCode;

        DoubleInfo(DataInputStream dataInputStream) throws IOException {
            this.bytes = dataInputStream.readDouble();
            long l = Double.doubleToRawLongBits(this.bytes);
            this.hashCode = this.getClass().hashCode() * 31 ^ (int)l * 37 ^ (int)(l >>> 32) * 41;
        }

        DoubleInfo(double d) {
            this.bytes = d;
            long l = Double.doubleToRawLongBits(this.bytes);
            this.hashCode = this.getClass().hashCode() * 31 ^ (int)l * 37 ^ (int)(l >>> 32) * 41;
        }

        @Override
        public int getTag() {
            return 6;
        }

        public double getBytes() {
            return this.bytes;
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(6);
            dataOutputStream.writeDouble(this.bytes);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DoubleInfo)) {
                return false;
            }
            return this.getBytes() == ((DoubleInfo)object).getBytes();
        }

        public String toString() {
            return "CONSTANT_Double_info : value=" + this.getBytes();
        }
    }

    public static class LongInfo
    extends ConstantPoolInfo {
        private final long bytes;
        private final int hashCode;

        LongInfo(DataInputStream dataInputStream) throws IOException {
            this.bytes = dataInputStream.readLong();
            this.hashCode = this.getClass().hashCode() * 31 ^ (int)this.bytes * 37 ^ (int)(this.bytes >>> 32) * 41;
        }

        LongInfo(long l) {
            this.bytes = l;
            this.hashCode = this.getClass().hashCode() * 31 ^ (int)this.bytes * 37 ^ (int)(this.bytes >>> 32) * 41;
        }

        @Override
        public int getTag() {
            return 5;
        }

        public long getBytes() {
            return this.bytes;
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(5);
            dataOutputStream.writeLong(this.bytes);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof LongInfo)) {
                return false;
            }
            return this.getBytes() == ((LongInfo)object).getBytes();
        }

        public String toString() {
            return "CONSTANT_Long_info : value=" + this.getBytes();
        }
    }

    public static class FloatInfo
    extends ConstantPoolInfo {
        private final float bytes;
        private final int hashCode;

        FloatInfo(DataInputStream dataInputStream) throws IOException {
            this.bytes = dataInputStream.readFloat();
            this.hashCode = this.getClass().hashCode() * 31 ^ Float.floatToRawIntBits(this.bytes) * 37;
        }

        FloatInfo(float f) {
            this.bytes = f;
            this.hashCode = this.getClass().hashCode() * 31 ^ Float.floatToRawIntBits(this.bytes) * 37;
        }

        @Override
        public int getTag() {
            return 4;
        }

        public float getBytes() {
            return this.bytes;
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(4);
            dataOutputStream.writeFloat(this.bytes);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof FloatInfo)) {
                return false;
            }
            return this.getBytes() == ((FloatInfo)object).getBytes();
        }

        public String toString() {
            return "CONSTANT_Float_info : value=" + this.getBytes();
        }
    }

    public static class IntegerInfo
    extends ConstantPoolInfo {
        private final int bytes;
        private final int hashCode;

        IntegerInfo(DataInputStream dataInputStream) throws IOException {
            this.bytes = dataInputStream.readInt();
            this.hashCode = this.getClass().hashCode() * 31 ^ this.bytes * 37;
        }

        IntegerInfo(int n) {
            this.bytes = n;
            this.hashCode = this.getClass().hashCode() * 31 ^ this.bytes * 37;
        }

        @Override
        public int getTag() {
            return 3;
        }

        public int getBytes() {
            return this.bytes;
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(3);
            dataOutputStream.writeInt(this.bytes);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof IntegerInfo)) {
                return false;
            }
            return this.getBytes() == ((IntegerInfo)object).getBytes();
        }

        public String toString() {
            return "CONSTANT_Integer_info : value=" + this.getBytes();
        }
    }

    public static class StringInfo
    extends ConstantPoolInfo {
        private final int stringIndex;
        private final int hashCode;

        StringInfo(DataInputStream dataInputStream) throws IOException {
            this.stringIndex = dataInputStream.readUnsignedShort();
            this.hashCode = this.getClass().hashCode() * 31 ^ this.stringIndex * 37;
        }

        StringInfo(int n) {
            this.stringIndex = n;
            this.hashCode = this.getClass().hashCode() * 31 ^ this.stringIndex * 37;
        }

        @Override
        public int getTag() {
            return 8;
        }

        public int getStringIndex() {
            return this.stringIndex;
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(8);
            dataOutputStream.writeShort(this.stringIndex);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof StringInfo)) {
                return false;
            }
            return this.getStringIndex() == ((StringInfo)object).getStringIndex();
        }

        public String toString() {
            return "CONSTANT_String_info : string=" + this.getStringIndex();
        }
    }

    public static class InterfaceMethodRefInfo
    extends MethodRefInfo {
        InterfaceMethodRefInfo(DataInputStream dataInputStream) throws IOException {
            super(dataInputStream);
        }

        InterfaceMethodRefInfo(int n, int n2) {
            super(n, n2);
        }

        @Override
        public int getTag() {
            return 11;
        }

        @Override
        public String toString() {
            return "CONSTANT_InterfaceMethodRef_info : class=" + this.getClassIndex() + " : nameandtype=" + this.getNameAndTypeIndex();
        }
    }

    public static class MethodRefInfo
    extends RefInfo {
        MethodRefInfo(DataInputStream dataInputStream) throws IOException {
            super(dataInputStream);
        }

        MethodRefInfo(int n, int n2) {
            super(n, n2);
        }

        @Override
        public int getTag() {
            return 10;
        }

        public String toString() {
            return "CONSTANT_MethodRef_info : class=" + this.getClassIndex() + " : nameandtype=" + this.getNameAndTypeIndex();
        }
    }

    public static class FieldRefInfo
    extends RefInfo {
        FieldRefInfo(DataInputStream dataInputStream) throws IOException {
            super(dataInputStream);
        }

        FieldRefInfo(int n, int n2) {
            super(n, n2);
        }

        @Override
        public int getTag() {
            return 9;
        }

        public String toString() {
            return "CONSTANT_FieldRef_info : class=" + this.getClassIndex() + " : nameandtype=" + this.getNameAndTypeIndex();
        }
    }

    static abstract class RefInfo
    extends ConstantPoolInfo {
        private final int classIndex;
        private final int nameAndTypeIndex;
        private final int hashCode;

        RefInfo(DataInputStream dataInputStream) throws IOException {
            this.classIndex = dataInputStream.readUnsignedShort();
            this.nameAndTypeIndex = dataInputStream.readUnsignedShort();
            this.hashCode = this.getClass().hashCode() * 31 ^ this.classIndex * 37 ^ this.nameAndTypeIndex * 41;
        }

        RefInfo(int n, int n2) {
            this.classIndex = n;
            this.nameAndTypeIndex = n2;
            this.hashCode = this.getClass().hashCode() * 31 ^ n * 37 ^ n2 * 41;
        }

        public int getClassIndex() {
            return this.classIndex;
        }

        public int getNameAndTypeIndex() {
            return this.nameAndTypeIndex;
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(this.getTag());
            dataOutputStream.writeShort(this.classIndex);
            dataOutputStream.writeShort(this.nameAndTypeIndex);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof RefInfo)) {
                return false;
            }
            if (this.getTag() != ((RefInfo)object).getTag()) {
                return false;
            }
            return this.getClassIndex() == ((RefInfo)object).getClassIndex() && this.getNameAndTypeIndex() == ((RefInfo)object).getNameAndTypeIndex();
        }
    }

    public static class ClassInfo
    extends ConstantPoolInfo {
        private final int nameIndex;
        private final int hashCode;

        ClassInfo(DataInputStream dataInputStream) throws IOException {
            this.nameIndex = dataInputStream.readUnsignedShort();
            this.hashCode = this.getClass().hashCode() * 31 ^ this.nameIndex * 37;
        }

        ClassInfo(int n) {
            this.nameIndex = n;
            this.hashCode = this.getClass().hashCode() * 31 ^ this.nameIndex * 37;
        }

        @Override
        public int getTag() {
            return 7;
        }

        public int getNameIndex() {
            return this.nameIndex;
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(7);
            dataOutputStream.writeShort(this.nameIndex);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ClassInfo)) {
                return false;
            }
            return this.getNameIndex() == ((ClassInfo)object).getNameIndex();
        }

        public String toString() {
            return "CONSTANT_Class_info : name=" + this.getNameIndex();
        }
    }
}

