/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.clock.Clock;
import dioscuri.module.cpu32.AbstractMemory;
import dioscuri.module.cpu32.CodeBlock;
import dioscuri.module.cpu32.LazyCodeBlockMemory;
import dioscuri.module.cpu32.Processor;

public class LazyMemory
extends AbstractMemory {
    private int size;
    boolean allocated = false;
    private byte[] buffer;
    private Clock clock;

    public LazyMemory(int n) {
        this.size = n;
        this.buffer = null;
    }

    public LazyMemory(int n, Clock clock) {
        this.size = n;
        this.buffer = null;
        this.clock = clock;
    }

    public LazyMemory(byte[] byArray) {
        this.size = byArray.length;
        this.buffer = byArray;
    }

    public boolean isCacheable() {
        return true;
    }

    private final void allocateBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[this.size];
            this.allocated = true;
        }
    }

    @Override
    public void copyContentsInto(int n, byte[] byArray, int n2, int n3) {
        try {
            System.arraycopy(this.buffer, n, byArray, n2, n3);
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            System.arraycopy(this.buffer, n, byArray, n2, n3);
        }
    }

    @Override
    public void copyContentsFrom(int n, byte[] byArray, int n2, int n3) {
        try {
            System.arraycopy(byArray, n2, this.buffer, n, n3);
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            System.arraycopy(byArray, n2, this.buffer, n, n3);
        }
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean isAllocated() {
        return this.allocated;
    }

    @Override
    public byte getByte(int n) {
        try {
            return this.buffer[n];
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            return this.buffer[n];
        }
    }

    @Override
    public void setByte(int n, byte by) {
        try {
            this.buffer[n] = by;
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            this.buffer[n] = by;
        }
    }

    @Override
    public short getWord(int n) {
        try {
            int n2 = 0xFF & this.buffer[n];
            return (short)(n2 |= this.buffer[++n] << 8);
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            int n3 = 0xFF & this.buffer[n];
            return (short)(n3 |= this.buffer[++n] << 8);
        }
    }

    @Override
    public int getDoubleWord(int n) {
        try {
            int n2 = 0xFF & this.buffer[n];
            n2 |= (0xFF & this.buffer[++n]) << 8;
            n2 |= (0xFF & this.buffer[++n]) << 16;
            return n2 |= this.buffer[++n] << 24;
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            int n3 = 0xFF & this.buffer[n];
            n3 |= (0xFF & this.buffer[++n]) << 8;
            n3 |= (0xFF & this.buffer[++n]) << 16;
            return n3 |= this.buffer[++n] << 24;
        }
    }

    @Override
    public void setWord(int n, short s) {
        try {
            this.buffer[n] = (byte)s;
            this.buffer[++n] = (byte)(s >> 8);
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            this.buffer[n] = (byte)s;
            this.buffer[++n] = (byte)(s >> 8);
        }
    }

    @Override
    public void setDoubleWord(int n, int n2) {
        try {
            this.buffer[n] = (byte)n2;
            this.buffer[++n] = (byte)(n2 >>= 8);
            this.buffer[++n] = (byte)(n2 >>= 8);
            this.buffer[++n] = (byte)(n2 >>= 8);
        }
        catch (NullPointerException nullPointerException) {
            this.allocateBuffer();
            this.buffer[n] = (byte)n2;
            this.buffer[++n] = (byte)(n2 >>= 8);
            this.buffer[++n] = (byte)(n2 >>= 8);
            this.buffer[++n] = (byte)(n2 >>= 8);
        }
    }

    @Override
    public void clear() {
        this.buffer = null;
    }

    @Override
    public int execute(Processor processor, int n) {
        return this.convertMemory(processor).execute(processor, n);
    }

    @Override
    public CodeBlock decodeCodeBlockAt(Processor processor, int n) {
        CodeBlock codeBlock = this.convertMemory(processor).decodeCodeBlockAt(processor, n);
        return codeBlock;
    }

    private LazyCodeBlockMemory convertMemory(Processor processor) {
        LazyCodeBlockMemory lazyCodeBlockMemory = new LazyCodeBlockMemory(this, this.clock);
        processor.physicalMemory.replaceBlocks(this, lazyCodeBlockMemory);
        processor.linearMemory.replaceBlocks(this, lazyCodeBlockMemory);
        return lazyCodeBlockMemory;
    }

    public String toString() {
        return "LazyMemory[" + this.getSize() + "] {Allocated=" + (this.buffer != null) + "}";
    }
}

