/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.ClassFile;
import dioscuri.module.cpu32.JavaOpcode;

public class JavaCodeAnalyser {
    public static int getMaxStackDepth(int[] nArray, int n, ClassFile classFile) {
        int n2;
        int n3;
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = Integer.MIN_VALUE;
        }
        int[] nArray3 = new int[nArray.length];
        for (n3 = 0; n3 < nArray3.length; ++n3) {
            nArray3[n3] = Integer.MIN_VALUE;
        }
        for (n3 = 0; n3 < nArray3.length; n3 += JavaOpcode.getOpcodeLength(nArray, n3)) {
            n2 = JavaOpcode.getStackDelta(nArray, n3);
            if (n2 == 48879) {
                n2 = JavaCodeAnalyser.calcStackDeltaFromConstPool(nArray, n3, classFile);
            }
            nArray2[n3] = n2;
        }
        n3 = 0;
        n2 = 0;
        for (int i = n; i < nArray3.length; i += JavaOpcode.getOpcodeLength(nArray, i)) {
            int n4;
            int n5 = JavaOpcode.getJumpOffset(nArray, i);
            if (nArray2[i] == Integer.MIN_VALUE) {
                throw new VerifyError("Invalid offset, not an opcode");
            }
            if (nArray3[i] != Integer.MIN_VALUE && (n2 += nArray2[i]) != nArray3[i]) {
                throw new VerifyError("Stack Depth Mismatch");
            }
            nArray3[i] = n2;
            n3 = Math.max(n3, n2);
            if (JavaOpcode.isBranchInstruction(nArray[i])) {
                n4 = i + n5;
                if (nArray2[n4] == Integer.MIN_VALUE) {
                    throw new VerifyError("No valid opcode at jump offset");
                }
                if (nArray3[n4] != Integer.MIN_VALUE && nArray3[n4] != n2 + nArray2[n4]) {
                    throw new VerifyError("Stack Irregularity In Jump");
                }
                nArray3[n4] = n2 + nArray2[n4];
                continue;
            }
            if (n5 != 0) {
                n4 = i + n5;
                if (nArray2[n4] == Integer.MIN_VALUE) {
                    throw new VerifyError("No valid opcode at jump offset");
                }
                if (nArray3[n4] != Integer.MIN_VALUE && nArray3[n4] != n2 + nArray2[n4]) {
                    throw new VerifyError("Stack Irregularity In Jump");
                }
                nArray3[n4] = n2 + nArray2[n4];
                i += JavaOpcode.getOpcodeLength(nArray, i);
                while (nArray3[i] == Integer.MIN_VALUE) {
                    i += JavaOpcode.getOpcodeLength(nArray, i);
                }
                n2 = nArray3[i];
                continue;
            }
            if (!JavaOpcode.isReturn(nArray[i])) continue;
            i += JavaOpcode.getOpcodeLength(nArray, i);
            while (i < nArray3.length && nArray3[i] == Integer.MIN_VALUE) {
                i += JavaOpcode.getOpcodeLength(nArray, i);
            }
            if (i >= nArray3.length) break;
            n2 = nArray3[i];
        }
        return n3;
    }

    public static int getMaxLocalVariables(int[] nArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < nArray.length; i += JavaOpcode.getOpcodeLength(nArray, i)) {
            n2 = JavaOpcode.getLocalVariableAccess(nArray, i);
            if (n2 <= n) continue;
            n = n2;
        }
        return n + 1;
    }

    private static int calcStackDeltaFromConstPool(int[] nArray, int n, ClassFile classFile) {
        int n2 = nArray[n];
        int n3 = nArray[n + 1] << 8 | nArray[n + 2];
        int n4 = 0;
        switch (n2) {
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                String string = classFile.getConstantPoolFieldDescriptor(n3);
                n4 = classFile.getFieldLength(string);
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                String string = classFile.getConstantPoolMethodDescriptor(n3);
                n4 = classFile.getMethodStackDelta(string);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (n2) {
            case 180: {
                return n4 - 1;
            }
            case 178: {
                return n4;
            }
            case 182: 
            case 183: 
            case 185: {
                return -(n4 + 1);
            }
            case 179: 
            case 184: {
                return -n4;
            }
            case 181: {
                return -(n4 + 1);
            }
        }
        return 0;
    }
}

