/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_ADD_AXIv
implements Instruction {
    private CPU cpu;
    byte[] immediateWord = new byte[2];
    byte[] oldDest = new byte[2];
    byte[] temp = new byte[2];

    public Instruction_ADD_AXIv() {
    }

    public Instruction_ADD_AXIv(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.immediateWord = this.cpu.getWordFromCode();
        System.arraycopy(this.cpu.ax, 0, this.oldDest, 0, this.cpu.ax.length);
        this.temp = Util.addWords(this.cpu.ax, this.immediateWord, 0);
        System.arraycopy(this.temp, 0, this.cpu.ax, 0, this.temp.length);
        this.cpu.flags[4] = Util.test_AF_ADD(this.oldDest[1], this.cpu.ax[1]);
        this.cpu.flags[0] = Util.test_CF_ADD(this.oldDest, this.immediateWord, 0);
        this.cpu.flags[11] = Util.test_OF_ADD(this.oldDest, this.immediateWord, this.cpu.ax, 0);
        this.cpu.flags[6] = this.cpu.ax[0] == 0 && this.cpu.ax[1] == 0;
        this.cpu.flags[7] = this.cpu.ax[0] < 0;
        this.cpu.flags[2] = Util.checkParityOfByte(this.cpu.ax[1]);
    }
}

