/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.AttributeInfo;
import dioscuri.module.cpu32.ConstantPoolInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FieldInfo {
    private int accessFlags;
    private int nameIndex;
    private int descriptorIndex;
    private int attributesCount;
    private AttributeInfo[] attributes;
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int SYNTHETIC = 4096;
    public static final int ENUM = 16384;

    public FieldInfo(DataInputStream dataInputStream, ConstantPoolInfo[] constantPoolInfoArray) throws IOException {
        this.accessFlags = dataInputStream.readUnsignedShort();
        this.nameIndex = dataInputStream.readUnsignedShort();
        this.descriptorIndex = dataInputStream.readUnsignedShort();
        this.attributesCount = dataInputStream.readUnsignedShort();
        this.attributes = new AttributeInfo[this.attributesCount];
        for (int i = 0; i < this.attributesCount; ++i) {
            this.attributes[i] = AttributeInfo.construct(dataInputStream, constantPoolInfoArray);
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.accessFlags);
        dataOutputStream.writeShort(this.nameIndex);
        dataOutputStream.writeShort(this.descriptorIndex);
        dataOutputStream.writeShort(this.attributesCount);
        for (int i = 0; i < this.attributesCount; ++i) {
            this.attributes[i].write(dataOutputStream);
        }
    }
}

