/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.ClassFile;
import dioscuri.module.cpu32.CountingOutputStream;
import dioscuri.module.cpu32.ExceptionHandler;
import dioscuri.module.cpu32.Processor;
import dioscuri.module.cpu32.ProcessorException;
import dioscuri.module.cpu32.ProtectedModeRPNNode;
import dioscuri.module.cpu32.RPNNode;
import java.io.IOException;
import java.util.Map;

public class ProtectedModeExceptionHandler
extends ExceptionHandler {
    public ProtectedModeExceptionHandler(int n, ProtectedModeRPNNode protectedModeRPNNode, Map<Integer, RPNNode> map) {
        super(n, protectedModeRPNNode, map);
    }

    @Override
    protected void writeHandlerRoutine(CountingOutputStream countingOutputStream, ClassFile classFile) throws IOException {
        int n;
        countingOutputStream.write(43);
        countingOutputStream.write(95);
        countingOutputStream.write(89);
        countingOutputStream.write(182);
        try {
            n = classFile.addToConstantPool(ProcessorException.class.getDeclaredMethod("getVector", null));
            if (n > 65535) {
                throw new IllegalStateException("Compilation ran out of constant pool slots");
            }
            countingOutputStream.write(n >>> 8);
            countingOutputStream.write(n & 0xFF);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(noSuchMethodException);
        }
        countingOutputStream.write(95);
        countingOutputStream.write(89);
        countingOutputStream.write(182);
        try {
            n = classFile.addToConstantPool(ProcessorException.class.getDeclaredMethod("hasErrorCode", null));
            if (n > 65535) {
                throw new IllegalStateException("Compilation ran out of constant pool slots");
            }
            countingOutputStream.write(n >>> 8);
            countingOutputStream.write(n & 0xFF);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(noSuchMethodException);
        }
        countingOutputStream.write(95);
        countingOutputStream.write(182);
        try {
            int n2 = classFile.addToConstantPool(ProcessorException.class.getDeclaredMethod("getErrorCode", null));
            if (n2 > 65535) {
                throw new IllegalStateException("Compilation ran out of constant pool slots");
            }
            countingOutputStream.write(n2 >>> 8);
            countingOutputStream.write(n2 & 0xFF);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(noSuchMethodException);
        }
        countingOutputStream.write(182);
        try {
            int n3 = classFile.addToConstantPool(Processor.class.getDeclaredMethod("handleProtectedModeException", Integer.TYPE, Boolean.TYPE, Integer.TYPE));
            if (n3 > 65535) {
                throw new IllegalStateException("Compilation ran out of constant pool slots");
            }
            countingOutputStream.write(n3 >>> 8);
            countingOutputStream.write(n3 & 0xFF);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(noSuchMethodException);
        }
    }
}

