/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.exception.ModuleException;
import dioscuri.module.cpu32.IOPortHandler;
import dioscuri.module.cpu32.ProcessorException;
import dioscuri.module.cpu32.Segment;

public class UCodeStaticMethods {
    private static final ProcessorException exceptionDE = new ProcessorException(0, true);
    private static final ProcessorException exceptionGP = new ProcessorException(13, 0, true);
    protected static final boolean[] parityMap = new boolean[256];

    public static int eip_nef_EIP_UPDATE_eip_x86length(int n, int n2) {
        return n + n2;
    }

    public static int reg0_nef_LOAD0_AL_eax(int n) {
        return n & 0xFF;
    }

    public static int reg0_nef_LOAD0_CL_ecx(int n) {
        return n & 0xFF;
    }

    public static int reg0_nef_LOAD0_DL_edx(int n) {
        return n & 0xFF;
    }

    public static int reg0_nef_LOAD0_BL_ebx(int n) {
        return n & 0xFF;
    }

    public static int reg0_nef_LOAD0_AH_eax(int n) {
        return n >>> 8 & 0xFF;
    }

    public static int reg0_nef_LOAD0_CH_ecx(int n) {
        return n >>> 8 & 0xFF;
    }

    public static int reg0_nef_LOAD0_DH_edx(int n) {
        return n >>> 8 & 0xFF;
    }

    public static int reg0_nef_LOAD0_BH_ebx(int n) {
        return n >>> 8 & 0xFF;
    }

    public static int reg0_nef_LOAD0_AX_eax(int n) {
        return n & 0xFFFF;
    }

    public static int reg0_nef_LOAD0_CX_ecx(int n) {
        return n & 0xFFFF;
    }

    public static int reg0_nef_LOAD0_DX_edx(int n) {
        return n & 0xFFFF;
    }

    public static int reg0_nef_LOAD0_BX_ebx(int n) {
        return n & 0xFFFF;
    }

    public static int reg0_nef_LOAD0_SP_esp(int n) {
        return n & 0xFFFF;
    }

    public static int reg0_nef_LOAD0_BP_ebp(int n) {
        return n & 0xFFFF;
    }

    public static int reg0_nef_LOAD0_SI_esi(int n) {
        return n & 0xFFFF;
    }

    public static int reg0_nef_LOAD0_DI_edi(int n) {
        return n & 0xFFFF;
    }

    public static int reg0_nef_LOAD0_EAX_eax(int n) {
        return n;
    }

    public static int reg0_nef_LOAD0_ECX_ecx(int n) {
        return n;
    }

    public static int reg0_nef_LOAD0_EDX_edx(int n) {
        return n;
    }

    public static int reg0_nef_LOAD0_EBX_ebx(int n) {
        return n;
    }

    public static int reg0_nef_LOAD0_ESP_esp(int n) {
        return n;
    }

    public static int reg0_nef_LOAD0_EBP_ebp(int n) {
        return n;
    }

    public static int reg0_nef_LOAD0_ESI_esi(int n) {
        return n;
    }

    public static int reg0_nef_LOAD0_EDI_edi(int n) {
        return n;
    }

    public static int reg0_hef_LOAD0_ES_es(Segment segment) {
        return 0xFFFF & segment.getSelector();
    }

    public static int reg0_hef_LOAD0_CS_cs(Segment segment) {
        return 0xFFFF & segment.getSelector();
    }

    public static int reg0_hef_LOAD0_SS_ss(Segment segment) {
        return 0xFFFF & segment.getSelector();
    }

    public static int reg0_hef_LOAD0_DS_ds(Segment segment) {
        return 0xFFFF & segment.getSelector();
    }

    public static int reg0_hef_LOAD0_FS_fs(Segment segment) {
        return 0xFFFF & segment.getSelector();
    }

    public static int reg0_hef_LOAD0_GS_gs(Segment segment) {
        return 0xFFFF & segment.getSelector();
    }

    public static int reg0_nef_LOAD0_IB_immediate(int n) {
        return n & 0xFF;
    }

    public static int reg0_nef_LOAD0_IW_immediate(int n) {
        return n & 0xFFFF;
    }

    public static int reg0_nef_LOAD0_ID_immediate(int n) {
        return n;
    }

    public static int reg0_hef_LOAD0_MEM_BYTE_seg0_addr0(Segment segment, int n) {
        return 0xFF & segment.getByte(n);
    }

    public static int reg0_hef_LOAD0_MEM_WORD_seg0_addr0(Segment segment, int n) {
        return 0xFFFF & segment.getWord(n);
    }

    public static int reg0_hef_LOAD0_MEM_DWORD_seg0_addr0(Segment segment, int n) {
        return segment.getDoubleWord(n);
    }

    public static int reg0_nef_LOAD0_FLAGS_cflag_pflag_aflag_zflag_sflag_tflag_iflag_dflag_oflag_iopl_ntflag(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int n12 = 0;
        n12 |= n11 << 14;
        n12 |= n10 << 12;
        n12 |= n9 << 11;
        n12 |= n8 << 10;
        n12 |= n7 << 9;
        n12 |= n6 << 8;
        n12 |= n5 << 7;
        n12 |= n4 << 6;
        n12 |= n3 << 4;
        n12 |= n2 << 2;
        n12 |= n;
        return n12 |= 2;
    }

    public static int reg0_nef_LOAD0_EFLAGS_cflag_pflag_aflag_zflag_sflag_tflag_iflag_dflag_oflag_iopl_ntflag_rflag_vmflag_acflag_viflag_vipflag_idflag(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
        int n18 = 0;
        n18 |= n17 << 21;
        n18 |= n16 << 20;
        n18 |= n15 << 19;
        n18 |= n14 << 18;
        n18 |= n13 << 17;
        n18 |= n12 << 16;
        n18 |= n11 << 14;
        n18 |= n10 << 12;
        n18 |= n9 << 11;
        n18 |= n8 << 10;
        n18 |= n7 << 9;
        n18 |= n6 << 8;
        n18 |= n5 << 7;
        n18 |= n4 << 6;
        n18 |= n3 << 4;
        n18 |= n2 << 2;
        n18 |= n;
        return n18 |= 2;
    }

    public static int reg0_nef_LOAD0_ADDR_addr0(int n) {
        return n;
    }

    public static int reg1_nef_LOAD1_AL_eax(int n) {
        return n & 0xFF;
    }

    public static int reg1_nef_LOAD1_CL_ecx(int n) {
        return n & 0xFF;
    }

    public static int reg1_nef_LOAD1_DL_edx(int n) {
        return n & 0xFF;
    }

    public static int reg1_nef_LOAD1_BL_ebx(int n) {
        return n & 0xFF;
    }

    public static int reg1_nef_LOAD1_AH_eax(int n) {
        return n >>> 8 & 0xFF;
    }

    public static int reg1_nef_LOAD1_CH_ecx(int n) {
        return n >>> 8 & 0xFF;
    }

    public static int reg1_nef_LOAD1_DH_edx(int n) {
        return n >>> 8 & 0xFF;
    }

    public static int reg1_nef_LOAD1_BH_ebx(int n) {
        return n >>> 8 & 0xFF;
    }

    public static int reg1_nef_LOAD1_AX_eax(int n) {
        return n & 0xFFFF;
    }

    public static int reg1_nef_LOAD1_CX_ecx(int n) {
        return n & 0xFFFF;
    }

    public static int reg1_nef_LOAD1_DX_edx(int n) {
        return n & 0xFFFF;
    }

    public static int reg1_nef_LOAD1_BX_ebx(int n) {
        return n & 0xFFFF;
    }

    public static int reg1_nef_LOAD1_SP_esp(int n) {
        return n & 0xFFFF;
    }

    public static int reg1_nef_LOAD1_BP_ebp(int n) {
        return n & 0xFFFF;
    }

    public static int reg1_nef_LOAD1_SI_esi(int n) {
        return n & 0xFFFF;
    }

    public static int reg1_nef_LOAD1_DI_edi(int n) {
        return n & 0xFFFF;
    }

    public static int reg1_nef_LOAD1_EAX_eax(int n) {
        return n;
    }

    public static int reg1_nef_LOAD1_ECX_ecx(int n) {
        return n;
    }

    public static int reg1_nef_LOAD1_EDX_edx(int n) {
        return n;
    }

    public static int reg1_nef_LOAD1_EBX_ebx(int n) {
        return n;
    }

    public static int reg1_nef_LOAD1_ESP_esp(int n) {
        return n;
    }

    public static int reg1_nef_LOAD1_EBP_ebp(int n) {
        return n;
    }

    public static int reg1_nef_LOAD1_ESI_esi(int n) {
        return n;
    }

    public static int reg1_nef_LOAD1_EDI_edi(int n) {
        return n;
    }

    public static int reg1_nef_LOAD1_IB_immediate(int n) {
        return n & 0xFF;
    }

    public static int reg1_nef_LOAD1_IW_immediate(int n) {
        return n & 0xFFFF;
    }

    public static int reg1_nef_LOAD1_ID_immediate(int n) {
        return n;
    }

    public static int reg1_hef_LOAD1_MEM_BYTE_seg0_addr0(Segment segment, int n) {
        return 0xFF & segment.getByte(n);
    }

    public static int reg1_hef_LOAD1_MEM_WORD_seg0_addr0(Segment segment, int n) {
        return 0xFFFF & segment.getWord(n);
    }

    public static int reg1_hef_LOAD1_MEM_DWORD_seg0_addr0(Segment segment, int n) {
        return segment.getDoubleWord(n);
    }

    public static int reg2_nef_LOAD2_EAX_eax(int n) {
        return n;
    }

    public static int reg2_nef_LOAD2_AX_eax(int n) {
        return 0xFFFF & n;
    }

    public static int reg2_nef_LOAD2_AL_eax(int n) {
        return 0xFF & n;
    }

    public static int reg2_nef_LOAD2_CL_ecx(int n) {
        return 0xFF & n;
    }

    public static int reg2_nef_LOAD2_IB_immediate(int n) {
        return n & 0xFF;
    }

    public static Segment seg0_nef_LOAD_SEG_CS_cs(Segment segment) {
        return segment;
    }

    public static Segment seg0_nef_LOAD_SEG_DS_ds(Segment segment) {
        return segment;
    }

    public static Segment seg0_nef_LOAD_SEG_ES_es(Segment segment) {
        return segment;
    }

    public static Segment seg0_nef_LOAD_SEG_FS_fs(Segment segment) {
        return segment;
    }

    public static Segment seg0_nef_LOAD_SEG_GS_gs(Segment segment) {
        return segment;
    }

    public static Segment seg0_nef_LOAD_SEG_SS_ss(Segment segment) {
        return segment;
    }

    public static int eax_nef_STORE0_AL_eax_reg0(int n, int n2) {
        return n & 0xFFFFFF00 | n2 & 0xFF;
    }

    public static int ecx_nef_STORE0_CL_ecx_reg0(int n, int n2) {
        return n & 0xFFFFFF00 | n2 & 0xFF;
    }

    public static int edx_nef_STORE0_DL_edx_reg0(int n, int n2) {
        return n & 0xFFFFFF00 | n2 & 0xFF;
    }

    public static int ebx_nef_STORE0_BL_ebx_reg0(int n, int n2) {
        return n & 0xFFFFFF00 | n2 & 0xFF;
    }

    public static int eax_nef_STORE0_AH_eax_reg0(int n, int n2) {
        return n & 0xFFFF00FF | n2 << 8 & 0xFF00;
    }

    public static int ecx_nef_STORE0_CH_ecx_reg0(int n, int n2) {
        return n & 0xFFFF00FF | n2 << 8 & 0xFF00;
    }

    public static int edx_nef_STORE0_DH_edx_reg0(int n, int n2) {
        return n & 0xFFFF00FF | n2 << 8 & 0xFF00;
    }

    public static int ebx_nef_STORE0_BH_ebx_reg0(int n, int n2) {
        return n & 0xFFFF00FF | n2 << 8 & 0xFF00;
    }

    public static int eax_nef_STORE0_AX_eax_reg0(int n, int n2) {
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int ecx_nef_STORE0_CX_ecx_reg0(int n, int n2) {
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int edx_nef_STORE0_DX_edx_reg0(int n, int n2) {
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int ebx_nef_STORE0_BX_ebx_reg0(int n, int n2) {
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int esp_nef_STORE0_SP_esp_reg0(int n, int n2) {
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int ebp_nef_STORE0_BP_ebp_reg0(int n, int n2) {
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int esi_nef_STORE0_SI_esi_reg0(int n, int n2) {
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int edi_nef_STORE0_DI_edi_reg0(int n, int n2) {
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int eax_nef_STORE0_EAX_reg0(int n) {
        return n;
    }

    public static int ecx_nef_STORE0_ECX_reg0(int n) {
        return n;
    }

    public static int edx_nef_STORE0_EDX_reg0(int n) {
        return n;
    }

    public static int ebx_nef_STORE0_EBX_reg0(int n) {
        return n;
    }

    public static int esp_nef_STORE0_ESP_reg0(int n) {
        return n;
    }

    public static int ebp_nef_STORE0_EBP_reg0(int n) {
        return n;
    }

    public static int esi_nef_STORE0_ESI_reg0(int n) {
        return n;
    }

    public static int edi_nef_STORE0_EDI_reg0(int n) {
        return n;
    }

    public static void memorywrite_hef_STORE0_MEM_BYTE_seg0_addr0_reg0(Segment segment, int n, int n2) {
        segment.setByte(n, (byte)n2);
    }

    public static void memorywrite_hef_STORE0_MEM_WORD_seg0_addr0_reg0(Segment segment, int n, int n2) {
        segment.setWord(n, (short)n2);
    }

    public static void memorywrite_hef_STORE0_MEM_DWORD_seg0_addr0_reg0(Segment segment, int n, int n2) {
        segment.setDoubleWord(n, n2);
    }

    public static boolean aflag_nef_STORE0_FLAGS_reg0(int n) {
        return (n & 0x10) != 0;
    }

    public static boolean cflag_nef_STORE0_FLAGS_reg0(int n) {
        return (n & 1) != 0;
    }

    public static boolean dflag_nef_STORE0_FLAGS_reg0(int n) {
        return (n & 0x400) != 0;
    }

    public static boolean iflag_nef_STORE0_FLAGS_reg0(int n) {
        return (n & 0x200) != 0;
    }

    public static int iopl_nef_STORE0_FLAGS_reg0(int n) {
        return n >>> 12 & 3;
    }

    public static boolean ntflag_nef_STORE0_FLAGS_reg0(int n) {
        return (n & 0x4000) != 0;
    }

    public static boolean oflag_nef_STORE0_FLAGS_reg0(int n) {
        return (n & 0x800) != 0;
    }

    public static boolean pflag_nef_STORE0_FLAGS_reg0(int n) {
        return (n & 4) != 0;
    }

    public static boolean sflag_nef_STORE0_FLAGS_reg0(int n) {
        return (n & 0x80) != 0;
    }

    public static boolean tflag_nef_STORE0_FLAGS_reg0(int n) {
        return (n & 0x100) != 0;
    }

    public static boolean zflag_nef_STORE0_FLAGS_reg0(int n) {
        return (n & 0x40) != 0;
    }

    public static int eax_nef_STORE1_AL_eax_reg1(int n, int n2) {
        return n & 0xFFFFFF00 | n2 & 0xFF;
    }

    public static int ecx_nef_STORE1_CL_ecx_reg1(int n, int n2) {
        return n & 0xFFFFFF00 | n2 & 0xFF;
    }

    public static int edx_nef_STORE1_DL_edx_reg1(int n, int n2) {
        return n & 0xFFFFFF00 | n2 & 0xFF;
    }

    public static int ebx_nef_STORE1_BL_ebx_reg1(int n, int n2) {
        return n & 0xFFFFFF00 | n2 & 0xFF;
    }

    public static int eax_nef_STORE1_AH_eax_reg1(int n, int n2) {
        return n & 0xFFFF00FF | n2 << 8 & 0xFF00;
    }

    public static int ecx_nef_STORE1_CH_ecx_reg1(int n, int n2) {
        return n & 0xFFFF00FF | n2 << 8 & 0xFF00;
    }

    public static int edx_nef_STORE1_DH_edx_reg1(int n, int n2) {
        return n & 0xFFFF00FF | n2 << 8 & 0xFF00;
    }

    public static int ebx_nef_STORE1_BH_ebx_reg1(int n, int n2) {
        return n & 0xFFFF00FF | n2 << 8 & 0xFF00;
    }

    public static int eax_nef_STORE1_AX_eax_reg1(int n, int n2) {
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int ecx_nef_STORE1_CX_ecx_reg1(int n, int n2) {
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int edx_nef_STORE1_DX_edx_reg1(int n, int n2) {
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int ebx_nef_STORE1_BX_ebx_reg1(int n, int n2) {
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int esp_nef_STORE1_SP_esp_reg1(int n, int n2) {
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int ebp_nef_STORE1_BP_ebp_reg1(int n, int n2) {
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int esi_nef_STORE1_SI_esi_reg1(int n, int n2) {
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int edi_nef_STORE1_DI_edi_reg1(int n, int n2) {
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int eax_nef_STORE1_EAX_reg1(int n) {
        return n;
    }

    public static int ecx_nef_STORE1_ECX_reg1(int n) {
        return n;
    }

    public static int edx_nef_STORE1_EDX_reg1(int n) {
        return n;
    }

    public static int ebx_nef_STORE1_EBX_reg1(int n) {
        return n;
    }

    public static int esp_nef_STORE1_ESP_reg1(int n) {
        return n;
    }

    public static int ebp_nef_STORE1_EBP_reg1(int n) {
        return n;
    }

    public static int esi_nef_STORE1_ESI_reg1(int n) {
        return n;
    }

    public static int edi_nef_STORE1_EDI_reg1(int n) {
        return n;
    }

    public static void memorywrite_hef_STORE1_MEM_BYTE_seg0_addr0_reg1(Segment segment, int n, int n2) {
        segment.setByte(n, (byte)n2);
    }

    public static void memorywrite_hef_STORE1_MEM_WORD_seg0_addr0_reg1(Segment segment, int n, int n2) {
        segment.setWord(n, (short)n2);
    }

    public static void memorywrite_hef_STORE1_MEM_DWORD_seg0_addr0_reg1(Segment segment, int n, int n2) {
        segment.setDoubleWord(n, n2);
    }

    public static int addr0_nef_ADDR_AX_addr0_eax(int n, int n2) {
        return n + (short)n2;
    }

    public static int addr0_nef_ADDR_CX_addr0_ecx(int n, int n2) {
        return n + (short)n2;
    }

    public static int addr0_nef_ADDR_DX_addr0_edx(int n, int n2) {
        return n + (short)n2;
    }

    public static int addr0_nef_ADDR_BX_addr0_ebx(int n, int n2) {
        return n + (short)n2;
    }

    public static int addr0_nef_ADDR_SP_addr0_esp(int n, int n2) {
        return n + (short)n2;
    }

    public static int addr0_nef_ADDR_BP_addr0_ebp(int n, int n2) {
        return n + (short)n2;
    }

    public static int addr0_nef_ADDR_SI_addr0_esi(int n, int n2) {
        return n + (short)n2;
    }

    public static int addr0_nef_ADDR_DI_addr0_edi(int n, int n2) {
        return n + (short)n2;
    }

    public static int addr0_nef_ADDR_EAX_addr0_eax(int n, int n2) {
        return n + n2;
    }

    public static int addr0_nef_ADDR_ECX_addr0_ecx(int n, int n2) {
        return n + n2;
    }

    public static int addr0_nef_ADDR_EDX_addr0_edx(int n, int n2) {
        return n + n2;
    }

    public static int addr0_nef_ADDR_EBX_addr0_ebx(int n, int n2) {
        return n + n2;
    }

    public static int addr0_nef_ADDR_ESP_addr0_esp(int n, int n2) {
        return n + n2;
    }

    public static int addr0_nef_ADDR_EBP_addr0_ebp(int n, int n2) {
        return n + n2;
    }

    public static int addr0_nef_ADDR_ESI_addr0_esi(int n, int n2) {
        return n + n2;
    }

    public static int addr0_nef_ADDR_EDI_addr0_edi(int n, int n2) {
        return n + n2;
    }

    public static int addr0_nef_ADDR_2EAX_addr0_eax(int n, int n2) {
        return n + (n2 << 1);
    }

    public static int addr0_nef_ADDR_2ECX_addr0_ecx(int n, int n2) {
        return n + (n2 << 1);
    }

    public static int addr0_nef_ADDR_2EDX_addr0_edx(int n, int n2) {
        return n + (n2 << 1);
    }

    public static int addr0_nef_ADDR_2EBX_addr0_ebx(int n, int n2) {
        return n + (n2 << 1);
    }

    public static int addr0_nef_ADDR_2ESP_addr0_esp(int n, int n2) {
        return n + (n2 << 1);
    }

    public static int addr0_nef_ADDR_2EBP_addr0_ebp(int n, int n2) {
        return n + (n2 << 1);
    }

    public static int addr0_nef_ADDR_2ESI_addr0_esi(int n, int n2) {
        return n + (n2 << 1);
    }

    public static int addr0_nef_ADDR_2EDI_addr0_edi(int n, int n2) {
        return n + (n2 << 1);
    }

    public static int addr0_nef_ADDR_4EAX_addr0_eax(int n, int n2) {
        return n + (n2 << 2);
    }

    public static int addr0_nef_ADDR_4ECX_addr0_ecx(int n, int n2) {
        return n + (n2 << 2);
    }

    public static int addr0_nef_ADDR_4EDX_addr0_edx(int n, int n2) {
        return n + (n2 << 2);
    }

    public static int addr0_nef_ADDR_4EBX_addr0_ebx(int n, int n2) {
        return n + (n2 << 2);
    }

    public static int addr0_nef_ADDR_4ESP_addr0_esp(int n, int n2) {
        return n + (n2 << 2);
    }

    public static int addr0_nef_ADDR_4EBP_addr0_ebp(int n, int n2) {
        return n + (n2 << 2);
    }

    public static int addr0_nef_ADDR_4ESI_addr0_esi(int n, int n2) {
        return n + (n2 << 2);
    }

    public static int addr0_nef_ADDR_4EDI_addr0_edi(int n, int n2) {
        return n + (n2 << 2);
    }

    public static int addr0_nef_ADDR_8EAX_addr0_eax(int n, int n2) {
        return n + (n2 << 3);
    }

    public static int addr0_nef_ADDR_8ECX_addr0_ecx(int n, int n2) {
        return n + (n2 << 3);
    }

    public static int addr0_nef_ADDR_8EDX_addr0_edx(int n, int n2) {
        return n + (n2 << 3);
    }

    public static int addr0_nef_ADDR_8EBX_addr0_ebx(int n, int n2) {
        return n + (n2 << 3);
    }

    public static int addr0_nef_ADDR_8ESP_addr0_esp(int n, int n2) {
        return n + (n2 << 3);
    }

    public static int addr0_nef_ADDR_8EBP_addr0_ebp(int n, int n2) {
        return n + (n2 << 3);
    }

    public static int addr0_nef_ADDR_8ESI_addr0_esi(int n, int n2) {
        return n + (n2 << 3);
    }

    public static int addr0_nef_ADDR_8EDI_addr0_edi(int n, int n2) {
        return n + (n2 << 3);
    }

    public static int addr0_nef_ADDR_IB_addr0_immediate(int n, int n2) {
        return n + (byte)n2;
    }

    public static int addr0_nef_ADDR_IW_addr0_immediate(int n, int n2) {
        return n + (short)n2;
    }

    public static int addr0_nef_ADDR_ID_addr0_immediate(int n, int n2) {
        return n + n2;
    }

    public static int addr0_nef_ADDR_MASK16_addr0(int n) {
        return n & 0xFFFF;
    }

    public static int addr0_nef_ADDR_uAL_addr0_eax(int n, int n2) {
        return n + (0xFF & n2);
    }

    public static int addr0_nef_ADDR_REG1_addr0_reg1(int n, int n2) {
        return n + n2;
    }

    public static int addr0_nef_MEM_RESET() {
        return 0;
    }

    public static Segment seg0_nef_MEM_RESET() {
        return null;
    }

    public static int reg0_nef_SIGN_EXTEND_8_16_reg0(int n) {
        return 0xFFFF & (byte)n;
    }

    public static int reg0_nef_SIGN_EXTEND_8_32_reg0(int n) {
        return (byte)n;
    }

    public static int reg0_nef_SIGN_EXTEND_16_32_reg0(int n) {
        return (short)n;
    }

    public static int eip_nef_JUMP_O8_cs_eip_reg0(Segment segment, int n, int n2) throws ProcessorException {
        segment.checkAddress(n += (byte)n2);
        return n;
    }

    public static int eip_nef_JUMP_O16_cs_eip_reg0(Segment segment, int n, int n2) throws ProcessorException {
        n = n + n2 & 0xFFFF;
        segment.checkAddress(n);
        return n;
    }

    public static int eip_nef_JUMP_O32_cs_eip_reg0(Segment segment, int n, int n2) throws ProcessorException {
        segment.checkAddress(n += n2);
        return n;
    }

    public static int eip_nef_JUMP_ABS_O32_cs_reg0(Segment segment, int n) throws ProcessorException {
        segment.checkAddress(n);
        return n;
    }

    public static int ecx_nef_LOOP_CX_ecx(int n) {
        return n & 0xFFFF0000 | n - 1 & 0xFFFF;
    }

    public static int eip_nef_LOOP_CX_cs_eip_reg0_ecx(Segment segment, int n, int n2, int n3) throws ProcessorException {
        if ((0xFFFF & n3 - 1) != 0) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int ecx_nef_LOOP_ECX_ecx(int n) {
        return n - 1;
    }

    public static int eip_nef_LOOP_ECX_cs_eip_reg0_ecx(Segment segment, int n, int n2, int n3) throws ProcessorException {
        if (n3 - 1 != 0) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JO_O8_cs_eip_reg0_oflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JO_O16_cs_eip_reg0_oflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O16_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JO_O32_cs_eip_reg0_oflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O32_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNO_O8_cs_eip_reg0_oflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (!bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNO_O16_cs_eip_reg0_oflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (!bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O16_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNO_O32_cs_eip_reg0_oflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (!bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O32_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JC_O8_cs_eip_reg0_cflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JC_O16_cs_eip_reg0_cflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O16_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JC_O32_cs_eip_reg0_cflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O32_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNC_O8_cs_eip_reg0_cflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (!bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNC_O16_cs_eip_reg0_cflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (!bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O16_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNC_O32_cs_eip_reg0_cflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (!bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O32_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JZ_O8_cs_eip_reg0_zflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JZ_O16_cs_eip_reg0_zflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O16_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JZ_O32_cs_eip_reg0_zflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O32_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNZ_O8_cs_eip_reg0_zflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (!bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNZ_O16_cs_eip_reg0_zflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (!bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O16_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNZ_O32_cs_eip_reg0_zflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (!bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O32_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNA_O8_cs_eip_reg0_cflag_zflag(Segment segment, int n, int n2, boolean bl, boolean bl2) throws ProcessorException {
        if (bl || bl2) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNA_O16_cs_eip_reg0_cflag_zflag(Segment segment, int n, int n2, boolean bl, boolean bl2) throws ProcessorException {
        if (bl || bl2) {
            return UCodeStaticMethods.eip_nef_JUMP_O16_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNA_O32_cs_eip_reg0_cflag_zflag(Segment segment, int n, int n2, boolean bl, boolean bl2) throws ProcessorException {
        if (bl || bl2) {
            return UCodeStaticMethods.eip_nef_JUMP_O32_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JA_O8_cs_eip_reg0_cflag_zflag(Segment segment, int n, int n2, boolean bl, boolean bl2) throws ProcessorException {
        if (!bl && !bl2) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JA_O16_cs_eip_reg0_cflag_zflag(Segment segment, int n, int n2, boolean bl, boolean bl2) throws ProcessorException {
        if (!bl && !bl2) {
            return UCodeStaticMethods.eip_nef_JUMP_O16_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JA_O32_cs_eip_reg0_cflag_zflag(Segment segment, int n, int n2, boolean bl, boolean bl2) throws ProcessorException {
        if (!bl && !bl2) {
            return UCodeStaticMethods.eip_nef_JUMP_O32_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JS_O8_cs_eip_reg0_sflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JS_O16_cs_eip_reg0_sflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O16_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JS_O32_cs_eip_reg0_sflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O32_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNS_O8_cs_eip_reg0_sflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (!bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNS_O16_cs_eip_reg0_sflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (!bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O16_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNS_O32_cs_eip_reg0_sflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (!bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O32_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JP_O8_cs_eip_reg0_pflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JP_O16_cs_eip_reg0_pflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O16_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JP_O32_cs_eip_reg0_pflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O32_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNP_O8_cs_eip_reg0_pflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (!bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNP_O16_cs_eip_reg0_pflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (!bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O16_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNP_O32_cs_eip_reg0_pflag(Segment segment, int n, int n2, boolean bl) throws ProcessorException {
        if (!bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O32_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JL_O8_cs_eip_reg0_oflag_sflag(Segment segment, int n, int n2, boolean bl, boolean bl2) throws ProcessorException {
        if (bl2 != bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JL_O16_cs_eip_reg0_oflag_sflag(Segment segment, int n, int n2, boolean bl, boolean bl2) throws ProcessorException {
        if (bl2 != bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O16_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JL_O32_cs_eip_reg0_oflag_sflag(Segment segment, int n, int n2, boolean bl, boolean bl2) throws ProcessorException {
        if (bl2 != bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O32_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNL_O8_cs_eip_reg0_oflag_sflag(Segment segment, int n, int n2, boolean bl, boolean bl2) throws ProcessorException {
        if (bl2 == bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNL_O16_cs_eip_reg0_oflag_sflag(Segment segment, int n, int n2, boolean bl, boolean bl2) throws ProcessorException {
        if (bl2 == bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O16_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNL_O32_cs_eip_reg0_oflag_sflag(Segment segment, int n, int n2, boolean bl, boolean bl2) throws ProcessorException {
        if (bl2 == bl) {
            return UCodeStaticMethods.eip_nef_JUMP_O32_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNG_O8_cs_eip_reg0_zflag_sflag_oflag(Segment segment, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws ProcessorException {
        if (bl || bl2 != bl3) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNG_O16_cs_eip_reg0_zflag_sflag_oflag(Segment segment, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws ProcessorException {
        if (bl || bl2 != bl3) {
            return UCodeStaticMethods.eip_nef_JUMP_O16_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JNG_O32_cs_eip_reg0_zflag_sflag_oflag(Segment segment, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws ProcessorException {
        if (bl || bl2 != bl3) {
            return UCodeStaticMethods.eip_nef_JUMP_O32_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JG_O8_cs_eip_reg0_zflag_sflag_oflag(Segment segment, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws ProcessorException {
        if (!bl && bl2 == bl3) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JG_O16_cs_eip_reg0_zflag_sflag_oflag(Segment segment, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws ProcessorException {
        if (!bl && bl2 == bl3) {
            return UCodeStaticMethods.eip_nef_JUMP_O16_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JG_O32_cs_eip_reg0_zflag_sflag_oflag(Segment segment, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws ProcessorException {
        if (!bl && bl2 == bl3) {
            return UCodeStaticMethods.eip_nef_JUMP_O32_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JCXZ_cs_eip_reg0_ecx(Segment segment, int n, int n2, int n3) throws ProcessorException {
        if ((n3 & 0xFFFF) == 0) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int eip_nef_JECXZ_cs_eip_reg0_ecx(Segment segment, int n, int n2, int n3) throws ProcessorException {
        if (n3 == 0) {
            return UCodeStaticMethods.eip_nef_JUMP_O8_cs_eip_reg0(segment, n, n2);
        }
        return n;
    }

    public static int reg0_nef_AND_reg0_reg1(int n, int n2) {
        return n & n2;
    }

    public static int reg0_nef_OR_reg0_reg1(int n, int n2) {
        return n | n2;
    }

    public static int reg0_nef_XOR_reg0_reg1(int n, int n2) {
        return n ^ n2;
    }

    public static int reg0_nef_NOT_reg0(int n) {
        return ~n;
    }

    public static boolean cflag_nef_BITWISE_FLAGS_O8() {
        return false;
    }

    public static boolean oflag_nef_BITWISE_FLAGS_O8() {
        return false;
    }

    public static boolean pflag_nef_BITWISE_FLAGS_O8_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_BITWISE_FLAGS_O8_reg0(int n) {
        return (byte)n < 0;
    }

    public static boolean zflag_nef_BITWISE_FLAGS_O8_reg0(int n) {
        return (byte)n == 0;
    }

    public static boolean cflag_nef_BITWISE_FLAGS_O16() {
        return false;
    }

    public static boolean oflag_nef_BITWISE_FLAGS_O16() {
        return false;
    }

    public static boolean pflag_nef_BITWISE_FLAGS_O16_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_BITWISE_FLAGS_O16_reg0(int n) {
        return (short)n < 0;
    }

    public static boolean zflag_nef_BITWISE_FLAGS_O16_reg0(int n) {
        return (short)n == 0;
    }

    public static boolean cflag_nef_BITWISE_FLAGS_O32() {
        return false;
    }

    public static boolean oflag_nef_BITWISE_FLAGS_O32() {
        return false;
    }

    public static boolean pflag_nef_BITWISE_FLAGS_O32_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_BITWISE_FLAGS_O32_reg0(int n) {
        return n < 0;
    }

    public static boolean zflag_nef_BITWISE_FLAGS_O32_reg0(int n) {
        return n == 0;
    }

    public static int reg0_nef_SHL_reg0_reg1(int n, int n2) {
        return n << n2;
    }

    public static int reg1_nef_SHL_reg1(int n) {
        return n & 0x1F;
    }

    public static int reg2_nef_SHL_reg0(int n) {
        return n;
    }

    public static boolean cflag_nef_SHL_O8_FLAGS_cflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n & 0x100) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_SHL_O8_FLAGS_oflag_reg2_reg1(boolean bl, int n, int n2) {
        if (n2 == 1) {
            return (n & 0xC0) != 0 && (n & 0xC0) != 192;
        }
        return bl;
    }

    public static boolean pflag_nef_SHL_O8_FLAGS_pflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return parityMap[n & 0xFF];
        }
        return bl;
    }

    public static boolean sflag_nef_SHL_O8_FLAGS_sflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (byte)n < 0;
        }
        return bl;
    }

    public static boolean zflag_nef_SHL_O8_FLAGS_zflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (byte)n == 0;
        }
        return bl;
    }

    public static boolean cflag_nef_SHL_O16_FLAGS_cflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n & 0x10000) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_SHL_O16_FLAGS_oflag_reg2_reg1(boolean bl, int n, int n2) {
        if (n2 == 1) {
            return (n & 0xC000) != 0 && (n & 0xC000) != 49152;
        }
        return bl;
    }

    public static boolean pflag_nef_SHL_O16_FLAGS_pflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return parityMap[n & 0xFF];
        }
        return bl;
    }

    public static boolean sflag_nef_SHL_O16_FLAGS_sflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (short)n < 0;
        }
        return bl;
    }

    public static boolean zflag_nef_SHL_O16_FLAGS_zflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (short)n == 0;
        }
        return bl;
    }

    public static boolean cflag_nef_SHL_O32_FLAGS_cflag_reg2_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n << n2 - 1 & Integer.MIN_VALUE) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_SHL_O32_FLAGS_oflag_reg2_reg1(boolean bl, int n, int n2) {
        if (n2 == 1) {
            return (n & 0xC0000000) != 0 && (n & 0xC0000000) != -1073741824;
        }
        return bl;
    }

    public static boolean pflag_nef_SHL_O32_FLAGS_pflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return parityMap[n & 0xFF];
        }
        return bl;
    }

    public static boolean sflag_nef_SHL_O32_FLAGS_sflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return n < 0;
        }
        return bl;
    }

    public static boolean zflag_nef_SHL_O32_FLAGS_zflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return n == 0;
        }
        return bl;
    }

    public static int reg0_nef_SHR_reg0_reg1(int n, int n2) {
        return n >>> n2;
    }

    public static int reg1_nef_SHR_reg1(int n) {
        return n & 0x1F;
    }

    public static int reg2_nef_SHR_reg0(int n) {
        return n;
    }

    public static boolean cflag_nef_SHR_O8_FLAGS_cflag_reg2_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n >>> n2 - 1 & 1) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_SHR_O8_FLAGS_oflag_reg2_reg1(boolean bl, int n, int n2) {
        if (n2 == 1) {
            return (n & 0x80) != 0;
        }
        return bl;
    }

    public static boolean pflag_nef_SHR_O8_FLAGS_pflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return parityMap[n & 0xFF];
        }
        return bl;
    }

    public static boolean sflag_nef_SHR_O8_FLAGS_sflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (byte)n < 0;
        }
        return bl;
    }

    public static boolean zflag_nef_SHR_O8_FLAGS_zflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (byte)n == 0;
        }
        return bl;
    }

    public static boolean cflag_nef_SHR_O16_FLAGS_cflag_reg2_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n >>> n2 - 1 & 1) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_SHR_O16_FLAGS_oflag_reg2_reg1(boolean bl, int n, int n2) {
        if (n2 == 1) {
            return (n & 0x8000) != 0;
        }
        return bl;
    }

    public static boolean pflag_nef_SHR_O16_FLAGS_pflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return parityMap[n & 0xFF];
        }
        return bl;
    }

    public static boolean sflag_nef_SHR_O16_FLAGS_sflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (short)n < 0;
        }
        return bl;
    }

    public static boolean zflag_nef_SHR_O16_FLAGS_zflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (short)n == 0;
        }
        return bl;
    }

    public static boolean cflag_nef_SHR_O32_FLAGS_cflag_reg2_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n >>> n2 - 1 & 1) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_SHR_O32_FLAGS_oflag_reg2_reg1(boolean bl, int n, int n2) {
        if (n2 == 1) {
            return (n & Integer.MIN_VALUE) != 0;
        }
        return bl;
    }

    public static boolean pflag_nef_SHR_O32_FLAGS_pflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return parityMap[n & 0xFF];
        }
        return bl;
    }

    public static boolean sflag_nef_SHR_O32_FLAGS_sflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return n < 0;
        }
        return bl;
    }

    public static boolean zflag_nef_SHR_O32_FLAGS_zflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return n == 0;
        }
        return bl;
    }

    public static int reg0_nef_SAR_O8_reg1_reg0(int n, int n2) {
        return (byte)n2 >> n;
    }

    public static int reg1_nef_SAR_O8_reg1(int n) {
        return n & 0x1F;
    }

    public static int reg2_nef_SAR_O8_reg0(int n) {
        return n;
    }

    public static int reg0_nef_SAR_O16_reg1_reg0(int n, int n2) {
        return (short)n2 >> n;
    }

    public static int reg1_nef_SAR_O16_reg1(int n) {
        return n & 0x1F;
    }

    public static int reg2_nef_SAR_O16_reg0(int n) {
        return n;
    }

    public static int reg0_nef_SAR_O32_reg0_reg1(int n, int n2) {
        return n >> n2;
    }

    public static int reg1_nef_SAR_O32_reg1(int n) {
        return n & 0x1F;
    }

    public static int reg2_nef_SAR_O32_reg0(int n) {
        return n;
    }

    public static boolean cflag_nef_SAR_O8_FLAGS_cflag_reg2_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n >> n2 - 1 & 1) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_SAR_O8_FLAGS_oflag_reg1(boolean bl, int n) {
        if (n == 1) {
            return false;
        }
        return bl;
    }

    public static boolean pflag_nef_SAR_O8_FLAGS_pflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return parityMap[n & 0xFF];
        }
        return bl;
    }

    public static boolean sflag_nef_SAR_O8_FLAGS_sflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (byte)n < 0;
        }
        return bl;
    }

    public static boolean zflag_nef_SAR_O8_FLAGS_zflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (byte)n == 0;
        }
        return bl;
    }

    public static boolean cflag_nef_SAR_O16_FLAGS_cflag_reg2_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n >> n2 - 1 & 1) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_SAR_O16_FLAGS_oflag_reg1(boolean bl, int n) {
        if (n == 1) {
            return false;
        }
        return bl;
    }

    public static boolean pflag_nef_SAR_O16_FLAGS_pflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return parityMap[n & 0xFF];
        }
        return bl;
    }

    public static boolean sflag_nef_SAR_O16_FLAGS_sflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (short)n < 0;
        }
        return bl;
    }

    public static boolean zflag_nef_SAR_O16_FLAGS_zflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (short)n == 0;
        }
        return bl;
    }

    public static boolean cflag_nef_SAR_O32_FLAGS_cflag_reg2_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n >> n2 - 1 & 1) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_SAR_O32_FLAGS_oflag_reg1(boolean bl, int n) {
        if (n == 1) {
            return false;
        }
        return bl;
    }

    public static boolean pflag_nef_SAR_O32_FLAGS_pflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return parityMap[n & 0xFF];
        }
        return bl;
    }

    public static boolean sflag_nef_SAR_O32_FLAGS_sflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return n < 0;
        }
        return bl;
    }

    public static boolean zflag_nef_SAR_O32_FLAGS_zflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return n == 0;
        }
        return bl;
    }

    public static int reg0_nef_ROL_O8_reg0_reg1(int n, int n2) {
        return n << (n2 &= 7) | n >>> 8 - n2;
    }

    public static int reg1_nef_ROL_O8_reg1(int n) {
        return n & 7;
    }

    public static int reg0_nef_ROL_O16_reg0_reg1(int n, int n2) {
        return n << (n2 &= 0xF) | n >>> 16 - n2;
    }

    public static int reg1_nef_ROL_O16_reg1(int n) {
        return n & 0xF;
    }

    public static int reg0_nef_ROL_O32_reg0_reg1(int n, int n2) {
        return n << (n2 &= 0x1F) | n >>> 32 - n2;
    }

    public static int reg1_nef_ROL_O32_reg1(int n) {
        return n & 0x1F;
    }

    public static boolean cflag_nef_ROL_O8_FLAGS_cflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n & 1) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_ROL_O8_FLAGS_oflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 == 1) {
            return (n & 0x81) != 0 && (n & 0x81) != 129;
        }
        return bl;
    }

    public static boolean cflag_nef_ROL_O16_FLAGS_cflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n & 1) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_ROL_O16_FLAGS_oflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 == 1) {
            return (n & 0x8001) != 0 && (n & 0x8001) != 32769;
        }
        return bl;
    }

    public static boolean cflag_nef_ROL_O32_FLAGS_cflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n & 1) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_ROL_O32_FLAGS_oflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 == 1) {
            return (n & 0x80000001) != 0 && (n & 0x80000001) != -2147483647;
        }
        return bl;
    }

    public static int reg0_nef_ROR_O8_reg0_reg1(int n, int n2) {
        return n >>> (n2 &= 7) | n << 8 - n2;
    }

    public static int reg1_nef_ROR_O8_reg1(int n) {
        return n & 7;
    }

    public static int reg0_nef_ROR_O16_reg0_reg1(int n, int n2) {
        return n >>> (n2 &= 0xF) | n << 16 - n2;
    }

    public static int reg1_nef_ROR_O16_reg1(int n) {
        return n & 0xF;
    }

    public static int reg0_nef_ROR_O32_reg0_reg1(int n, int n2) {
        return n >>> (n2 &= 0x1F) | n << 32 - n2;
    }

    public static int reg1_nef_ROR_O32_reg1(int n) {
        return n & 0x1F;
    }

    public static boolean cflag_nef_ROR_O8_FLAGS_cflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n & 0x80) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_ROR_O8_FLAGS_oflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 == 1) {
            return (n & 0xC0) != 0 && (n & 0xC0) != 192;
        }
        return bl;
    }

    public static boolean cflag_nef_ROR_O16_FLAGS_cflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n & 0x8000) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_ROR_O16_FLAGS_oflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 == 1) {
            return (n & 0xC000) != 0 && (n & 0xC000) != 49152;
        }
        return bl;
    }

    public static boolean cflag_nef_ROR_O32_FLAGS_cflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n & Integer.MIN_VALUE) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_ROR_O32_FLAGS_oflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 == 1) {
            return (n & 0xC0000000) != 0 && (n & 0xC0000000) != -1073741824;
        }
        return bl;
    }

    public static int reg0_nef_RCL_O8_reg1_reg0_cflag(int n, int n2, boolean bl) {
        n &= 0x1F;
        return (n2 |= bl ? 256 : 0) << (n %= 9) | n2 >>> 9 - n;
    }

    public static int reg1_nef_RCL_O8_reg1(int n) {
        return (n &= 0x1F) % 9;
    }

    public static int reg0_nef_RCL_O16_reg1_reg0_cflag(int n, int n2, boolean bl) {
        n &= 0x1F;
        return (n2 |= bl ? 65536 : 0) << (n %= 17) | n2 >>> 17 - n;
    }

    public static int reg1_nef_RCL_O16_reg1(int n) {
        return (n &= 0x1F) % 17;
    }

    public static boolean cflag_nef_RCL_O8_FLAGS_cflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n & 0x100) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_RCL_O8_FLAGS_oflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 == 1) {
            return (n & 0x180) != 0 && (n & 0x180) != 384;
        }
        return bl;
    }

    public static boolean cflag_nef_RCL_O16_FLAGS_cflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n & 0x10000) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_RCL_O16_FLAGS_oflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 == 1) {
            return (n & 0x18000) != 0 && (n & 0x18000) != 98304;
        }
        return bl;
    }

    public static int reg0_nef_RCR_O8_reg1_reg0_cflag(int n, int n2, boolean bl) {
        n &= 0x1F;
        return (n2 |= bl ? 256 : 0) >>> (n %= 9) | n2 << 9 - n;
    }

    public static int reg1_nef_RCR_O8_reg1(int n) {
        return (n &= 0x1F) % 9;
    }

    public static int reg0_nef_RCR_O16_reg1_reg0_cflag(int n, int n2, boolean bl) {
        n &= 0x1F;
        return (n2 |= bl ? 65536 : 0) >>> (n %= 17) | n2 << 17 - n;
    }

    public static int reg1_nef_RCR_O16_reg1(int n) {
        return (n &= 0x1F) % 17;
    }

    public static boolean cflag_nef_RCR_O8_FLAGS_cflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n & 0x100) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_RCR_O8_FLAGS_oflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 == 1) {
            return (n & 0x180) != 0 && (n & 0x180) != 384;
        }
        return bl;
    }

    public static boolean cflag_nef_RCR_O16_FLAGS_cflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 > 0) {
            return (n & 0x10000) != 0;
        }
        return bl;
    }

    public static boolean oflag_nef_RCR_O16_FLAGS_oflag_reg0_reg1(boolean bl, int n, int n2) {
        if (n2 == 1) {
            return (n & 0x18000) != 0 && (n & 0x18000) != 98304;
        }
        return bl;
    }

    public static int reg0_nef_SHRD_O16_reg0_reg1_reg2(int n, int n2, int n3) {
        if ((n3 &= 0x1F) != 0) {
            return n >>> n3 | n2 << 16 - n3;
        }
        return n;
    }

    public static int reg1_nef_SHRD_O16_reg2(int n) {
        return n & 0x1F;
    }

    public static int reg2_nef_SHRD_O16_reg0(int n) {
        return n;
    }

    public static int reg0_nef_SHRD_O32_reg0_reg1_reg2(int n, int n2, int n3) {
        if ((n3 &= 0x1F) != 0) {
            return n >>> n3 | n2 << 32 - n3;
        }
        return n;
    }

    public static int reg1_nef_SHRD_O32_reg2(int n) {
        return n & 0x1F;
    }

    public static int reg2_nef_SHRD_O32_reg0(int n) {
        return n;
    }

    public static int reg0_nef_SHLD_O16_reg0_reg1_reg2(int n, int n2, int n3) {
        if ((n3 &= 0x1F) != 0) {
            return n << n3 | n2 >>> 16 - n3;
        }
        return n;
    }

    public static int reg1_nef_SHLD_O16_reg2(int n) {
        return n & 0x1F;
    }

    public static int reg2_nef_SHLD_O16_reg0(int n) {
        return n;
    }

    public static int reg0_nef_SHLD_O32_reg0_reg1_reg2(int n, int n2, int n3) {
        if ((n3 &= 0x1F) != 0) {
            return n << n3 | n2 >>> 32 - n3;
        }
        return n;
    }

    public static int reg1_nef_SHLD_O32_reg2(int n) {
        return n & 0x1F;
    }

    public static int reg2_nef_SHLD_O32_reg0(int n) {
        return n;
    }

    public static int reg0_nef_BSF_reg1_reg0(int n, int n2) {
        if (n == 0) {
            return n2;
        }
        return Integer.numberOfTrailingZeros(n);
    }

    public static int zflag_nef_BSF_reg1(int n) {
        if (n == 0) {
            return 1;
        }
        return 0;
    }

    public static int reg0_nef_BSR_reg1_reg0(int n, int n2) {
        if (n == 0) {
            return n2;
        }
        return 31 - Integer.numberOfTrailingZeros(n);
    }

    public static int zflag_nef_BSR_reg1(int n) {
        if (n == 0) {
            return 1;
        }
        return 0;
    }

    public static int reg0_nef_ADD_reg0_reg1(int n, int n2) {
        return n + n2;
    }

    public static int reg2_nef_ADD_reg0(int n) {
        return n;
    }

    public static boolean aflag_nef_ADD_O8_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return ((n3 ^ n2 ^ n) & 0x10) != 0;
    }

    public static boolean cflag_nef_ADD_O8_FLAGS_reg0(int n) {
        return (n & 0xFFFFFF00) != 0;
    }

    public static boolean oflag_nef_ADD_O8_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return (n3 & 0x80) == (n2 & 0x80) && (n3 & 0x80) != (n & 0x80);
    }

    public static boolean pflag_nef_ADD_O8_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_ADD_O8_FLAGS_reg0(int n) {
        return (byte)n < 0;
    }

    public static boolean zflag_nef_ADD_O8_FLAGS_reg0(int n) {
        return (byte)n == 0;
    }

    public static boolean aflag_nef_ADD_O16_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return ((n3 ^ n2 ^ n) & 0x10) != 0;
    }

    public static boolean cflag_nef_ADD_O16_FLAGS_reg0(int n) {
        return (n & 0xFFFF0000) != 0;
    }

    public static boolean oflag_nef_ADD_O16_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return (n3 & 0x8000) == (n2 & 0x8000) && (n3 & 0x8000) != (n & 0x8000);
    }

    public static boolean pflag_nef_ADD_O16_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_ADD_O16_FLAGS_reg0(int n) {
        return (short)n < 0;
    }

    public static boolean zflag_nef_ADD_O16_FLAGS_reg0(int n) {
        return (short)n == 0;
    }

    public static boolean aflag_nef_ADD_O32_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return ((n3 ^ n2 ^ n) & 0x10) != 0;
    }

    public static boolean cflag_nef_ADD_O32_FLAGS_reg1_reg2(int n, int n2) {
        long l = (0xFFFFFFFFL & (long)n2) + (0xFFFFFFFFL & (long)n);
        return (l & 0xFFFFFFFF00000000L) != 0L;
    }

    public static boolean oflag_nef_ADD_O32_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return (n3 & Integer.MIN_VALUE) == (n2 & Integer.MIN_VALUE) && (n3 & Integer.MIN_VALUE) != (n & Integer.MIN_VALUE);
    }

    public static boolean pflag_nef_ADD_O32_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_ADD_O32_FLAGS_reg0(int n) {
        return n < 0;
    }

    public static boolean zflag_nef_ADD_O32_FLAGS_reg0(int n) {
        return n == 0;
    }

    public static int reg0_nef_SUB_reg0_reg1(int n, int n2) {
        return n - n2;
    }

    public static int reg2_nef_SUB_reg0(int n) {
        return n;
    }

    public static boolean aflag_nef_SUB_O8_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return ((n3 ^ n2 ^ n) & 0x10) != 0;
    }

    public static boolean cflag_nef_SUB_O8_FLAGS_reg0(int n) {
        return (n & 0xFFFFFF00) != 0;
    }

    public static boolean oflag_nef_SUB_O8_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return (n3 & 0x80) != (n2 & 0x80) && (n3 & 0x80) != (n & 0x80);
    }

    public static boolean pflag_nef_SUB_O8_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_SUB_O8_FLAGS_reg0(int n) {
        return (byte)n < 0;
    }

    public static boolean zflag_nef_SUB_O8_FLAGS_reg0(int n) {
        return (byte)n == 0;
    }

    public static boolean aflag_nef_SUB_O16_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return ((n3 ^ n2 ^ n) & 0x10) != 0;
    }

    public static boolean cflag_nef_SUB_O16_FLAGS_reg0(int n) {
        return (n & 0xFFFF0000) != 0;
    }

    public static boolean oflag_nef_SUB_O16_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return (n3 & 0x8000) != (n2 & 0x8000) && (n3 & 0x8000) != (n & 0x8000);
    }

    public static boolean pflag_nef_SUB_O16_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_SUB_O16_FLAGS_reg0(int n) {
        return (short)n < 0;
    }

    public static boolean zflag_nef_SUB_O16_FLAGS_reg0(int n) {
        return (short)n == 0;
    }

    public static boolean aflag_nef_SUB_O32_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return ((n3 ^ n2 ^ n) & 0x10) != 0;
    }

    public static boolean cflag_nef_SUB_O32_FLAGS_reg2_reg1(int n, int n2) {
        long l = (0xFFFFFFFFL & (long)n) - (0xFFFFFFFFL & (long)n2);
        return (l & 0xFFFFFFFF00000000L) != 0L;
    }

    public static boolean oflag_nef_SUB_O32_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return (n3 & Integer.MIN_VALUE) != (n2 & Integer.MIN_VALUE) && (n3 & Integer.MIN_VALUE) != (n & Integer.MIN_VALUE);
    }

    public static boolean pflag_nef_SUB_O32_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_SUB_O32_FLAGS_reg0(int n) {
        return n < 0;
    }

    public static boolean zflag_nef_SUB_O32_FLAGS_reg0(int n) {
        return n == 0;
    }

    public static int reg0_nef_INC_reg0(int n) {
        return n + 1;
    }

    public static boolean aflag_nef_INC_O8_FLAGS_reg0(int n) {
        return (n & 0xF) == 0;
    }

    public static boolean oflag_nef_INC_O8_FLAGS_reg0(int n) {
        return (byte)n == -128;
    }

    public static boolean pflag_nef_INC_O8_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_INC_O8_FLAGS_reg0(int n) {
        return (byte)n < 0;
    }

    public static boolean zflag_nef_INC_O8_FLAGS_reg0(int n) {
        return (byte)n == 0;
    }

    public static boolean aflag_nef_INC_O16_FLAGS_reg0(int n) {
        return ((short)n & 0xF) == 0;
    }

    public static boolean oflag_nef_INC_O16_FLAGS_reg0(int n) {
        return (short)n == Short.MIN_VALUE;
    }

    public static boolean pflag_nef_INC_O16_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_INC_O16_FLAGS_reg0(int n) {
        return (short)n < 0;
    }

    public static boolean zflag_nef_INC_O16_FLAGS_reg0(int n) {
        return (short)n == 0;
    }

    public static boolean aflag_nef_INC_O32_FLAGS_reg0(int n) {
        return (n & 0xF) == 0;
    }

    public static boolean oflag_nef_INC_O32_FLAGS_reg0(int n) {
        return n == Integer.MIN_VALUE;
    }

    public static boolean pflag_nef_INC_O32_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_INC_O32_FLAGS_reg0(int n) {
        return n < 0;
    }

    public static boolean zflag_nef_INC_O32_FLAGS_reg0(int n) {
        return n == 0;
    }

    public static int reg0_nef_DEC_reg0(int n) {
        return n - 1;
    }

    public static boolean aflag_nef_DEC_O8_FLAGS_reg0(int n) {
        return (n & 0xF) == 15;
    }

    public static boolean oflag_nef_DEC_O8_FLAGS_reg0(int n) {
        return (byte)n == 127;
    }

    public static boolean pflag_nef_DEC_O8_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_DEC_O8_FLAGS_reg0(int n) {
        return (byte)n < 0;
    }

    public static boolean zflag_nef_DEC_O8_FLAGS_reg0(int n) {
        return (byte)n == 0;
    }

    public static boolean aflag_nef_DEC_O16_FLAGS_reg0(int n) {
        return (n & 0xF) == 15;
    }

    public static boolean oflag_nef_DEC_O16_FLAGS_reg0(int n) {
        return (short)n == Short.MAX_VALUE;
    }

    public static boolean pflag_nef_DEC_O16_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_DEC_O16_FLAGS_reg0(int n) {
        return (short)n < 0;
    }

    public static boolean zflag_nef_DEC_O16_FLAGS_reg0(int n) {
        return (short)n == 0;
    }

    public static boolean aflag_nef_DEC_O32_FLAGS_reg0(int n) {
        return (n & 0xF) == 15;
    }

    public static boolean oflag_nef_DEC_O32_FLAGS_reg0(int n) {
        return n == Integer.MAX_VALUE;
    }

    public static boolean pflag_nef_DEC_O32_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_DEC_O32_FLAGS_reg0(int n) {
        return n < 0;
    }

    public static boolean zflag_nef_DEC_O32_FLAGS_reg0(int n) {
        return n == 0;
    }

    public static int reg0_nef_ADC_reg0_reg1_cflag(int n, int n2, int n3) {
        return n + n2 + n3;
    }

    public static int reg2_nef_ADC_reg0(int n) {
        return n;
    }

    public static boolean aflag_nef_ADC_O8_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return ((n3 ^ n2 ^ n) & 0x10) != 0;
    }

    public static boolean cflag_nef_ADC_O8_FLAGS_cflag_reg1_reg0(boolean bl, int n, int n2) {
        if (bl && n == 255) {
            return true;
        }
        return (n2 & 0xFFFFFF00) != 0;
    }

    public static boolean oflag_nef_ADC_O8_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return (n3 & 0x80) == (n2 & 0x80) && (n3 & 0x80) != (n & 0x80);
    }

    public static boolean pflag_nef_ADC_O8_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_ADC_O8_FLAGS_reg0(int n) {
        return (byte)n < 0;
    }

    public static boolean zflag_nef_ADC_O8_FLAGS_reg0(int n) {
        return (byte)n == 0;
    }

    public static boolean aflag_nef_ADC_O16_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return ((n3 ^ n2 ^ n) & 0x10) != 0;
    }

    public static boolean cflag_nef_ADC_O16_FLAGS_cflag_reg1_reg0(boolean bl, int n, int n2) {
        if (bl && n == 65535) {
            return true;
        }
        return (n2 & 0xFFFF0000) != 0;
    }

    public static boolean oflag_nef_ADC_O16_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return (n3 & 0x8000) == (n2 & 0x8000) && (n3 & 0x8000) != (n & 0x8000);
    }

    public static boolean pflag_nef_ADC_O16_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_ADC_O16_FLAGS_reg0(int n) {
        return (short)n < 0;
    }

    public static boolean zflag_nef_ADC_O16_FLAGS_reg0(int n) {
        return (short)n == 0;
    }

    public static boolean aflag_nef_ADC_O32_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return ((n3 ^ n2 ^ n) & 0x10) != 0;
    }

    public static boolean cflag_nef_ADC_O32_FLAGS_cflag_reg1_reg2(boolean bl, int n, int n2) {
        if (bl && n == -1) {
            return true;
        }
        long l = (0xFFFFFFFFL & (long)n2) + (0xFFFFFFFFL & (long)n) + (long)(bl ? 1 : 0);
        return (l & 0xFFFFFFFF00000000L) != 0L;
    }

    public static boolean oflag_nef_ADC_O32_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return (n3 & Integer.MIN_VALUE) == (n2 & Integer.MIN_VALUE) && (n3 & Integer.MIN_VALUE) != (n & Integer.MIN_VALUE);
    }

    public static boolean pflag_nef_ADC_O32_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_ADC_O32_FLAGS_reg0(int n) {
        return n < 0;
    }

    public static boolean zflag_nef_ADC_O32_FLAGS_reg0(int n) {
        return n == 0;
    }

    public static int reg0_nef_SBB_reg0_reg1_cflag(int n, int n2, int n3) {
        return n - (n2 + n3);
    }

    public static int reg2_nef_SBB_reg0(int n) {
        return n;
    }

    public static boolean aflag_nef_SBB_O8_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return ((n3 ^ n2 ^ n) & 0x10) != 0;
    }

    public static boolean cflag_nef_SBB_O8_FLAGS_reg0(int n) {
        return (n & 0xFFFFFF00) != 0;
    }

    public static boolean oflag_nef_SBB_O8_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return (n3 & 0x80) != (n2 & 0x80) && (n3 & 0x80) != (n & 0x80);
    }

    public static boolean pflag_nef_SBB_O8_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_SBB_O8_FLAGS_reg0(int n) {
        return (byte)n < 0;
    }

    public static boolean zflag_nef_SBB_O8_FLAGS_reg0(int n) {
        return (byte)n == 0;
    }

    public static boolean aflag_nef_SBB_O16_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return ((n3 ^ n2 ^ n) & 0x10) != 0;
    }

    public static boolean cflag_nef_SBB_O16_FLAGS_reg0(int n) {
        return (n & 0xFFFF0000) != 0;
    }

    public static boolean oflag_nef_SBB_O16_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return (n3 & 0x8000) != (n2 & 0x8000) && (n3 & 0x8000) != (n & 0x8000);
    }

    public static boolean pflag_nef_SBB_O16_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_SBB_O16_FLAGS_reg0(int n) {
        return (short)n < 0;
    }

    public static boolean zflag_nef_SBB_O16_FLAGS_reg0(int n) {
        return (short)n == 0;
    }

    public static boolean aflag_nef_SBB_O32_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return ((n3 ^ n2 ^ n) & 0x10) != 0;
    }

    public static boolean cflag_nef_SBB_O32_FLAGS_reg1_reg2_cflag(int n, int n2, int n3) {
        long l = (0xFFFFFFFFL & (long)n2) - ((0xFFFFFFFFL & (long)n) + (long)n3);
        return (l & 0xFFFFFFFF00000000L) != 0L;
    }

    public static boolean oflag_nef_SBB_O32_FLAGS_reg0_reg1_reg2(int n, int n2, int n3) {
        return (n3 & Integer.MIN_VALUE) != (n2 & Integer.MIN_VALUE) && (n3 & Integer.MIN_VALUE) != (n & Integer.MIN_VALUE);
    }

    public static boolean pflag_nef_SBB_O32_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_SBB_O32_FLAGS_reg0(int n) {
        return n < 0;
    }

    public static boolean zflag_nef_SBB_O32_FLAGS_reg0(int n) {
        return n == 0;
    }

    public static int reg0_nef_NEG_reg0(int n) {
        return -n;
    }

    public static boolean aflag_nef_NEG_O8_FLAGS_reg0(int n) {
        return (n & 0xF) == 0;
    }

    public static boolean cflag_nef_NEG_O8_FLAGS_reg0(int n) {
        return (byte)n != 0;
    }

    public static boolean oflag_nef_NEG_O8_FLAGS_reg0(int n) {
        return (byte)n == -128;
    }

    public static boolean pflag_nef_NEG_O8_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_NEG_O8_FLAGS_reg0(int n) {
        return (byte)n < 0;
    }

    public static boolean zflag_nef_NEG_O8_FLAGS_reg0(int n) {
        return (byte)n == 0;
    }

    public static boolean aflag_nef_NEG_O16_FLAGS_reg0(int n) {
        return (n & 0xF) == 0;
    }

    public static boolean cflag_nef_NEG_O16_FLAGS_reg0(int n) {
        return (short)n != 0;
    }

    public static boolean oflag_nef_NEG_O16_FLAGS_reg0(int n) {
        return (short)n == Short.MIN_VALUE;
    }

    public static boolean pflag_nef_NEG_O16_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_NEG_O16_FLAGS_reg0(int n) {
        return (short)n < 0;
    }

    public static boolean zflag_nef_NEG_O16_FLAGS_reg0(int n) {
        return (short)n == 0;
    }

    public static boolean aflag_nef_NEG_O32_FLAGS_reg0(int n) {
        return (n & 0xF) == 0;
    }

    public static boolean cflag_nef_NEG_O32_FLAGS_reg0(int n) {
        return n != 0;
    }

    public static boolean oflag_nef_NEG_O32_FLAGS_reg0(int n) {
        return n == Integer.MIN_VALUE;
    }

    public static boolean pflag_nef_NEG_O32_FLAGS_reg0(int n) {
        return parityMap[n & 0xFF];
    }

    public static boolean sflag_nef_NEG_O32_FLAGS_reg0(int n) {
        return n < 0;
    }

    public static boolean zflag_nef_NEG_O32_FLAGS_reg0(int n) {
        return n == 0;
    }

    public static int edx_nef_CWD_edx_eax(int n, int n2) {
        if ((n2 & 0x8000) == 0) {
            return n & 0xFFFF0000;
        }
        return n | 0xFFFF;
    }

    public static int edx_nef_CDQ_eax(int n) {
        if ((n & Integer.MIN_VALUE) == 0) {
            return 0;
        }
        return -1;
    }

    public static int eax_nef_DIV_O8_eax_reg0(int n, int n2) throws ProcessorException {
        if (n2 == 0) {
            throw exceptionDE;
        }
        int n3 = (n & 0xFFFF) / n2;
        if (n3 > 255) {
            throw exceptionDE;
        }
        int n4 = (n & 0xFFFF) % n2 << 8;
        return n & 0xFFFF0000 | 0xFF & n3 | 0xFF00 & n4;
    }

    public static int eax_nef_DIV_O16_edx_eax_reg0(int n, int n2, int n3) throws ProcessorException {
        if (n3 == 0) {
            throw exceptionDE;
        }
        long l = (long)n & 0xFFFFL;
        l <<= 16;
        long l2 = (l |= (long)n2 & 0xFFFFL) / (long)n3;
        if (l2 > 65535L) {
            throw exceptionDE;
        }
        return n2 & 0xFFFF0000 | (int)(l2 & 0xFFFFL);
    }

    public static int edx_nef_DIV_O16_reg0_eax_edx(int n, int n2, int n3) {
        long l = (long)n3 & 0xFFFFL;
        l <<= 16;
        long l2 = (l |= (long)n2 & 0xFFFFL) % (long)n;
        return n3 & 0xFFFF0000 | (int)(l2 & 0xFFFFL);
    }

    public static int eax_nef_DIV_O32_edx_eax_reg0(int n, int n2, int n3) throws ProcessorException {
        long l = 0xFFFFFFFFL & (long)n3;
        if (l == 0L) {
            throw exceptionDE;
        }
        long l2 = n;
        l2 <<= 32;
        long l3 = (l2 |= (long)n2 & 0xFFFFFFFFL) & 1L;
        long l4 = l2 >>> 1;
        long l5 = l4 / l;
        long l6 = l4 % l;
        long l7 = l5 << 1;
        long l8 = (l6 << 1) + l3;
        if ((l7 += l8 / l) > 0xFFFFFFFFL) {
            throw exceptionDE;
        }
        return (int)l7;
    }

    public static int edx_nef_DIV_O32_reg0_eax_edx(int n, int n2, int n3) {
        long l = 0xFFFFFFFFL & (long)n;
        long l2 = n3;
        l2 <<= 32;
        long l3 = (l2 |= (long)n2 & 0xFFFFFFFFL) & 1L;
        long l4 = l2 >>> 1;
        long l5 = l4 % l;
        long l6 = (l5 << 1) + l3;
        return (int)(l6 %= l);
    }

    public static int eax_nef_IDIV_O8_reg0_eax(int n, int n2) throws ProcessorException {
        if ((byte)n == 0) {
            throw exceptionDE;
        }
        int n3 = (short)n2 / (byte)n;
        int n4 = (short)n2 % (byte)n;
        if (n3 > 127 || n3 < -128) {
            throw exceptionDE;
        }
        return n2 & 0xFFFF0000 | 0xFF & n3 | (0xFF & n4) << 8;
    }

    public static int eax_nef_IDIV_O16_reg0_eax_edx(int n, int n2, int n3) throws ProcessorException {
        if ((short)n == 0) {
            throw exceptionDE;
        }
        int n4 = n3 << 16 | n2 & 0xFFFF;
        int n5 = n4 / (short)n;
        if (n5 > Short.MAX_VALUE || n5 < Short.MIN_VALUE) {
            throw exceptionDE;
        }
        return n2 & 0xFFFF0000 | n5 & 0xFFFF;
    }

    public static int edx_nef_IDIV_O16_reg0_eax_edx(int n, int n2, int n3) {
        int n4 = n3 << 16 | n2 & 0xFFFF;
        int n5 = n4 % (short)n;
        return n3 & 0xFFFF0000 | n5 & 0xFFFF;
    }

    public static int eax_nef_IDIV_O32_reg0_eax_edx(int n, int n2, int n3) throws ProcessorException {
        if (n == 0) {
            throw exceptionDE;
        }
        long l = (0xFFFFFFFFL & (long)n3) << 32 | (long)n2 & 0xFFFFFFFFL;
        long l2 = l / (long)n;
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw exceptionDE;
        }
        return (int)l2;
    }

    public static int edx_nef_IDIV_O32_reg0_eax_edx(int n, int n2, int n3) {
        long l = (0xFFFFFFFFL & (long)n3) << 32 | (long)n2 & 0xFFFFFFFFL;
        int n4 = (int)(l % (long)n);
        return n4;
    }

    public static boolean cflag_nef_MUL_O8_reg0_eax(int n, int n2) {
        int n3 = (n2 & 0xFF) * n;
        return (n3 & 0xFF00) != 0;
    }

    public static boolean oflag_nef_MUL_O8_reg0_eax(int n, int n2) {
        int n3 = (n2 & 0xFF) * n;
        return (n3 & 0xFF00) != 0;
    }

    public static int eax_nef_MUL_O8_reg0_eax(int n, int n2) {
        int n3 = (n2 & 0xFF) * n;
        return n2 & 0xFFFF0000 | 0xFFFF & n3;
    }

    public static boolean cflag_nef_MUL_O16_reg0_eax(int n, int n2) {
        int n3 = (n2 & 0xFFFF) * n;
        return (n3 & 0xFFFF0000) != 0;
    }

    public static boolean oflag_nef_MUL_O16_reg0_eax(int n, int n2) {
        int n3 = (n2 & 0xFFFF) * n;
        return (n3 & 0xFFFF0000) != 0;
    }

    public static int eax_nef_MUL_O16_reg0_eax(int n, int n2) {
        int n3 = (n2 & 0xFFFF) * n;
        return n2 & 0xFFFF0000 | 0xFFFF & n3;
    }

    public static int edx_nef_MUL_O16_edx_reg0_eax(int n, int n2, int n3) {
        int n4 = (n3 & 0xFFFF) * n2;
        return n & 0xFFFF0000 | 0xFFFF & (n4 >>= 16);
    }

    public static int eax_nef_MUL_O32_reg0_eax(int n, int n2) {
        long l = (long)n2 & 0xFFFFFFFFL;
        long l2 = (long)n & 0xFFFFFFFFL;
        long l3 = l * l2;
        return (int)l3;
    }

    public static int edx_nef_MUL_O32_reg0_eax(int n, int n2) {
        long l = (long)n2 & 0xFFFFFFFFL;
        long l2 = (long)n & 0xFFFFFFFFL;
        long l3 = l * l2;
        return (int)(l3 >>>= 32);
    }

    public static boolean oflag_nef_MUL_O32_reg0_eax(int n, int n2) {
        long l = (long)n2 & 0xFFFFFFFFL;
        long l2 = (long)n & 0xFFFFFFFFL;
        long l3 = l * l2;
        return (int)(l3 >>>= 32) != 0;
    }

    public static boolean cflag_nef_MUL_O32_reg0_eax(int n, int n2) {
        long l = (long)n2 & 0xFFFFFFFFL;
        long l2 = (long)n & 0xFFFFFFFFL;
        long l3 = l * l2;
        return (int)(l3 >>>= 32) != 0;
    }

    public static int eax_nef_IMULA_O8_reg0_eax(int n, int n2) {
        int n3 = (byte)n2 * (byte)n;
        return n2 & 0xFFFF0000 | n3 & 0xFFFF;
    }

    public static boolean cflag_nef_IMULA_O8_reg0_eax(int n, int n2) {
        int n3 = (byte)n2 * (byte)n;
        return n3 != (byte)n3;
    }

    public static boolean oflag_nef_IMULA_O8_reg0_eax(int n, int n2) {
        int n3 = (byte)n2 * (byte)n;
        return n3 != (byte)n3;
    }

    public static int eax_nef_IMULA_O16_reg0_eax(int n, int n2) {
        int n3 = (short)n2 * (short)n;
        return n2 & 0xFFFF0000 | n3 & 0xFFFF;
    }

    public static int edx_nef_IMULA_O16_edx_reg0_eax(int n, int n2, int n3) {
        int n4 = (short)n3 * (short)n2;
        return n & 0xFFFF0000 | n4 >>> 16;
    }

    public static boolean cflag_nef_IMULA_O16_reg0_eax(int n, int n2) {
        int n3 = (short)n2 * (short)n;
        return n3 != (short)n3;
    }

    public static boolean oflag_nef_IMULA_O16_reg0_eax(int n, int n2) {
        int n3 = (short)n2 * (short)n;
        return n3 != (short)n3;
    }

    public static int eax_nef_IMULA_O32_reg0_eax(int n, int n2) {
        return n2 * n;
    }

    public static int edx_nef_IMULA_O32_edx_reg0_eax(int n, int n2, int n3) {
        long l = (long)n3 * (long)n2;
        return (int)(l >>> 32);
    }

    public static boolean cflag_nef_IMULA_O32_reg0_eax(int n, int n2) {
        long l = (long)n2 * (long)n;
        return l != (long)((int)l);
    }

    public static boolean oflag_nef_IMULA_O32_reg0_eax(int n, int n2) {
        long l = (long)n2 * (long)n;
        return l != (long)((int)l);
    }

    public static boolean cflag_nef_IMUL_O16_reg0_reg1(int n, int n2) {
        int n3 = (short)n * (short)n2;
        return n3 != (short)n3;
    }

    public static boolean oflag_nef_IMUL_O16_reg0_reg1(int n, int n2) {
        int n3 = (short)n * (short)n2;
        return n3 != (short)n3;
    }

    public static int reg0_nef_IMUL_O16_reg0_reg1(int n, int n2) {
        return (short)n * (short)n2;
    }

    public static boolean cflag_nef_IMUL_O32_reg0_reg1(int n, int n2) {
        long l = (long)n * (long)n2;
        return l != (long)((int)l);
    }

    public static boolean oflag_nef_IMUL_O32_reg0_reg1(int n, int n2) {
        long l = (long)n * (long)n2;
        return l != (long)((int)l);
    }

    public static int reg0_nef_IMUL_O32_reg0_reg1(int n, int n2) {
        return n * n2;
    }

    public static int eax_nef_LAHF_eax_cflag_pflag_aflag_zflag_sflag(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n2 = 512;
        if (bl5) {
            n2 |= 0x8000;
        }
        if (bl4) {
            n2 |= 0x4000;
        }
        if (bl3) {
            n2 |= 0x1000;
        }
        if (bl2) {
            n2 |= 0x400;
        }
        if (bl) {
            n2 |= 0x100;
        }
        return (n &= 0xFFFF00FF) | n2;
    }

    public static int eax_hef_LODSB_A16_eax_seg0_esi(int n, Segment segment, int n2) {
        return n & 0xFFFFFF00 | 0xFF & segment.getByte(n2 & 0xFFFF);
    }

    public static int esi_nef_LODSB_A16_esi_dflag(int n, boolean bl) {
        int n2 = n;
        n2 = bl ? --n2 : ++n2;
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int eax_hef_LODSB_A32_eax_seg0_esi(int n, Segment segment, int n2) {
        return n & 0xFFFFFF00 | 0xFF & segment.getByte(n2);
    }

    public static int esi_nef_LODSB_A32_esi_dflag(int n, boolean bl) {
        if (bl) {
            return n - 1;
        }
        return n + 1;
    }

    public static int eax_hef_LODSW_A16_eax_seg0_esi(int n, Segment segment, int n2) {
        return n & 0xFFFF0000 | 0xFFFF & segment.getWord(n2 & 0xFFFF);
    }

    public static int esi_nef_LODSW_A16_esi_dflag(int n, boolean bl) {
        int n2 = n & 0xFFFF;
        n2 = bl ? (n2 -= 2) : (n2 += 2);
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int eax_hef_LODSW_A32_eax_seg0_esi(int n, Segment segment, int n2) {
        return n & 0xFFFF0000 | 0xFFFF & segment.getWord(n2);
    }

    public static int esi_nef_LODSW_A32_esi_dflag(int n, boolean bl) {
        if (bl) {
            return n - 2;
        }
        return n + 2;
    }

    public static int eax_hef_LODSD_A16_seg0_esi(Segment segment, int n) {
        return segment.getDoubleWord(n & 0xFFFF);
    }

    public static int esi_nef_LODSD_A16_esi_dflag(int n, boolean bl) {
        int n2 = n & 0xFFFF;
        n2 = bl ? (n2 -= 4) : (n2 += 4);
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int eax_hef_LODSD_A32_seg0_esi(Segment segment, int n) {
        return segment.getDoubleWord(n);
    }

    public static int esi_nef_LODSD_A32_esi_dflag(int n, boolean bl) {
        if (bl) {
            return n - 4;
        }
        return n + 4;
    }

    public static int edi_nef_MOVSB_A16_dflag_edi(boolean bl, int n) {
        int n2 = n & 0xFFFF;
        n2 = bl ? --n2 : ++n2;
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int esi_nef_MOVSB_A16_dflag_esi(boolean bl, int n) {
        int n2 = n & 0xFFFF;
        n2 = bl ? --n2 : ++n2;
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static void memorywrite_hef_MOVSB_A16_es_edi_seg0_esi(Segment segment, int n, Segment segment2, int n2) {
        segment.setByte(n & 0xFFFF, segment2.getByte(n2 & 0xFFFF));
    }

    public static int edi_nef_MOVSB_A32_dflag_edi(boolean bl, int n) {
        if (bl) {
            return n - 1;
        }
        return n + 1;
    }

    public static int esi_nef_MOVSB_A32_dflag_esi(boolean bl, int n) {
        if (bl) {
            return n - 1;
        }
        return n + 1;
    }

    public static void memorywrite_hef_MOVSB_A32_es_edi_seg0_esi(Segment segment, int n, Segment segment2, int n2) {
        segment.setByte(n, segment2.getByte(n2));
    }

    public static int edi_nef_MOVSW_A16_dflag_edi(boolean bl, int n) {
        int n2 = n & 0xFFFF;
        n2 = bl ? (n2 -= 2) : (n2 += 2);
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int esi_nef_MOVSW_A16_dflag_esi(boolean bl, int n) {
        int n2 = n & 0xFFFF;
        n2 = bl ? (n2 -= 2) : (n2 += 2);
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static void memorywrite_hef_MOVSW_A16_es_edi_seg0_esi(Segment segment, int n, Segment segment2, int n2) {
        segment.setWord(n & 0xFFFF, segment2.getWord(n2 & 0xFFFF));
    }

    public static int edi_nef_MOVSW_A32_dflag_edi(boolean bl, int n) {
        if (bl) {
            return n - 2;
        }
        return n + 2;
    }

    public static int esi_nef_MOVSW_A32_dflag_esi(boolean bl, int n) {
        if (bl) {
            return n - 2;
        }
        return n + 2;
    }

    public static void memorywrite_hef_MOVSW_A32_es_edi_seg0_esi(Segment segment, int n, Segment segment2, int n2) {
        segment.setWord(n, segment2.getWord(n2));
    }

    public static int edi_nef_MOVSD_A16_dflag_edi(boolean bl, int n) {
        int n2 = n & 0xFFFF;
        n2 = bl ? (n2 -= 4) : (n2 += 4);
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static int esi_nef_MOVSD_A16_dflag_esi(boolean bl, int n) {
        int n2 = n & 0xFFFF;
        n2 = bl ? (n2 -= 4) : (n2 += 4);
        return n & 0xFFFF0000 | n2 & 0xFFFF;
    }

    public static void memorywrite_hef_MOVSD_A16_es_edi_seg0_esi(Segment segment, int n, Segment segment2, int n2) {
        segment.setDoubleWord(n & 0xFFFF, segment2.getDoubleWord(n2 & 0xFFFF));
    }

    public static int edi_nef_MOVSD_A32_dflag_edi(boolean bl, int n) {
        if (bl) {
            return n - 4;
        }
        return n + 4;
    }

    public static int esi_nef_MOVSD_A32_dflag_esi(boolean bl, int n) {
        if (bl) {
            return n - 4;
        }
        return n + 4;
    }

    public static void memorywrite_hef_MOVSD_A32_es_edi_seg0_esi(Segment segment, int n, Segment segment2, int n2) {
        segment.setDoubleWord(n, segment2.getDoubleWord(n2));
    }

    public static int reg0_hef_IN_O8_cpl_iopl_tss_reg0_ioports(int n, int n2, Segment segment, int n3, IOPortHandler iOPortHandler) throws ModuleException {
        if (UCodeStaticMethods.checkIOPermissionsByte(n, n2, segment, n3)) {
            return 0xFF & iOPortHandler.ioPortReadByte(n3);
        }
        throw exceptionGP;
    }

    public static int reg0_hef_IN_O16_cpl_iopl_tss_reg0_ioports(int n, int n2, Segment segment, int n3, IOPortHandler iOPortHandler) throws ModuleException {
        if (UCodeStaticMethods.checkIOPermissionsShort(n, n2, segment, n3)) {
            return 0xFFFF & iOPortHandler.ioPortReadWord(n3);
        }
        throw exceptionGP;
    }

    public static int reg0_hef_IN_O32_cpl_iopl_tss_reg0_ioports(int n, int n2, Segment segment, int n3, IOPortHandler iOPortHandler) throws ModuleException {
        if (UCodeStaticMethods.checkIOPermissionsInt(n, n2, segment, n3)) {
            return iOPortHandler.ioPortReadLong(n3);
        }
        throw exceptionGP;
    }

    public static void ioportwrite_hef_OUT_O8_cpl_iopl_tss_reg0_reg1_ioports(int n, int n2, Segment segment, int n3, int n4, IOPortHandler iOPortHandler) throws ModuleException {
        if (!UCodeStaticMethods.checkIOPermissionsByte(n, n2, segment, n3)) {
            throw exceptionGP;
        }
        iOPortHandler.ioPortWriteByte(n3, n4);
    }

    public static void ioportwrite_hef_OUT_O16_cpl_iopl_tss_reg0_reg1_ioports(int n, int n2, Segment segment, int n3, int n4, IOPortHandler iOPortHandler) throws ModuleException {
        if (!UCodeStaticMethods.checkIOPermissionsShort(n, n2, segment, n3)) {
            throw exceptionGP;
        }
        iOPortHandler.ioPortWriteWord(n3, n4);
    }

    public static void ioportwrite_hef_OUT_O32_cpl_iopl_tss_reg0_reg1_ioports(int n, int n2, Segment segment, int n3, int n4, IOPortHandler iOPortHandler) throws ModuleException {
        if (!UCodeStaticMethods.checkIOPermissionsInt(n, n2, segment, n3)) {
            throw exceptionGP;
        }
        iOPortHandler.ioPortWriteLong(n3, n4);
    }

    public static int cflag_hef_BT_MEM_reg1_seg0_addr0(int n, Segment segment, int n2) {
        n2 += n >>> 3;
        return segment.getByte(n2) >>> (n &= 7) & 1;
    }

    public static int cflag_hef_BTS_MEM_reg1_seg0_addr0(int n, Segment segment, int n2) {
        byte by = segment.getByte(n2 += n >>> 3);
        int n3 = by >>> (n &= 7) & 1;
        if (n3 == 0) {
            segment.setByte(n2, (byte)(by | 1 << n));
        }
        return n3;
    }

    public static int cflag_hef_BTR_MEM_reg1_seg0_addr0(int n, Segment segment, int n2) {
        byte by = segment.getByte(n2 += n >>> 3);
        int n3 = by >>> (n &= 7) & 1;
        if (n3 == 1) {
            segment.setByte(n2, (byte)(by & ~(1 << n)));
        }
        return n3;
    }

    public static int cflag_hef_BTC_MEM_reg1_seg0_addr0(int n, Segment segment, int n2) {
        n2 += n >>> 3;
        byte by = segment.getByte(n2);
        int n3 = by >>> (n &= 7) & 1;
        segment.setByte(n2, (byte)(by ^ 1 << n));
        return n3;
    }

    public static int esp_nef_PUSH_O16_A32_ss_esp(Segment segment, int n) {
        if (segment.getDefaultSizeFlag()) {
            return n - 2;
        }
        return n & 0xFFFF0000 | n - 2 & 0xFFFF;
    }

    public static void memorywrite_hef_PUSH_O16_A32_ss_reg0_esp(Segment segment, int n, int n2) {
        if (segment.getDefaultSizeFlag()) {
            if (n2 < 2 && n2 > 0) {
                throw new ProcessorException(12, 0, true);
            }
            segment.setWord(n2 - 2, (short)n);
        } else {
            if ((0xFFFF & n2) < 2 && (0xFFFF & n2) > 0) {
                throw new ProcessorException(12, 0, true);
            }
            segment.setWord(n2 - 2 & 0xFFFF, (short)n);
        }
    }

    public static int esp_nef_PUSH_O32_A32_ss_esp(Segment segment, int n) {
        if (segment.getDefaultSizeFlag()) {
            return n - 4;
        }
        return n & 0xFFFF0000 | n - 4 & 0xFFFF;
    }

    public static void memorywrite_hef_PUSH_O32_A32_ss_reg0_esp(Segment segment, int n, int n2) {
        if (segment.getDefaultSizeFlag()) {
            if (n2 < 4 && n2 > 0) {
                throw new ProcessorException(12, 0, true);
            }
            segment.setDoubleWord(n2 - 4, n);
        } else {
            if ((0xFFFF & n2) < 4 && (0xFFFF & n2) > 0) {
                throw new ProcessorException(12, 0, true);
            }
            segment.setDoubleWord(n2 - 4 & 0xFFFF, n);
        }
    }

    public static int reg0_hef_POP_O32_A32_ss_esp(Segment segment, int n) {
        if (segment.getDefaultSizeFlag()) {
            return segment.getDoubleWord(n);
        }
        return segment.getDoubleWord(0xFFFF & n);
    }

    public static int reg1_nef_POP_O32_A32_ss_esp(Segment segment, int n) {
        if (segment.getDefaultSizeFlag()) {
            return n + 4;
        }
        return n & 0xFFFF0000 | n + 4 & 0xFFFF;
    }

    public static int esp_nef_PUSHF_O32_A32_ss_esp(Segment segment, int n) {
        if (segment.getDefaultSizeFlag()) {
            return n - 4;
        }
        return n & 0xFFFF0000 | n - 4 & 0xFFFF;
    }

    public static void memorywrite_hef_PUSHF_O32_A32_ss_reg0_esp(Segment segment, int n, int n2) {
        if (segment.getDefaultSizeFlag()) {
            if (n2 < 4 && n2 > 0) {
                throw new ProcessorException(12, 0, true);
            }
            segment.setDoubleWord(n2 - 4, 0xFFFCFFFF & n);
        } else {
            if ((0xFFFF & n2) < 4 && (0xFFFF & n2) > 0) {
                throw new ProcessorException(12, 0, true);
            }
            segment.setDoubleWord(n2 - 4 & 0xFFFF, 0xFFFCFFFF & n);
        }
    }

    public static int reg0_hef_POPF_O32_A32_ss_esp_cpl_iopl_vmflag_iflag(Segment segment, int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4 = 0;
        n4 = segment.getDefaultSizeFlag() ? segment.getDoubleWord(n) : segment.getDoubleWord(0xFFFF & n);
        n4 = n2 == 0 ? (bl ? 131072 : 0) | n4 & 0xFFE5FFFF : (n2 > n3 ? (bl ? 131072 : 0) | n3 << 12 | (bl2 ? 512 : 0) | n4 & 0xFFE5CDFF : (bl ? 131072 : 0) | n3 << 12 | n4 & 0xFFE5CFFF);
        return n4;
    }

    public static int esp_nef_POPF_O32_A32_ss_esp(Segment segment, int n) {
        if (segment.getDefaultSizeFlag()) {
            return n + 4;
        }
        return n & 0xFFFF0000 | n + 4 & 0xFFFF;
    }

    public static int esp_nef_PUSHAD_A32_ss_esp(Segment segment, int n) {
        if (segment.getDefaultSizeFlag()) {
            return n - 32;
        }
        return n & 0xFFFF0000 | n - 32 & 0xFFFF;
    }

    public static void memorywrite_hef_PUSHAD_A32_edi_esi_ebp_ebx_edx_ecx_eax_ss_esp(int n, int n2, int n3, int n4, int n5, int n6, int n7, Segment segment, int n8) {
        if (segment.getDefaultSizeFlag()) {
            if (n8 < 32 && n8 > 0) {
                throw new ProcessorException(12, 0, true);
            }
            int n9 = n8;
            segment.setDoubleWord(n9 -= 4, n7);
            segment.setDoubleWord(n9 -= 4, n6);
            segment.setDoubleWord(n9 -= 4, n5);
            segment.setDoubleWord(n9 -= 4, n4);
            segment.setDoubleWord(n9 -= 4, n8);
            segment.setDoubleWord(n9 -= 4, n3);
            segment.setDoubleWord(n9 -= 4, n2);
            segment.setDoubleWord(n9 -= 4, n);
        } else {
            if ((n8 & 0xFFFF) < 32) {
                throw new ProcessorException(12, 0, true);
            }
            int n10 = n8 & 0xFFFF;
            segment.setDoubleWord(n10 -= 4, n7);
            segment.setDoubleWord(n10 -= 4, n6);
            segment.setDoubleWord(n10 -= 4, n5);
            segment.setDoubleWord(n10 -= 4, n4);
            segment.setDoubleWord(n10 -= 4, n8);
            segment.setDoubleWord(n10 -= 4, n3);
            segment.setDoubleWord(n10 -= 4, n2);
            segment.setDoubleWord(n10 -= 4, n);
        }
    }

    public static int eax_hef_POPAD_A32_eax_ss_esp(int n, Segment segment, int n2) {
        if (segment.getDefaultSizeFlag()) {
            return segment.getDoubleWord(n2 + 28);
        }
        return segment.getDoubleWord(n2 + 28 & 0xFFFF);
    }

    public static int ebp_hef_POPAD_A32_ebp_ss_esp(int n, Segment segment, int n2) {
        if (segment.getDefaultSizeFlag()) {
            return segment.getDoubleWord(n2 + 8);
        }
        return segment.getDoubleWord(n2 + 8 & 0xFFFF);
    }

    public static int ebx_hef_POPAD_A32_ebx_ss_esp(int n, Segment segment, int n2) {
        if (segment.getDefaultSizeFlag()) {
            return segment.getDoubleWord(n2 + 16);
        }
        return segment.getDoubleWord(n2 + 16 & 0xFFFF);
    }

    public static int ecx_hef_POPAD_A32_ecx_ss_esp(int n, Segment segment, int n2) {
        if (segment.getDefaultSizeFlag()) {
            return segment.getDoubleWord(n2 + 24);
        }
        return segment.getDoubleWord(n2 + 24 & 0xFFFF);
    }

    public static int edi_hef_POPAD_A32_edi_ss_esp(int n, Segment segment, int n2) {
        if (segment.getDefaultSizeFlag()) {
            return segment.getDoubleWord(n2);
        }
        return segment.getDoubleWord(n2 & 0xFFFF);
    }

    public static int edx_hef_POPAD_A32_edx_ss_esp(int n, Segment segment, int n2) {
        if (segment.getDefaultSizeFlag()) {
            return segment.getDoubleWord(n2 + 20);
        }
        return segment.getDoubleWord(n2 + 20 & 0xFFFF);
    }

    public static int esi_hef_POPAD_A32_esi_ss_esp(int n, Segment segment, int n2) {
        if (segment.getDefaultSizeFlag()) {
            return segment.getDoubleWord(n2 + 4);
        }
        return segment.getDoubleWord(n2 + 4 & 0xFFFF);
    }

    public static int esp_nef_POPAD_A32_ss_esp(Segment segment, int n) {
        if (segment.getDefaultSizeFlag()) {
            return n + 32;
        }
        return n & 0xFFFF0000 | n + 32 & 0xFFFF;
    }

    public static boolean reg0_nef_SETO_oflag(boolean bl) {
        return bl;
    }

    public static boolean reg0_nef_SETNO_oflag(boolean bl) {
        return !bl;
    }

    public static boolean reg0_nef_SETC_cflag(boolean bl) {
        return bl;
    }

    public static boolean reg0_nef_SETNC_cflag(boolean bl) {
        return !bl;
    }

    public static boolean reg0_nef_SETZ_zflag(boolean bl) {
        return bl;
    }

    public static boolean reg0_nef_SETNZ_zflag(boolean bl) {
        return !bl;
    }

    public static boolean reg0_nef_SETNA_cflag_zflag(boolean bl, boolean bl2) {
        return bl || bl2;
    }

    public static boolean reg0_nef_SETA_cflag_zflag(boolean bl, boolean bl2) {
        return !bl && !bl2;
    }

    public static boolean reg0_nef_SETS_sflag(boolean bl) {
        return bl;
    }

    public static boolean reg0_nef_SETNS_sflag(boolean bl) {
        return !bl;
    }

    public static boolean reg0_nef_SETP_pflag(boolean bl) {
        return bl;
    }

    public static boolean reg0_nef_SETNP_pflag(boolean bl) {
        return !bl;
    }

    public static boolean reg0_nef_SETL_sflag_oflag(boolean bl, boolean bl2) {
        return bl != bl2;
    }

    public static boolean reg0_nef_SETNL_sflag_oflag(boolean bl, boolean bl2) {
        return bl == bl2;
    }

    public static boolean reg0_nef_SETNG_zflag_sflag_oflag(boolean bl, boolean bl2, boolean bl3) {
        return bl || bl2 != bl3;
    }

    public static boolean reg0_nef_SETG_zflag_sflag_oflag(boolean bl, boolean bl2, boolean bl3) {
        return !bl && bl2 == bl3;
    }

    public static int reg0_nef_CMOVO_reg0_reg1_oflag(int n, int n2, boolean bl) {
        if (bl) {
            return n2;
        }
        return n;
    }

    public static int reg0_nef_CMOVNO_reg0_reg1_oflag(int n, int n2, boolean bl) {
        if (!bl) {
            return n2;
        }
        return n;
    }

    public static int reg0_nef_CMOVC_reg0_reg1_cflag(int n, int n2, boolean bl) {
        if (bl) {
            return n2;
        }
        return n;
    }

    public static int reg0_nef_CMOVNC_reg0_reg1_cflag(int n, int n2, boolean bl) {
        if (!bl) {
            return n2;
        }
        return n;
    }

    public static int reg0_nef_CMOVZ_reg0_reg1_zflag(int n, int n2, boolean bl) {
        if (bl) {
            return n2;
        }
        return n;
    }

    public static int reg0_nef_CMOVNZ_reg0_reg1_zflag(int n, int n2, boolean bl) {
        if (!bl) {
            return n2;
        }
        return n;
    }

    public static int reg0_nef_CMOVNA_reg0_reg1_cflag_zflag(int n, int n2, boolean bl, boolean bl2) {
        if (bl || bl2) {
            return n2;
        }
        return n;
    }

    public static int reg0_nef_CMOVA_reg0_reg1_cflag_zflag(int n, int n2, boolean bl, boolean bl2) {
        if (!bl && !bl2) {
            return n2;
        }
        return n;
    }

    public static int reg0_nef_CMOVS_reg0_reg1_sflag(int n, int n2, boolean bl) {
        if (bl) {
            return n2;
        }
        return n;
    }

    public static int reg0_nef_CMOVNS_reg0_reg1_sflag(int n, int n2, boolean bl) {
        if (!bl) {
            return n2;
        }
        return n;
    }

    public static int reg0_nef_CMOVP_reg0_reg1_pflag(int n, int n2, boolean bl) {
        if (bl) {
            return n2;
        }
        return n;
    }

    public static int reg0_nef_CMOVNP_reg0_reg1_pflag(int n, int n2, boolean bl) {
        if (!bl) {
            return n2;
        }
        return n;
    }

    public static int reg0_nef_CMOVL_reg0_reg1_sflag_oflag(int n, int n2, boolean bl, boolean bl2) {
        if (bl != bl2) {
            return n2;
        }
        return n;
    }

    public static int reg0_nef_CMOVNL_reg0_reg1_sflag_oflag(int n, int n2, boolean bl, boolean bl2) {
        if (bl == bl2) {
            return n2;
        }
        return n;
    }

    public static int reg0_nef_CMOVNG_reg0_reg1_zflag_sflag_oflag(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        if (bl || bl2 != bl3) {
            return n2;
        }
        return n;
    }

    public static int reg0_nef_CMOVG_reg0_reg1_zflag_sflag_oflag(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        if (!bl && bl2 == bl3) {
            return n2;
        }
        return n;
    }

    public static int reg0_nef_CMPXCHG_reg0_reg1_reg2(int n, int n2, int n3) {
        if (n3 == n) {
            return n2;
        }
        return n;
    }

    public static int reg1_nef_CMPXCHG_reg0(int n) {
        return n;
    }

    public static boolean aflag_nef_CMPXCHG_O8_FLAGS_reg1_reg2(int n, int n2) {
        int n3 = n2 - n;
        return ((n2 ^ n ^ n3) & 0x10) != 0;
    }

    public static boolean cflag_nef_CMPXCHG_O8_FLAGS_reg1_reg2(int n, int n2) {
        int n3 = n2 - n;
        return (n3 & 0xFFFFFF00) != 0;
    }

    public static boolean oflag_nef_CMPXCHG_O8_FLAGS_reg1_reg2(int n, int n2) {
        int n3 = n2 - n;
        return (n2 & 0x80) != (n & 0x80) && (n2 & 0x80) != (n3 & 0x80);
    }

    public static boolean pflag_nef_CMPXCHG_O8_FLAGS_reg1_reg2(int n, int n2) {
        int n3 = n2 - n;
        return parityMap[n3 & 0xFF];
    }

    public static boolean sflag_nef_CMPXCHG_O8_FLAGS_reg1_reg2(int n, int n2) {
        int n3 = n2 - n;
        return (byte)n3 < 0;
    }

    public static boolean zflag_nef_CMPXCHG_O8_FLAGS_reg1_reg2(int n, int n2) {
        int n3 = n2 - n;
        return (byte)n3 == 0;
    }

    public static boolean aflag_nef_CMPXCHG_O16_FLAGS_reg1_reg2(int n, int n2) {
        int n3 = n2 - n;
        return ((n2 ^ n ^ n3) & 0x10) != 0;
    }

    public static boolean cflag_nef_CMPXCHG_O16_FLAGS_reg1_reg2(int n, int n2) {
        int n3 = n2 - n;
        return (n3 & 0xFFFF0000) != 0;
    }

    public static boolean oflag_nef_CMPXCHG_O16_FLAGS_reg1_reg2(int n, int n2) {
        int n3 = n2 - n;
        return (n2 & 0x8000) != (n & 0x8000) && (n2 & 0x8000) != (n3 & 0x8000);
    }

    public static boolean pflag_nef_CMPXCHG_O16_FLAGS_reg1_reg2(int n, int n2) {
        int n3 = n2 - n;
        return parityMap[n3 & 0xFF];
    }

    public static boolean sflag_nef_CMPXCHG_O16_FLAGS_reg1_reg2(int n, int n2) {
        int n3 = n2 - n;
        return (short)n3 < 0;
    }

    public static boolean zflag_nef_CMPXCHG_O16_FLAGS_reg1_reg2(int n, int n2) {
        int n3 = n2 - n;
        return (short)n3 == 0;
    }

    public static boolean aflag_nef_CMPXCHG_O32_FLAGS_reg1_reg2(int n, int n2) {
        int n3 = n2 - n;
        return ((n2 ^ n ^ n3) & 0x10) != 0;
    }

    public static boolean cflag_nef_CMPXCHG_O32_FLAGS_reg1_reg2(int n, int n2) {
        long l = (0xFFFFFFFFL & (long)n2) - (0xFFFFFFFFL & (long)n);
        return (l & 0xFFFFFFFF00000000L) != 0L;
    }

    public static boolean oflag_nef_CMPXCHG_O32_FLAGS_reg1_reg2(int n, int n2) {
        int n3 = n2 - n;
        return (n2 & Integer.MIN_VALUE) != (n & Integer.MIN_VALUE) && (n2 & Integer.MIN_VALUE) != (n3 & Integer.MIN_VALUE);
    }

    public static boolean pflag_nef_CMPXCHG_O32_FLAGS_reg1_reg2(int n, int n2) {
        int n3 = n2 - n;
        return parityMap[n3 & 0xFF];
    }

    public static boolean sflag_nef_CMPXCHG_O32_FLAGS_reg1_reg2(int n, int n2) {
        int n3 = n2 - n;
        return n3 < 0;
    }

    public static boolean zflag_nef_CMPXCHG_O32_FLAGS_reg1_reg2(int n, int n2) {
        int n3 = n2 - n;
        return n3 == 0;
    }

    public static int edi_nef_STOSB_A16_edi_dflag(int n, boolean bl) {
        if (bl) {
            return n & 0xFFFF0000 | n - 1 & 0xFFFF;
        }
        return n & 0xFFFF0000 | n + 1 & 0xFFFF;
    }

    public static void memorywrite_hef_STOSB_A16_es_reg0_edi(Segment segment, int n, int n2) {
        segment.setByte(n2 & 0xFFFF, (byte)n);
    }

    public static int edi_nef_STOSB_A32_edi_dflag(int n, boolean bl) {
        if (bl) {
            return n - 1;
        }
        return n + 1;
    }

    public static void memorywrite_hef_STOSB_A32_es_reg0_edi(Segment segment, int n, int n2) {
        segment.setByte(n2, (byte)n);
    }

    public static int edi_nef_STOSW_A16_edi_dflag(int n, boolean bl) {
        if (bl) {
            return n & 0xFFFF0000 | n - 2 & 0xFFFF;
        }
        return n & 0xFFFF0000 | n + 2 & 0xFFFF;
    }

    public static void memorywrite_hef_STOSW_A16_es_reg0_edi(Segment segment, int n, int n2) {
        segment.setWord(n2 & 0xFFFF, (short)n);
    }

    public static int edi_nef_STOSW_A32_edi_dflag(int n, boolean bl) {
        if (bl) {
            return n - 2;
        }
        return n + 2;
    }

    public static void memorywrite_hef_STOSW_A32_es_reg0_edi(Segment segment, int n, int n2) {
        segment.setWord(n2, (short)n);
    }

    public static int edi_nef_STOSD_A16_edi_dflag(int n, boolean bl) {
        if (bl) {
            return n & 0xFFFF0000 | n - 4 & 0xFFFF;
        }
        return n & 0xFFFF0000 | n + 4 & 0xFFFF;
    }

    public static void memorywrite_hef_STOSD_A16_es_reg0_edi(Segment segment, int n, int n2) {
        segment.setDoubleWord(n2 & 0xFFFF, n);
    }

    public static int edi_nef_STOSD_A32_edi_dflag(int n, boolean bl) {
        if (bl) {
            return n - 4;
        }
        return n + 4;
    }

    public static void memorywrite_hef_STOSD_A32_es_reg0_edi(Segment segment, int n, int n2) {
        segment.setDoubleWord(n2, n);
    }

    public static boolean cflag_nef_CLC() {
        return false;
    }

    public static boolean dflag_nef_CLD() {
        return false;
    }

    public static boolean iflag_nef_CLI() {
        return false;
    }

    public static boolean cflag_nef_STC() {
        return true;
    }

    public static boolean dflag_nef_STD() {
        return true;
    }

    public static boolean iflag_nef_STI() {
        return true;
    }

    public static boolean cflag_nef_CMC_cflag(boolean bl) {
        return bl ^ true;
    }

    public static int eip_nef_CALL_O32_A32_cs_eip_reg0(Segment segment, int n, int n2) throws ProcessorException {
        segment.checkAddress(n += n2);
        return n;
    }

    public static int esp_nef_CALL_O32_A32_ss_esp(Segment segment, int n) {
        if (segment.getDefaultSizeFlag()) {
            return n - 4;
        }
        return n & 0xFFFF0000 | n - 4 & 0xFFFF;
    }

    public static void memorywrite_hef_CALL_O32_A32_ss_esp_eip(Segment segment, int n, int n2) {
        if (segment.getDefaultSizeFlag()) {
            if (n < 4 && n > 0) {
                throw new ProcessorException(12, 0, true);
            }
            segment.setDoubleWord(n - 4, n2);
        } else {
            if ((0xFFFF & n) < 4 && (0xFFFF & n) > 0) {
                throw new ProcessorException(12, 0, true);
            }
            segment.setDoubleWord(n - 4 & 0xFFFF, n2);
        }
    }

    public static int eip_nef_CALL_ABS_O32_A32_cs_reg0(Segment segment, int n) throws ProcessorException {
        segment.checkAddress(n);
        return n;
    }

    public static int esp_nef_CALL_ABS_O32_A32_ss_esp(Segment segment, int n) {
        if (segment.getDefaultSizeFlag()) {
            return n - 4;
        }
        return n & 0xFFFF0000 | n - 4 & 0xFFFF;
    }

    public static void memorywrite_hef_CALL_ABS_O32_A32_ss_esp_eip(Segment segment, int n, int n2) {
        if (segment.getDefaultSizeFlag()) {
            if (n < 4 && n > 0) {
                throw new ProcessorException(12, 0, true);
            }
            segment.setDoubleWord(n - 4, n2);
        } else {
            if ((0xFFFF & n) < 4 && (0xFFFF & n) > 0) {
                throw new ProcessorException(12, 0, true);
            }
            segment.setDoubleWord(n - 4 & 0xFFFF, n2);
        }
    }

    public static int eip_hef_RET_O32_A32_ss_esp(Segment segment, int n) {
        if (segment.getDefaultSizeFlag()) {
            return segment.getDoubleWord(n);
        }
        return segment.getDoubleWord(n & 0xFFFF);
    }

    public static int esp_nef_RET_O32_A32_ss_esp(Segment segment, int n) {
        if (segment.getDefaultSizeFlag()) {
            return n + 4;
        }
        return n & 0xFFFF0000 | n + 4 & 0xFFFF;
    }

    public static int eip_hef_RET_IW_O32_A32_ss_esp(Segment segment, int n) {
        if (segment.getDefaultSizeFlag()) {
            return segment.getDoubleWord(n);
        }
        return segment.getDoubleWord(n & 0xFFFF);
    }

    public static int esp_nef_RET_IW_O32_A32_ss_esp_reg0(Segment segment, int n, int n2) {
        if (segment.getDefaultSizeFlag()) {
            return n + 4 + (short)n2;
        }
        return n & 0xFFFF0000 | n + 4 + n2 & 0xFFFF;
    }

    public static int esp_nef_LEAVE_O32_A32_ss_ebp_esp(Segment segment, int n, int n2) throws ProcessorException {
        if (segment.getDefaultSizeFlag()) {
            segment.checkAddress(n);
            return n + 4;
        }
        segment.checkAddress(n & 0xFFFF);
        return n2 & 0xFFFF0000 | n + 4 & 0xFFFF;
    }

    public static int ebp_hef_LEAVE_O32_A32_ss_ebp(Segment segment, int n) {
        if (segment.getDefaultSizeFlag()) {
            return segment.getDoubleWord(n);
        }
        return segment.getDoubleWord(n & 0xFFFF);
    }

    private static final boolean checkIOPermissionsByte(int n, int n2, Segment segment, int n3) {
        if (n <= n2) {
            return true;
        }
        int n4 = 0xFFFF & segment.getWord(102);
        try {
            byte by = segment.getByte(n4 + (n3 >>> 3));
            return (by & 1 << (n3 & 7)) == 0;
        }
        catch (ProcessorException processorException) {
            if (processorException.getVector() == 13) {
                return false;
            }
            throw processorException;
        }
    }

    private static final boolean checkIOPermissionsShort(int n, int n2, Segment segment, int n3) {
        if (n <= n2) {
            return true;
        }
        int n4 = 0xFFFF & segment.getWord(102);
        try {
            short s = segment.getWord(n4 + (n3 >>> 3));
            return (s & 3 << (n3 & 7)) == 0;
        }
        catch (ProcessorException processorException) {
            if (processorException.getVector() == 13) {
                return false;
            }
            throw processorException;
        }
    }

    private static final boolean checkIOPermissionsInt(int n, int n2, Segment segment, int n3) {
        if (n <= n2) {
            return true;
        }
        int n4 = 0xFFFF & segment.getWord(102);
        try {
            short s = segment.getWord(n4 + (n3 >>> 3));
            return (s & 15 << (n3 & 7)) == 0;
        }
        catch (ProcessorException processorException) {
            if (processorException.getVector() == 13) {
                return false;
            }
            throw processorException;
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            boolean bl = true;
            for (int j = 0; j < 8; ++j) {
                if ((1 & i >> j) != 1) continue;
                bl = !bl;
            }
            UCodeStaticMethods.parityMap[i] = bl;
        }
    }
}

