/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.ata;

public enum ATACommand {
    READ_SECTORS_WITH_RETRY(32, "Read Sectors With Retry"),
    READ_SECTORS_WITHOUT_RETRY(33, "Read Sectors Without Retry"),
    IDENTIFY_DRIVE(-20, "Identify Drive"),
    WRITE_SECTORS_WITH_RETRY(48, "Write Sectors With Retry"),
    WRITE_MULTIPLE(-59, "WRITE MULTIPLE"),
    PACKET_A0(-96, "Packet"),
    PACKET_A1(-95, "Packet"),
    DEVICE_RESET(8, "DEVICE_RESET"),
    RECALIBRATE(16, "Recalibrate"),
    READ_LONG_WITH_RETRY(34, "Read Long With Retry"),
    READ_LONG_WITHOUT_RETRY(35, "Read Long Without Retry"),
    READ_SECTORS_EXT(36, "READ SECTORS EXT"),
    READ_DMA_EXT(37, "READ DMA EXT"),
    READ_DMA_QUEUED_EXT(38, "READ DMA QUEUED EXT"),
    READ_NATIVE_MAX_ADDRESS_EXT(39, "READ NATIVE MAX ADDRESS EXT"),
    READ_MULTIPLE_EXT(41, "READ MULTIPLE EXT"),
    READ_STREAM_DMA(42, "READ STREAM DMA"),
    READ_STREAM_PIO(43, "READ STREAM PIO"),
    READ_LOG_EXT(47, "READ LOG EXT"),
    WRITE_SECTORS_WITHOUT_RETRY(49, "Write Sectors Without Retry"),
    WRITE_LONG_SECTORS_WITH_RETRY(50, "Write Long Sectors With Retry"),
    WRITE_LONG_SECTORS_WITHOUT_RETRY(51, "Write Long Sectors Without Retry"),
    WRITE_SECTORS_EXT(52, "WRITE SECTORS EXT"),
    WRITE_DMA_EXT(53, "WRITE DMA EXT"),
    WRITE_DMA_QUEUED_EXT(54, "WRITE DMA QUEUED EXT"),
    SET_MAX_ADDRESS_EXT(55, "SET MAX ADDRESS EXT"),
    CFA_WRITE_SECTORS_WITHOUT_ERASE(56, "CFA WRITE SECTORS W/OUT ERASE"),
    WRITE_MULTIPLE_EXT(57, "WRITE MULTIPLE EXT"),
    WRITE_STREAM_DMA(58, "WRITE STREAM DMA"),
    WRITE_STREAM_PIO(59, "WRITE STREAM PIO"),
    WRITE_LOG_EXT(63, "WRITE LOG EXT"),
    READ_VERIFY_SECTOR_WITH_RETRY(64, "Read Verify Sector With Retry"),
    READ_VERIFY_SECTOR_WITHOUT_RETRY(65, "Read Verify Sector Without Retry"),
    READ_VERIFY_SECTORS_EXT(66, "READ VERIFY SECTORS EXT"),
    FORMAT_TRACK(80, "Format Track"),
    CONFIGURE_STREAM(81, "CONFIGURE STREAM"),
    SEEK(112, "Seek"),
    CFA_TRANSLATE_SECTOR(-121, "CFA TRANSLATE SECTOR"),
    EXECUTE_DEVICE_DIAGNOSTIC(-112, "EXECUTE DEVICE DIAGNOSTIC"),
    INITIALIZE_DEVICE_PARAMETERS(-111, "INITIALIZE DEVICE PARAMETERS"),
    DOWNLOAD_MICROCODE(-110, "DOWNLOAD MICROCODE"),
    STANDBY_IMMEDIATE(-108, "STANDBY IMMEDIATE"),
    IDLE_IMMEDIATE(-107, "IDLE IMMEDIATE"),
    STANDBY(-106, "STANDBY"),
    IDLE(-105, "IDLE"),
    CHECK_POWER_MODE(-104, "CHECK POWER MODE"),
    SLEEP(-103, "SLEEP"),
    SERVICE(-94, "SERVICE"),
    SMART_DISABLE_OPERATIONS(-80, "SMART DISABLE OPERATIONS"),
    DEVICE_CONFIGURATION_FREEZE_LOCK(-79, "DEVICE CONFIGURATION FREEZE LOCK"),
    CFA_ERASE_SECTORS(-64, "CFA ERASE SECTORS"),
    READ_MULTIPLE(-60, "READ MULTIPLE"),
    SET_MULTIPLE_MOD(-58, "SET MULTIPLE MOD"),
    READ_DMA_QUEUED(-57, "READ DMA QUEUED"),
    READ_DMA(-56, "READ DMA"),
    READ_DMA_NO_RETRY(-55, "READ DMA NO RETRY"),
    WRITE_DMA(-54, "WRITE DMA"),
    WRITE_DMA_QUEUED(-52, "WRITE DMA QUEUED"),
    CFA_WRITE_MULTIPLE_WITHOUT_ERASED(-51, "CFA WRITE MULTIPLE W/OUT ERASE"),
    CHECK_MEDIA_CARD_TYPE(-47, "CHECK MEDIA CARD TYPE"),
    GET_MEDIA_STATUS(-38, "GET MEDIA STATUS"),
    MEDIA_LOCK(-34, "MEDIA LOCK"),
    MEDIA_UNLOCK(-33, "MEDIA UNLOCK"),
    STANDBY_IMMEDIATE_2(-32, "STANDBY IMMEDIATE"),
    IDLE_IMMEDIATE_2(-31, "IDLE IMMEDIATE"),
    STANDBY_2(-30, "STANDBY"),
    IDLE_2(-29, "IDLE"),
    READ_BUFFER_2(-28, "READ BUFFER"),
    CHECK_POWER_MODE_2(-27, "CHECK POWER MODE"),
    SLEEP_2(-26, "SLEEP"),
    FLUSH_CACHE(-25, "FLUSH CACHE"),
    WRITE_BUFFER(-24, "Write Buffer"),
    FLUSH_CACHE_EXT(-22, "FLUSH CACHE EXT"),
    MEDIA_EJECT(-19, "MEDIA EJECT"),
    SET_FEATURES(-17, "Set Features"),
    SECURITY_SET_PASSWORD(-15, "SECURITY SET PASSWORD"),
    SECURITY_UNLOCK(-14, "SECURITY UNLOCK"),
    SECURITY_ERASE_PREPARE(-13, "SECURITY ERASE PREPARE"),
    SECURITY_ERASE_UNIT(-12, "SECURITY ERASE UNIT"),
    SECURITY_FREEZE_LOCK(-11, "SECURITY FREEZE LOCK"),
    SECURITY_DISABLE_PASSWORD(-10, "SECURITY DISABLE PASSWORD"),
    READ_NATIVE_MAX_ADDRESS(-8, "READ NATIVE MAX ADDRESS"),
    SET_MAX_ADDRESS(-7, "SET MAX ADDRESS");

    private final byte address;
    private final String name;

    private ATACommand(byte by, String string2) {
        this.address = by;
        this.name = string2;
    }

    public static ATACommand getCommand(int n) {
        ATACommand aTACommand = null;
        for (ATACommand aTACommand2 : ATACommand.values()) {
            if (aTACommand2.getAddress() != n) continue;
            aTACommand = aTACommand2;
            break;
        }
        return aTACommand;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public int getAddress() {
        return this.address;
    }
}

