/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_ADD_GvEv
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = true;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceValue = new byte[2];
    byte[] oldSource = new byte[2];
    byte[] destinationRegister = new byte[2];
    byte[] oldDest = new byte[2];
    int internalCarry = 0;
    byte[] temp = new byte[2];

    public Instruction_ADD_GvEv() {
    }

    public Instruction_ADD_GvEv(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        if ((this.addressByte >> 6 & 3) == 3) {
            this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
        } else {
            this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
            this.sourceValue = this.cpu.getWordFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
        }
        this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, (this.addressByte & 0x38) >> 3);
        System.arraycopy(this.destinationRegister, 0, this.oldDest, 0, this.destinationRegister.length);
        System.arraycopy(this.sourceValue, 0, this.oldSource, 0, this.sourceValue.length);
        this.temp = Util.addWords(this.destinationRegister, this.sourceValue, 0);
        System.arraycopy(this.temp, 0, this.destinationRegister, 0, this.temp.length);
        this.cpu.flags[4] = Util.test_AF_ADD(this.oldDest[1], this.destinationRegister[1]);
        this.cpu.flags[0] = Util.test_CF_ADD(this.oldDest, this.oldSource, 0);
        this.cpu.flags[11] = Util.test_OF_ADD(this.oldDest, this.oldSource, this.destinationRegister, 0);
        this.cpu.flags[6] = this.destinationRegister[0] == 0 && this.destinationRegister[1] == 0;
        this.cpu.flags[7] = this.destinationRegister[0] < 0;
        this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[1]);
    }
}

