/*
 * Decompiled with CFR 0.152.
 */
package gnu.vnc.pixels;

import gnu.awt.PixelsOwner;
import gnu.rfb.Colour;
import gnu.rfb.PixelFormat;
import gnu.rfb.server.RFBClient;
import gnu.rfb.server.RFBClients;
import gnu.rfb.server.RFBServer;
import gnu.vnc.VNCQueue;
import gnu.vnc.awt.VNCEvents;
import java.io.IOException;
import java.util.Enumeration;

public class VNCPixels
implements RFBServer,
PixelsOwner {
    private VNCEvents events = null;
    private String name;
    private int width;
    private int height;
    private RFBClients clients = new RFBClients();
    private boolean shared = false;
    private int[] pixelArray = null;
    protected VNCQueue queue;

    public void setVNCEventsHandler(VNCEvents events) {
        this.events = events;
    }

    public VNCEvents getVNCEventsHandler() {
        return this.events;
    }

    public VNCPixels(String name, int width, int height) {
        this.name = name;
        this.width = width;
        this.height = height;
        this.queue = new VNCQueue(this.clients);
        this.pixelArray = new int[width * height];
    }

    public VNCQueue getQueue() {
        return this.queue;
    }

    public void dispose() {
    }

    @Override
    public void addClient(RFBClient client) {
        this.clients.addClient(client);
    }

    public RFBClients getClients() {
        return this.clients;
    }

    @Override
    public void removeClient(RFBClient client) {
        this.clients.removeClient(client);
        if (this.clients.isEmpty() && !this.shared) {
            this.clients.closeAll();
            this.dispose();
        }
    }

    @Override
    public String getDesktopName(RFBClient client) {
        return this.name;
    }

    @Override
    public int getFrameBufferWidth(RFBClient client) {
        return this.width;
    }

    @Override
    public int getFrameBufferHeight(RFBClient client) {
        return this.height;
    }

    @Override
    public PixelFormat getPreferredPixelFormat(RFBClient client) {
        return PixelFormat.RGB888;
    }

    @Override
    public boolean allowShared() {
        return true;
    }

    @Override
    public void setClientProtocolVersionMsg(RFBClient client, String protocolVersionMsg) throws IOException {
    }

    @Override
    public void setShared(RFBClient client, boolean shared) throws IOException {
        if (shared) {
            this.shared = true;
        }
    }

    @Override
    public void setPixelFormat(RFBClient client, PixelFormat pixelFormat) throws IOException {
    }

    @Override
    public void setEncodings(RFBClient client, int[] encodings) throws IOException {
    }

    @Override
    public void fixColourMapEntries(RFBClient client, int firstColour, Colour[] colourMap) throws IOException {
    }

    @Override
    public void frameBufferUpdateRequest(RFBClient client, boolean incremental, int x, int y, int w, int h) throws IOException {
        this.queue.takeSnapshot(this);
        this.queue.frameBufferUpdate(client, incremental, x, y, w, h);
    }

    @Override
    public void keyEvent(RFBClient client, boolean down, int key) throws IOException {
        if (this.events != null) {
            this.events.translateKeyEvent(client, down, key);
        } else {
            this.updateAll();
        }
    }

    @Override
    public void pointerEvent(RFBClient client, int buttonMask, int x, int y) throws IOException {
        if (this.events != null) {
            this.events.translatePointerEvent(client, buttonMask, x, y);
        } else {
            this.updateAll();
        }
    }

    @Override
    public void clientCutText(RFBClient client, String text) throws IOException {
    }

    @Override
    public int[] getPixels() {
        return this.pixelArray;
    }

    @Override
    public void setPixelArray(int[] pixelArray, int pixelWidth, int pixelHeight) {
        this.pixelArray = pixelArray;
        this.width = pixelWidth;
        this.height = pixelHeight;
    }

    @Override
    public int getPixelWidth() {
        return this.width;
    }

    @Override
    public int getPixelHeight() {
        return this.height;
    }

    public void updateAll() throws IOException {
        Enumeration e = this.clients.elements();
        while (e.hasMoreElements()) {
            RFBClient client = (RFBClient)e.nextElement();
            this.frameBufferUpdateRequest(client, false, 0, 0, this.width, this.height);
        }
    }
}

