/*
 * Decompiled with CFR 0.152.
 */
package gnu.vnc.awt.swing;

import gnu.awt.PixelsOwner;
import gnu.awt.virtual.swing.VirtualDesktop;
import gnu.rfb.Colour;
import gnu.rfb.PixelFormat;
import gnu.rfb.server.RFBClient;
import gnu.rfb.server.RFBClients;
import gnu.rfb.server.RFBServer;
import gnu.vnc.awt.VNCEvents;
import gnu.vnc.awt.swing.VNCRepaintManager;
import java.awt.Insets;
import java.awt.image.DirectColorModel;
import java.io.IOException;

public class VNCDesktop
extends VirtualDesktop
implements RFBServer {
    private RFBClients clients = new RFBClients();
    private VNCEvents events;
    private boolean shared = false;
    private VNCRepaintManager repaintManager;

    public VNCDesktop(int bitsPerPixel, int rMask, int gMask, int bMask, String title, int width, int height) {
        super(bitsPerPixel, rMask, gMask, bMask, title, width, height);
        this.init();
    }

    public VNCDesktop(String title, int width, int height) {
        super(title, width, height);
        this.init();
    }

    @Override
    public void dispose() {
        this.clients.closeAll();
        super.dispose();
    }

    @Override
    public void addClient(RFBClient client) {
        this.clients.addClient(client);
    }

    @Override
    public void removeClient(RFBClient client) {
        this.clients.removeClient(client);
        if (this.clients.isEmpty() && !this.shared) {
            this.dispose();
        }
    }

    @Override
    public String getDesktopName(RFBClient client) {
        return this.desktopFrame.getTitle();
    }

    @Override
    public int getFrameBufferWidth(RFBClient client) {
        Insets insets = this.desktopFrame.getInsets();
        return this.desktopFrame.getWidth() - insets.left - insets.right;
    }

    @Override
    public int getFrameBufferHeight(RFBClient client) {
        Insets insets = this.desktopFrame.getInsets();
        return this.desktopFrame.getHeight() - insets.top - insets.bottom;
    }

    @Override
    public PixelFormat getPreferredPixelFormat(RFBClient client) {
        return PixelFormat.RGB888;
    }

    @Override
    public boolean allowShared() {
        return true;
    }

    @Override
    public void setClientProtocolVersionMsg(RFBClient client, String protocolVersionMsg) throws IOException {
    }

    @Override
    public void setShared(RFBClient client, boolean shared) throws IOException {
        if (shared) {
            this.shared = true;
        }
    }

    @Override
    public void setPixelFormat(RFBClient client, PixelFormat pixelFormat) throws IOException {
        pixelFormat.setDirectColorModel((DirectColorModel)this.getColorModel());
    }

    @Override
    public void setEncodings(RFBClient client, int[] encodings) throws IOException {
    }

    @Override
    public void fixColourMapEntries(RFBClient client, int firstColour, Colour[] colourMap) throws IOException {
    }

    @Override
    public void frameBufferUpdateRequest(RFBClient client, boolean incremental, int x, int y, int w, int h) throws IOException {
        this.repaintManager.frameBufferUpdate(client, incremental, x, y, w, h);
    }

    @Override
    public void keyEvent(RFBClient client, boolean down, int key) throws IOException {
        this.events.translateKeyEvent(client, down, key);
    }

    @Override
    public void pointerEvent(RFBClient client, int buttonMask, int x, int y) throws IOException {
        this.events.translatePointerEvent(client, buttonMask, x, y);
    }

    @Override
    public void clientCutText(RFBClient client, String text) throws IOException {
    }

    private void init() {
        this.events = new VNCEvents(this.desktopFrame, this.clients);
        this.repaintManager = new VNCRepaintManager((PixelsOwner)this.desktopFrame, this.clients);
        VNCRepaintManager.setCurrentManager(this.repaintManager);
        this.desktopFrame.setResizable(false);
        this.show();
    }
}

