/*
 * Decompiled with CFR 0.152.
 */
package gnu.rfb.server;

import gnu.logging.VLogger;
import gnu.rfb.Colour;
import gnu.rfb.PixelFormat;
import gnu.rfb.Rect;
import gnu.rfb.server.RFBAuthenticator;
import gnu.rfb.server.RFBClient;
import gnu.rfb.server.RFBHost;
import gnu.rfb.server.RFBServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Iterator;
import java.util.Vector;

public class RFBSocket
implements RFBClient,
Runnable {
    private Socket socket;
    private RFBHost host;
    private RFBAuthenticator authenticator;
    private RFBServer server = null;
    private DataInputStream input;
    private DataOutputStream output;
    private PixelFormat pixelFormat = null;
    private String protocolVersionMsg = "";
    private boolean shared = true;
    private int[] encodings = new int[0];
    private int preferredEncoding = 5;
    private boolean isRunning = false;
    private boolean threadFinished = false;
    private Vector updateQueue = new Vector();
    private boolean updateAvailable = true;

    public RFBSocket(Socket socket, RFBServer server, RFBHost host, RFBAuthenticator authenticator) throws IOException {
        this.socket = socket;
        this.server = server;
        this.host = host;
        this.authenticator = authenticator;
        this.input = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.output = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), 16384));
        new Thread(this).start();
    }

    public RFBSocket(Socket socket, RFBServer server, RFBHost host, RFBAuthenticator authenticator, boolean syncronous) throws IOException {
        this.socket = socket;
        this.server = server;
        this.host = host;
        this.authenticator = authenticator;
        this.input = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.output = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), 16384));
        if (syncronous) {
            this.run();
        } else {
            new Thread(this).start();
        }
    }

    @Override
    public synchronized PixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    @Override
    public synchronized String getProtocolVersionMsg() {
        return this.protocolVersionMsg;
    }

    @Override
    public synchronized boolean getShared() {
        return this.shared;
    }

    @Override
    public synchronized int getPreferredEncoding() {
        return this.preferredEncoding;
    }

    @Override
    public synchronized void setPreferredEncoding(int encoding) {
        if (this.encodings.length > 0) {
            int i = 0;
            while (i < this.encodings.length) {
                if (encoding == this.encodings[i]) {
                    this.preferredEncoding = encoding;
                    return;
                }
                ++i;
            }
        } else {
            this.preferredEncoding = encoding;
        }
    }

    @Override
    public synchronized int[] getEncodings() {
        return this.encodings;
    }

    @Override
    public synchronized void writeFrameBufferUpdate(Rect[] rects) throws IOException {
        this.writeServerMessageType(0);
        this.output.writeByte(0);
        int count = 0;
        int i = 0;
        while (i < rects.length) {
            count += rects[i].count;
            ++i;
        }
        this.output.writeShort(count);
        i = 0;
        while (i < rects.length) {
            rects[i].writeData(this.output);
            ++i;
        }
        this.output.flush();
    }

    @Override
    public synchronized void writeSetColourMapEntries(int firstColour, Colour[] colours) throws IOException {
        this.writeServerMessageType(1);
        this.output.writeByte(0);
        this.output.writeShort(firstColour);
        this.output.writeShort(colours.length);
        int i = 0;
        while (i < colours.length) {
            this.output.writeShort(colours[i].r);
            this.output.writeShort(colours[i].g);
            this.output.writeShort(colours[i].b);
            ++i;
        }
        this.output.flush();
    }

    @Override
    public synchronized void writeBell() throws IOException {
        this.writeServerMessageType(2);
    }

    @Override
    public synchronized void writeServerCutText(String text) throws IOException {
        this.writeServerMessageType(3);
        this.output.writeByte(0);
        this.output.writeShort(0);
        this.output.writeInt(text.length());
        this.output.writeBytes(text);
        this.output.writeByte(0);
        this.output.flush();
    }

    @Override
    public synchronized void close() {
        this.isRunning = false;
        while (!this.threadFinished) {
            try {
                Thread.currentThread();
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            try {
                this.output.close();
                this.input.close();
                this.socket.close();
            }
            catch (IOException e) {
                VLogger.getLogger().log("Got and exception shutting down RFBSocket ", e);
                this.output = null;
                this.input = null;
                this.socket = null;
            }
        }
        finally {
            this.output = null;
            this.input = null;
            this.socket = null;
        }
    }

    @Override
    public void run() {
        this.isRunning = true;
        try {
            this.writeProtocolVersionMsg();
            this.readProtocolVersionMsg();
            if (!this.authenticator.authenticate(this.input, this.output, this)) {
                System.out.println("Authentiation failed");
                return;
            }
            this.readClientInit();
            this.initServer();
            this.writeServerInit();
            while (this.isRunning) {
                if (this.getUpdateIsAvailable()) {
                    this.doFrameBufferUpdate();
                }
                if (this.input.available() == 0) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                switch (this.input.readUnsignedByte()) {
                    case 0: {
                        this.readSetPixelFormat();
                        break;
                    }
                    case 1: {
                        this.readFixColourMapEntries();
                        break;
                    }
                    case 2: {
                        this.readSetEncodings();
                        break;
                    }
                    case 3: {
                        this.readFrameBufferUpdateRequest();
                        break;
                    }
                    case 4: {
                        this.readKeyEvent();
                        break;
                    }
                    case 5: {
                        this.readPointerEvent();
                        break;
                    }
                    case 6: {
                        this.readClientCutText();
                    }
                }
            }
        }
        catch (IOException x) {
            System.out.println("Got an IOException, drop the client");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (this.server != null) {
            this.server.removeClient(this);
        }
        this.threadFinished = true;
        this.close();
    }

    private void initServer() throws IOException {
        if (this.shared) {
            this.server = this.host.getSharedServer();
        }
        this.server.addClient(this);
        this.server.setClientProtocolVersionMsg(this, this.protocolVersionMsg);
        this.server.setShared(this, this.shared);
    }

    private synchronized void writeProtocolVersionMsg() throws IOException {
        this.output.writeBytes("RFB 003.003\n");
        this.output.flush();
    }

    private synchronized void readProtocolVersionMsg() throws IOException {
        byte[] b = new byte[12];
        this.input.readFully(b);
        this.protocolVersionMsg = new String(b);
    }

    private synchronized void readClientInit() throws IOException {
        this.shared = this.input.readUnsignedByte() == 1;
    }

    private synchronized void writeServerInit() throws IOException {
        this.output.writeShort(this.server.getFrameBufferWidth(this));
        this.output.writeShort(this.server.getFrameBufferHeight(this));
        this.server.getPreferredPixelFormat(this).writeData(this.output);
        this.output.writeByte(0);
        this.output.writeByte(0);
        this.output.writeByte(0);
        String desktopName = this.server.getDesktopName(this);
        this.output.writeInt(desktopName.length());
        this.output.writeBytes(desktopName);
        this.output.flush();
    }

    private synchronized void writeAuthScheme() throws IOException {
        this.output.writeInt(this.authenticator.getAuthScheme(this));
        this.output.flush();
    }

    private synchronized void writeServerMessageType(int type) throws IOException {
        this.output.writeByte(type);
    }

    private synchronized void readSetPixelFormat() throws IOException {
        this.input.readUnsignedByte();
        this.input.readUnsignedShort();
        this.pixelFormat = new PixelFormat(this.input);
        this.input.readUnsignedByte();
        this.input.readUnsignedShort();
        this.server.setPixelFormat(this, this.pixelFormat);
    }

    private synchronized void readFixColourMapEntries() throws IOException {
        this.input.readUnsignedByte();
        int firstColour = this.input.readUnsignedShort();
        int nColours = this.input.readUnsignedShort();
        Colour[] colourMap = new Colour[nColours];
        int i = 0;
        while (i < nColours) {
            colourMap[i].readData(this.input);
            ++i;
        }
        this.server.fixColourMapEntries(this, firstColour, colourMap);
    }

    private synchronized void readSetEncodings() throws IOException {
        this.input.readUnsignedByte();
        int nEncodings = this.input.readUnsignedShort();
        this.encodings = new int[nEncodings];
        int i = 0;
        while (i < nEncodings) {
            this.encodings[i] = this.input.readInt();
            ++i;
        }
        this.preferredEncoding = Rect.bestEncoding(this.encodings);
        this.server.setEncodings(this, this.encodings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void readFrameBufferUpdateRequest() throws IOException {
        boolean incremental = this.input.readUnsignedByte() == 1;
        int x = this.input.readUnsignedShort();
        int y = this.input.readUnsignedShort();
        int w = this.input.readUnsignedShort();
        int h = this.input.readUnsignedShort();
        UpdateRequest r = new UpdateRequest(incremental, x, y, w, h);
        Vector vector = this.updateQueue;
        synchronized (vector) {
            int index = this.updateQueue.indexOf(r);
            if (index >= 0) {
                if (!r.incremental) {
                    this.updateQueue.setElementAt(r, index);
                }
            } else {
                this.updateQueue.add(r);
            }
        }
    }

    private synchronized void doFrameBufferUpdate() throws IOException {
        Iterator iter = this.updateQueue.iterator();
        while (iter.hasNext()) {
            UpdateRequest ur = (UpdateRequest)iter.next();
            iter.remove();
            try {
                try {
                    System.out.println("RFBSocket is doing an update");
                    this.server.frameBufferUpdateRequest(this, ur.incremental, ur.x, ur.y, ur.w, ur.h);
                    System.out.println("RFBSocket is done");
                }
                catch (IOException e) {
                    if (!e.getMessage().startsWith("rects.length == 0")) {
                        throw e;
                    }
                    this.server.frameBufferUpdateRequest(this, false, 0, 0, 1, 1);
                    this.setUpdateIsAvailable(false);
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.setUpdateIsAvailable(false);
                throw throwable;
            }
            this.setUpdateIsAvailable(false);
        }
    }

    private synchronized void readKeyEvent() throws IOException {
        boolean down = this.input.readUnsignedByte() == 1;
        this.input.readUnsignedShort();
        int key = this.input.readInt();
        this.server.keyEvent(this, down, key);
    }

    private synchronized void readPointerEvent() throws IOException {
        int buttonMask = this.input.readUnsignedByte();
        int x = this.input.readUnsignedShort();
        int y = this.input.readUnsignedShort();
        this.server.pointerEvent(this, buttonMask, x, y);
    }

    private synchronized void readClientCutText() throws IOException {
        this.input.readUnsignedByte();
        this.input.readUnsignedShort();
        int length = this.input.readInt();
        byte[] bytes = new byte[length];
        this.input.readFully(bytes);
        String text = new String(bytes);
        this.server.clientCutText(this, text);
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public String getName() {
        return this.host.getDisplayName();
    }

    @Override
    public void setUpdateIsAvailable(boolean value) {
        this.updateAvailable = value;
    }

    public boolean getUpdateIsAvailable() {
        return this.updateAvailable;
    }

    private class UpdateRequest {
        boolean incremental;
        int x;
        int y;
        int w;
        int h;

        public UpdateRequest(boolean incremental, int x, int y, int w, int h) {
            this.incremental = incremental;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        public boolean equals(Object obj) {
            UpdateRequest u2 = (UpdateRequest)obj;
            return this.x == u2.x && this.y == u2.y && this.w == u2.w && this.h == u2.h;
        }
    }
}

