/*
 * Decompiled with CFR 0.152.
 */
package gnu.awt.virtual;

import gnu.awt.PixelsOwner;
import gnu.awt.virtual.VirtualComponentPeer;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.awt.peer.FramePeer;
import sun.awt.CausedFocusEvent;
import sun.java2d.pipe.Region;

class VirtualFramePeer
extends VirtualComponentPeer
implements FramePeer {
    private PixelsOwner pixelsOwner;
    private Insets insets = new Insets(0, 0, 0, 0);
    private BufferedImage image = null;

    public VirtualFramePeer(Frame frame, PixelsOwner pixelsOwner) {
        super(frame.getToolkit(), frame);
        this.pixelsOwner = pixelsOwner;
    }

    @Override
    public void setTitle(String title) {
    }

    public void setIconImage(Image im) {
    }

    @Override
    public void setMenuBar(MenuBar mb) {
    }

    @Override
    public void setResizable(boolean resizeable) {
    }

    @Override
    public void setState(int state) {
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public void toFront() {
    }

    @Override
    public void toBack() {
    }

    public int handleFocusTraversalEvent(KeyEvent e) {
        return -1;
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public void beginValidate() {
    }

    @Override
    public void endValidate() {
    }

    public Insets insets() {
        return this.getInsets();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.component.paint(this.getGraphics());
        }
    }

    @Override
    public Graphics getGraphics() {
        if (this.image == null) {
            if (this.size.width > 0 && this.size.height > 0) {
                DirectColorModel colorModel = (DirectColorModel)this.getColorModel();
                int[] pixels = new int[this.size.width * this.size.height];
                DataBufferInt dataBuffer = new DataBufferInt(pixels, pixels.length);
                SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(3, this.size.width, this.size.height, colorModel.getMasks());
                WritableRaster raster = Raster.createWritableRaster(sampleModel, dataBuffer, null);
                this.image = new BufferedImage(colorModel, raster, true, null);
                this.pixelsOwner.setPixelArray(pixels, this.size.width, this.size.height);
            } else {
                System.err.println("ERROR[VirtualFramePeer] getGraphics() - width and/or height == 0, cannot create Graphics");
                return null;
            }
        }
        return this.image.getGraphics();
    }

    @Override
    public Image createImage(int width, int height) {
        DirectColorModel colorModel = (DirectColorModel)this.getColorModel();
        SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(3, width, height, colorModel.getMasks());
        WritableRaster raster = Raster.createWritableRaster(sampleModel, null);
        return new BufferedImage(colorModel, raster, true, null);
    }

    @Override
    public void setMaximizedBounds(Rectangle rec) {
    }

    @Override
    public void beginLayout() {
    }

    @Override
    public void endLayout() {
    }

    public boolean isPaintPending() {
        return false;
    }

    @Override
    public boolean canDetermineObscurity() {
        return false;
    }

    @Override
    public void createBuffers(int arg0, BufferCapabilities arg1) throws AWTException {
    }

    @Override
    public VolatileImage createVolatileImage(int arg0, int arg1) {
        return null;
    }

    @Override
    public void destroyBuffers() {
    }

    public void flip(BufferCapabilities.FlipContents arg0) {
    }

    @Override
    public Image getBackBuffer() {
        return null;
    }

    @Override
    public boolean handlesWheelScrolling() {
        return false;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public boolean isObscured() {
        return false;
    }

    public boolean requestFocus(Component arg0, boolean arg1, boolean arg2, long arg3) {
        return false;
    }

    @Override
    public void updateCursorImmediately() {
    }

    @Override
    public void setBoundsPrivate(int x, int y, int width, int height) {
    }

    public boolean requestWindowFocus() {
        return false;
    }

    public void updateAlwaysOnTop() {
    }

    @Override
    public void updateFocusableWindowState() {
    }

    public void cancelPendingPaint(int x, int y, int w, int h) {
    }

    public boolean isRestackSupported() {
        return false;
    }

    public void restack() {
    }

    public Rectangle getBounds() {
        return null;
    }

    @Override
    public boolean isReparentSupported() {
        return false;
    }

    @Override
    public void layout() {
    }

    @Override
    public void setBounds(int x, int y, int width, int height, int op) {
    }

    @Override
    public Rectangle getBoundsPrivate() {
        return null;
    }

    @Override
    public void repositionSecurityWarning() {
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
    }

    @Override
    public void setModalBlocked(Dialog blocker, boolean blocked) {
    }

    @Override
    public void setOpacity(float opacity) {
    }

    @Override
    public void setOpaque(boolean isOpaque) {
    }

    @Override
    public void updateIconImages() {
    }

    @Override
    public void updateMinimumSize() {
    }

    @Override
    public void updateWindow() {
    }

    @Override
    public void applyShape(Region shape) {
    }

    @Override
    public void flip(int x1, int y1, int x2, int y2, BufferCapabilities.FlipContents flipAction) {
    }

    public boolean requestFocus(Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time, CausedFocusEvent.Cause cause) {
        return false;
    }
}

