/*
 * Decompiled with CFR 0.152.
 */
package gnu.vnc.awt;

import gnu.rfb.keysym;
import gnu.rfb.server.RFBClient;
import gnu.rfb.server.RFBClients;
import gnu.rfb.server.RFBSocket;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.HashMap;

public class VNCEvents {
    static Object log;
    static Method logmethod;
    private Window container;
    private RFBClients clients;
    private static HashMap eventMap;

    static {
        eventMap = new HashMap();
    }

    private void logDebug(String msg) {
        try {
            if (log == null) {
                log = System.err;
                logmethod = PrintStream.class.getMethod("println", String.class);
            }
            logmethod.invoke(log, msg);
        }
        catch (Exception x) {
            x.printStackTrace();
            System.err.println(msg);
        }
    }

    public VNCEvents(Window container, RFBClients clients) {
        this.container = container;
        this.clients = clients;
    }

    public void translateKeyEvent(RFBClient client, boolean down, int key) {
        int virtualKeyCode;
        State state = this.getState(client);
        char character = (char)key;
        int newKeyModifiers = keysym.toMask(key);
        if (newKeyModifiers != 0) {
            state.keyModifiers = down ? (state.keyModifiers |= newKeyModifiers) : (state.keyModifiers &= ~newKeyModifiers);
        }
        if (state.keyModifiers % 2 == 0 & Character.isUpperCase(character)) {
            state.keyModifiers |= 1;
        }
        if ((virtualKeyCode = keysym.toVKall(key)) == 0) {
            virtualKeyCode = key;
        }
        if (down) {
            this.fireKeyEvent(client, 401, virtualKeyCode, character, state.keyModifiers, null);
        } else {
            if (key >= 32 & key <= 126 | key >= 160 & key <= 255) {
                this.fireKeyEvent(client, 400, 0, character, state.keyModifiers, null);
            }
            this.fireKeyEvent(client, 402, virtualKeyCode, character, state.keyModifiers, null);
        }
    }

    public void translatePointerEvent(RFBClient client, int buttonMask, int x, int y) {
        State state = this.getState(client);
        int newMouseModifiers = 0;
        int wheelRotation = 0;
        boolean pressed = false;
        int button = -1;
        if ((buttonMask & 1) != 0) {
            button = 0;
            boolean bl = pressed = ((newMouseModifiers |= 0x10) & 0x10) > 0;
        }
        if ((buttonMask & 2) != 0) {
            button = 1;
            boolean bl = pressed = ((newMouseModifiers |= 8) & 8) > 0;
        }
        if ((buttonMask & 4) != 0) {
            button = 2;
            boolean bl = pressed = ((newMouseModifiers |= 4) & 4) > 0;
        }
        if ((buttonMask & 8) != 0) {
            wheelRotation = -1;
        }
        if ((buttonMask & 0x10) != 0) {
            wheelRotation = 1;
        }
        Insets insets = this.container.getInsets();
        Component newComponent = state.dragging ? state.oldComponent : this.container.findComponentAt(x += insets.left, y += insets.top);
        if (wheelRotation != 0) {
            this.fireWheelEvent(client, this.container, 507, x, y, 0, state.keyModifiers | state.mouseModifiers, wheelRotation);
        }
        state.dragging = false;
        if (newMouseModifiers == state.mouseModifiers) {
            if (newMouseModifiers == 0) {
                this.fireMouseEvent(client, this.container, 503, x, y, 0, state.keyModifiers | state.mouseModifiers);
            } else {
                state.dragging = true;
                this.fireMouseEvent(client, this.container, 506, x, y, 0, state.keyModifiers | state.mouseModifiers);
            }
        } else {
            if (pressed) {
                int numClicks = 1;
                long diff = System.currentTimeMillis() - state.lastMouseClickTime[button];
                if (diff < 1000L) {
                    numClicks = 2;
                }
                state.mouseModifiers = newMouseModifiers;
                state.lastMouseClickTime[button] = System.currentTimeMillis();
                this.fireMouseEvent(client, this.container, 501, x, y, numClicks, state.keyModifiers | state.mouseModifiers);
                state.lastMouseClickTime[button] = System.currentTimeMillis();
                this.fireMouseEvent(client, this.container, 500, x, y, numClicks, state.keyModifiers | state.mouseModifiers);
            } else {
                this.fireMouseEvent(client, this.container, 502, x, y, 0, state.keyModifiers | state.mouseModifiers);
            }
            state.mouseModifiers = newMouseModifiers;
            Component focusComponent = this.getFocusComponent(this.container);
            if (focusComponent != this.container) {
                if (focusComponent != null) {
                    this.fireEvent(client, new FocusEvent(focusComponent, 1005));
                }
                if (newComponent != null && newComponent.getParent() != null) {
                    this.fireEvent(client, new FocusEvent(newComponent.getParent(), 1004));
                    this.fireEvent(client, new FocusEvent(newComponent, 1004));
                } else {
                    System.out.println("bad:" + newComponent);
                }
                focusComponent = this.container;
            }
        }
        if (newComponent != state.oldComponent) {
            if (state.oldComponent != null) {
                this.fireMouseEvent(client, this.container, 505, state.oldX, state.oldY, 0, state.keyModifiers | state.mouseModifiers);
            }
            this.fireMouseEvent(client, this.container, 504, x, y, 0, state.keyModifiers | state.mouseModifiers);
            state.oldComponent = newComponent;
            state.oldX = x;
            state.oldY = y;
        }
    }

    public static HashMap getEventMap() {
        return eventMap;
    }

    private State getState(RFBClient client) {
        State state = (State)this.clients.getProperty(client, "events");
        if (state == null) {
            state = new State();
            this.clients.setProperty(client, "events", state);
        }
        return state;
    }

    private void fireEvent(RFBClient client, ComponentEvent event) {
        if (event == null) {
            System.err.println("VNCEvents.fireEvent(event==null)");
            return;
        }
        ((Component)event.getSource()).enableInputMethods(false);
        VNCEvents.getEventMap().put(event, ((RFBSocket)client).getInetAddress().getHostName());
        ((Component)event.getSource()).getToolkit().getSystemEventQueue().postEvent(event);
    }

    private void fireKeyEvent(RFBClient client, int id, int vk, char character, int keyModifiers, Component component) {
        KeyEvent ke = new KeyEvent(this.container, id, System.currentTimeMillis(), keyModifiers, vk, character, 0);
        this.fireEvent(client, ke);
    }

    private void fireMouseEvent(RFBClient client, Component component, int id, int x, int y, int clicks, int modifiers) {
        this.fireEvent(client, new MouseEvent(component, id, System.currentTimeMillis(), modifiers, x, y, clicks, false));
    }

    private void fireWheelEvent(RFBClient client, Component component, int id, int x, int y, int clicks, int modifiers, int rotation) {
        this.fireEvent(client, new MouseWheelEvent(component, id, System.currentTimeMillis(), modifiers, x, y, clicks, false, 0, 3, rotation));
    }

    private Point getLocation(Component component) {
        Point location = component.getLocation();
        if (component == this.container) {
            return location;
        }
        Container parent = component.getParent();
        if (parent != null) {
            Point parentLocation = parent.getLocationOnScreen();
            return new Point(location.x - parentLocation.x, location.y - parentLocation.y);
        }
        return location;
    }

    private Component getFocusComponent(Component component) {
        if (component.hasFocus()) {
            return component;
        }
        if (component instanceof Container) {
            Component[] components = ((Container)component).getComponents();
            Component focusComponent = null;
            int i = 0;
            while (i < components.length) {
                focusComponent = this.getFocusComponent(components[i]);
                if (focusComponent != null) {
                    return focusComponent;
                }
                ++i;
            }
        }
        return null;
    }

    private static class State {
        public int keyModifiers = 0;
        public int mouseModifiers = 0;
        public Component oldComponent = null;
        public int oldX;
        public int oldY;
        public boolean dragging = false;
        public long[] lastMouseClickTime = new long[5];

        private State() {
        }
    }
}

