/*
 * Decompiled with CFR 0.152.
 */
package dioscuri;

import dioscuri.CommandLineInterface;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.junit.Test;

public class TestCommandLineInterface {
    private static Logger logger = Logger.getLogger(TestCommandLineInterface.class.getName());

    private File createTempFile() {
        File file = new File(System.getProperty("java.io.tmpdir"), "tmp-dioscuri" + System.currentTimeMillis());
        try {
            file.createNewFile();
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            file = null;
        }
        return file;
    }

    private CommandLineInterface parseCommandLineInterface(String ... stringArray) throws Exception {
        logger.log(Level.INFO, " [test] trying to parse: " + Arrays.toString(stringArray));
        String[] stringArray2 = new String[stringArray.length + 2];
        stringArray2[0] = "-c";
        stringArray2[1] = "C:\\BK\\IntelliJ\\dioscuri_043_paths\\config\\DioscuriConfig.xml";
        System.arraycopy(stringArray, 0, stringArray2, 2, stringArray.length);
        return new CommandLineInterface(stringArray2);
    }

    private void testInValid(String ... stringArray) throws Exception {
        try {
            this.parseCommandLineInterface(stringArray);
        }
        catch (Exception exception) {
            return;
        }
        throw new RuntimeException("exception expected for input: " + Arrays.toString(stringArray));
    }

    private void testValid(String ... stringArray) throws Exception {
        this.parseCommandLineInterface(stringArray);
    }

    @Test
    public void testAllValid() throws Exception {
        Options options = this.parseCommandLineInterface((String[])new String[0]).commandLineOptions;
        this.testValid("");
        for (Object e : options.getOptions()) {
            Option option = (Option)e;
            if (option.hasArg()) continue;
            this.testValid("-" + option.getOpt());
            this.testValid("--" + option.getLongOpt());
        }
        this.testValid("-he");
        this.testValid("-h", "-e", "-s");
        File file = this.createTempFile();
        if (file != null) {
            this.testValid("-c", file.getAbsolutePath());
            this.testValid("-f", file.getAbsolutePath());
            this.testValid("-d", file.getAbsolutePath());
        }
        this.testValid("-b", "floppy");
        this.testValid("-b", "HARDdisk");
        this.testValid("-a", "16");
        this.testValid("-a", "32");
    }

    @Test
    public void testAllInvalid() throws Exception {
        this.testInValid("-b", "flopy");
        this.testInValid("-b", "hd");
        this.testInValid("-a", "-16");
        this.testInValid("-a", "166");
        this.testInValid("-a", "31");
        this.testInValid("-FOO", "--BAR");
        this.testInValid("-X");
    }
}

