/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.config;

import dioscuri.GUI;
import dioscuri.config.AbstractModulePanel;
import dioscuri.config.Emulator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class AtaPanel
extends AbstractModulePanel {
    final JTextField updateInterval = new JTextField(10);
    final JTabbedPane hds = new JTabbedPane();
    final Emulator.Architecture.Modules.Ata ata;
    final List<HD> hdList;

    AtaPanel(GUI gUI, Emulator emulator) {
        super(gUI, emulator);
        super.setLayout(new BorderLayout(5, 5));
        this.ata = emulator.getArchitecture().getModules().getAta();
        this.hdList = new ArrayList<HD>();
        this.updateInterval.setText(this.ata.getUpdateintervalmicrosecs().toString());
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.add(new JLabel("Update interval  "));
        jPanel.add(this.updateInterval);
        jPanel.add(new JLabel("microseconds"));
        for (int i = 1; i <= this.ata.getHarddiskdrive().size(); ++i) {
            HD hD = new HD(this.ata.getHarddiskdrive().get(i - 1));
            this.hds.add("hd" + i, hD);
            this.hdList.add(hD);
        }
        super.add((Component)jPanel, "North");
        super.add((Component)this.hds, "South");
    }

    @Override
    void save() throws Exception {
        this.ata.setUpdateintervalmicrosecs(new BigInteger(this.updateInterval.getText()));
        for (HD hD : this.hdList) {
            hD.save();
        }
    }

    class HD
    extends JPanel {
        final Emulator.Architecture.Modules.Ata.Harddiskdrive hd;
        final JCheckBox enabled = new JCheckBox();
        final JTextField channelIndex = new JTextField();
        final JCheckBox master = new JCheckBox();
        final JCheckBox autoDetect = new JCheckBox();
        final JTextField cylinders = new JTextField();
        final JTextField heads = new JTextField();
        final JTextField sectors = new JTextField();
        final JTextField imageFile = new JTextField();
        final JButton browse = new JButton("browse");

        HD(Emulator.Architecture.Modules.Ata.Harddiskdrive harddiskdrive) {
            this.hd = harddiskdrive;
            this.enabled.setSelected(harddiskdrive.isEnabled());
            this.channelIndex.setText(harddiskdrive.getChannelindex().toString());
            this.master.setSelected(harddiskdrive.isMaster());
            this.autoDetect.setSelected(harddiskdrive.isAutodetectcylinders());
            this.cylinders.setText(harddiskdrive.getCylinders().toString());
            this.heads.setText(harddiskdrive.getHeads().toString());
            this.sectors.setText(harddiskdrive.getSectorspertrack().toString());
            this.imageFile.setText(harddiskdrive.getImagefilepath());
            this.imageFile.setEditable(false);
            this.imageFile.setToolTipText(this.imageFile.getText());
            this.imageFile.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    HD.this.imageFile.setCaretPosition(HD.this.imageFile.getText().length());
                }
            });
            super.setLayout(new GridLayout(0, 3, 5, 5));
            super.add(new JLabel("Enabled"));
            super.add(this.enabled);
            super.add(new JLabel());
            super.add(new JLabel("Channel index"));
            super.add(this.channelIndex);
            super.add(new JLabel());
            super.add(new JLabel("Master"));
            super.add(this.master);
            super.add(new JLabel());
            super.add(new JLabel("Auto detect"));
            super.add(this.autoDetect);
            super.add(new JLabel());
            super.add(new JLabel("Cylinders"));
            super.add(this.cylinders);
            super.add(new JLabel());
            super.add(new JLabel("Heads"));
            super.add(this.heads);
            super.add(new JLabel());
            super.add(new JLabel("Sectors"));
            super.add(this.sectors);
            super.add(new JLabel());
            super.add(new JLabel("Image file"));
            super.add(this.imageFile);
            super.add(this.browse);
            this.browse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File file = AtaPanel.super.chooseFile();
                    if (file != null) {
                        HD.this.imageFile.setText(file.getAbsolutePath());
                        HD.this.imageFile.setToolTipText(HD.this.imageFile.getText());
                    }
                }
            });
        }

        void save() throws Exception {
            this.hd.setEnabled(this.enabled.isSelected());
            this.hd.setChannelindex(new BigInteger(this.channelIndex.getText()));
            this.hd.setMaster(this.master.isSelected());
            this.hd.setAutodetectcylinders(this.autoDetect.isSelected());
            this.hd.setCylinders(new BigInteger(this.cylinders.getText()));
            this.hd.setHeads(new BigInteger(this.heads.getText()));
            this.hd.setSectorspertrack(new BigInteger(this.sectors.getText()));
            this.hd.setImagefilepath(this.imageFile.getText().trim());
        }
    }
}

