/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_INC_BP
implements Instruction {
    private CPU cpu;
    private byte[] temp;
    private byte[] oldDest;
    private byte[] incWord;

    public Instruction_INC_BP() {
    }

    public Instruction_INC_BP(CPU cPU) {
        this.cpu = cPU;
        this.temp = new byte[2];
        this.oldDest = new byte[2];
        this.incWord = new byte[]{0, 1};
    }

    @Override
    public void execute() {
        System.arraycopy(this.cpu.bp, 0, this.oldDest, 0, this.cpu.bp.length);
        this.temp = Util.addWords(this.cpu.bp, this.incWord, 0);
        this.cpu.bp[0] = this.temp[0];
        this.cpu.bp[1] = this.temp[1];
        this.cpu.flags[4] = (this.oldDest[1] & 0xF) == 15;
        this.cpu.flags[11] = Util.test_OF_ADD(this.oldDest, this.incWord, this.cpu.bp, 0);
        this.cpu.flags[6] = this.cpu.bp[0] == 0 && this.cpu.bp[1] == 0;
        this.cpu.flags[7] = this.cpu.bp[0] < 0;
        this.cpu.flags[2] = Util.checkParityOfByte(this.cpu.bp[1]);
    }
}

