/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;

public class Instruction_XCHG_EbGb
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = false;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte[] sourceRegister = new byte[2];
    byte[] destinationRegister = new byte[2];
    byte sourceHighLow = 0;
    byte destinationHighLow = 0;
    byte tempValue = 0;

    public Instruction_XCHG_EbGb() {
    }

    public Instruction_XCHG_EbGb(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        this.sourceHighLow = (this.addressByte & 0x20) >> 5 == 0 ? (byte)1 : 0;
        this.sourceRegister = this.cpu.decodeRegister(this.operandWordSize, (this.addressByte & 0x38) >> 3);
        if ((this.addressByte & 0xC0) >> 6 == 3) {
            this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7);
            this.destinationHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
            this.tempValue = this.destinationRegister[this.destinationHighLow];
            this.destinationRegister[this.destinationHighLow] = this.sourceRegister[this.sourceHighLow];
            this.sourceRegister[this.sourceHighLow] = this.tempValue;
        } else {
            this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
            this.tempValue = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
            this.cpu.setByteInMemorySegment(this.addressByte, this.memoryReferenceLocation, this.sourceRegister[this.sourceHighLow]);
            this.sourceRegister[this.sourceHighLow] = this.tempValue;
        }
    }
}

