/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.fdc;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.StorageDeviceException;
import dioscuri.exception.UnknownPortException;
import dioscuri.exception.WriteOnlyPortException;
import dioscuri.interfaces.Module;
import dioscuri.module.ModuleATA;
import dioscuri.module.ModuleDMA;
import dioscuri.module.ModuleFDC;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.ModulePIC;
import dioscuri.module.ModuleRTC;
import dioscuri.module.cpu32.DMAController;
import dioscuri.module.cpu32.DMATransferCapable;
import dioscuri.module.cpu32.HardwareComponent;
import dioscuri.module.fdc.DMA8Handler;
import dioscuri.module.fdc.Drive;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FDC
extends ModuleFDC
implements DMATransferCapable {
    private static final Logger logger = Logger.getLogger(FDC.class.getName());
    private Emulator emu;
    private DMAController dma32;
    private int irqNumber;
    private boolean pendingIRQ;
    private int resetSenseInterrupt;
    public DMA8Handler dma8Handler;
    private boolean tc;
    private boolean dmaAndInterruptEnabled;
    private int updateInterval;
    private Drive[] drives;
    private int numberOfDrives;
    private int[] dataRates;
    private int dataRate;
    private boolean fdcEnabled;
    private boolean fdcEnabledPrevious;
    private int drive;
    private int formatCount;
    private byte formatFillbyte;
    protected byte[] floppyBuffer;
    private int floppyBufferIndex;
    private byte floppyBufferCurrentByte;
    private byte[] command;
    private int commandIndex;
    private int commandSize;
    private int commandPending;
    private boolean commandComplete;
    private byte[] result;
    private int resultIndex;
    private int resultSize;
    byte nonDMA;
    byte lock;
    byte srt;
    byte hut;
    byte hlt;
    byte config;
    byte preTrack;
    byte perpMode;
    private byte dor;
    private byte tdr;
    private byte msr;
    private int statusRegister0;
    private int statusRegister1;
    private int statusRegister2;
    private int statusRegister3;
    private static final int PORT_FLOPPY_STATUS_A = 1008;
    private static final int PORT_FLOPPY_STATUS_B = 1009;
    private static final int PORT_FLOPPY_DOR = 1010;
    private static final int PORT_FLOPPY_TAPEDRIVE = 1011;
    private static final int PORT_FLOPPY_MAIN_DATARATE = 1012;
    private static final int PORT_FLOPPY_CMD_DATA = 1013;
    private static final int PORT_FLOPPY_RESERVED_FIXED = 1014;
    private static final int PORT_FLOPPY_HD_CONTROLLER = 1015;
    private static final byte FLOPPY_DRIVETYPE_NONE = 0;
    private static final byte FLOPPY_DRIVETYPE_525DD = 1;
    private static final byte FLOPPY_DRIVETYPE_525HD = 2;
    private static final byte FLOPPY_DRIVETYPE_350DD = 3;
    private static final byte FLOPPY_DRIVETYPE_350HD = 4;
    private static final byte FLOPPY_DRIVETYPE_350ED = 5;
    private static final byte FLOPPY_DISKTYPE_NONE = 0;
    private static final byte FLOPPY_DISKTYPE_360K = 1;
    private static final byte FLOPPY_DISKTYPE_1_2 = 2;
    private static final byte FLOPPY_DISKTYPE_720K = 3;
    private static final byte FLOPPY_DISKTYPE_1_44 = 4;
    private static final byte FLOPPY_DISKTYPE_2_88 = 5;
    private static final byte FLOPPY_DISKTYPE_160K = 6;
    private static final byte FLOPPY_DISKTYPE_180K = 7;
    private static final byte FLOPPY_DISKTYPE_320K = 8;
    private static final int FDC_CMD_MRQ = 128;
    private static final int FDC_CMD_DIO = 64;
    private static final int FDC_CMD_NDMA = 32;
    private static final int FDC_CMD_BUSY = 16;
    private static final int FDC_CMD_ACTD = 8;
    private static final int FDC_CMD_ACTC = 4;
    private static final int FDC_CMD_ACTB = 2;
    private static final int FDC_CMD_ACTA = 1;
    private static final int FDC_DMA_CHANNEL = 2;

    public FDC(Emulator emulator) {
        this.emu = emulator;
        this.updateInterval = -1;
        this.irqNumber = -1;
        this.pendingIRQ = false;
        this.resetSenseInterrupt = 0;
        this.dma8Handler = null;
        this.dmaAndInterruptEnabled = false;
        this.drives = new Drive[1];
        this.drives[0] = new Drive();
        this.dataRates = new int[]{500, 300, 250, 1000};
        this.dataRate = 0;
        this.fdcEnabled = false;
        this.fdcEnabledPrevious = false;
        this.drive = 0;
        this.command = new byte[10];
        this.commandIndex = 0;
        this.commandSize = 0;
        this.commandPending = 0;
        this.commandComplete = false;
        this.formatCount = 0;
        this.formatFillbyte = 0;
        this.tc = false;
        this.floppyBuffer = new byte[514];
        this.floppyBufferIndex = 0;
        this.nonDMA = 0;
        this.lock = 0;
        this.srt = 0;
        this.hut = 0;
        this.hlt = 0;
        this.config = 0;
        this.preTrack = 0;
        this.perpMode = 0;
        this.result = new byte[10];
        this.resultIndex = 0;
        this.resultSize = 0;
        this.dor = 0;
        this.msr = (byte)64;
        this.tdr = 0;
        this.statusRegister0 = 0;
        this.statusRegister1 = 0;
        this.statusRegister2 = 0;
        this.statusRegister3 = 0;
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] " + this.getClass().getName() + " -> AbstractModule created successfully.");
    }

    @Override
    public boolean reset() {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModuleRTC moduleRTC = (ModuleRTC)super.getConnection(Module.Type.RTC);
        ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
        ModuleDMA moduleDMA = (ModuleDMA)super.getConnection(Module.Type.DMA);
        ModuleATA moduleATA = (ModuleATA)super.getConnection(Module.Type.ATA);
        moduleMotherboard.setIOPort(1008, this);
        moduleMotherboard.setIOPort(1009, this);
        moduleMotherboard.setIOPort(1010, this);
        moduleMotherboard.setIOPort(1011, this);
        moduleMotherboard.setIOPort(1012, this);
        moduleMotherboard.setIOPort(1013, this);
        moduleMotherboard.setIOPort(1014, this);
        moduleMotherboard.setIOPort(1015, this);
        this.irqNumber = modulePIC.requestIRQNumber(this);
        if (this.irqNumber > -1) {
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " IRQ number set to: " + this.irqNumber);
        } else {
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Request of IRQ number failed.");
        }
        if (moduleMotherboard.requestTimer(this, this.updateInterval, false)) {
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " Timer requested successfully.");
        } else {
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Failed to request a timer.");
        }
        if (!this.emu.isCpu32bit()) {
            this.dma8Handler = new DMA8Handler(this);
            if (moduleDMA.registerDMAChannel(2, this.dma8Handler)) {
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " DMA channel registered to line: " + 2);
            } else {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Failed to register DMA channel " + 2);
            }
        }
        moduleRTC.setCMOSRegister(20, (byte)(moduleRTC.getCMOSRegister(20) | 1));
        return this.reset(1);
    }

    private boolean reset(int n) {
        int n2;
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModuleRTC moduleRTC = (ModuleRTC)super.getConnection(Module.Type.RTC);
        ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
        ModuleDMA moduleDMA = (ModuleDMA)super.getConnection(Module.Type.DMA);
        ModuleATA moduleATA = (ModuleATA)super.getConnection(Module.Type.ATA);
        this.pendingIRQ = false;
        this.resetSenseInterrupt = 0;
        this.msr = (byte)64;
        this.statusRegister0 = 0;
        this.statusRegister1 = 0;
        this.statusRegister2 = 0;
        this.statusRegister3 = 0;
        if (n == 1) {
            this.dor = (byte)12;
            for (n2 = 0; n2 < this.drives.length; ++n2) {
                this.drives[n2].dir = (byte)(this.drives[n2].dir | 0x80);
            }
            this.dataRate = 2;
            this.lock = 0;
        } else {
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " FDC controller reset (software)");
        }
        if (this.lock == 0) {
            this.config = 0;
            this.preTrack = 0;
        }
        this.perpMode = 0;
        for (n2 = 0; n2 < this.drives.length; ++n2) {
            this.drives[n2].reset();
        }
        modulePIC.clearIRQ(this.irqNumber);
        if (!this.emu.isCpu32bit()) {
            moduleDMA.setDMARequest(2, false);
        }
        this.enterIdlePhase();
        if (n == 1) {
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " AbstractModule has been reset.");
        }
        return true;
    }

    @Override
    public void stop() {
        for (int i = 0; i < this.drives.length; ++i) {
            if (this.drives[i] == null || !this.drives[i].containsFloppy() || this.ejectCarrier(i)) continue;
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "] Drive " + i + ": eject floppy failed.");
        }
    }

    @Override
    public String getDump() {
        String string = "";
        String string2 = "\r\n";
        String string3 = "\t";
        string = "FDC dump:" + string2;
        string = string + "In total " + this.drives.length + " floppy drives exist:" + string2;
        for (int i = 0; i < this.drives.length; ++i) {
            string = this.drives[i] != null ? string + "Drive " + i + string3 + ":" + string3 + this.drives[i].toString() + string2 : string + "Drive " + i + string3 + ":" + string3 + "not enabled" + string2;
        }
        return string;
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void setUpdateInterval(int n) {
        this.updateInterval = n > 0 ? n : 1000;
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        moduleMotherboard.resetTimer(this, this.updateInterval);
    }

    @Override
    public void update() {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModuleDMA moduleDMA = (ModuleDMA)super.getConnection(Module.Type.DMA);
        if (this.commandPending != 0) {
            this.drive = this.dor & 3;
            switch (this.commandPending) {
                case 7: {
                    this.statusRegister0 = 0x20 | this.drive;
                    if (this.drives[this.drive].getDriveType() == 0 || !this.drives[this.drive].isMotorRunning()) {
                        this.statusRegister0 |= 0x50;
                    }
                    this.enterIdlePhase();
                    this.setInterrupt();
                    break;
                }
                case 15: {
                    this.statusRegister0 = 0x20 | this.drives[this.drive].hds << 2 | this.drive;
                    this.enterIdlePhase();
                    this.setInterrupt();
                    break;
                }
                case 74: {
                    this.enterResultPhase();
                    break;
                }
                case 69: 
                case 197: {
                    if (this.tc) {
                        this.statusRegister0 = this.drives[this.drive].hds << 2 | this.drive;
                        this.statusRegister1 = 0;
                        this.statusRegister2 = 0;
                        this.enterResultPhase();
                        break;
                    }
                    if (this.emu.isCpu32bit()) {
                        this.dma32.holdDREQ(2);
                        break;
                    }
                    moduleDMA.setDMARequest(2, true);
                    break;
                }
                case 70: 
                case 102: 
                case 198: 
                case 230: {
                    if (this.emu.isCpu32bit()) {
                        this.dma32.holdDREQ(2);
                        break;
                    }
                    moduleDMA.setDMARequest(2, true);
                    break;
                }
                case 77: {
                    if (this.formatCount == 0 || this.tc) {
                        this.formatCount = 0;
                        this.statusRegister0 = this.drives[this.drive].hds << 2 | this.drive;
                        this.enterResultPhase();
                        break;
                    }
                    if (this.emu.isCpu32bit()) {
                        this.dma32.holdDREQ(2);
                        break;
                    }
                    moduleDMA.setDMARequest(2, true);
                    break;
                }
                case 254: {
                    this.reset(0);
                    this.commandPending = 0;
                    this.statusRegister0 = 192;
                    this.setInterrupt();
                    this.resetSenseInterrupt = 4;
                    break;
                }
                default: {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: unknown command during update.");
                }
            }
        }
    }

    @Override
    public byte getIOPortByte(int n) throws ModuleException, UnknownPortException, WriteOnlyPortException {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModuleRTC moduleRTC = (ModuleRTC)super.getConnection(Module.Type.RTC);
        ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
        ModuleDMA moduleDMA = (ModuleDMA)super.getConnection(Module.Type.DMA);
        ModuleATA moduleATA = (ModuleATA)super.getConnection(Module.Type.ATA);
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " IN command (byte) to port " + Integer.toHexString(n).toUpperCase() + " received");
        int n2 = 0;
        block0 : switch (n) {
            case 1008: 
            case 1009: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Reading ports 0x3F0 and 0x3F1 not implemented");
                break;
            }
            case 1010: {
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " Is reading allowed of port 0x3F2? Returned DOR");
                n2 = this.dor;
                break;
            }
            case 1011: {
                int n3 = this.dor & 3;
                if (this.drives[n3].containsFloppy()) {
                    switch (this.drives[n3].getFloppyType()) {
                        case 1: 
                        case 2: 
                        case 6: 
                        case 7: 
                        case 8: {
                            n2 = 0;
                            break block0;
                        }
                        case 3: {
                            n2 = -64;
                            break block0;
                        }
                        case 4: {
                            n2 = -128;
                            break block0;
                        }
                        case 5: {
                            n2 = 64;
                            break block0;
                        }
                    }
                    n2 = 32;
                    break;
                }
                n2 = 32;
                break;
            }
            case 1012: {
                n2 = this.msr;
                break;
            }
            case 1013: {
                if (this.resultSize == 0) {
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Port 0x3F5: no results to read");
                    this.msr = (byte)64;
                    n2 = this.result[0];
                    break;
                }
                n2 = this.result[this.resultIndex];
                ++this.resultIndex;
                this.msr = (byte)(this.msr & 0xF0);
                this.clearInterrupt();
                if (this.resultIndex < this.resultSize) break;
                this.enterIdlePhase();
                break;
            }
            case 1014: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " IN (byte) to port " + Integer.toHexString(n).toUpperCase() + ": reserved port.");
                n2 = moduleATA.getIOPortByte(n);
                break;
            }
            case 1015: {
                n2 = moduleATA.getIOPortByte(n);
                n2 = (byte)(n2 & 0x7F);
                int n4 = this.dor & 3;
                if ((this.dor & 1 << n4 + 4) != 1) break;
                if (this.drives[n4] != null) {
                    n2 = (byte)(n2 | this.drives[n4].dir & 0x80);
                    break;
                }
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Non-existing drive requested at port " + Integer.toHexString(n).toUpperCase());
                break;
            }
            default: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Unknown port address encountered: " + Integer.toHexString(n).toUpperCase());
            }
        }
        return (byte)n2;
    }

    @Override
    public void setIOPortByte(int n, byte by) throws ModuleException, UnknownPortException {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModuleRTC moduleRTC = (ModuleRTC)super.getConnection(Module.Type.RTC);
        ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
        ModuleDMA moduleDMA = (ModuleDMA)super.getConnection(Module.Type.DMA);
        ModuleATA moduleATA = (ModuleATA)super.getConnection(Module.Type.ATA);
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " OUT (byte) to port " + Integer.toHexString(n).toUpperCase() + ": 0x" + Integer.toHexString(by & 0xFF).toUpperCase());
        switch (n) {
            case 1008: 
            case 1009: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Port address is read only and cannot be written to: " + Integer.toHexString(n).toUpperCase());
                break;
            }
            case 1010: {
                for (int i = 0; i < this.drives.length; ++i) {
                    if (this.drives[i] != null) {
                        switch (i) {
                            case 0: {
                                this.drives[0].setMotor((by & 0x10) > 0);
                                break;
                            }
                            case 1: {
                                this.drives[1].setMotor((by & 0x20) > 0);
                                break;
                            }
                            case 2: {
                                this.drives[2].setMotor((by & 0x40) > 0);
                                break;
                            }
                            case 3: {
                                this.drives[3].setMotor((by & 0x80) > 0);
                                break;
                            }
                            default: {
                                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Unknown drive selected at port " + Integer.toHexString(n).toUpperCase());
                                break;
                            }
                        }
                        continue;
                    }
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Non-existing drive selected at port " + Integer.toHexString(n).toUpperCase());
                }
                this.dmaAndInterruptEnabled = (by & 8) > 0;
                this.fdcEnabled = (by & 4) > 0;
                this.drive = by & 3;
                this.fdcEnabledPrevious = (this.dor & 4) > 0;
                this.dor = by;
                if (!this.fdcEnabledPrevious && this.fdcEnabled) {
                    moduleMotherboard.resetTimer(this, this.updateInterval);
                    moduleMotherboard.setTimerActiveState(this, true);
                } else if (this.fdcEnabledPrevious && !this.fdcEnabled) {
                    this.msr = (byte)64;
                    this.commandPending = 254;
                }
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " OUT (byte) to port " + Integer.toHexString(n).toUpperCase() + ", DMA/IRQ=" + this.dmaAndInterruptEnabled + ", FDC=" + this.fdcEnabled + ", drive=" + this.drive + ", motorRunning=" + this.drives[this.drive].isMotorRunning());
                break;
            }
            case 1012: {
                this.dataRate = by & 3;
                if ((by & 0x80) > 0) {
                    this.msr = (byte)64;
                    this.commandPending = 254;
                    moduleMotherboard.resetTimer(this, this.updateInterval);
                    moduleMotherboard.setTimerActiveState(this, true);
                }
                if ((by & 0x7C) <= 0) break;
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " OUT (byte) to port " + Integer.toHexString(n).toUpperCase() + ": drive is busy, but in non-DMA mode which is not supported.");
                break;
            }
            case 1013: {
                if (this.commandComplete) {
                    if (this.commandPending != 0) {
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " new command received while old command is still pending.");
                    }
                    this.command[0] = by;
                    this.commandComplete = false;
                    this.commandIndex = 1;
                    this.msr = (byte)(this.msr & 0xF);
                    this.msr = (byte)(this.msr | 0x90);
                    int n2 = by & 0xFF;
                    switch (n2) {
                        case 3: {
                            this.commandSize = 3;
                            break;
                        }
                        case 4: {
                            this.commandSize = 2;
                            break;
                        }
                        case 7: {
                            this.commandSize = 2;
                            break;
                        }
                        case 8: {
                            this.commandSize = 1;
                            break;
                        }
                        case 15: {
                            this.commandSize = 3;
                            break;
                        }
                        case 74: {
                            this.commandSize = 2;
                            break;
                        }
                        case 77: {
                            this.commandSize = 10;
                            break;
                        }
                        case 69: 
                        case 197: {
                            this.commandSize = 9;
                            break;
                        }
                        case 70: 
                        case 102: 
                        case 198: 
                        case 230: {
                            this.commandSize = 9;
                            break;
                        }
                        case 14: 
                        case 16: 
                        case 20: 
                        case 148: {
                            this.commandSize = 0;
                            this.commandPending = n2;
                            this.enterResultPhase();
                            break;
                        }
                        case 18: {
                            this.commandSize = 2;
                            break;
                        }
                        case 19: {
                            this.commandSize = 4;
                            break;
                        }
                        case 24: {
                            this.commandSize = 0;
                            this.statusRegister0 = 128;
                            this.enterResultPhase();
                            break;
                        }
                        case 143: 
                        case 207: {
                            this.commandSize = 3;
                            break;
                        }
                        default: {
                            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " OUT (byte) to port " + Integer.toHexString(n).toUpperCase() + ": invalid FDC command.");
                            this.commandSize = 0;
                            this.statusRegister0 = 128;
                            this.enterResultPhase();
                            break;
                        }
                    }
                } else {
                    this.command[this.commandIndex++] = by;
                }
                if (this.commandIndex != this.commandSize) break;
                this.executeCommand();
                this.commandComplete = true;
                break;
            }
            case 1014: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " OUT (byte) to port " + Integer.toHexString(n).toUpperCase() + ": reserved port.");
                moduleATA.setIOPortByte(n, by);
                break;
            }
            case 1015: {
                this.dataRate = by & 3;
                switch (this.dataRate) {
                    case 0: {
                        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Datarate is set to 500 Kbps");
                        break;
                    }
                    case 1: {
                        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Datarate is set to 300 Kbps");
                        break;
                    }
                    case 2: {
                        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Datarate is set to 250 Kbps");
                        break;
                    }
                    case 3: {
                        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Datarate is set to 1 Mbps");
                    }
                }
                break;
            }
            default: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Unknown port address encountered: " + Integer.toHexString(n).toUpperCase());
            }
        }
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException, WriteOnlyPortException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " IN command (word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Returned default value 0xFFFF");
        return new byte[]{-1, -1};
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " OUT command (word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException, WriteOnlyPortException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " IN command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Returned default value 0xFFFFFFFF");
        return new byte[]{-1, -1, -1, -1};
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " OUT command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    protected void setInterrupt() {
        ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
        modulePIC.setIRQ(this.irqNumber);
        this.pendingIRQ = true;
        this.resetSenseInterrupt = 0;
    }

    protected void clearInterrupt() {
        if (this.pendingIRQ) {
            ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
            modulePIC.clearIRQ(this.irqNumber);
            this.pendingIRQ = false;
        }
    }

    @Override
    public boolean setNumberOfDrives(int n) {
        ModuleRTC moduleRTC = (ModuleRTC)super.getConnection(Module.Type.RTC);
        if (n > 0 && n <= 4) {
            this.numberOfDrives = n;
            this.drives = new Drive[this.numberOfDrives];
            for (int i = 0; i < this.drives.length; ++i) {
                this.drives[i] = new Drive();
            }
            if (this.numberOfDrives == 1) {
                moduleRTC.setCMOSRegister(20, (byte)(moduleRTC.getCMOSRegister(20) & 0x3F | 0));
            } else if (this.numberOfDrives == 2) {
                moduleRTC.setCMOSRegister(20, (byte)(moduleRTC.getCMOSRegister(20) & 0x3F | 0x40));
            } else if (this.numberOfDrives == 3) {
                moduleRTC.setCMOSRegister(20, (byte)(moduleRTC.getCMOSRegister(20) & 0x3F | 0x80));
            } else if (this.numberOfDrives == 4) {
                moduleRTC.setCMOSRegister(20, (byte)(moduleRTC.getCMOSRegister(20) & 0x3F | 0xC0));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean insertCarrier(String string, byte by, File file, boolean bl) {
        int n = -1;
        if (string.equalsIgnoreCase("A")) {
            n = 0;
        } else if (string.equalsIgnoreCase("B")) {
            n = 1;
        }
        return this.insertCarrier(n, by, file, bl);
    }

    @Override
    public boolean ejectCarrier(String string) {
        int n = -1;
        if (string.equalsIgnoreCase("A")) {
            n = 0;
        } else if (string.equalsIgnoreCase("B")) {
            n = 1;
        }
        return this.ejectCarrier(n);
    }

    @Override
    public boolean insertCarrier(int n, byte by, File file, boolean bl) {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModuleRTC moduleRTC = (ModuleRTC)super.getConnection(Module.Type.RTC);
        ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
        ModuleDMA moduleDMA = (ModuleDMA)super.getConnection(Module.Type.DMA);
        ModuleATA moduleATA = (ModuleATA)super.getConnection(Module.Type.ATA);
        if (n == 0) {
            String string = "A";
            if (this.drives.length > 0 && !this.drives[n].containsFloppy()) {
                switch (by) {
                    case 0: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF | 0));
                        this.drives[n].setDriveType((byte)0);
                        break;
                    }
                    case 1: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF | 0x10));
                        this.drives[n].setDriveType((byte)1);
                        break;
                    }
                    case 2: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF | 0x20));
                        this.drives[n].setDriveType((byte)2);
                        break;
                    }
                    case 3: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF | 0x30));
                        this.drives[n].setDriveType((byte)3);
                        break;
                    }
                    case 4: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF | 0x40));
                        this.drives[n].setDriveType((byte)4);
                        break;
                    }
                    case 5: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF | 0x50));
                        this.drives[n].setDriveType((byte)5);
                        break;
                    }
                    case 6: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF | 0x60));
                        this.drives[n].setDriveType((byte)1);
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Drive " + string + " set to reserved CMOS floppy drive type 6");
                        break;
                    }
                    case 7: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF | 0x70));
                        this.drives[n].setDriveType((byte)1);
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Drive " + string + " set to reserved CMOS floppy drive type 7");
                        break;
                    }
                    case 8: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF | 0x80));
                        this.drives[n].setDriveType((byte)1);
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Drive " + string + " set to reserved CMOS floppy drive type 8");
                        break;
                    }
                    default: {
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Unsupported floppy drive type.");
                    }
                }
                try {
                    this.drives[n].insertFloppy(by, file, bl);
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Floppy \"" + file.getName() + "\" is inserted in drive " + n);
                    return true;
                }
                catch (StorageDeviceException storageDeviceException) {
                    logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " Error: " + storageDeviceException.getMessage());
                }
            } else {
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " Drive " + string + " does not exist or already contains a floppy. Eject floppy first!");
            }
        } else if (n == 1) {
            String string = "B";
            if (this.drives.length > 1 && !this.drives[n].containsFloppy()) {
                switch (by) {
                    case 0: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF0 | 0));
                        this.drives[n].setDriveType((byte)0);
                        break;
                    }
                    case 1: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF0 | 1));
                        this.drives[n].setDriveType((byte)1);
                        break;
                    }
                    case 2: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF0 | 2));
                        this.drives[n].setDriveType((byte)2);
                        break;
                    }
                    case 3: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF0 | 3));
                        this.drives[n].setDriveType((byte)3);
                        break;
                    }
                    case 4: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF0 | 4));
                        this.drives[n].setDriveType((byte)4);
                        break;
                    }
                    case 5: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF0 | 5));
                        this.drives[n].setDriveType((byte)5);
                        break;
                    }
                    case 6: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF0 | 6));
                        this.drives[n].setDriveType((byte)1);
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Drive " + string + " set to reserved CMOS floppy drive type 6");
                        break;
                    }
                    case 7: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF0 | 7));
                        this.drives[n].setDriveType((byte)1);
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Drive " + string + " set to reserved CMOS floppy drive type 7");
                        break;
                    }
                    case 8: {
                        moduleRTC.setCMOSRegister(16, (byte)(moduleRTC.getCMOSRegister(16) & 0xF0 | 8));
                        this.drives[n].setDriveType((byte)1);
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Drive " + string + " set to reserved CMOS floppy drive type 8");
                        break;
                    }
                    default: {
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Unsupported floppy drive type.");
                    }
                }
                try {
                    this.drives[n].insertFloppy(by, file, bl);
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Floppy \"" + file.getName() + "\" is inserted in drive " + n);
                    return true;
                }
                catch (StorageDeviceException storageDeviceException) {
                    logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " Error: " + storageDeviceException.getMessage());
                }
            } else {
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " Drive " + string + " does not exist or already contains a floppy. Eject floppy first!");
            }
        } else {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " Can not insert floppy because additional drives are not implemented.");
        }
        return false;
    }

    @Override
    public boolean ejectCarrier(int n) {
        try {
            if (n != -1) {
                boolean bl = this.drives[n].writeProtected;
                this.drives[n].ejectFloppy();
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Floppy is ejected from drive " + this.drive + ".");
                if (!bl) {
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Floppy data is stored to image file.");
                }
                return true;
            }
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " Can not eject floppy because drive is not recognized.");
        }
        catch (StorageDeviceException storageDeviceException) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + storageDeviceException.getMessage());
            return false;
        }
        return false;
    }

    private void executeCommand() {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModuleDMA moduleDMA = (ModuleDMA)super.getConnection(Module.Type.DMA);
        this.commandPending = this.command[0] & 0xFF;
        switch (this.commandPending) {
            case 3: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " CMD: specify");
                this.srt = (byte)(this.command[1] >> 4 & 0xF);
                this.hut = (byte)(this.command[1] & 0xF);
                this.hlt = (byte)(this.command[2] >> 1 & 0x7F);
                this.nonDMA = (byte)(this.command[2] & 1);
                this.enterIdlePhase();
                break;
            }
            case 4: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " CMD: sense drive status");
                int n = this.command[1] & 3;
                this.drives[n].hds = this.command[1] >> 2 & 1;
                this.statusRegister3 = (byte)(0x28 | this.drives[n].hds << 2 | n);
                this.statusRegister3 |= this.drives[n].writeProtected ? 64 : 0;
                if (this.drives[n].cylinder == 0) {
                    this.statusRegister3 |= 0x10;
                }
                this.enterResultPhase();
                break;
            }
            case 69: 
            case 70: 
            case 102: 
            case 197: 
            case 198: 
            case 230: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " CMD: Read/write data");
                this.emu.statusChanged(0);
                if ((this.dor & 8) == 0) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: read/write normal data -> DMA is disabled");
                }
                int n = this.command[1] & 3;
                this.dor = (byte)(this.dor & 0xFC);
                this.dor = (byte)(this.dor | n);
                this.drives[n].multiTrack = (this.command[0] >> 7 & 1) == 1;
                int n2 = this.command[2];
                int n3 = this.command[3] & 1;
                int n4 = this.command[4];
                byte by = this.command[5];
                int n5 = this.command[6];
                byte by2 = this.command[8];
                boolean bl = true;
                if (!this.drives[n].isMotorRunning()) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: read/write normal data -> drive motor of drive " + n + " is not running.");
                    this.msr = (byte)16;
                    bl = false;
                }
                if (this.drives[n].getDriveType() == 0) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: read/write normal data -> incorrect drive type if drive " + n + ".");
                    this.msr = (byte)16;
                    bl = false;
                }
                if (n3 != (this.command[1] >> 2 & 1)) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] head number in command[1] doesn't match head field");
                    bl = false;
                    this.statusRegister0 = 0x40 | this.drives[n].hds << 2 | n;
                    this.statusRegister1 = 4;
                    this.statusRegister2 = 0;
                    this.enterResultPhase();
                }
                if (!this.drives[n].containsFloppy()) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: read/write normal data -> floppy is not inserted in drive " + n + ".");
                    this.msr = (byte)16;
                    bl = false;
                }
                if (by != 2) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: read/write normal data -> sector size (bytes per sector) not supported.");
                    bl = false;
                }
                if (n2 >= this.drives[n].tracks) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: read/write normal data -> cylinder number exceeds maximum number of tracks.");
                    bl = false;
                }
                if (n4 > this.drives[n].sectorsPerTrack) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: read/write normal data -> sector number (" + n4 + ") exceeds sectors per track (" + this.drives[n].sectorsPerTrack + ").");
                    this.drives[n].cylinder = n2;
                    this.drives[n].hds = n3;
                    this.drives[n].sector = n4;
                    this.statusRegister0 = 0x40 | this.drives[n].hds << 2 | n;
                    this.statusRegister1 = 4;
                    this.statusRegister2 = 0;
                    this.enterResultPhase();
                    return;
                }
                if (n2 != this.drives[n].cylinder) {
                    logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " CMD: read/write normal data -> requested cylinder differs from selected cylinder on drive. Will proceed.");
                    this.drives[n].resetChangeline();
                }
                int n6 = n2 * this.drives[n].heads * this.drives[n].sectorsPerTrack + n3 * this.drives[n].sectorsPerTrack + (n4 - 1);
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " Logical sectors calculated: " + n6);
                if (n6 >= this.drives[n].sectors) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: read/write normal data -> logical sectors exceeds total number of sectors on disk.");
                    bl = false;
                }
                if (bl) {
                    if (n5 == 0) {
                        n5 = this.drives[n].sectorsPerTrack;
                    }
                    this.drives[n].cylinder = n2;
                    this.drives[n].hds = n3;
                    this.drives[n].sector = n4;
                    this.drives[n].eot = n5;
                    if ((this.command[0] & 0x4F) == 70) {
                        try {
                            this.drives[n].readData(n6 * 512, 512, this.floppyBuffer);
                        }
                        catch (StorageDeviceException storageDeviceException) {
                            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " " + storageDeviceException.getMessage());
                        }
                        this.msr = (byte)16;
                        this.msr = (byte)(this.msr | 0x40);
                        int n7 = 200000 / this.drives[n].sectorsPerTrack;
                        moduleMotherboard.resetTimer(this, n7);
                        moduleMotherboard.setTimerActiveState(this, true);
                        break;
                    }
                    if ((this.command[0] & 0x7F) == 69) {
                        this.msr = (byte)16;
                        this.msr = (byte)(this.msr & 0xFFFFFFBF);
                        if (this.emu.isCpu32bit()) {
                            this.dma32.holdDREQ(2);
                            break;
                        }
                        moduleDMA.setDMARequest(2, true);
                        break;
                    }
                    this.msr = (byte)(this.msr | 0x40);
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: unknown read/write command");
                    break;
                }
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " CMD: not able to transfer data");
                break;
            }
            case 7: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " CMD: recalibrate drive");
                int n = this.command[1] & 3;
                this.dor = (byte)(this.dor & 0xFC);
                this.dor = (byte)(this.dor | n);
                moduleMotherboard.resetTimer(this, this.calculateStepDelay(n, 0));
                moduleMotherboard.setTimerActiveState(this, true);
                this.drives[n].cylinder = 0;
                this.msr = (byte)(1 << n);
                break;
            }
            case 8: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " CMD: sense interrupt status");
                if (this.resetSenseInterrupt > 0) {
                    int n = 4 - this.resetSenseInterrupt;
                    this.statusRegister0 &= 0xF8;
                    this.statusRegister0 |= this.drives[n].hds << 2 | n;
                    --this.resetSenseInterrupt;
                } else if (!this.pendingIRQ) {
                    this.statusRegister0 = 128;
                }
                this.enterResultPhase();
                break;
            }
            case 74: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " CMD: read ID");
                int n = this.command[1] & 3;
                this.drives[n].hds = this.command[1] >> 2 & 1;
                this.dor = (byte)(this.dor & 0xFC);
                this.dor = (byte)(this.dor | n);
                if (this.drives[n].isMotorRunning()) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: read ID -> drive motor is not running.");
                    this.msr = (byte)16;
                    return;
                }
                if (this.drives[n].getDriveType() == 0) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: read ID -> incorrect drive type.");
                    this.msr = (byte)16;
                    return;
                }
                if (!this.drives[n].containsFloppy()) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: read ID -> floppy is not inserted.");
                    this.msr = (byte)16;
                    return;
                }
                this.statusRegister0 = this.drives[n].hds << 2 | n;
                int n8 = 200000 / this.drives[n].sectorsPerTrack;
                moduleMotherboard.resetTimer(this, n8);
                moduleMotherboard.setTimerActiveState(this, true);
                this.msr = (byte)16;
                this.enterResultPhase();
                break;
            }
            case 77: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " CMD: format track");
                int n = this.command[1] & 3;
                this.dor = (byte)(this.dor & 0xFC);
                this.dor = (byte)(this.dor | n);
                if (this.drives[n].isMotorRunning()) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: format track -> drive motor is not running.");
                    this.msr = (byte)16;
                    return;
                }
                this.drives[n].hds = this.command[1] >> 2 & 1;
                if (this.drives[n].getDriveType() == 0) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: format track -> incorrect drive type.");
                    this.msr = (byte)16;
                    return;
                }
                if (!this.drives[n].containsFloppy()) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: format track -> floppy is not inserted.");
                    this.msr = (byte)16;
                    return;
                }
                byte by = this.command[2];
                this.formatCount = this.command[3];
                this.formatFillbyte = this.command[5];
                if (by != 2) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: format track -> sector size (bytes per sector) not supported.");
                }
                if (this.formatCount != this.drives[n].sectorsPerTrack) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: format track -> wrong number of sectors per track encountered.");
                }
                if (this.drives[n].writeProtected) {
                    logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " CMD: format track -> floppy is write protected.");
                    this.statusRegister0 = 0x40 | this.drives[n].hds << 2 | n;
                    this.statusRegister1 = 39;
                    this.statusRegister2 = 49;
                    this.enterResultPhase();
                    return;
                }
                this.formatCount *= 4;
                if (this.emu.isCpu32bit()) {
                    this.dma32.holdDREQ(2);
                } else {
                    moduleDMA.setDMARequest(2, true);
                }
                this.msr = (byte)16;
                break;
            }
            case 15: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " CMD: seek");
                int n = this.command[1] & 3;
                this.dor = (byte)(this.dor & 0xFC);
                this.dor = (byte)(this.dor | n);
                this.drives[n].hds = this.command[1] >> 2 & 1;
                moduleMotherboard.resetTimer(this, this.calculateStepDelay(n, this.command[2]));
                moduleMotherboard.setTimerActiveState(this, true);
                this.drives[n].cylinder = this.command[2];
                this.msr = (byte)(1 << n);
                break;
            }
            case 14: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " CMD: dump registers (EHD)");
                this.enterResultPhase();
                break;
            }
            case 18: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " CMD: perpendicular mode (EHD)");
                this.perpMode = this.command[1];
                this.enterIdlePhase();
                break;
            }
            case 19: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " CMD: configure (EHD)");
                this.config = this.command[2];
                this.preTrack = this.command[3];
                this.enterIdlePhase();
                break;
            }
            default: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " Unsupported FDC command 0x" + this.command[0]);
            }
        }
    }

    private void enterResultPhase() {
        int n = this.dor & 3;
        this.resultIndex = 0;
        this.msr = (byte)(this.msr & 0xF);
        this.msr = (byte)(this.msr | 0xD0);
        if ((this.statusRegister0 & 0xC0) == 128) {
            this.resultSize = 1;
            this.result[0] = (byte)this.statusRegister0;
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " result phase: invalid command.");
            return;
        }
        switch (this.commandPending) {
            case 4: {
                this.resultSize = 1;
                this.result[0] = (byte)this.statusRegister3;
                break;
            }
            case 8: {
                this.resultSize = 2;
                this.result[0] = (byte)this.statusRegister0;
                this.result[1] = (byte)this.drives[n].cylinder;
                break;
            }
            case 69: 
            case 70: 
            case 74: 
            case 77: 
            case 102: 
            case 197: 
            case 198: 
            case 230: {
                this.resultSize = 7;
                this.result[0] = (byte)this.statusRegister0;
                this.result[1] = (byte)this.statusRegister1;
                this.result[2] = (byte)this.statusRegister2;
                this.result[3] = (byte)this.drives[n].cylinder;
                this.result[4] = (byte)this.drives[n].hds;
                this.result[5] = (byte)this.drives[n].sector;
                this.result[6] = 2;
                this.setInterrupt();
                break;
            }
            case 14: {
                this.resultSize = 10;
                for (int i = 0; i < 2; ++i) {
                    this.result[i] = (byte)this.drives[i].cylinders;
                }
                this.result[2] = 0;
                this.result[3] = 0;
                this.result[4] = (byte)(this.srt << 4 & 0xF0 | this.hut);
                this.result[5] = (byte)(this.hlt << 1 & 0xFE | this.nonDMA);
                this.result[6] = (byte)this.drives[n].eot;
                this.result[7] = (byte)(this.lock << 7 | this.perpMode & 0x7F);
                this.result[8] = this.config;
                this.result[9] = this.preTrack;
                break;
            }
            case 16: {
                this.resultSize = 1;
                this.result[0] = -112;
                break;
            }
            case 20: 
            case 148: {
                this.lock = (byte)(this.commandPending >> 7);
                this.resultSize = 1;
                this.result[0] = (byte)(this.lock << 4);
                break;
            }
            default: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " CMD: no command match");
            }
        }
        this.emu.statusChanged(1);
    }

    private void enterIdlePhase() {
        this.msr = (byte)(this.msr & 0xF);
        this.msr = (byte)(this.msr | 0x80);
        this.commandComplete = true;
        this.commandIndex = 0;
        this.commandSize = 0;
        this.commandPending = 0;
        this.floppyBufferIndex = 0;
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " idle phase finished");
    }

    protected byte getDMAByte() {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModuleRTC moduleRTC = (ModuleRTC)super.getConnection(Module.Type.RTC);
        ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
        ModuleDMA moduleDMA = (ModuleDMA)super.getConnection(Module.Type.DMA);
        ModuleATA moduleATA = (ModuleATA)super.getConnection(Module.Type.ATA);
        this.floppyBufferCurrentByte = this.floppyBuffer[this.floppyBufferIndex];
        ++this.floppyBufferIndex;
        this.tc = moduleDMA.isTerminalCountReached();
        if (this.floppyBufferIndex >= 512 || this.tc) {
            int n = this.dor & 3;
            if (this.floppyBufferIndex >= 512) {
                this.drives[n].incrementSector();
                this.floppyBufferIndex = 0;
            }
            if (this.tc) {
                this.statusRegister0 = this.drives[n].hds << 2 | n;
                this.statusRegister1 = 0;
                this.statusRegister2 = 0;
                moduleDMA.setDMARequest(2, false);
                this.enterResultPhase();
            } else {
                int n2 = this.drives[n].cylinder * this.drives[n].heads * this.drives[n].sectorsPerTrack + this.drives[n].hds * this.drives[n].sectorsPerTrack + (this.drives[n].sector - 1);
                try {
                    this.drives[n].readData(n2 * 512, 512, this.floppyBuffer);
                }
                catch (StorageDeviceException storageDeviceException) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " " + storageDeviceException.getMessage());
                }
                moduleDMA.setDMARequest(2, false);
                int n3 = 200000 / this.drives[n].sectorsPerTrack;
                logger.log(Level.CONFIG, moduleMotherboard.getCurrentInstructionNumber() + " " + "[" + (Object)((Object)super.getType()) + "]" + " Activating floppy time to sector time of " + n3 + "(" + n3 * 5 + ")");
                moduleMotherboard.resetTimer(this, n3);
                moduleMotherboard.setTimerActiveState(this, true);
            }
        }
        return this.floppyBufferCurrentByte;
    }

    protected void setDMAByte(byte by) {
        block16: {
            int n;
            ModuleDMA moduleDMA;
            ModuleMotherboard moduleMotherboard;
            block15: {
                moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
                ModuleRTC moduleRTC = (ModuleRTC)super.getConnection(Module.Type.RTC);
                ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
                moduleDMA = (ModuleDMA)super.getConnection(Module.Type.DMA);
                ModuleATA moduleATA = (ModuleATA)super.getConnection(Module.Type.ATA);
                this.tc = moduleDMA.isTerminalCountReached();
                n = this.dor & 3;
                if (this.commandPending != 77) break block15;
                --this.formatCount;
                switch (3 - (this.formatCount & 3)) {
                    case 0: {
                        this.drives[n].cylinder = by;
                        break;
                    }
                    case 1: {
                        if (by != this.drives[n].hds) {
                            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " DMA transfer formatting track: head number does not match head field.");
                            break;
                        }
                        break block16;
                    }
                    case 2: {
                        this.drives[n].sector = by;
                        break;
                    }
                    case 3: {
                        if (by != 2) {
                            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " DMA transfer formatting track: sector size is not supported.");
                            break;
                        }
                        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " DMA transfer formatting track: cyl=" + this.drives[n].cylinder + ", head=" + this.drives[n].hds + ", sector=" + this.drives[n].sector);
                        for (int i = 0; i < 512; ++i) {
                            this.floppyBuffer[i] = this.formatFillbyte;
                        }
                        int n2 = this.drives[n].cylinder * this.drives[n].heads * this.drives[n].sectorsPerTrack + this.drives[n].hds * this.drives[n].sectorsPerTrack + (this.drives[n].sector - 1);
                        try {
                            this.drives[n].writeData(n2 * 512, 512, this.floppyBuffer);
                        }
                        catch (StorageDeviceException storageDeviceException) {
                            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " " + storageDeviceException.getMessage());
                        }
                        moduleDMA.setDMARequest(2, false);
                        int n3 = 200000 / this.drives[n].sectorsPerTrack;
                        moduleMotherboard.resetTimer(this, n3);
                        moduleMotherboard.setTimerActiveState(this, true);
                        break;
                    }
                    default: {
                        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " DMA transfer formatting track failed.");
                        break;
                    }
                }
                break block16;
            }
            this.floppyBuffer[this.floppyBufferIndex++] = by;
            if (this.floppyBufferIndex >= 512 || this.tc) {
                int n4 = this.drives[n].cylinder * this.drives[n].heads * this.drives[n].sectorsPerTrack + this.drives[n].hds * this.drives[n].sectorsPerTrack + (this.drives[n].sector - 1);
                if (this.drives[n].writeProtected) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " DMA transfer to floppy failed: floppy is write protected.");
                    this.statusRegister0 = 0x40 | this.drives[n].hds << 2 | n;
                    this.statusRegister1 = 39;
                    this.statusRegister2 = 49;
                    this.enterResultPhase();
                    return;
                }
                try {
                    this.drives[n].writeData(n4 * 512, 512, this.floppyBuffer);
                    this.drives[n].incrementSector();
                    this.floppyBufferIndex = 0;
                }
                catch (StorageDeviceException storageDeviceException) {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " " + storageDeviceException.getMessage());
                }
                moduleDMA.setDMARequest(2, false);
                int n5 = 200000 / this.drives[n].sectorsPerTrack;
                moduleMotherboard.resetTimer(this, n5);
                moduleMotherboard.setTimerActiveState(this, true);
            }
        }
    }

    protected int calculateStepDelay(int n, int n2) {
        int n3;
        if (n2 == this.drives[n].cylinder) {
            n3 = 1;
        } else {
            n3 = Math.abs(n2 - this.drives[n].cylinder);
            this.drives[n].resetChangeline();
        }
        int n4 = ((this.srt ^ 0xF) + 1) * 500000 / this.dataRates[this.dataRate];
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " Calculated step delay: " + n3 * n4);
        return n3 * n4;
    }

    private boolean unregisterDevices() {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModuleRTC moduleRTC = (ModuleRTC)super.getConnection(Module.Type.RTC);
        ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
        ModuleDMA moduleDMA = (ModuleDMA)super.getConnection(Module.Type.DMA);
        ModuleATA moduleATA = (ModuleATA)super.getConnection(Module.Type.ATA);
        boolean bl = false;
        modulePIC.clearIRQ(this.irqNumber);
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " IRQ unregister result: " + bl);
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " Timer unregister result: " + bl);
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " DMA unregister result: " + bl);
        return bl;
    }

    @Override
    public int transferHandler(int n, int n2, int n3) {
        int n4;
        int n5 = Math.min(n3, 512);
        if (this.drives[this.drive] == null) {
            logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "]" + " no floppy in DMA transfer, aborting");
            return 0;
        }
        for (n4 = this.floppyBufferIndex; n4 < n3; n4 += 512) {
            int n6 = n4 % 512;
            if ((this.msr & 0x40) == 64) {
                this.dma32.writeMemory(n, this.floppyBuffer, n6, n4, n5);
            } else {
                this.dma32.readMemory(n, this.floppyBuffer, n6, n4, n5);
            }
            if (n6 != 0) continue;
            try {
                int n7;
                if ((this.msr & 0x40) == 64) {
                    this.drives[this.drive].incrementSector();
                    this.floppyBufferIndex = 0;
                    n7 = this.drives[this.drive].cylinder * this.drives[this.drive].heads * this.drives[this.drive].sectorsPerTrack + this.drives[this.drive].hds * this.drives[this.drive].sectorsPerTrack + (this.drives[this.drive].sector - 1);
                    this.drives[this.drive].readData(n7 * 512, 512, this.floppyBuffer);
                    continue;
                }
                n7 = this.drives[this.drive].cylinder * this.drives[this.drive].heads * this.drives[this.drive].sectorsPerTrack + this.drives[this.drive].hds * this.drives[this.drive].sectorsPerTrack + (this.drives[this.drive].sector - 1);
                this.drives[this.drive].writeData(n7 * 512, 512, this.floppyBuffer);
                this.drives[this.drive].incrementSector();
                this.floppyBufferIndex = 0;
                continue;
            }
            catch (StorageDeviceException storageDeviceException) {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "]" + " " + storageDeviceException.getMessage());
            }
        }
        this.statusRegister0 = this.drives[this.drive].hds << 2 | this.drive;
        this.statusRegister1 = 0;
        this.statusRegister2 = 0;
        this.dma32.releaseDREQ(2);
        this.enterResultPhase();
        return n4;
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof DMAController && hardwareComponent.initialised() && ((DMAController)hardwareComponent).isFirst()) {
            this.dma32 = (DMAController)hardwareComponent;
            this.dma32.registerChannel(2, this);
        }
    }
}

