/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.util;

import dioscuri.Constants;
import dioscuri.config.ConfigController;
import dioscuri.config.Emulator;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Utilities {
    private static final Logger logger = Logger.getLogger(Utilities.class.getName());

    private Utilities() {
    }

    public static String resolvePathAsString(String string) {
        File file = Utilities.resolvePathAsFile(string);
        return file.isFile() ? file.getAbsolutePath() : "";
    }

    public static File resolvePathAsFile(String string) {
        File file;
        if (string == null) {
            string = "";
        }
        if (!(file = new File(string)).exists() && !(file = new File(Constants.EXE_FOLDER, string)).exists()) {
            logger.log(Level.SEVERE, "neither '" + string + "' nor '" + file.getAbsolutePath() + "' exists");
        }
        return file;
    }

    public static boolean saveXML(Emulator emulator, String string) {
        try {
            ConfigController.saveToXML(emulator, Utilities.resolvePathAsFile(string));
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, " [util] Failed to save config file");
            return false;
        }
        return true;
    }
}

