/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import dioscuri.module.cpu.Util;

public class Instruction_ADC_GbEb
implements Instruction {
    private CPU cpu;
    boolean operandWordSize = false;
    byte addressByte = 0;
    byte[] memoryReferenceLocation = new byte[2];
    byte[] memoryReferenceDisplacement = new byte[2];
    byte sourceValue = 0;
    byte oldDest = 0;
    byte[] destinationRegister = new byte[2];
    byte registerHighLow = 0;
    int iCarryFlag = 0;

    public Instruction_ADC_GbEb() {
    }

    public Instruction_ADC_GbEb(CPU cPU) {
        this();
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        this.iCarryFlag = this.cpu.flags[0] ? 1 : 0;
        this.addressByte = this.cpu.getByteFromCode();
        this.memoryReferenceDisplacement = this.cpu.decodeMM(this.addressByte);
        if ((this.addressByte >> 6 & 3) == 3) {
            this.registerHighLow = (this.addressByte & 4) >> 2 == 0 ? (byte)1 : 0;
            this.sourceValue = this.cpu.decodeRegister(this.operandWordSize, this.addressByte & 7)[this.registerHighLow];
        } else {
            this.memoryReferenceLocation = this.cpu.decodeSSSMemDest(this.addressByte, this.memoryReferenceDisplacement);
            this.sourceValue = this.cpu.getByteFromMemorySegment(this.addressByte, this.memoryReferenceLocation);
        }
        this.registerHighLow = (this.addressByte & 0x20) >> 5 == 0 ? (byte)1 : 0;
        this.destinationRegister = this.cpu.decodeRegister(this.operandWordSize, (this.addressByte & 0x38) >> 3);
        this.oldDest = this.destinationRegister[this.registerHighLow];
        byte by = this.registerHighLow;
        this.destinationRegister[by] = (byte)(this.destinationRegister[by] + (this.sourceValue + this.iCarryFlag));
        this.cpu.flags[4] = Util.test_AF_ADD(this.oldDest, this.destinationRegister[this.registerHighLow]);
        this.cpu.flags[0] = Util.test_CF_ADD(this.oldDest, this.sourceValue, this.iCarryFlag);
        this.cpu.flags[11] = Util.test_OF_ADD(this.oldDest, this.sourceValue, this.destinationRegister[this.registerHighLow], this.iCarryFlag);
        this.cpu.flags[6] = this.destinationRegister[this.registerHighLow] == 0;
        this.cpu.flags[7] = this.destinationRegister[this.registerHighLow] < 0;
        this.cpu.flags[2] = Util.checkParityOfByte(this.destinationRegister[this.registerHighLow]);
    }
}

