/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

import dioscuri.exception.ModuleException;
import dioscuri.module.cpu.CPU;
import dioscuri.module.cpu.Instruction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Instruction_OUT_DXAL
implements Instruction {
    private CPU cpu;
    byte data;
    int portAddress;
    private static final Logger logger = Logger.getLogger(Instruction_OUT_DXAL.class.getName());

    public Instruction_OUT_DXAL() {
    }

    public Instruction_OUT_DXAL(CPU cPU) {
        this.cpu = cPU;
    }

    @Override
    public void execute() {
        try {
            this.portAddress = ((this.cpu.dx[0] & 0xFF) << 8) + (this.cpu.dx[1] & 0xFF);
            if (this.portAddress == 1024 || this.portAddress == 1025 || this.portAddress == 1026 || this.portAddress == 1027) {
                logger.log(Level.CONFIG, "Instruction_OUT_DXAL targeted custom Bochs port " + this.portAddress + ". OUT ignored.");
            } else {
                this.cpu.setIOPortByte(this.portAddress, this.cpu.ax[1]);
            }
        }
        catch (ModuleException moduleException) {
            // empty catch block
        }
    }
}

