/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu;

public class Util {
    private static boolean[] parityLookupByte = new boolean[]{true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true};
    protected static boolean cf = false;
    protected static int lowerByteCarry = 0;
    private static final int REGISTER_LOW = 1;
    private static final int REGISTER_HIGH = 0;
    private static final int OVERFLOW_FLAG = 0;
    private static final int CARRY_FLAG = 1;

    private Util() {
    }

    protected static boolean checkParityOfByte(byte by) {
        int n = by & 0xFF;
        return parityLookupByte[n];
    }

    protected static byte[] addWords(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = new byte[2];
        lowerByteCarry = (byArray[1] & 0xFF) + (byArray2[1] & 0xFF) + n;
        byArray3[1] = (byte)lowerByteCarry;
        byArray3[0] = (byte)((byArray[0] & 0xFF) + (byArray2[0] & 0xFF));
        if (lowerByteCarry > 255) {
            byArray3[0] = (byte)(byArray3[0] + 1);
        }
        return byArray3;
    }

    protected static byte[] subtractWords(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = new byte[2];
        byArray3[1] = (byte)(byArray[1] - (byArray2[1] + n));
        byArray3[0] = (byte)(byArray[0] - byArray2[0]);
        if ((byArray2[1] & 0xFF) + n > (byArray[1] & 0xFF)) {
            byArray3[0] = (byte)(byArray3[0] - 1);
        }
        return byArray3;
    }

    protected static byte[] addRegRegDisp(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[2];
        byArray4[1] = (byte)(byArray[1] + byArray2[1] + byArray3[1]);
        byArray4[0] = (byte)(byArray[0] + byArray2[0] + byArray3[0]);
        int n = (byArray[1] & 0xFF) + (byArray2[1] & 0xFF) + (byArray3[1] & 0xFF);
        if (n > 255) {
            byArray4[0] = n >= 512 ? (byte)(byArray4[0] + 2) : (byte)(byArray4[0] + 1);
        }
        return byArray4;
    }

    protected static boolean test_AF_ADD(byte by, byte by2) {
        return (by2 & 0xF) < (by & 0xF);
    }

    protected static boolean test_AF_SUB(byte by, byte by2) {
        return (by2 & 0xF) > (by & 0xF);
    }

    protected static boolean test_AF_ShiftLeft(byte by, int n) {
        return n > 0 && n <= 4 && (by >> 4 - n & 1) == 1;
    }

    protected static boolean test_CF_ADD(byte by, byte by2, int n) {
        return (by & 0xFF) + (by2 & 0xFF) + n > 255;
    }

    protected static boolean test_CF_ADD(byte[] byArray, byte[] byArray2, int n) {
        return ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF) + ((byArray2[0] & 0xFF) << 8) + (byArray2[1] & 0xFF) + n > 65535;
    }

    protected static boolean test_CF_SUB(byte by, byte by2, int n) {
        return (by & 0xFF) < (by2 & 0xFF) + n;
    }

    protected static boolean test_CF_SUB(byte[] byArray, byte[] byArray2, int n) {
        return ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF) < ((byArray2[0] & 0xFF) << 8) + (byArray2[1] & 0xFF) + n;
    }

    protected static boolean test_OF_ADD(byte by, byte by2, byte by3, int n) {
        if (by3 >= 0) {
            return by + n < 0 && by2 < 0;
        }
        return by + n >= 0 && by2 >= 0;
    }

    protected static boolean test_OF_ADD(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        if ((byArray3[0] << 8) + (byArray3[1] & 0xFF) >= 0) {
            return (byArray[0] << 8) + (byArray[1] & 0xFF) + n < 0 && (byArray2[0] << 8) + (byArray2[1] & 0xFF) < 0;
        }
        return (byArray[0] << 8) + (byArray[1] & 0xFF) + n >= 0 && (byArray2[0] << 8) + (byArray2[1] & 0xFF) >= 0;
    }

    protected static boolean test_OF_SUB(byte by, byte by2, byte by3, int n) {
        if (by >= 0) {
            return by2 + n < 0 && by3 < 0;
        }
        return by2 + n >= 0 && by3 >= 0;
    }

    protected static boolean test_OF_SUB(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        if ((byArray[0] << 8) + (byArray[1] & 0xFF) >= 0) {
            return (byArray2[0] << 8) + (byArray2[1] & 0xFF) + n < 0 && (byArray3[0] << 8) + (byArray3[1] & 0xFF) < 0;
        }
        return (byArray2[0] << 8) + (byArray2[1] & 0xFF) + n >= 0 && (byArray3[0] << 8) + (byArray3[1] & 0xFF) >= 0;
    }

    protected static byte signExtend(byte by) {
        return by >> 7 == 0 ? (byte)0 : -1;
    }

    protected static byte[] booleansToBytes(boolean[] blArray) {
        int n;
        int n2 = 0;
        int[] nArray = new int[blArray.length / 8];
        for (int i = nArray.length - 1; i >= 0; --i) {
            for (n = 0; n <= 7; ++n) {
                n2 = blArray[n + (nArray.length - 1 - i) * 8] ? 1 : 0;
                int n3 = i;
                nArray[n3] = nArray[n3] + n2 * (int)Math.pow(2.0, n);
            }
        }
        byte[] byArray = new byte[nArray.length];
        for (n = 0; n < byArray.length; ++n) {
            byArray[n] = (byte)(nArray[n] & 0xFF);
        }
        return byArray;
    }

    protected static boolean[] bytesToBooleans(byte[] byArray) {
        int n = 0;
        boolean[] blArray = new boolean[byArray.length * 8];
        for (int i = byArray.length - 1; i >= 0; --i) {
            for (int j = 0; j < 8; ++j) {
                n = byArray[i] >> j & 1;
                blArray[(byArray.length - 1 - i) * 8 + j] = n == 1;
            }
        }
        return blArray;
    }

    protected static String convertByteToString(byte by) {
        return Integer.toHexString(0x100 | by & 0xFF).substring(1);
    }

    protected static String convertWordToString(byte[] byArray) {
        return Integer.toHexString(0x100 | byArray[0] & 0xFF).substring(1) + Integer.toHexString(0x100 | byArray[1] & 0xFF).substring(1);
    }

    protected static byte convertStringToByte(String string) {
        try {
            byte by = 0;
            for (int i = string.length(); i > 0; --i) {
                by = (byte)(by + (int)Math.pow(16.0, string.length() - i) * Integer.parseInt(string.substring(i - 1, i), 16));
            }
            return by;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected static byte[] convertStringToWord(String string) {
        byte[] byArray = new byte[2];
        try {
            int n = 0;
            for (int i = string.length(); i > 0; --i) {
                n = (byte)((double)n + Math.pow(16.0, string.length() - i) * (double)Byte.parseByte(string.substring(i - 1, i), 16));
            }
            byArray[0] = (byte)(n >>> 8 & 0xFF);
            byArray[1] = (byte)(n & 0xFF);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return byArray;
    }

    public static int getExponent(double d) {
        return (int)(((Double.doubleToRawLongBits(d) & 0x7FF0000000000000L) >> 52) - 1023L);
    }

    public static int getExponent(float f) {
        return ((Float.floatToRawIntBits(f) & 0x7F800000) >> 23) - 127;
    }

    public static double scalb(double d, int n) {
        int n2 = 0;
        int n3 = 0;
        double d2 = 0.0;
        if (n < 0) {
            n = Math.max(n, -2099);
            n3 = 65024;
            d2 = Math.pow(2.0, -512.0);
        } else {
            n = Math.min(n, 2099);
            n3 = 512;
            d2 = Math.pow(2.0, 512.0);
        }
        int n4 = n >> 8 >>> 23;
        n2 = (n + n4 & 0x1FF) - n4;
        d *= Math.pow(2.0, n2);
        n -= n2;
        while (n != 0) {
            d *= d2;
            n -= n3;
        }
        return d;
    }

    public static float scalb(float f, int n) {
        n = Math.max(Math.min(n, 278), -278);
        return (float)((double)f * Math.pow(2.0, n));
    }
}

