/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.AbstractMemory;
import dioscuri.module.cpu32.Memory;

public abstract class AddressSpace
extends AbstractMemory {
    public static final int BLOCK_SIZE = 4096;
    public static final int BLOCK_MASK = 4095;
    public static final int INDEX_MASK = -4096;
    public static final int INDEX_SHIFT = 12;
    public static final int INDEX_SIZE = 0x100000;

    @Override
    public final long getSize() {
        return 0x100000000L;
    }

    public final int getBlockStart(int n) {
        return n & 0xFFFFF000;
    }

    public final int getBlockEnd(int n) {
        return (n & 0xFFFFF000) + 4096;
    }

    public abstract Memory getReadMemoryBlockAt(int var1);

    public abstract Memory getWriteMemoryBlockAt(int var1);

    @Override
    public abstract void clear();

    public abstract boolean updated();

    @Override
    public byte getByte(int n) {
        return this.getReadMemoryBlockAt(n).getByte(n & 0xFFF);
    }

    @Override
    public void setByte(int n, byte by) {
        this.getWriteMemoryBlockAt(n).setByte(n & 0xFFF, by);
    }

    @Override
    public short getWord(int n) {
        try {
            return this.getReadMemoryBlockAt(n).getWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return super.getWord(n);
        }
    }

    @Override
    public int getDoubleWord(int n) {
        try {
            return this.getReadMemoryBlockAt(n).getDoubleWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return super.getDoubleWord(n);
        }
    }

    @Override
    public long getQuadWord(int n) {
        try {
            return this.getReadMemoryBlockAt(n).getQuadWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return super.getQuadWord(n);
        }
    }

    @Override
    public long getLowerDoubleQuadWord(int n) {
        try {
            return this.getReadMemoryBlockAt(n).getLowerDoubleQuadWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return super.getLowerDoubleQuadWord(n);
        }
    }

    @Override
    public long getUpperDoubleQuadWord(int n) {
        try {
            return this.getReadMemoryBlockAt(n).getUpperDoubleQuadWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return super.getUpperDoubleQuadWord(n);
        }
    }

    @Override
    public void setWord(int n, short s) {
        try {
            this.getWriteMemoryBlockAt(n).setWord(n & 0xFFF, s);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            super.setWord(n, s);
        }
    }

    @Override
    public void setDoubleWord(int n, int n2) {
        try {
            this.getWriteMemoryBlockAt(n).setDoubleWord(n & 0xFFF, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            super.setDoubleWord(n, n2);
        }
    }

    @Override
    public void setQuadWord(int n, long l) {
        try {
            this.getWriteMemoryBlockAt(n).setQuadWord(n & 0xFFF, l);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            super.setQuadWord(n, l);
        }
    }

    @Override
    public void setLowerDoubleQuadWord(int n, long l) {
        try {
            this.getWriteMemoryBlockAt(n).setLowerDoubleQuadWord(n & 0xFFF, l);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            super.setLowerDoubleQuadWord(n, l);
        }
    }

    @Override
    public void setUpperDoubleQuadWord(int n, long l) {
        try {
            this.getWriteMemoryBlockAt(n).setUpperDoubleQuadWord(n & 0xFFF, l);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            super.setUpperDoubleQuadWord(n, l);
        }
    }

    @Override
    public void copyContentsFrom(int n, byte[] byArray, int n2, int n3) {
        int n4;
        do {
            n4 = Math.min(4096 - (n & 0xFFF), n3);
            this.getWriteMemoryBlockAt(n).copyContentsFrom(n & 0xFFF, byArray, n2, n4);
            n += n4;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    @Override
    public void copyContentsInto(int n, byte[] byArray, int n2, int n3) {
        int n4;
        do {
            n4 = Math.min(4096 - (n & 0xFFF), n3);
            this.getReadMemoryBlockAt(n).copyContentsInto(n & 0xFFF, byArray, n2, n4);
            n += n4;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    abstract void replaceBlocks(Memory var1, Memory var2);
}

