/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.CodeBlock;
import dioscuri.module.cpu32.CodeBlockReplacementException;
import dioscuri.module.cpu32.Processor;
import dioscuri.module.cpu32.RealModeCodeBlock;

public class CombiningRealCodeBlock
implements RealModeCodeBlock {
    private CodeBlock block0;
    private CodeBlock block1;
    private CodeBlock block2;
    private int x86Length = 0;
    private int block2Start;
    private int block1Start;
    private int block0Start;
    private boolean selfModified = false;

    public CombiningRealCodeBlock(CodeBlock codeBlock, CodeBlock codeBlock2, CodeBlock codeBlock3, int n, int n2) {
        this.block0 = codeBlock;
        this.block1 = codeBlock2;
        this.block2 = codeBlock3;
        this.x86Length = n2 < codeBlock2.getX86Length() ? codeBlock.getX86Length() + codeBlock2.getX86Length() : codeBlock.getX86Length() + n2 + codeBlock3.getX86Length();
        this.block1Start = n + codeBlock.getX86Length();
        this.block0Start = n;
        this.block2Start = this.block1Start + n2;
    }

    @Override
    public int getX86Length() {
        return this.x86Length;
    }

    @Override
    public int getX86Count() {
        return this.block0.getX86Count() + this.block1.getX86Count() + this.block2.getX86Count();
    }

    public void invalidate() {
        this.selfModified = true;
    }

    @Override
    public int execute(Processor processor) {
        int n = 0;
        int n2 = 0;
        int n3 = processor.getInstructionPointer() & 0xFFFFF000;
        while (!(this.selfModified || processor.eflagsInterruptEnable && (processor.getInterruptFlags() & 1) != 0)) {
            if (++n2 > 10000) {
                return n;
            }
            int n4 = processor.getInstructionPointer() & 0xFFF;
            int n5 = processor.getInstructionPointer() & 0xFFFFF000;
            if (n5 != n3) {
                return n;
            }
            if (n4 == this.block0Start) {
                try {
                    n += this.block0.execute(processor);
                }
                catch (CodeBlockReplacementException codeBlockReplacementException) {
                    this.block0 = codeBlockReplacementException.getReplacement();
                    n += this.block0.execute(processor);
                }
                continue;
            }
            if (n4 == this.block1Start) {
                try {
                    n += this.block1.execute(processor);
                }
                catch (CodeBlockReplacementException codeBlockReplacementException) {
                    this.block1 = codeBlockReplacementException.getReplacement();
                    n += this.block1.execute(processor);
                }
                continue;
            }
            if (n4 != this.block2Start) break;
            try {
                n += this.block2.execute(processor);
            }
            catch (CodeBlockReplacementException codeBlockReplacementException) {
                this.block2 = codeBlockReplacementException.getReplacement();
                n += this.block2.execute(processor);
            }
        }
        return n;
    }

    @Override
    public boolean handleMemoryRegionChange(int n, int n2) {
        this.invalidate();
        return false;
    }

    @Override
    public String getDisplayString() {
        return "\nBlock0:\n" + this.block0.getDisplayString() + "\nBlock1:\n" + this.block1.getDisplayString() + "\nBlock2:\n" + this.block2.getDisplayString();
    }
}

