/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.AttributeInfo;
import dioscuri.module.cpu32.ClassFile;
import dioscuri.module.cpu32.ClassFileBuilder;
import dioscuri.module.cpu32.CodeBlockCompiler;
import dioscuri.module.cpu32.CountingOutputStream;
import dioscuri.module.cpu32.ExceptionHandler;
import dioscuri.module.cpu32.InstructionSource;
import dioscuri.module.cpu32.MicrocodeNode;
import dioscuri.module.cpu32.ProcessorException;
import dioscuri.module.cpu32.ProtectedModeBytecodeFragments;
import dioscuri.module.cpu32.ProtectedModeCodeBlock;
import dioscuri.module.cpu32.ProtectedModeExceptionHandler;
import dioscuri.module.cpu32.ProtectedModeRPNNode;
import dioscuri.module.cpu32.RPNNode;
import dioscuri.module.cpu32.RealModeBytecodeFragments;
import dioscuri.module.cpu32.RealModeCodeBlock;
import dioscuri.module.cpu32.RealModeExceptionHandler;
import dioscuri.module.cpu32.RealModeRPNNode;
import dioscuri.module.cpu32.Virtual8086ModeCodeBlock;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class FASTCompiler
implements CodeBlockCompiler {
    public static final int PROCESSOR_ELEMENT_EAX = 0;
    public static final int PROCESSOR_ELEMENT_ECX = 1;
    public static final int PROCESSOR_ELEMENT_EDX = 2;
    public static final int PROCESSOR_ELEMENT_EBX = 3;
    public static final int PROCESSOR_ELEMENT_ESP = 4;
    public static final int PROCESSOR_ELEMENT_EBP = 5;
    public static final int PROCESSOR_ELEMENT_ESI = 6;
    public static final int PROCESSOR_ELEMENT_EDI = 7;
    public static final int PROCESSOR_ELEMENT_EIP = 8;
    public static final int PROCESSOR_ELEMENT_CFLAG = 9;
    public static final int PROCESSOR_ELEMENT_PFLAG = 10;
    public static final int PROCESSOR_ELEMENT_AFLAG = 11;
    public static final int PROCESSOR_ELEMENT_ZFLAG = 12;
    public static final int PROCESSOR_ELEMENT_SFLAG = 13;
    public static final int PROCESSOR_ELEMENT_TFLAG = 14;
    public static final int PROCESSOR_ELEMENT_IFLAG = 15;
    public static final int PROCESSOR_ELEMENT_DFLAG = 16;
    public static final int PROCESSOR_ELEMENT_OFLAG = 17;
    public static final int PROCESSOR_ELEMENT_IOPL = 18;
    public static final int PROCESSOR_ELEMENT_NTFLAG = 19;
    public static final int PROCESSOR_ELEMENT_RFLAG = 20;
    public static final int PROCESSOR_ELEMENT_VMFLAG = 21;
    public static final int PROCESSOR_ELEMENT_ACFLAG = 22;
    public static final int PROCESSOR_ELEMENT_VIFLAG = 23;
    public static final int PROCESSOR_ELEMENT_VIPFLAG = 24;
    public static final int PROCESSOR_ELEMENT_IDFLAG = 25;
    public static final int PROCESSOR_ELEMENT_ES = 26;
    public static final int PROCESSOR_ELEMENT_CS = 27;
    public static final int PROCESSOR_ELEMENT_SS = 28;
    public static final int PROCESSOR_ELEMENT_DS = 29;
    public static final int PROCESSOR_ELEMENT_FS = 30;
    public static final int PROCESSOR_ELEMENT_GS = 31;
    public static final int PROCESSOR_ELEMENT_IDTR = 32;
    public static final int PROCESSOR_ELEMENT_GDTR = 33;
    public static final int PROCESSOR_ELEMENT_LDTR = 34;
    public static final int PROCESSOR_ELEMENT_TSS = 35;
    public static final int PROCESSOR_ELEMENT_CPL = 36;
    public static final int PROCESSOR_ELEMENT_IOPORTS = 37;
    public static final int PROCESSOR_ELEMENT_ADDR0 = 38;
    public static final int PROCESSOR_ELEMENT_COUNT = 39;
    public static final int PROCESSOR_ELEMENT_REG0 = 39;
    public static final int PROCESSOR_ELEMENT_REG1 = 40;
    public static final int PROCESSOR_ELEMENT_REG2 = 41;
    public static final int PROCESSOR_ELEMENT_SEG0 = 42;
    public static final int POPABLE_ELEMENT_COUNT = 43;
    public static final int PROCESSOR_ELEMENT_MEMORYWRITE = 43;
    public static final int PROCESSOR_ELEMENT_IOPORTWRITE = 44;
    public static final int PROCESSOR_ELEMENT_EXECUTECOUNT = 45;
    public static final int ELEMENT_COUNT = 46;
    public static final int VARIABLE_EXECUTE_COUNT_INDEX = 10;
    public static final int VARIABLE_OFFSET = 11;
    private static int classIndex = 0;

    @Override
    public ProtectedModeCodeBlock getProtectedModeCodeBlock(InstructionSource instructionSource) {
        MicrocodeNode[] microcodeNodeArray = MicrocodeNode.getMicrocodes(instructionSource);
        ClassFile classFile = null;
        try {
            classFile = ClassFileBuilder.createNewProtectedModeSkeletonClass();
            MicrocodeNode microcodeNode = microcodeNodeArray[microcodeNodeArray.length - 1];
            classFile.setClassName("org.jpc.dynamic.FAST_PM_LEN" + microcodeNode.getX86Index() + "_NUM" + classIndex++);
            int n = classFile.addToConstantPool(new Integer(microcodeNode.getX86Index()));
            int n2 = classFile.addToConstantPool(new Integer(microcodeNode.getX86Position()));
            FASTCompiler.compileX86CountMethod(classFile, n);
            FASTCompiler.compileX86LengthMethod(classFile, n2);
            FASTCompiler.compileProtectedModeExecuteMethod(microcodeNodeArray, classFile, n);
            return (ProtectedModeCodeBlock)ClassFileBuilder.instantiateClass(classFile);
        }
        catch (Error error) {
            throw new IllegalStateException("Failed to compile Protected Mode FAST block : " + error, error);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Failed to compile Protected Mode FAST block : " + nullPointerException, nullPointerException);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to compile Protected Mode FAST block : " + iOException, iOException);
        }
    }

    @Override
    public Virtual8086ModeCodeBlock getVirtual8086ModeCodeBlock(InstructionSource instructionSource) {
        throw new IllegalStateException("Cannot compile Virtual8086 Mode FAST blocks");
    }

    @Override
    public RealModeCodeBlock getRealModeCodeBlock(InstructionSource instructionSource) {
        MicrocodeNode[] microcodeNodeArray = MicrocodeNode.getMicrocodes(instructionSource);
        ClassFile classFile = null;
        try {
            classFile = ClassFileBuilder.createNewRealModeSkeletonClass();
            MicrocodeNode microcodeNode = microcodeNodeArray[microcodeNodeArray.length - 1];
            classFile.setClassName("org.jpc.dynamic.FAST_RM_LEN" + microcodeNode.getX86Index() + "_NUM" + classIndex++);
            int n = classFile.addToConstantPool(new Integer(microcodeNode.getX86Index()));
            int n2 = classFile.addToConstantPool(new Integer(microcodeNode.getX86Position()));
            FASTCompiler.compileX86CountMethod(classFile, n);
            FASTCompiler.compileX86LengthMethod(classFile, n2);
            FASTCompiler.compileRealModeExecuteMethod(microcodeNodeArray, classFile, n);
            return (RealModeCodeBlock)ClassFileBuilder.instantiateClass(classFile);
        }
        catch (Error error) {
            throw new IllegalStateException("Failed to compile Real Mode FAST block : " + error, error);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Failed to compile Real Mode FAST block : " + nullPointerException, nullPointerException);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to compile Real Mode FAST block : " + iOException, iOException);
        }
    }

    private static void compileProtectedModeExecuteMethod(MicrocodeNode[] microcodeNodeArray, ClassFile classFile, int n) throws IOException {
        Object object;
        int n2;
        int n3;
        int n4;
        Object object2;
        Object object3;
        Object object42;
        int n5;
        int n6;
        ArrayList<ProtectedModeRPNNode> arrayList = new ArrayList<ProtectedModeRPNNode>();
        HashMap<Integer, ProtectedModeRPNNode> hashMap = new HashMap<Integer, ProtectedModeRPNNode>();
        ArrayList<ExceptionHandler> arrayList2 = new ArrayList<ExceptionHandler>();
        ExceptionHandler exceptionHandler = null;
        for (n6 = 0; n6 < 39; ++n6) {
            hashMap.put(new Integer(n6), new ProtectedModeRPNNode(n6, null));
        }
        n6 = 0;
        for (n5 = 0; n5 < microcodeNodeArray.length; ++n5) {
            int n7;
            MicrocodeNode microcodeNode = microcodeNodeArray[n5];
            int n8 = microcodeNode.getMicrocode();
            object42 = ProtectedModeBytecodeFragments.getTargetsOf(n8);
            if (object42 == null) {
                throw new IllegalStateException("Unimplemented Microcode: " + MicrocodeNode.getName(n8));
            }
            ArrayList<ProtectedModeRPNNode> arrayList3 = new ArrayList<ProtectedModeRPNNode>();
            for (n7 = 0; n7 < ((Object[])object42).length; ++n7) {
                if (object42[n7] == null) continue;
                object3 = new ProtectedModeRPNNode(n7, microcodeNode);
                if (((ProtectedModeRPNNode)object3).hasExternalEffect()) {
                    arrayList.add((ProtectedModeRPNNode)object3);
                }
                if (((ProtectedModeRPNNode)object3).canThrowException()) {
                    if (exceptionHandler == null || exceptionHandler.getX86Index() != ((RPNNode)object3).getX86Index()) {
                        exceptionHandler = new ProtectedModeExceptionHandler(n6, (ProtectedModeRPNNode)object3, new HashMap<Integer, RPNNode>(hashMap));
                        arrayList2.add(exceptionHandler);
                    }
                    ((RPNNode)object3).attachExceptionHandler(exceptionHandler);
                }
                arrayList3.add((ProtectedModeRPNNode)object3);
                object2 = ProtectedModeBytecodeFragments.getOperands(n7, n8);
                if (object2 == null) {
                    System.out.println("NULL IDS FOR: " + n7 + "  " + n8);
                }
                for (n4 = 0; n4 < ((int[])object2).length; ++n4) {
                    ProtectedModeRPNNode protectedModeRPNNode = (ProtectedModeRPNNode)hashMap.get(new Integer(object2[n4]));
                    ((RPNNode)object3).linkTo(protectedModeRPNNode);
                }
            }
            for (n7 = 0; n7 < arrayList3.size(); ++n7) {
                object3 = (ProtectedModeRPNNode)arrayList3.get(n7);
                hashMap.put(new Integer(((RPNNode)object3).getID()), (ProtectedModeRPNNode)object3);
            }
            if (n5 + 1 >= microcodeNodeArray.length || microcodeNode.getX86Position() == microcodeNodeArray[n5 + 1].getX86Position()) continue;
            n6 = microcodeNode.getX86Position();
        }
        for (n5 = 39; n5 < 46; ++n5) {
            hashMap.remove(new Integer(n5));
        }
        n5 = 11;
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            n5 = ((ProtectedModeRPNNode)arrayList.get(n3)).markSubtrees(n5);
        }
        n3 = 0;
        for (Object object42 : hashMap.values()) {
            if (((RPNNode)object42).getMicrocode() == -1) continue;
            ++n3;
            n5 = ((RPNNode)object42).markSubtrees(n5);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        object42 = new CountingOutputStream(byteArrayOutputStream);
        ((CountingOutputStream)object42).write(18);
        ((CountingOutputStream)object42).write(n);
        ((CountingOutputStream)object42).write(54);
        ((CountingOutputStream)object42).write(10);
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            ProtectedModeRPNNode protectedModeRPNNode = (ProtectedModeRPNNode)arrayList.get(n2);
            protectedModeRPNNode.write((CountingOutputStream)object42, classFile, false);
        }
        n2 = 0;
        ProtectedModeRPNNode[] protectedModeRPNNodeArray = new ProtectedModeRPNNode[n3];
        object3 = hashMap.values().iterator();
        while (object3.hasNext()) {
            object2 = (ProtectedModeRPNNode)object3.next();
            if (((RPNNode)object2).getMicrocode() == -1) continue;
            ((RPNNode)object2).write((CountingOutputStream)object42, classFile, true);
            protectedModeRPNNodeArray[n2++] = object2;
        }
        for (int i = n2 - 1; i >= 0; --i) {
            RPNNode.writeBytecodes((CountingOutputStream)object42, classFile, ProtectedModeBytecodeFragments.popCode(protectedModeRPNNodeArray[i].getID()));
        }
        ((CountingOutputStream)object42).write(21);
        ((CountingOutputStream)object42).write(10);
        ((CountingOutputStream)object42).write(172);
        AttributeInfo.CodeAttribute.ExceptionEntry[] exceptionEntryArray = new AttributeInfo.CodeAttribute.ExceptionEntry[arrayList2.size()];
        int n9 = 0;
        for (n4 = 0; n4 < arrayList2.size(); ++n4) {
            int n10 = ((CountingOutputStream)object42).position();
            object = (ExceptionHandler)arrayList2.get(n4);
            if (!((ExceptionHandler)object).used()) continue;
            ((ExceptionHandler)object).write((CountingOutputStream)object42, classFile);
            exceptionEntryArray[n9++] = new AttributeInfo.CodeAttribute.ExceptionEntry(((ExceptionHandler)object).start(), ((ExceptionHandler)object).end(), n10, classFile.addToConstantPool(ProcessorException.class));
        }
        AttributeInfo.CodeAttribute.ExceptionEntry[] exceptionEntryArray2 = new AttributeInfo.CodeAttribute.ExceptionEntry[n9];
        System.arraycopy(exceptionEntryArray, 0, exceptionEntryArray2, 0, exceptionEntryArray2.length);
        exceptionEntryArray = exceptionEntryArray2;
        byte[] byArray = byteArrayOutputStream.toByteArray();
        object = new int[byArray.length];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = 0xFF & byArray[i];
        }
        classFile.setMethodCode("execute", (int[])object);
        classFile.setMethodExceptionTable("execute", exceptionEntryArray);
    }

    private static void compileRealModeExecuteMethod(MicrocodeNode[] microcodeNodeArray, ClassFile classFile, int n) throws IOException {
        Object object;
        int n2;
        int n3;
        int n4;
        Object object2;
        Object object3;
        Object object42;
        int n5;
        int n6;
        ArrayList<RealModeRPNNode> arrayList = new ArrayList<RealModeRPNNode>();
        HashMap<Integer, RealModeRPNNode> hashMap = new HashMap<Integer, RealModeRPNNode>();
        ArrayList<ExceptionHandler> arrayList2 = new ArrayList<ExceptionHandler>();
        ExceptionHandler exceptionHandler = null;
        for (n6 = 0; n6 < 39; ++n6) {
            hashMap.put(new Integer(n6), new RealModeRPNNode(n6, null));
        }
        n6 = 0;
        for (n5 = 0; n5 < microcodeNodeArray.length; ++n5) {
            int n7;
            MicrocodeNode microcodeNode = microcodeNodeArray[n5];
            int n8 = microcodeNode.getMicrocode();
            object42 = RealModeBytecodeFragments.getTargetsOf(n8);
            if (object42 == null) {
                throw new IllegalStateException("Unimplemented Microcode: " + MicrocodeNode.getName(n8));
            }
            ArrayList<RealModeRPNNode> arrayList3 = new ArrayList<RealModeRPNNode>();
            for (n7 = 0; n7 < ((Object[])object42).length; ++n7) {
                if (object42[n7] == null) continue;
                object3 = new RealModeRPNNode(n7, microcodeNode);
                if (((RealModeRPNNode)object3).hasExternalEffect()) {
                    arrayList.add((RealModeRPNNode)object3);
                }
                if (((RealModeRPNNode)object3).canThrowException()) {
                    if (exceptionHandler == null || exceptionHandler.getX86Index() != ((RPNNode)object3).getX86Index()) {
                        exceptionHandler = new RealModeExceptionHandler(n6, (RealModeRPNNode)object3, new HashMap<Integer, RPNNode>(hashMap));
                        arrayList2.add(exceptionHandler);
                    }
                    ((RPNNode)object3).attachExceptionHandler(exceptionHandler);
                }
                arrayList3.add((RealModeRPNNode)object3);
                object2 = RealModeBytecodeFragments.getOperands(n7, n8);
                if (object2 == null) {
                    System.out.println("NULL IDS FOR: " + n7 + "  " + n8);
                }
                for (n4 = 0; n4 < ((int[])object2).length; ++n4) {
                    RealModeRPNNode realModeRPNNode = (RealModeRPNNode)hashMap.get(new Integer(object2[n4]));
                    ((RPNNode)object3).linkTo(realModeRPNNode);
                }
            }
            for (n7 = 0; n7 < arrayList3.size(); ++n7) {
                object3 = (RealModeRPNNode)arrayList3.get(n7);
                hashMap.put(new Integer(((RPNNode)object3).getID()), (RealModeRPNNode)object3);
            }
            if (n5 + 1 >= microcodeNodeArray.length || microcodeNode.getX86Position() == microcodeNodeArray[n5 + 1].getX86Position()) continue;
            n6 = microcodeNode.getX86Position();
        }
        for (n5 = 39; n5 < 46; ++n5) {
            hashMap.remove(new Integer(n5));
        }
        n5 = 11;
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            n5 = ((RealModeRPNNode)arrayList.get(n3)).markSubtrees(n5);
        }
        n3 = 0;
        for (Object object42 : hashMap.values()) {
            if (((RPNNode)object42).getMicrocode() == -1) continue;
            ++n3;
            n5 = ((RPNNode)object42).markSubtrees(n5);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        object42 = new CountingOutputStream(byteArrayOutputStream);
        ((CountingOutputStream)object42).write(18);
        ((CountingOutputStream)object42).write(n);
        ((CountingOutputStream)object42).write(54);
        ((CountingOutputStream)object42).write(10);
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            RealModeRPNNode realModeRPNNode = (RealModeRPNNode)arrayList.get(n2);
            realModeRPNNode.write((CountingOutputStream)object42, classFile, false);
        }
        n2 = 0;
        RealModeRPNNode[] realModeRPNNodeArray = new RealModeRPNNode[n3];
        object3 = hashMap.values().iterator();
        while (object3.hasNext()) {
            object2 = (RealModeRPNNode)object3.next();
            if (((RPNNode)object2).getMicrocode() == -1) continue;
            ((RPNNode)object2).write((CountingOutputStream)object42, classFile, true);
            realModeRPNNodeArray[n2++] = object2;
        }
        for (int i = n2 - 1; i >= 0; --i) {
            RPNNode.writeBytecodes((CountingOutputStream)object42, classFile, RealModeBytecodeFragments.popCode(realModeRPNNodeArray[i].getID()));
        }
        ((CountingOutputStream)object42).write(21);
        ((CountingOutputStream)object42).write(10);
        ((CountingOutputStream)object42).write(172);
        AttributeInfo.CodeAttribute.ExceptionEntry[] exceptionEntryArray = new AttributeInfo.CodeAttribute.ExceptionEntry[arrayList2.size()];
        int n9 = 0;
        for (n4 = 0; n4 < arrayList2.size(); ++n4) {
            int n10 = ((CountingOutputStream)object42).position();
            object = (ExceptionHandler)arrayList2.get(n4);
            if (!((ExceptionHandler)object).used()) continue;
            ((ExceptionHandler)object).write((CountingOutputStream)object42, classFile);
            exceptionEntryArray[n9++] = new AttributeInfo.CodeAttribute.ExceptionEntry(((ExceptionHandler)object).start(), ((ExceptionHandler)object).end(), n10, classFile.addToConstantPool(ProcessorException.class));
        }
        AttributeInfo.CodeAttribute.ExceptionEntry[] exceptionEntryArray2 = new AttributeInfo.CodeAttribute.ExceptionEntry[n9];
        System.arraycopy(exceptionEntryArray, 0, exceptionEntryArray2, 0, exceptionEntryArray2.length);
        exceptionEntryArray = exceptionEntryArray2;
        byte[] byArray = byteArrayOutputStream.toByteArray();
        object = new int[byArray.length];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = 0xFF & byArray[i];
        }
        classFile.setMethodCode("execute", (int[])object);
        classFile.setMethodExceptionTable("execute", exceptionEntryArray);
    }

    private static void compileX86CountMethod(ClassFile classFile, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(18);
        byteArrayOutputStream.write(n);
        byteArrayOutputStream.write(172);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0xFF & byArray[i];
        }
        classFile.setMethodCode("getX86Count", nArray);
    }

    private static void compileX86LengthMethod(ClassFile classFile, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(18);
        byteArrayOutputStream.write(n);
        byteArrayOutputStream.write(172);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0xFF & byArray[i];
        }
        classFile.setMethodCode("getX86Length", nArray);
    }

    private static void dumpClass(ClassFile classFile) {
        try {
            File file = new File(classFile.getClassName().replace('.', '/') + ".class");
            file.getParentFile().mkdirs();
            classFile.write(new DataOutputStream(new FileOutputStream(file)));
        }
        catch (Exception exception) {
            System.err.println("Attempt to save class file to disk failed: " + exception);
        }
    }
}

