/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.clock.Clock;
import dioscuri.module.cpu32.BlankCodeBlock;
import dioscuri.module.cpu32.CodeBlock;
import dioscuri.module.cpu32.CodeBlockManager;
import dioscuri.module.cpu32.CodeBlockReplacementException;
import dioscuri.module.cpu32.LazyMemory;
import dioscuri.module.cpu32.Memory;
import dioscuri.module.cpu32.Processor;
import dioscuri.module.cpu32.ProcessorException;
import dioscuri.module.cpu32.ProtectedModeCodeBlock;
import dioscuri.module.cpu32.RealModeCodeBlock;
import dioscuri.module.cpu32.Virtual8086ModeCodeBlock;

public class LazyCodeBlockMemory
extends LazyMemory {
    private static CodeBlockManager codeBlockManager;
    private static final BlankCodeBlock PLACEHOLDER;
    protected RealModeCodeBlock[] realCodeBuffer;
    protected ProtectedModeCodeBlock[] protectedCodeBuffer;
    protected Virtual8086ModeCodeBlock[] virtual8086CodeBuffer;
    private Clock clock;

    public LazyCodeBlockMemory(Memory memory, Clock clock) {
        super((int)memory.getSize());
        if (memory.getSize() > 0x2000000L) {
            throw new IllegalStateException("Cannot create code block of size " + memory.getSize());
        }
        this.constructCodeBlocksArray();
        byte[] byArray = new byte[(int)memory.getSize()];
        memory.copyContentsInto(0, byArray, 0, byArray.length);
        this.copyContentsFrom(0, byArray, 0, byArray.length);
        if (codeBlockManager == null) {
            codeBlockManager = new CodeBlockManager(clock);
        }
        this.clock = clock;
    }

    public LazyCodeBlockMemory(byte[] byArray, Clock clock) {
        super(byArray);
        this.constructCodeBlocksArray();
        if (codeBlockManager == null) {
            codeBlockManager = new CodeBlockManager(clock);
        }
    }

    public LazyCodeBlockMemory(int n, Clock clock) {
        super(n);
        this.constructCodeBlocksArray();
        if (codeBlockManager == null) {
            codeBlockManager = new CodeBlockManager(clock);
        }
    }

    protected void constructCodeBlocksArray() {
        this.realCodeBuffer = new RealModeCodeBlock[(int)this.getSize()];
        this.protectedCodeBuffer = new ProtectedModeCodeBlock[(int)this.getSize()];
        this.virtual8086CodeBuffer = new Virtual8086ModeCodeBlock[(int)this.getSize()];
    }

    public void relinquishCache() {
    }

    @Override
    public int execute(Processor processor, int n) {
        if (processor.isProtectedMode()) {
            if (processor.isVirtual8086Mode()) {
                return this.executeVirtual8086(processor, n);
            }
            return this.executeProtected(processor, n);
        }
        return this.executeReal(processor, n);
    }

    @Override
    public CodeBlock decodeCodeBlockAt(Processor processor, int n) {
        if (processor.isProtectedMode()) {
            if (processor.isVirtual8086Mode()) {
                return this.decodeVirtual8086(processor, n);
            }
            return this.decodeProtected(processor, n);
        }
        return this.decodeReal(processor, n);
    }

    private int executeProtected(Processor processor, int n) {
        int n2 = 0;
        int n3 = processor.getInstructionPointer();
        int n4 = n3 & 0xFFFFF000;
        do {
            try {
                n = n3 & 0xFFF;
                ProtectedModeCodeBlock protectedModeCodeBlock = this.getProtectedModeCodeBlockAt(n);
                try {
                    try {
                        n2 += protectedModeCodeBlock.execute(processor);
                    }
                    catch (NullPointerException nullPointerException) {
                        protectedModeCodeBlock = codeBlockManager.getProtectedModeCodeBlockAt(this, n, processor.cs.getDefaultSizeFlag());
                        n2 += protectedModeCodeBlock.execute(processor);
                    }
                }
                catch (CodeBlockReplacementException codeBlockReplacementException) {
                    protectedModeCodeBlock = (ProtectedModeCodeBlock)codeBlockReplacementException.getReplacement();
                    this.setProtectedCodeBlockAt(n, protectedModeCodeBlock);
                    n2 += protectedModeCodeBlock.execute(processor);
                }
                processor.processProtectedModeInterrupts();
            }
            catch (ProcessorException processorException) {
                processor.handleProtectedModeException(processorException.getVector(), processorException.hasErrorCode(), processorException.getErrorCode());
            }
        } while (((n3 = processor.getInstructionPointer()) & 0xFFFFF000) == n4);
        return n2;
    }

    private CodeBlock decodeProtected(Processor processor, int n) {
        ProtectedModeCodeBlock protectedModeCodeBlock = this.getProtectedModeCodeBlockAt(n);
        try {
            try {
                protectedModeCodeBlock.getX86Length();
            }
            catch (NullPointerException nullPointerException) {
                protectedModeCodeBlock = codeBlockManager.getProtectedModeCodeBlockAt(this, n, processor.cs.getDefaultSizeFlag());
                protectedModeCodeBlock.getX86Length();
            }
        }
        catch (CodeBlockReplacementException codeBlockReplacementException) {
            protectedModeCodeBlock = (ProtectedModeCodeBlock)codeBlockReplacementException.getReplacement();
            this.setProtectedCodeBlockAt(n, protectedModeCodeBlock);
        }
        return protectedModeCodeBlock;
    }

    private int executeReal(Processor processor, int n) {
        int n2 = 0;
        int n3 = processor.getInstructionPointer();
        int n4 = n3 & 0xFFFFF000;
        do {
            try {
                n = n3 & 0xFFF;
                RealModeCodeBlock realModeCodeBlock = this.getRealModeCodeBlockAt(n);
                try {
                    try {
                        n2 += realModeCodeBlock.execute(processor);
                    }
                    catch (NullPointerException nullPointerException) {
                        realModeCodeBlock = codeBlockManager.getRealModeCodeBlockAt(this, n);
                        n2 += realModeCodeBlock.execute(processor);
                    }
                }
                catch (CodeBlockReplacementException codeBlockReplacementException) {
                    realModeCodeBlock = (RealModeCodeBlock)codeBlockReplacementException.getReplacement();
                    this.setRealCodeBlockAt(n, realModeCodeBlock);
                    n2 += realModeCodeBlock.execute(processor);
                }
                processor.processRealModeInterrupts();
            }
            catch (ProcessorException processorException) {
                processor.handleRealModeException(processorException.getVector());
            }
        } while (((n3 = processor.getInstructionPointer()) & 0xFFFFF000) == n4);
        return n2;
    }

    private CodeBlock decodeReal(Processor processor, int n) {
        RealModeCodeBlock realModeCodeBlock = this.getRealModeCodeBlockAt(n);
        try {
            try {
                realModeCodeBlock.getX86Length();
            }
            catch (NullPointerException nullPointerException) {
                realModeCodeBlock = codeBlockManager.getRealModeCodeBlockAt(this, n);
            }
        }
        catch (CodeBlockReplacementException codeBlockReplacementException) {
            realModeCodeBlock = (RealModeCodeBlock)codeBlockReplacementException.getReplacement();
            this.setRealCodeBlockAt(n, realModeCodeBlock);
        }
        return realModeCodeBlock;
    }

    private int executeVirtual8086(Processor processor, int n) {
        int n2 = 0;
        int n3 = processor.getInstructionPointer();
        int n4 = n3 & 0xFFFFF000;
        do {
            try {
                n = n3 & 0xFFF;
                Virtual8086ModeCodeBlock virtual8086ModeCodeBlock = this.getVirtual8086ModeCodeBlockAt(n);
                try {
                    try {
                        n2 += virtual8086ModeCodeBlock.execute(processor);
                    }
                    catch (NullPointerException nullPointerException) {
                        virtual8086ModeCodeBlock = codeBlockManager.getVirtual8086ModeCodeBlockAt(this, n);
                        n2 += virtual8086ModeCodeBlock.execute(processor);
                    }
                }
                catch (CodeBlockReplacementException codeBlockReplacementException) {
                    virtual8086ModeCodeBlock = (Virtual8086ModeCodeBlock)codeBlockReplacementException.getReplacement();
                    this.setVirtual8086CodeBlockAt(n, virtual8086ModeCodeBlock);
                    n2 += virtual8086ModeCodeBlock.execute(processor);
                }
                processor.processVirtual8086ModeInterrupts();
            }
            catch (ProcessorException processorException) {
                processor.handleVirtual8086ModeException(processorException.getVector(), processorException.hasErrorCode(), processorException.getErrorCode());
            }
        } while (((n3 = processor.getInstructionPointer()) & 0xFFFFF000) == n4);
        return n2;
    }

    private CodeBlock decodeVirtual8086(Processor processor, int n) {
        Virtual8086ModeCodeBlock virtual8086ModeCodeBlock = this.getVirtual8086ModeCodeBlockAt(n);
        try {
            try {
                virtual8086ModeCodeBlock.getX86Length();
            }
            catch (NullPointerException nullPointerException) {
                virtual8086ModeCodeBlock = codeBlockManager.getVirtual8086ModeCodeBlockAt(this, n);
                virtual8086ModeCodeBlock.getX86Length();
            }
        }
        catch (CodeBlockReplacementException codeBlockReplacementException) {
            virtual8086ModeCodeBlock = (Virtual8086ModeCodeBlock)codeBlockReplacementException.getReplacement();
            this.setVirtual8086CodeBlockAt(n, virtual8086ModeCodeBlock);
        }
        return virtual8086ModeCodeBlock;
    }

    private RealModeCodeBlock getRealModeCodeBlockAt(int n) {
        return this.realCodeBuffer[n];
    }

    private ProtectedModeCodeBlock getProtectedModeCodeBlockAt(int n) {
        return this.protectedCodeBuffer[n];
    }

    private Virtual8086ModeCodeBlock getVirtual8086ModeCodeBlockAt(int n) {
        return this.virtual8086CodeBuffer[n];
    }

    private void removeVirtual8086CodeBlockAt(int n) {
        int n2;
        Virtual8086ModeCodeBlock virtual8086ModeCodeBlock = this.virtual8086CodeBuffer[n];
        if (virtual8086ModeCodeBlock == null || virtual8086ModeCodeBlock == PLACEHOLDER) {
            return;
        }
        this.virtual8086CodeBuffer[n] = null;
        int n3 = virtual8086ModeCodeBlock.getX86Length();
        for (n2 = n + 1; n2 < n + n3 && n2 < this.virtual8086CodeBuffer.length; ++n2) {
            if (this.virtual8086CodeBuffer[n2] != PLACEHOLDER) continue;
            this.virtual8086CodeBuffer[n2] = null;
        }
        for (n2 = Math.min(n + n3, this.virtual8086CodeBuffer.length) - 1; n2 >= 0; --n2) {
            if (this.virtual8086CodeBuffer[n2] == null) {
                if (n2 >= n) continue;
                break;
            }
            if (this.virtual8086CodeBuffer[n2] == PLACEHOLDER) continue;
            Virtual8086ModeCodeBlock virtual8086ModeCodeBlock2 = this.virtual8086CodeBuffer[n2];
            n3 = virtual8086ModeCodeBlock2.getX86Length();
            for (int i = n2 + 1; i < n2 + n3 && i < this.virtual8086CodeBuffer.length; ++i) {
                if (this.virtual8086CodeBuffer[i] != null) continue;
                this.virtual8086CodeBuffer[i] = PLACEHOLDER;
            }
        }
    }

    private void removeProtectedCodeBlockAt(int n) {
        int n2;
        ProtectedModeCodeBlock protectedModeCodeBlock = this.protectedCodeBuffer[n];
        if (protectedModeCodeBlock == null || protectedModeCodeBlock == PLACEHOLDER) {
            return;
        }
        this.protectedCodeBuffer[n] = null;
        int n3 = protectedModeCodeBlock.getX86Length();
        for (n2 = n + 1; n2 < n + n3 && n2 < this.protectedCodeBuffer.length; ++n2) {
            if (this.protectedCodeBuffer[n2] != PLACEHOLDER) continue;
            this.protectedCodeBuffer[n2] = null;
        }
        for (n2 = Math.min(n + n3, this.protectedCodeBuffer.length) - 1; n2 >= 0; --n2) {
            if (this.protectedCodeBuffer[n2] == null) {
                if (n2 >= n) continue;
                break;
            }
            if (this.protectedCodeBuffer[n2] == PLACEHOLDER) continue;
            ProtectedModeCodeBlock protectedModeCodeBlock2 = this.protectedCodeBuffer[n2];
            n3 = protectedModeCodeBlock2.getX86Length();
            for (int i = n2 + 1; i < n2 + n3 && i < this.protectedCodeBuffer.length; ++i) {
                if (this.protectedCodeBuffer[i] != null) continue;
                this.protectedCodeBuffer[i] = PLACEHOLDER;
            }
        }
    }

    private void removeRealCodeBlockAt(int n) {
        int n2;
        RealModeCodeBlock realModeCodeBlock = this.realCodeBuffer[n];
        if (realModeCodeBlock == null || realModeCodeBlock == PLACEHOLDER) {
            return;
        }
        this.realCodeBuffer[n] = null;
        int n3 = realModeCodeBlock.getX86Length();
        for (n2 = n + 1; n2 < n + n3 && n2 < this.realCodeBuffer.length; ++n2) {
            if (this.realCodeBuffer[n2] != PLACEHOLDER) continue;
            this.realCodeBuffer[n2] = null;
        }
        for (n2 = Math.min(n + n3, this.realCodeBuffer.length) - 1; n2 >= 0; --n2) {
            if (this.realCodeBuffer[n2] == null) {
                if (n2 >= n) continue;
                break;
            }
            if (this.realCodeBuffer[n2] == PLACEHOLDER) continue;
            RealModeCodeBlock realModeCodeBlock2 = this.realCodeBuffer[n2];
            n3 = realModeCodeBlock2.getX86Length();
            for (int i = n2 + 1; i < n2 + n3 && i < this.realCodeBuffer.length; ++i) {
                if (this.realCodeBuffer[i] != null) continue;
                this.realCodeBuffer[i] = PLACEHOLDER;
            }
        }
    }

    public void setVirtual8086CodeBlockAt(int n, Virtual8086ModeCodeBlock virtual8086ModeCodeBlock) {
        this.removeVirtual8086CodeBlockAt(n);
        if (virtual8086ModeCodeBlock == null) {
            return;
        }
        this.virtual8086CodeBuffer[n] = virtual8086ModeCodeBlock;
        int n2 = virtual8086ModeCodeBlock.getX86Length();
        for (int i = n + 1; i < n + n2 && i < this.virtual8086CodeBuffer.length; ++i) {
            if (this.virtual8086CodeBuffer[i] != null) continue;
            this.virtual8086CodeBuffer[i] = PLACEHOLDER;
        }
    }

    public void setProtectedCodeBlockAt(int n, ProtectedModeCodeBlock protectedModeCodeBlock) {
        this.removeProtectedCodeBlockAt(n);
        if (protectedModeCodeBlock == null) {
            return;
        }
        this.protectedCodeBuffer[n] = protectedModeCodeBlock;
        int n2 = protectedModeCodeBlock.getX86Length();
        for (int i = n + 1; i < n + n2 && i < this.protectedCodeBuffer.length; ++i) {
            if (this.protectedCodeBuffer[i] != null) continue;
            this.protectedCodeBuffer[i] = PLACEHOLDER;
        }
    }

    public void setRealCodeBlockAt(int n, RealModeCodeBlock realModeCodeBlock) {
        this.removeRealCodeBlockAt(n);
        if (realModeCodeBlock == null) {
            return;
        }
        this.realCodeBuffer[n] = realModeCodeBlock;
        int n2 = realModeCodeBlock.getX86Length();
        for (int i = n + 1; i < n + n2 && i < this.realCodeBuffer.length; ++i) {
            if (this.realCodeBuffer[i] != null) continue;
            this.realCodeBuffer[i] = PLACEHOLDER;
        }
    }

    protected void regionAltered(int n, int n2) {
        CodeBlock codeBlock;
        int n3;
        for (n3 = n2; n3 >= 0; --n3) {
            codeBlock = this.realCodeBuffer[n3];
            if (codeBlock == null) {
                if (n3 >= n) continue;
                break;
            }
            if (codeBlock == PLACEHOLDER || codeBlock.handleMemoryRegionChange(n, n2)) continue;
            this.removeRealCodeBlockAt(n3);
        }
        for (n3 = n2; n3 >= 0; --n3) {
            codeBlock = this.protectedCodeBuffer[n3];
            if (codeBlock == null) {
                if (n3 >= n) continue;
                break;
            }
            if (codeBlock == PLACEHOLDER || codeBlock.handleMemoryRegionChange(n, n2)) continue;
            this.removeProtectedCodeBlockAt(n3);
        }
        for (n3 = n2; n3 >= 0; --n3) {
            codeBlock = this.virtual8086CodeBuffer[n3];
            if (codeBlock == null) {
                if (n3 >= n) continue;
                break;
            }
            if (codeBlock == PLACEHOLDER || codeBlock.handleMemoryRegionChange(n, n2)) continue;
            this.removeVirtual8086CodeBlockAt(n3);
        }
    }

    @Override
    public void copyContentsFrom(int n, byte[] byArray, int n2, int n3) {
        super.copyContentsFrom(n, byArray, n2, n3);
        this.regionAltered(n, n + n3 - 1);
    }

    @Override
    public void setByte(int n, byte by) {
        if (super.getByte(n) == by) {
            return;
        }
        super.setByte(n, by);
        this.regionAltered(n, n);
    }

    @Override
    public void setWord(int n, short s) {
        if (super.getWord(n) == s) {
            return;
        }
        super.setWord(n, s);
        this.regionAltered(n, n + 1);
    }

    @Override
    public void setDoubleWord(int n, int n2) {
        if (super.getDoubleWord(n) == n2) {
            return;
        }
        super.setDoubleWord(n, n2);
        this.regionAltered(n, n + 3);
    }

    @Override
    public void clear() {
        this.constructCodeBlocksArray();
        super.clear();
    }

    @Override
    public String toString() {
        return "LazyCodeBlockMemory[" + this.getSize() + "]";
    }

    public static void dispose() {
        if (codeBlockManager != null) {
            codeBlockManager.dispose();
        }
        codeBlockManager = null;
    }

    static {
        PLACEHOLDER = new BlankCodeBlock(0, 0);
    }
}

