/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.InstructionSource;
import dioscuri.module.cpu32.MicrocodeSet;
import java.lang.reflect.Field;
import java.util.Vector;

public class MicrocodeNode
implements MicrocodeSet {
    private boolean hasImmediate;
    private int microcode;
    private int x86Position;
    private int immediate;
    private int x86Index;
    private static final String[] microcodeNames;

    public MicrocodeNode(int n, int n2, int n3) {
        this.x86Index = n3;
        this.x86Position = n2;
        this.microcode = n;
        this.hasImmediate = false;
    }

    public MicrocodeNode(int n, int n2, int n3, int n4) {
        this.x86Index = n3;
        this.x86Position = n2;
        this.microcode = n;
        this.immediate = n4;
        this.hasImmediate = true;
    }

    public int getMicrocode() {
        return this.microcode;
    }

    public int getX86Index() {
        return this.x86Index;
    }

    public int getX86Position() {
        return this.x86Position;
    }

    public boolean hasImmediate() {
        return this.hasImmediate;
    }

    public int getImmediate() {
        return this.immediate;
    }

    public String toString() {
        return MicrocodeNode.getName(this.microcode);
    }

    public static String getName(int n) {
        try {
            return microcodeNames[n];
        }
        catch (Exception exception) {
            return "Invalid[" + n + "]";
        }
    }

    private static boolean hasImmediate(int n) {
        switch (n) {
            case 3: 
            case 8: 
            case 13: 
            case 26: 
            case 27: 
            case 49: 
            case 168: 
            case 229: 
            case 255: 
            case 300: {
                return true;
            }
        }
        return false;
    }

    public static MicrocodeNode[] getMicrocodes(InstructionSource instructionSource) {
        int n = 0;
        int n2 = 0;
        Vector<MicrocodeNode> vector = new Vector<MicrocodeNode>();
        while (instructionSource.getNext()) {
            n += instructionSource.getX86Length();
            ++n2;
            int n3 = instructionSource.getLength();
            for (int i = 0; i < n3; ++i) {
                int n4 = instructionSource.getMicrocode();
                MicrocodeNode microcodeNode = null;
                if (MicrocodeNode.hasImmediate(n4)) {
                    microcodeNode = new MicrocodeNode(n4, n, n2, instructionSource.getMicrocode());
                    ++i;
                } else {
                    microcodeNode = new MicrocodeNode(n4, n, n2);
                }
                vector.add(microcodeNode);
            }
        }
        MicrocodeNode[] microcodeNodeArray = new MicrocodeNode[vector.size()];
        vector.toArray(microcodeNodeArray);
        return microcodeNodeArray;
    }

    static {
        Field[] fieldArray = MicrocodeSet.class.getDeclaredFields();
        microcodeNames = new String[753];
        for (int i = 0; i < fieldArray.length; ++i) {
            if ("MICROCODE_LIMIT".equals(fieldArray[i].getName())) continue;
            try {
                MicrocodeNode.microcodeNames[fieldArray[i].getInt(null)] = fieldArray[i].getName();
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

