/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.mouse;

import dioscuri.Emulator;
import dioscuri.interfaces.Module;
import dioscuri.interfaces.UART;
import dioscuri.module.ModuleKeyboard;
import dioscuri.module.ModuleMouse;
import dioscuri.module.ModuleSerialPort;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Mouse
extends ModuleMouse
implements UART {
    private Queue<Byte> buffer;
    private boolean mouseEnabled;
    private int mouseType;
    private int mouseMode;
    private int mousePreviousMode;
    private byte lastMouseCommand;
    private boolean expectingMouseParameter;
    private int imRequest;
    private boolean imMode;
    private byte sampleRate = (byte)100;
    private int resolutionCpmm = 4;
    private int scaling = 1;
    private int delayed_dx = 0;
    private int delayed_dy = 0;
    private int delayed_dz = 0;
    private byte buttonStatus;
    private MouseEvent mouseEvent;
    private static Logger logger = Logger.getLogger("dioscuri.module.mouse");
    private static final int MOUSE_TYPE_PS2 = 1;
    private static final int MOUSE_TYPE_IMPS2 = 2;
    private static final int MOUSE_TYPE_SERIAL = 3;
    private static final int MOUSE_TYPE_SERIAL_WHEEL = 4;
    private static final int MOUSE_MODE_WRAP = 1;
    private static final int MOUSE_MODE_STREAM = 2;
    private static final int MOUSE_MODE_REMOTE = 3;
    private static final int MOUSE_MODE_RESET = 4;
    private static final byte MOUSE_CMD_ACK = -6;
    private static final byte MOUSE_CMD_COMPLETION = -86;
    private static final byte MOUSE_CMD_ID = 0;
    private static final byte MOUSE_CMD_RESEND = -2;
    private static final int MOUSE_BUFFER_SIZE = 16;
    final int pointerWidth = 90;
    final int pointerHeight = 25;
    final double scaleX = 7.888888888888889;
    final double scaleY = 16.0;

    public Mouse(Emulator emulator) {
        this.buffer = new LinkedList<Byte>();
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] " + this.getClass().getName() + " -> AbstractModule created successfully.");
    }

    @Override
    public boolean reset() {
        this.lastMouseCommand = 0;
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " AbstractModule has been reset.");
        return true;
    }

    @Override
    public String getDump() {
        String string = "Mouse status:\n";
        return string;
    }

    @Override
    public void setMouseEnabled(boolean bl) {
        this.mouseEnabled = bl;
    }

    @Override
    public void setMouseType(String string) {
        ModuleSerialPort moduleSerialPort = (ModuleSerialPort)super.getConnection(Module.Type.SERIALPORT);
        if (string.equalsIgnoreCase("serial")) {
            this.mouseType = 3;
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Mouse type set to serial");
            if (moduleSerialPort.setUARTDevice(this, 0)) {
                logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] Mouse connected to COM port 1");
            } else {
                logger.log(Level.SEVERE, "[" + (Object)((Object)super.getType()) + "] Could not connect mouse to COM port 1");
            }
        } else if (string.equalsIgnoreCase("ps/2")) {
            this.mouseType = 1;
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Mouse type set to PS/2");
        } else {
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Mouse type not recognised: set to default (serial)");
            this.mouseType = 3;
        }
    }

    @Override
    public boolean isBufferEmpty() {
        return this.buffer.isEmpty();
    }

    @Override
    public void storeBufferData(boolean bl) {
        byte by = -121;
        byte by2 = (byte)((double)this.mouseEvent.getX() / 7.888888888888889 - 45.0);
        byte by3 = (byte)(-((double)this.mouseEvent.getY() / 16.0 - 12.5));
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] moved to (" + by2 + "," + by3 + ")");
        if (this.mouseEvent != null && this.mouseEvent.getID() == 501) {
            if (this.mouseEvent.getButton() == 1) {
                by = (byte)(by & 0xFB);
            }
            if (this.mouseEvent.getButton() == 2) {
                by = (byte)(by & 0xFD);
            }
            if (this.mouseEvent.getButton() == 3) {
                by = (byte)(by & 0xFE);
            }
        }
        if (this.enqueueData(by, by2, by3, (byte)0, (byte)0)) {
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Mouse data stored in mouse buffer. Total bytes in buffer: " + this.buffer.size());
        } else {
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Mouse data could not be stored in mouse buffer");
        }
    }

    private boolean enqueueData(byte by, byte by2, byte by3, byte by4, byte by5) {
        return this.buffer.offer(by) && this.buffer.offer(by2) && this.buffer.offer(by3) && this.buffer.offer(by4) && this.buffer.offer(by5);
    }

    @Override
    public byte getDataFromBuffer() {
        return this.buffer.isEmpty() ? (byte)-1 : this.buffer.poll();
    }

    @Override
    public void controlMouse(byte by) {
        ModuleKeyboard moduleKeyboard = (ModuleKeyboard)super.getConnection(Module.Type.KEYBOARD);
        boolean bl = false;
        if (this.mouseType == 1 || this.mouseType == 2) {
            bl = true;
        }
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] kbd_ctrl_to_mouse " + by);
        if (this.expectingMouseParameter) {
            this.expectingMouseParameter = false;
            switch (this.lastMouseCommand) {
                case -13: {
                    this.sampleRate = by;
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Sampling rate set to " + by);
                    if (by == 200 && this.imRequest == 0) {
                        this.imRequest = 1;
                    } else if (by == 100 && this.imRequest == 1) {
                        this.imRequest = 2;
                    } else if (by == 80 && this.imRequest == 2) {
                        if (this.mouseType == 2) {
                            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Wheel mouse mode enabled");
                            this.imMode = true;
                        } else {
                            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Wheel mouse mode request rejected");
                        }
                        this.imRequest = 0;
                    } else {
                        this.imRequest = 0;
                    }
                    moduleKeyboard.enqueueControllerBuffer((byte)-6, 1);
                    break;
                }
                case -24: {
                    switch (by) {
                        case 0: {
                            this.resolutionCpmm = 1;
                            break;
                        }
                        case 1: {
                            this.resolutionCpmm = 2;
                            break;
                        }
                        case 2: {
                            this.resolutionCpmm = 4;
                            break;
                        }
                        case 3: {
                            this.resolutionCpmm = 8;
                            break;
                        }
                        default: {
                            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Unknown resolution");
                        }
                    }
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Resolution set to " + this.resolutionCpmm + " counts per mm");
                    moduleKeyboard.enqueueControllerBuffer((byte)-6, 1);
                    break;
                }
                default: {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] unknown last command " + this.lastMouseCommand);
                    break;
                }
            }
        } else {
            this.expectingMouseParameter = false;
            this.lastMouseCommand = by;
            if (this.mouseMode == 1 && by != 255 && by != 236) {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Wrap mode: ignoring command " + by);
                moduleKeyboard.enqueueControllerBuffer(by, 1);
                return;
            }
            switch (by) {
                case -69: {
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Ignoring command 0xBB");
                    break;
                }
                case -26: {
                    moduleKeyboard.enqueueControllerBuffer((byte)-6, 1);
                    this.scaling = 2;
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Scaling set to 1:1");
                    break;
                }
                case -25: {
                    moduleKeyboard.enqueueControllerBuffer((byte)-6, 1);
                    this.scaling = 2;
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Scaling set to 2:1");
                    break;
                }
                case -24: {
                    moduleKeyboard.enqueueControllerBuffer((byte)-6, 1);
                    this.expectingMouseParameter = true;
                    break;
                }
                case -23: {
                    moduleKeyboard.enqueueControllerBuffer((byte)-6, 1);
                    moduleKeyboard.enqueueControllerBuffer(this.getStatusByte(), 1);
                    moduleKeyboard.enqueueControllerBuffer(this.getResolutionByte(), 1);
                    moduleKeyboard.enqueueControllerBuffer(this.sampleRate, 1);
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Mouse information returned");
                    break;
                }
                case -22: {
                    this.mouseMode = 2;
                    moduleKeyboard.enqueueControllerBuffer((byte)-6, 1);
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Stream mode on");
                    break;
                }
                case -21: {
                    moduleKeyboard.enqueueControllerBuffer((byte)-6, 1);
                    this.enqueueData((byte)(this.buttonStatus & 0xF | 8), (byte)0, (byte)0, (byte)0, (byte)0);
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Read Data command partially supported");
                    break;
                }
                case -20: {
                    if (this.mouseMode != 1) break;
                    this.mouseMode = this.mousePreviousMode;
                    moduleKeyboard.enqueueControllerBuffer((byte)-6, 1);
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Wrap mode off. Set to previous mode");
                    break;
                }
                case -18: {
                    this.mousePreviousMode = this.mouseMode;
                    this.mouseMode = 1;
                    moduleKeyboard.enqueueControllerBuffer((byte)-6, 1);
                    logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] Wrap mode on");
                    break;
                }
                case -16: {
                    this.mouseMode = 3;
                    moduleKeyboard.enqueueControllerBuffer((byte)-6, 1);
                    logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] Remote mode on");
                    break;
                }
                case -14: {
                    moduleKeyboard.enqueueControllerBuffer((byte)-6, 1);
                    if (this.imMode) {
                        moduleKeyboard.enqueueControllerBuffer((byte)3, 1);
                    } else {
                        moduleKeyboard.enqueueControllerBuffer((byte)0, 1);
                    }
                    logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] Read mouse ID");
                    break;
                }
                case -13: {
                    moduleKeyboard.enqueueControllerBuffer((byte)-6, 1);
                    this.expectingMouseParameter = true;
                    break;
                }
                case -12: {
                    if (bl) {
                        this.mouseEnabled = true;
                        moduleKeyboard.enqueueControllerBuffer((byte)-6, 1);
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] Mouse enabled (stream mode)");
                        break;
                    }
                    moduleKeyboard.enqueueControllerBuffer((byte)-2, 1);
                    moduleKeyboard.setTimeOut((byte)1);
                    break;
                }
                case -11: {
                    this.mouseEnabled = false;
                    moduleKeyboard.enqueueControllerBuffer((byte)-6, 1);
                    logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] Mouse disabled (stream mode)");
                    break;
                }
                case -10: {
                    this.sampleRate = (byte)100;
                    this.resolutionCpmm = 4;
                    this.scaling = 1;
                    this.mouseEnabled = false;
                    this.mouseMode = 2;
                    moduleKeyboard.enqueueControllerBuffer((byte)-6, 1);
                    logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] Mouse set to default settings");
                    break;
                }
                case -1: {
                    if (bl) {
                        this.sampleRate = (byte)100;
                        this.resolutionCpmm = 4;
                        this.scaling = 1;
                        this.mouseEnabled = false;
                        this.mouseMode = 4;
                        if (this.imMode) {
                            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] Wheel mouse mode disabled");
                        }
                        this.imMode = false;
                        moduleKeyboard.enqueueControllerBuffer((byte)-6, 1);
                        moduleKeyboard.enqueueControllerBuffer((byte)-86, 1);
                        moduleKeyboard.enqueueControllerBuffer((byte)0, 1);
                        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] Mouse has been reset");
                        break;
                    }
                    moduleKeyboard.enqueueControllerBuffer((byte)-2, 1);
                    moduleKeyboard.setTimeOut((byte)1);
                    break;
                }
                default: {
                    if (!bl) break;
                    logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] kbd_ctrl_to_mouse(): no command match");
                    moduleKeyboard.enqueueControllerBuffer((byte)-2, 1);
                }
            }
        }
    }

    @Override
    public void mouseMotion(MouseEvent mouseEvent) {
        this.mouseEvent = mouseEvent;
        this.delayed_dx = mouseEvent.getX();
        this.delayed_dy = mouseEvent.getY();
        this.delayed_dz = mouseEvent.getButton();
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] delayed :: (" + this.delayed_dx + "," + this.delayed_dy + ")");
        boolean bl = true;
        if (this.mouseType == 3 || this.mouseType == 4) {
            this.storeBufferData(bl);
        }
    }

    private byte getStatusByte() {
        byte by = (byte)(this.mouseMode == 3 ? 64 : 0);
        by = (byte)(by | (this.mouseEnabled ? 1 : 0) << 5);
        by = (byte)(by | (this.scaling == 1 ? 0 : 16));
        by = (byte)(by | (this.buttonStatus & 1) << 2);
        by = (byte)(by | (this.buttonStatus & 2) << 0);
        return by;
    }

    private byte getResolutionByte() {
        byte by = 0;
        switch (this.resolutionCpmm) {
            case 1: {
                by = 0;
                break;
            }
            case 2: {
                by = 1;
                break;
            }
            case 4: {
                by = 2;
                break;
            }
            case 8: {
                by = 3;
                break;
            }
            default: {
                logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Invalid resolution cpmm");
            }
        }
        return by;
    }

    @Override
    public synchronized boolean isDataAvailable() {
        return !this.buffer.isEmpty();
    }

    @Override
    public synchronized byte getSerialData() {
        return this.buffer.isEmpty() ? (byte)-1 : this.buffer.poll();
    }

    @Override
    public synchronized void setSerialData(byte by) {
        this.buffer.offer(by);
    }
}

