/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.rtc;

import dioscuri.Emulator;
import dioscuri.exception.ModuleException;
import dioscuri.exception.UnknownPortException;
import dioscuri.exception.WriteOnlyPortException;
import dioscuri.interfaces.Module;
import dioscuri.module.ModuleMotherboard;
import dioscuri.module.ModulePIC;
import dioscuri.module.ModuleRTC;
import dioscuri.module.rtc.CMOS;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RTC
extends ModuleRTC {
    CMOS cmos = new CMOS();
    private boolean systemTime = false;
    private static final Logger logger = Logger.getLogger(RTC.class.getName());
    private boolean disableNMI;
    private int irqNumber = -1;
    protected int lookupRegister;
    private static final int OUT_PORT = 112;
    private static final int IN_PORT = 113;

    public RTC(Emulator emulator) {
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] " + " AbstractModule created successfully.");
    }

    @Override
    public boolean reset() {
        ModuleMotherboard moduleMotherboard = (ModuleMotherboard)super.getConnection(Module.Type.MOTHERBOARD);
        ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
        this.cmos.reset(this.systemTime);
        if (this.systemTime) {
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] CMOS clock set to host machine's values: " + this.cmos.getClockValue());
        } else {
            logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] CMOS clock set to user-defined values: " + this.cmos.getClockValue());
        }
        moduleMotherboard.setIOPort(112, this);
        moduleMotherboard.setIOPort(113, this);
        this.lookupRegister = 0;
        this.irqNumber = modulePIC.requestIRQNumber(this);
        if (this.irqNumber > -1) {
            logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] IRQ number set to: " + this.irqNumber);
        } else {
            logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Request of IRQ number failed.");
        }
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] AbstractModule has been reset.");
        return true;
    }

    @Override
    public String getDump() {
        String string = "Dump of RTC/CMOS registers 0x00 - 0x2F and checksum regs:\n";
        string = string + "Reg\tVal(hex)\tVal(BCD)\n";
        DecimalFormat decimalFormat = new DecimalFormat("00");
        for (int i = 0; i <= 47; ++i) {
            string = string + "0x" + Integer.toHexString(0x100 | i & 0xFF).substring(1).toUpperCase();
            string = string + "\t";
            string = string + "[" + Integer.toHexString(0x100 | this.cmos.ram[i] & 0xFF).substring(1).toUpperCase() + "]";
            string = string + "\t";
            string = string + "[" + decimalFormat.format(this.cmos.ram[i]) + "]";
            string = string + "\n";
        }
        return string;
    }

    public int getUpdateInterval() {
        return -1;
    }

    public void setUpdateInterval(int n) {
    }

    public void update() {
    }

    @Override
    public byte getIOPortByte(int n) throws UnknownPortException, WriteOnlyPortException {
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " IO read from " + n);
        switch (n) {
            case 112: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " IN command (byte) from port 0x" + Integer.toHexString(n).toUpperCase() + "; Returned 0xFF");
                return -1;
            }
            case 113: {
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " IN command (byte) from register 0x" + Integer.toHexString(this.lookupRegister).toUpperCase() + ": 0x" + Integer.toHexString(this.cmos.ram[this.lookupRegister]).toUpperCase());
                if (this.lookupRegister == 12) {
                    this.cmos.ram[12] = 0;
                    ModulePIC modulePIC = (ModulePIC)super.getConnection(Module.Type.PIC);
                    modulePIC.clearIRQ(this.irqNumber);
                }
                return this.cmos.ram[this.lookupRegister];
            }
        }
        throw new UnknownPortException("[" + (Object)((Object)super.getType()) + "] Unknown I/O port requested");
    }

    @Override
    public void setIOPortByte(int n, byte by) throws UnknownPortException {
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "]" + " IO write to " + n + " = " + by);
        this.disableNMI = (by & 0x80) == 1;
        switch (n) {
            case 112: {
                this.lookupRegister = by & 0x7F;
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " OUT command (byte) to port 0x" + Integer.toHexString(n).toUpperCase() + ": lookup byte set to 0x" + Integer.toHexString(this.lookupRegister).toUpperCase());
                return;
            }
            case 113: {
                if (this.lookupRegister != 12 && this.lookupRegister != 13) {
                    this.cmos.ram[this.lookupRegister] = by;
                }
                logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "]" + " OUT command (byte) to port 0x" + Integer.toHexString(n).toUpperCase() + " [0x" + Integer.toHexString(this.lookupRegister).toUpperCase() + "] set to: 0x" + Integer.toHexString(by).toUpperCase());
                return;
            }
        }
        throw new UnknownPortException("[" + (Object)((Object)super.getType()) + "] Unknown I/O port requested");
    }

    @Override
    public byte[] getIOPortWord(int n) throws ModuleException, WriteOnlyPortException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] IN command (word) from port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Returned default value 0xFFFF to AX");
        return new byte[]{-1, -1};
    }

    @Override
    public void setIOPortWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] OUT command (word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte[] getIOPortDoubleWord(int n) throws ModuleException, WriteOnlyPortException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] IN command (double word) from port " + Integer.toHexString(n).toUpperCase() + " received");
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] Returned default value 0xFFFFFFFF to eAX");
        return new byte[]{-1, -1, -1, -1};
    }

    @Override
    public void setIOPortDoubleWord(int n, byte[] byArray) throws ModuleException {
        logger.log(Level.WARNING, "[" + (Object)((Object)super.getType()) + "] OUT command (double word) to port " + Integer.toHexString(n).toUpperCase() + " received. No action taken.");
    }

    @Override
    public byte getCMOSRegister(int n) {
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] Returned CMOS register " + n + ": 0x" + Integer.toHexString(this.cmos.ram[n]).toUpperCase());
        return this.cmos.ram[n];
    }

    @Override
    public void setCMOSRegister(int n, byte by) {
        logger.log(Level.CONFIG, "[" + (Object)((Object)super.getType()) + "] Set CMOS register " + n + ": 0x" + Integer.toHexString(by).toUpperCase());
        this.cmos.ram[n] = by;
    }

    @Override
    public void updateClock() {
        this.cmos.setClockValue(1);
        logger.log(Level.INFO, "[" + (Object)((Object)super.getType()) + "] CMOS clock updated: " + this.cmos.getClockValue());
    }
}

