/*
 * Decompiled with CFR 0.152.
 */
package gnu.awt;

import gnu.awt.Point;

public class Rectangle {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public Rectangle intersection(Rectangle r) {
        int x1 = Math.max(this.x, r.x);
        int x2 = Math.min(this.x + this.width, r.x + r.width);
        int y1 = Math.max(this.y, r.y);
        int y2 = Math.min(this.y + this.height, r.y + r.height);
        if (x2 - x1 < 0 || y2 - y1 < 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public boolean contains(Point p) {
        return p.x >= this.x && p.y >= this.y && p.x - this.x < this.width && p.y - this.y < this.height;
    }

    public boolean contains(Rectangle r) {
        if (this.width <= 0 || this.height <= 0 || r.width <= 0 || r.height <= 0) {
            return false;
        }
        return r.x >= this.x && r.y >= this.y && r.x + r.width < this.x + this.width && r.y + r.height < this.y + this.height;
    }
}

