/*
 * Decompiled with CFR 0.152.
 */
package gnu.rfb;

import gnu.rfb.PixelFormat;
import gnu.rfb.RRE;
import java.io.DataOutput;
import java.io.IOException;

public class CoRRE
extends RRE {
    public CoRRE(int[] pixels, PixelFormat pixelFormat, int offsetX, int offsetY, int scanline, int x, int y, int w, int h) {
        super(pixels, pixelFormat, offsetX, offsetY, scanline, x, y, w, h);
    }

    public CoRRE(int x, int y, int w, int h, PixelFormat pixelFormat, int bgpixel, RRE.SubRect[] subrects) {
        super(x, y, w, h, pixelFormat, bgpixel, subrects);
    }

    @Override
    public void writeData(DataOutput output) throws IOException {
        output.writeShort(this.x);
        output.writeShort(this.y);
        output.writeShort(this.w);
        output.writeShort(this.h);
        output.writeInt(4);
        output.writeInt(this.subrects.length);
        CoRRE.writePixel(output, this.pixelFormat, this.bgpixel);
        int i = 0;
        while (i < this.subrects.length) {
            CoRRE.writePixel(output, this.pixelFormat, this.subrects[i].pixel);
            output.writeByte(this.subrects[i].x);
            output.writeByte(this.subrects[i].y);
            output.writeByte(this.subrects[i].w);
            output.writeByte(this.subrects[i].h);
            ++i;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RRE.SubRect[] subrectsClone = new RRE.SubRect[this.subrects.length];
        int i = 0;
        while (i < this.subrects.length) {
            subrectsClone[i] = new RRE.SubRect();
            subrectsClone[i].pixel = this.subrects[i].pixel;
            subrectsClone[i].x = this.subrects[i].x;
            subrectsClone[i].y = this.subrects[i].y;
            subrectsClone[i].w = this.subrects[i].w;
            subrectsClone[i].h = this.subrects[i].h;
            ++i;
        }
        return new CoRRE(this.x, this.y, this.w, this.h, this.pixelFormat, this.bgpixel, subrectsClone);
    }
}

