/*
 * Decompiled with CFR 0.152.
 */
package gnu.vnc;

import gnu.rfb.server.DefaultRFBAuthenticator;
import gnu.rfb.server.RFBHost;
import gnu.vnc.WebServer;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class VNCHost {
    public static void main(String[] args) {
        ResourceBundle properties = null;
        try {
            properties = ResourceBundle.getBundle("vncj");
        }
        catch (MissingResourceException x) {
            System.err.println("Can't load 'vncj.properties'.");
            return;
        }
        DefaultRFBAuthenticator authenticator = new DefaultRFBAuthenticator("password");
        Enumeration<String> e = properties.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (!key.startsWith("class.")) continue;
            int display = Integer.parseInt(key.substring(6));
            String serverClassName = properties.getString(key);
            String displayName = properties.getString("name." + display);
            System.out.println(displayName);
            try {
                Class<?> serverClass = Class.forName(serverClassName);
                new RFBHost(display, displayName, serverClass, authenticator);
                new WebServer(display, displayName, 800, 600);
                System.out.println("  VNC display " + display);
                System.out.println("  Web server on port " + (5800 + display));
                System.out.println("  Class: " + serverClassName);
            }
            catch (ClassNotFoundException x) {
                System.out.println("  Could not load class: " + serverClassName);
            }
            catch (NoSuchMethodException x) {
                System.out.println("  Unsupported class: " + serverClassName);
            }
        }
    }
}

