/*
 * Decompiled with CFR 0.152.
 */
package gnu.vnc.console;

import gnu.rfb.Colour;
import gnu.rfb.PixelFormat;
import gnu.rfb.keysym;
import gnu.rfb.server.RFBClient;
import gnu.rfb.server.RFBClients;
import gnu.rfb.server.RFBServer;
import gnu.vnc.console.VNCConsoleBuffer;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public abstract class VNCConsole
implements RFBServer,
Runnable {
    private String displayName;
    private int columns;
    private int rows;
    private Dimension charSize;
    private VNCConsoleBuffer buffer;
    private RFBClients clients = new RFBClients();
    private boolean shared = false;
    protected InputStream in;
    protected PrintStream out;

    public VNCConsole(String displayName, int columns, int rows, int charW, int charH) {
        this.displayName = displayName;
        this.columns = columns;
        this.rows = rows;
        this.charSize = new Dimension(charW, charH);
        this.buffer = new VNCConsoleBuffer(columns, rows, this.charSize, this.clients);
        this.in = this.buffer.inputStream();
        this.out = this.buffer.printStream();
        new Thread(this).start();
    }

    public abstract void main();

    public void dispose() {
        this.clients.closeAll();
    }

    @Override
    public void addClient(RFBClient client) {
        this.clients.addClient(client);
    }

    @Override
    public void removeClient(RFBClient client) {
        this.clients.removeClient(client);
        if (this.clients.isEmpty() && !this.shared) {
            this.dispose();
        }
    }

    @Override
    public String getDesktopName(RFBClient client) {
        return this.displayName;
    }

    @Override
    public int getFrameBufferWidth(RFBClient client) {
        return this.columns * this.charSize.width;
    }

    @Override
    public int getFrameBufferHeight(RFBClient client) {
        return this.rows * this.charSize.height;
    }

    @Override
    public PixelFormat getPreferredPixelFormat(RFBClient client) {
        return PixelFormat.BGR233;
    }

    @Override
    public boolean allowShared() {
        return true;
    }

    @Override
    public void setClientProtocolVersionMsg(RFBClient client, String protocolVersionMsg) throws IOException {
    }

    @Override
    public void setShared(RFBClient client, boolean shared) throws IOException {
        if (shared) {
            this.shared = true;
        }
    }

    @Override
    public void setPixelFormat(RFBClient client, PixelFormat pixelFormat) throws IOException {
        pixelFormat.setDirectColorModel(this.buffer.getFont(client).getDirectColorModel());
    }

    @Override
    public void setEncodings(RFBClient client, int[] encodings) throws IOException {
    }

    @Override
    public void fixColourMapEntries(RFBClient client, int firstColour, Colour[] colourMap) throws IOException {
    }

    @Override
    public void frameBufferUpdateRequest(RFBClient client, boolean incremental, int x, int y, int w, int h) throws IOException {
        client.writeFrameBufferUpdate(this.buffer.getRects(client, incremental));
    }

    @Override
    public void keyEvent(RFBClient client, boolean down, int key) throws IOException {
        if (keysym.toMask(key) != 0) {
            return;
        }
        if (down) {
            int vk = keysym.toVK(key);
            if (vk == 0) {
                this.buffer.input(key);
            } else {
                this.buffer.inputVK(vk);
            }
        }
    }

    @Override
    public void pointerEvent(RFBClient client, int buttonMask, int x, int y) throws IOException {
    }

    @Override
    public void clientCutText(RFBClient client, String text) throws IOException {
    }

    @Override
    public void run() {
        this.main();
        this.dispose();
    }
}

