/*
    ARM9Core
    Copyright (C) 2007 Alberto Huerta Aranda,
	Sergio Hidalgo Serrano, Daniel Saudo Vacas

    This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 3 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
	License along with this library. If not, see <http://www.gnu.org/licenses/>

*/


#ifndef ARM9ContextoH
#define ARM9ContextoH

/**************************************************************************************

  Archivo: ARM9Contexto.h

  Descripcion: Contexto del procesador

**************************************************************************************/

#include "Utils.h"


class ARM9Contexto {
public:
	
	//Puntero al banco de registros actual dentro de la tabla
	ARM9Reg32 bancoRegistros[16];
	
	//Registros 13 y 14
	ARM9Reg32 tablaPunteros[6][2];
	//Registros FIQ 8-12
	ARM9Reg32 tablaFIQ[5];

	//Registros fisicos
	//Registros 0-7:  Prop. general, no banqueados
	//Registros 8-12: Prop. general, banqueados x2
	//Registro 13: Stack Pointer, banqueado x6
	//Registro 14: Dir. retorno subrutina, banqueado x6*/

	ARM9Reg32 *PC;			//Registro 15: Program Counter, no banqueado
	ARM9Reg32 SPSR[5];		//Saved Program Status Register, banqueado x5

	//Flags CPSR
	ARM9Mode modo;	//Modo del procesador
	int state;		//Estado del procesador (0 = ARM, 1 = THUMB)
	int fiqDis;		//FIQ disable
	int irqDis;		//IRQ disable

	union {
		struct {
			unsigned int v:1;	//Indicador de overflow
			unsigned int c:1;	//Indicador de Carry / Borrow / Extend
			unsigned int z:1;	//Indicador de resultado cero
			unsigned int n:1;	//Indicador de Negative / Less Than	
		} flags;

		unsigned int condFlags:4;
	};


//Mtodos

	ARM9Contexto ();

	void reset ();
	void cambiarModo (ARM9Mode nuevoModo);
	void escribirCPSR (uint32 nuevoCPSR);
	uint32 leerCPSR ();

	ARM9Mode bitsToMode (unsigned int bits);
	unsigned int modeToBits (ARM9Mode m);
};


#endif