/*
    ARM9Core
    Copyright (C) 2007 Alberto Huerta Aranda,
	Sergio Hidalgo Serrano, Daniel Saudo Vacas

    This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 3 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
	License along with this library. If not, see <http://www.gnu.org/licenses/>

*/


/**************************************************************************************

  Archivo: ARM9TablaARM.cpp

  Descripcion: Generacion de la tabla de saltos del modo ARM

**************************************************************************************/

	if (tablaGenerada == 0) {
		void *direccion;

		for (i = 0; i < 256; i++) {
			for (j = 0; j < 16; j++) {
				__asm {
					lea eax, RUT_undefined
					mov direccion, eax
				}
				tablaSaltos[i][j] = direccion;
			}
		}

		__asm{
			lea eax, RUT_add
			mov direccion, eax
		}
		for (j = 0; j < 16; j++) {
			tablaSaltos[0x28][j] = direccion;
			tablaSaltos[0x29][j] = direccion;
			tablaSaltos[0x08][j] = direccion;
			tablaSaltos[0x09][j] = direccion;
		}
		
		
		__asm{
			lea eax, RUT_adc
			mov direccion, eax
		}
		for (j = 0; j < 16; j++) {
			tablaSaltos[0x2A][j] = direccion;
			tablaSaltos[0x2B][j] = direccion;
			tablaSaltos[0x0A][j] = direccion;
			tablaSaltos[0x0B][j] = direccion;
		}

		__asm{
			lea eax, RUT_sub
			mov direccion, eax
		}
		for (j = 0; j < 16; j++) {
			tablaSaltos[0x24][j] = direccion;
			tablaSaltos[0x25][j] = direccion;
			tablaSaltos[0x04][j] = direccion;
			tablaSaltos[0x05][j] = direccion;
		}

		__asm{
			lea eax, RUT_sbc
			mov direccion, eax
		}
		for (j = 0; j < 16; j++) {
			tablaSaltos[0x2C][j] = direccion;
			tablaSaltos[0x2D][j] = direccion;
			tablaSaltos[0x0C][j] = direccion;
			tablaSaltos[0x0D][j] = direccion;
		}

		__asm{
			lea eax, RUT_rsb
			mov direccion, eax
		}
		for (j = 0; j < 16; j++) {
			tablaSaltos[0x26][j] = direccion;
			tablaSaltos[0x27][j] = direccion;
			tablaSaltos[0x06][j] = direccion;
			tablaSaltos[0x07][j] = direccion;
		}

		__asm{
			lea eax, RUT_rsc
			mov direccion, eax
		}
		for (j = 0; j < 16; j++) {
			tablaSaltos[0x2E][j] = direccion;
			tablaSaltos[0x2F][j] = direccion;
			tablaSaltos[0x0E][j] = direccion;
			tablaSaltos[0x0F][j] = direccion;
		}

		__asm{
			lea eax, RUT_mov
			mov direccion, eax
		}
		for (j = 0; j < 16; j++) {
			tablaSaltos[0x3A][j] = direccion;
			tablaSaltos[0x3B][j] = direccion;
			tablaSaltos[0x1A][j] = direccion;
			tablaSaltos[0x1B][j] = direccion;
		}

		__asm{
			lea eax, RUT_mvn
			mov direccion, eax
		}
		for (j = 0; j < 16; j++) {
			tablaSaltos[0x3E][j] = direccion;
			tablaSaltos[0x3F][j] = direccion;
			tablaSaltos[0x1E][j] = direccion;
			tablaSaltos[0x1F][j] = direccion;
		}

		__asm{
			lea eax, RUT_and
			mov direccion, eax
		}
		for (j = 0; j < 16; j++) {
			tablaSaltos[0x20][j] = direccion;
			tablaSaltos[0x21][j] = direccion;	
			tablaSaltos[0x00][j] = direccion;
			tablaSaltos[0x01][j] = direccion;
		}

		__asm{
			lea eax, RUT_eor
			mov direccion, eax
		}
		for (j = 0; j < 16; j++) {
			tablaSaltos[0x22][j] = direccion;
			tablaSaltos[0x23][j] = direccion;
			tablaSaltos[0x02][j] = direccion;
			tablaSaltos[0x03][j] = direccion;
		}

		__asm{
			lea eax, RUT_orr
			mov direccion, eax
		}
		for (j = 0; j < 16; j++) {
			tablaSaltos[0x38][j] = direccion;
			tablaSaltos[0x39][j] = direccion;
			tablaSaltos[0x18][j] = direccion;
			tablaSaltos[0x19][j] = direccion;
		}

		__asm{
			lea eax, RUT_bic
			mov direccion, eax
		}
		for (j = 0; j < 16; j++) {
			tablaSaltos[0x3C][j] = direccion;
			tablaSaltos[0x3D][j]= direccion;
			tablaSaltos[0x1C][j] = direccion;
			tablaSaltos[0x1D][j] = direccion;
		}

		__asm{
			lea eax, RUT_tst
			mov direccion, eax
		}
		for (j = 0; j < 16; j++) {
			//tablaSaltos[0x30][j] = direccion; //S = 0!
			tablaSaltos[0x31][j] = direccion;
			//tablaSaltos[0x10][j] = direccion; //S = 0!
			tablaSaltos[0x11][j] = direccion;
		}

		__asm{
			lea eax, RUT_teq
			mov direccion, eax
		}
		for (j = 0; j < 16; j++) {
			//tablaSaltos[0x32][j] = direccion; //S = 0!
			tablaSaltos[0x33][j] = direccion;
			//tablaSaltos[0x12][j] = direccion; //S = 0!
			tablaSaltos[0x13][j] = direccion;
		}

		__asm{
			lea eax, RUT_cmp
			mov direccion, eax
		}
		for (j = 0; j < 16; j++) {
			//tablaSaltos[0x34][j] = direccion; //S = 0!
			tablaSaltos[0x35][j] = direccion;
			//tablaSaltos[0x14][j] = direccion; //S = 0!
			tablaSaltos[0x15][j] = direccion;
		}

		__asm{
			lea eax, RUT_cmn
			mov direccion, eax
		}
		for (j = 0; j < 16; j++) {
			//tablaSaltos[0x36][j] = direccion; //S = 0!
			tablaSaltos[0x37][j] = direccion;
			//tablaSaltos[0x16][j] = direccion; //S = 0!
			tablaSaltos[0x17][j] = direccion;
		}

		__asm{
			lea eax, RUT_bbl
			mov direccion, eax
		}
		for (i = 0xA0; i <= 0xBF; i++){
			for (j = 0; j < 16; j++)
				tablaSaltos[i][j] = direccion;
		}

		__asm{
			lea eax, RUT_bx
			mov direccion, eax
		}
		tablaSaltos[0x12][0x1] = direccion;

		__asm{
			lea eax, RUT_ldr_pre
			mov direccion, eax
		}
		for (i = 0x51; i <= 0x5F; i+=2)
			for (j = 0; j < 16; j++)
				tablaSaltos[i][j] = direccion;
		for (i = 0x71; i <= 0x7F; i+=2)
			for (j = 0; j < 16; j++)
				tablaSaltos[i][j] = direccion;

		__asm{
			lea eax, RUT_str_pre
			mov direccion, eax
		}
		for (i = 0x50; i <= 0x5E; i+=2)
			for (j = 0; j < 16; j++)
				tablaSaltos[i][j] = direccion;
		for (i = 0x70; i <= 0x7E; i+=2)
			for (j = 0; j < 16; j++)
				tablaSaltos[i][j] = direccion;

		__asm{
			lea eax, RUT_ldr_post
			mov direccion, eax
		}
		for (i = 0x41; i <= 0x4F; i+=2)
			for (j = 0; j < 16; j++)
				tablaSaltos[i][j] = direccion;
		for (i = 0x61; i <= 0x6F; i+=2)
			for (j = 0; j < 16; j++)
				tablaSaltos[i][j] = direccion;

		__asm{
			lea eax, RUT_str_post
			mov direccion, eax
		}
		for (i = 0x40; i <= 0x4E; i+=2)
			for (j = 0; j < 16; j++)
				tablaSaltos[i][j] = direccion;
		for (i = 0x60; i <= 0x6E; i+=2)
			for (j = 0; j < 16; j++)
				tablaSaltos[i][j] = direccion;
		
		__asm{
			lea eax, RUT_ldr_hw_pre
			mov direccion, eax
		}
		for (i = 0x11; i <= 0x1F; i+=2){
			tablaSaltos[i][0xB] = direccion;
			tablaSaltos[i][0xD] = direccion;
			tablaSaltos[i][0xF] = direccion;
		}

		__asm{
			lea eax, RUT_ldr_hw_post
			mov direccion, eax
		}
		for (i = 0x01; i <= 0x0F; i+=2){
			tablaSaltos[i][0xB] = direccion;
			tablaSaltos[i][0xD] = direccion;
			tablaSaltos[i][0xF] = direccion;
		}

		__asm{
			lea eax, RUT_str_hw_pre
			mov direccion, eax
		}
		for (i = 0x10; i <= 0x1E; i+=2){
			tablaSaltos[i][0xB] = direccion;
		}

		__asm{
			lea eax, RUT_str_hw_post
			mov direccion, eax
		}
		for (i = 0x00; i <= 0x0E; i+=2){
			tablaSaltos[i][0xB] = direccion;
		}

		__asm{
			lea eax, RUT_ldm_pre
			mov direccion, eax
		}
		for (i = 0x91; i <= 0x9F; i+=2)
			for (j = 0; j < 16; j++)
				tablaSaltos[i][j] = direccion;

		__asm{
			lea eax, RUT_ldm_post
			mov direccion, eax
		}
		for (i = 0x81; i <= 0x8F; i+=2)
			for (j = 0; j < 16; j++)
				tablaSaltos[i][j] = direccion;

		__asm{
			lea eax, RUT_stm_pre
			mov direccion, eax
		}
		for (i = 0x90; i <= 0x9E; i+=2)
			for (j = 0; j < 16; j++)
				tablaSaltos[i][j] = direccion;

		__asm{
			lea eax, RUT_stm_post
			mov direccion, eax
		}
		for (i = 0x80; i <= 0x8E; i+=2)
			for (j = 0; j < 16; j++)
				tablaSaltos[i][j] = direccion;

		__asm{
			lea eax, RUT_swap
			mov direccion, eax
		}	
		tablaSaltos[0x10][0x9] = direccion;
		tablaSaltos[0x14][0x9] = direccion;

		__asm{
			lea eax, RUT_mul
			mov direccion, eax
		}
		tablaSaltos[0x00][0x9] = direccion;
		tablaSaltos[0x01][0x9] = direccion;
		tablaSaltos[0x02][0x9] = direccion;
		tablaSaltos[0x03][0x9] = direccion;

		__asm{
			lea eax, RUT_mull
			mov direccion, eax
		}
		for (i = 0x08; i <= 0x0F; i++) {
			tablaSaltos[i][0x9] = direccion;
		}

		__asm{
			lea eax, RUT_msr
			mov direccion, eax
		}
		tablaSaltos[0x12][0] = direccion;
		tablaSaltos[0x16][0] = direccion;
		for (i = 0x0; i <= 0xF; i++) {
			tablaSaltos[0x32][i] = direccion;
			tablaSaltos[0x36][i] = direccion;
		}

		__asm{
			lea eax, RUT_mrs
			mov direccion, eax
		}
		tablaSaltos[0x10][0] = direccion;
		tablaSaltos[0x14][0] = direccion;

		__asm{
			lea eax, RUT_swi
			mov direccion, eax
		}
		for (i = 0xF0; i <=0xFF; i++)
			for (j = 0x0; j <= 0xF; j++)
				tablaSaltos[i][j] = direccion;

		__asm{
			lea eax, RUT_codp
			mov direccion, eax
		}
		for (i = 0xE0; i <=0xEF; i++)
			for (j = 0x0; j <= 0xE; j+=2)
				tablaSaltos[i][j] = direccion;

		__asm{
			lea eax, RUT_cols
			mov direccion, eax
		}
		for (i = 0xC0; i <=0xDF; i++)
			for (j = 0x0; j <= 0xF; j++)
				tablaSaltos[i][j] = direccion;

		__asm{
			lea eax, RUT_cort
			mov direccion, eax
		}
		for (i = 0xE0; i <=0xEF; i++)
			for (j = 0x1; j <= 0xF; j+=2)
				tablaSaltos[i][j] = direccion;
			
		__asm{
			lea eax, RUT_undefined
			mov direccion, eax
		}
		for (j = 0; j < 16; j++) {
			tablaSaltos[0x30][j] = direccion;
			tablaSaltos[0x34][j] = direccion;
		}
		//Interfiere con LSRO:
		for (i = 0x60; i <= 0x7F; i++) {
			for (j=0x1; j <= 0xF; j+=2)
				tablaSaltos[i][j] = direccion;
		}

		for (i = 0x10; i <= 0x1E; i+=2){
			tablaSaltos[i][0xD] = direccion;
			tablaSaltos[i][0xF] = direccion;
		}
		for (i = 0x00; i <= 0x0E; i+=2){
			tablaSaltos[i][0xD] = direccion;
			tablaSaltos[i][0xF] = direccion;
		}

		tablaGenerada = 1;
	}