/*
    ARM9Core
    Copyright (C) 2007 Alberto Huerta Aranda,
	Sergio Hidalgo Serrano, Daniel Saudo Vacas

    This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 3 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
	License along with this library. If not, see <http://www.gnu.org/licenses/>

*/


#ifndef ARM9RutinasARMH
#define ARM9RutinasARMH

/**************************************************************************************

  Archivo: ARM9RutinasARM.h

  Descripcion: Codigo de las rutinas del modo ARM

**************************************************************************************/

#include "Utils.h"
#include "ARM9MacrosARM.h"

//Predefinicion de las clases para evitar referencias cruzadas
class ARM9Core;
class ARM9Contexto;


class ARM9RutinasARM {
protected:
	ARM9Core *core;
	ARM9Contexto *contexto;
	int tablaGenerada;
	void* tablaSaltos[256][16];

	bool tablaCond[16][16];	//[Opcode][CPSR]

public:
	
	ARM9RutinasARM ();
	int run (ARM9Core *core, ARM9Contexto *contexto, int nCiclos);

};


#endif