/*
    ARM9Core
    Copyright (C) 2007 Alberto Huerta Aranda,
	Sergio Hidalgo Serrano, Daniel Saudo Vacas

    This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 3 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
	License along with this library. If not, see <http://www.gnu.org/licenses/>

*/


#ifndef ARM9CoreH
#define ARM9CoreH

/**************************************************************************************

  Archivo: ARM9Core.h

  Descripcion:

**************************************************************************************/

//INCLUDES//
#define WIN32_LEAN_AND_MEAN
#include "windows.h"

#include "ARM9Contexto.h"
#include "ARM9RutinasARM.h"

class ARM9Core {

protected:
	//Contexto
	int numeroContextos; //y de cores
	ARM9Contexto *contextos;
	ARM9Contexto *contextoActual;
	
	//Clase que emula las instrucciones ARM
	ARM9RutinasARM rutinasARM;

	//Clase que emula las instrucciones THUMB
//	ARM9RutinasTHUMB rutinasTHUMB;

	//Interfaces de los coprocesadores (max 16)
	coproDP listaCoproDP[16];
	coproLS listaCoproLS[16];
	coproRT listaCoproRT[16];

	//Funcion externa
	void (*funcionExterna) (void);


	//Memoria
	int nRegiones;
	ARM9MemRegion *memoria;

	//Marcador de excepciones
	ARM9Exception excepcionActiva;
	int paramExcepcion;

	//Handler de interrupciones de software
	void (*excepHandler[6])(int n);

	//Indica si est emulando
	bool running;

	//Variables de sincronizacion
	LONGLONG frecuenciaX86;
	double tiempoInicio;
	double frecuenciaARM;


public:

	//Constructor
	ARM9Core();

	//Constructor
	ARM9Core(int numeroContextos);

	~ARM9Core();
	
	//Reset
	void reset();

	//Run
	void run(int nCiclos);
	//Step
	void step();

	//Stop
	void stop();

	void marcarExcepcion (ARM9Exception excepcion, int param = 0);
	void tratarExcepciones ();
	

	bool addMemoria (int nRegiones, ARM9MemRegion *lista);

	uint32 readInstruccion(uint32 direccion);

	uint32 readMemoriaWord(uint32 direccion);

	uint8 readMemoriaByte(uint32 direccion);

	uint16 readMemoriaHalfword(uint32 direccion);

	void writeMemoriaWord(uint32 datos, uint32 direccion);

	void writeMemoriaByte(uint8 datos, uint32 direccion);

	void writeMemoriaHalfword(uint16 datos, uint32 direccion);

	
	void setFrecuenciaARM (double f);

	void calcularFrecuenciaX86 ();
	double calcularTiempoX86 ();

	//getters y setters
	void setCores(int numeroCores);

	void setExcepHandler (ARM9Exception ex, void (*handler)(int n));
	void (*getExcepHandler(ARM9Exception ex))(int n);

	void setFuncionExterna (void (*func)(void));
	void (*getFuncionExterna())(void);

	void setCopro (int cpn, coproDP fdp, coproLS fls, coproRT frt);
	coproDP getCoproDP (int cpn);
	coproLS getCoproLS (int cpn);
	coproRT getCoproRT (int cpn);

	bool getRunning();

	ARM9Contexto *getContexto(int num=0);
	inline ARM9Exception getExcepcionActiva () {return excepcionActiva;}


};

#endif