#!/bin/bash
#===============================================================================
#                  uBee512 start-up script for portable media
#                     (c) Copyright 2008-2009 uBee
#
# Runs the uBee512 emulator from this disk's root directory. The uBee512
# binary to be run is determined by the host Unix system.
#
# This script supports Linux, FreeBSD and Mac OS X systems, others may be
# added. The FreeBSD and Mac OS X systems requires a uBee512 binary file
# added to the local directory './usr/local/bin/' with '.fbsd' or '.macosx'
# appended to it.  Other system binaries can be added in a similar manner.
#
# The '$*' represents all the command line parameters passed to this script.
#===============================================================================

# get the Unix host's POSIX system name
SYSTEM=`uname`

# some systems refuse to execute binaries from VFAT ? partitions so we copy
# to the users home account first and run from there.
if [ "$SYSTEM" = "Linux" ]; then
   cp ./usr/local/bin/ubee512 ~/ubee512.bin
fi

if [ "$SYSTEM" = "FreeBSD" ]; then
   cp ./usr/local/bin/ubee512.fbsd ~/ubee512.bin
fi

if [ "$SYSTEM" = "Darwin" ]; then
   cp ./usr/local/bin/ubee512.macosx ~/ubee512.bin
fi

# run the uBee512 emulator
~/ubee512.bin --account=./ubee512 --prefix=./ $*

# clean up
rm ~/ubee512.bin
