#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "Definicje.h"

#include "des.h"

  //--------------------------------------------------------------------------
  // procedury prywatne

  /** Zapamietanie klucza. */
static int Klucz (char *ciag);
  /** Obrcenie kolejnoci 8 bajtw. */
static void Obroc (void *wsk);
  //--------------------------------------------------------------------------

  //--------------------------------------------------------------------------
  // zmienne

  /** Klucz deszyfrujcy plik. */
static uint8_t s_klucz [8];
  /** Stan maszyny deszyfrujcej DES. */
static des_context s_DES;
  //--------------------------------------------------------------------------

  //--------------------------------------------------------------------------
int main (int ia, char *ta [])
  {
  FILE *we, *wy;
  int i, ile;
  uint8_t dane [8], wynik [8];
  char *nazwa;

  if (ia < 3)
    {
    printf ("Usage: %s <key> <file>\n", ta [0]);
    return -1;
    }

  if (Klucz (ta [1]))
    {
    printf ("Invalid key\n");
    return -1;
    }

  Obroc (s_klucz);
  des_set_key (&s_DES, s_klucz);

  we = fopen (ta [2], "rb");
  if (we == NULL)
    {
    printf ("Error opening file %s\n", ta [2]);
    return 1;
    }

  nazwa = new char [strlen (ta [2]) + 16];
  strcpy (nazwa, ta [2]);
  strcat (nazwa, ".dat");
  wy = fopen (nazwa, "wb");
  if (wy == NULL)
    {
    printf ("Error creating file %s\n", nazwa);
    return 1;
    }
  delete [] nazwa;

  printf ("Decrypting file %s, please wait...", ta [2]);

  while (!feof (we))
    {
    ile = fread (dane, 1, 8, we);
    if (ile == 0)
      break;

    Obroc (dane);
    des_decrypt (&s_DES, dane, wynik);
    Obroc (wynik);

    fwrite (wynik, 1, ile, wy);
    }

  printf (" done\n");

  fclose (wy);
  fclose (we);

  return FALSE;
  }
  //--------------------------------------------------------------------------

  //--------------------------------------------------------------------------
  /** Zapamietanie klucza. */
int Klucz (char *ciag)
  {
  int i, z;

  if (strlen (ciag) != 16)
    return TRUE;
  for (i = 0; i < 8; i++)
    {
    z = tolower (ciag [i * 2 + 0]);
    if (z >= '0' && z <= '9')
      z -= '0';
    else if (z >= 'a' && z <= 'f')
      z -= 'a' - 10;
    else
      return TRUE;
    s_klucz [i] = z << 4;
    z = tolower (ciag [i * 2 + 1]);
    if (z >= '0' && z <= '9')
      z -= '0';
    else if (z >= 'a' && z <= 'f')
      z -= 'a' - 10;
    else
      return TRUE;
    s_klucz [i] |= z;
    }
  return FALSE;
  }
  //--------------------------------------------------------------------------

  //--------------------------------------------------------------------------
  /** Obrcenie kolejnoci 8 bajtw. */
void Obroc (void *wsk)
  {
  uint32_t t, *v;

  v = (uint32_t *)wsk;
  t = BSWAP (v [0]);
  v [0] = BSWAP (v [1]);
  v [1] = t;
  }
  //--------------------------------------------------------------------------
