
#ifndef _Definicje_h_
#define _Definicje_h_

  //--------------------------------------------------------------------------
  // definicje

  /** Typy danych zgodne z C99. */
#include <stdint.h>
#include <inttypes.h>

  /** Definicja prawdy/faszu. */
#ifndef FALSE
  #define FALSE 0
#endif
#ifndef TRUE
  #define TRUE 1
#endif

  /** Definicja NULL. */
#ifndef NULL
  #ifdef __cplusplus
    #define NULL 0
  #else
    #define NULL ((void*)0)
  #endif
#endif

  /** Wyznaczanie iloci elementw tablicy. */
#ifndef countof
  #define countof(x) (sizeof (x) / sizeof (x [0]))
#endif

  /** Makra znajdowania minimum i maksimum. */
#ifndef MIN
  #define MIN(x,y) ((x) < (y) ? (x) : (y))
#endif
#ifndef MAX
  #define MAX(x,y) ((x) > (y) ? (x) : (y))
#endif
#ifndef CLAMP
  #define CLAMP(w,min,max) ((w) > (min) ? ((w) < (max) ? (w) : (max)) : (min))
#endif

  /** Konwersja kolejnoci zapisu bajtw w dwusowie. */
#ifdef WIN32
  #define BSWAP(w) ({ uint32_t n; asm ( "bswap %0" : "=r" (n) : "0" (w)); n; })
#else
  #define BSWAP(w) (((w & 0xff) << 24) | ((w & 0xff00) << 8) |\
 ((w >> 8) & 0xff00) | ((w >> 24) & 0xff))
#endif
  //--------------------------------------------------------------------------

#endif
