#include <stdlib.h>
#include <stdio.h>
#include "PAD.h"
#ifdef __WIN32__
#include "Win32.h"
#else
#include "Linux.h"
#endif

static char *PluginName = "MegaPad plugin (beta)";
static u32 PluginVersion = MAKE_VERSION(2, 0, 0);

_Config Config;

FILE *logf = NULL;

const u8 Cmd40Data[2][8] =	{{0xFF, 0x5A, 0x00, 0x00, 0x02, 0x00, 0x00, 0x5A},
				 			 {0xFF, 0x5A, 0x00, 0x00, 0x02, 0x00, 0x00, 0x5A}};
const u8 Cmd41Data[2][8] =	{{0xFF, 0x5A, 0xFF, 0xFF, 0x03, 0x00, 0x00, 0x5A},
							 {0xFF, 0x5A, 0xFF, 0xFF, 0x03, 0x00, 0x00, 0x5A}};
const u8 Cmd42Data[2][20] =	{{0xFF, 0x5A, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
							 {0xFF, 0x5A, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}};
const u8 Cmd43Data[2][20] =	{{0xFF, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
							 {0xFF, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}};
const u8 Cmd44Data[2][8] =	{{0xFF, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
				 			 {0xFF, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}};
const u8 Cmd45Data[2][8] =	{{0xFF, 0x5A, 0x03, 0x02, 0x00, 0x02, 0x01, 0x00},
							 {0xFF, 0x5A, 0x03, 0x02, 0x00, 0x02, 0x01, 0x00}};
const u8 Cmd46Data[2][8] =	{{0xFF, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
							 {0xFF, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}};
const u8 Cmd47Data[2][8] =	{{0xFF, 0x5A, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00},
							 {0xFF, 0x5A, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00}};
const u8 Cmd4CData[2][8] =	{{0xFF, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
				 			 {0xFF, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}};
const u8 Cmd4DData[2][8] =	{{0xFF, 0x5A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF},
							 {0xFF, 0x5A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF}};
const u8 Cmd4FData[2][8] =	{{0xFF, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5A},
				 			 {0xFF, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5A}};

u8 Cmd40Buf[2][8];
u8 Cmd41Buf[2][8];
u8 Cmd42Buf[2][20];
u8 Cmd43Buf[2][20];
u8 Cmd44Buf[2][8];
u8 Cmd45Buf[2][8];
u8 Cmd46Buf[2][8];
u8 Cmd47Buf[2][8];
u8 Cmd4CBuf[2][8];
u8 Cmd4DBuf[2][8];
u8 Cmd4FBuf[2][8];

u8 BtnMask[2][4];

u8 CurPad;
u8 CurCmd;
u8 CurByte;
u8 *CmdBuf;
u8 CmdLen;

u8 PadID[2];
u8 EscapeMode[2];

/* Logging */

void Log(char *fmt, ...)
{
	if((Config.logging == false) || (logf == NULL))
		return;

	va_list list;

	va_start(list, fmt);
	vfprintf(logf, fmt, list);
	va_end(list);
}

/* Config */

void SaveConfig()
{
	int i, j;
	FILE *f = fopen("./inis/MegaPad.ini", "w");
	if(f == NULL)
	{
		printf("MegaPad: error: cannot create the config file.\n\tMake sure the inis folder doesn't have the read-only attribute.\n");
		return;
	}

	fprintf(f, "MegaPad_Version = 0x%04X\n", (PluginVersion & 0xFFFF));

	fprintf(f, "Logging = %i\n", Config.logging);

	for(i = 0; i < 2; i++)
	{
		fprintf(f, "Pad%i_Enable = %i\n", i, Config.PadConfig[i].enable);
		fprintf(f, "Pad%i_EnableDSII = %i\n", i, Config.PadConfig[i].enable_dsII);

		for(j = 0; j < 25; j++)
		{
			fprintf(f, "Pad%i_Button%i = 0x%08X\n", i, j, Config.PadConfig[i].buttons[j]);
		}

		for(j = 0; j < 2; j++)
		{
			fprintf(f, "Pad%i_FF%i = 0x%08X\n", i, j, Config.PadConfig[i].ff[j]);
		}
	}

	fclose(f);
}

void LoadConfig()
{
	u16 plg_ver;
	char str[64];
	int i, j;
	FILE *f = fopen("./inis/MegaPad.ini", "r");
	if(f == NULL)
	{
		Config.logging = false;
		for(i = 0; i < 2; i++)
		{
			Config.PadConfig[i].enable = true;
			Config.PadConfig[i].enable_dsII = true;
			for(j = 0; j < 25; j++)
				Config.PadConfig[i].buttons[j] = 0x00000000;
			for(j = 0; j < 2; j++)
				Config.PadConfig[i].ff[j] = 0x00000000;
		}

		SaveConfig();
		return;
	}

	fscanf(f, "MegaPad_Version = 0x%04X\n", &plg_ver);
	if(plg_ver != (PluginVersion & 0xFFFF))
	{
		Config.logging = false;
		for(i = 0; i < 2; i++)
		{
			Config.PadConfig[i].enable = true;
			Config.PadConfig[i].enable_dsII = true;
			for(j = 0; j < 25; j++)
				Config.PadConfig[i].buttons[j] = 0x00000000;
			for(j = 0; j < 2; j++)
				Config.PadConfig[i].ff[j] = 0x00000000;
		}

		SaveConfig();
		return;
	}

	fscanf(f, "Logging = %i\n", &Config.logging);

	for(i = 0; i < 2; i++)
	{
		sprintf(str, "Pad%i_Enable = %%i\n", i);
		fscanf(f, str, &Config.PadConfig[i].enable);

		sprintf(str, "Pad%i_EnableDSII = %%i\n", i);
		fscanf(f, str, &Config.PadConfig[i].enable_dsII);

		for(j = 0; j < 25; j++)
		{
			sprintf(str, "Pad%i_Button%i = 0x%%08X\n", i, j);
			fscanf(f, str, &Config.PadConfig[i].buttons[j]);
		}

		for(j = 0; j < 2; j++)
		{
			sprintf(str, "Pad%i_FF%i = 0x%%08X\n", i, j);
			fscanf(f, str, &Config.PadConfig[i].ff[j]);
		}
	}

	fclose(f);
}

/* PS2 plugin interface */

char * CALLBACK PS2EgetLibName()
{
	return PluginName;
}

u32 CALLBACK PS2EgetLibType()
{
	return PS2E_LT_PAD;
}

u32 CALLBACK PS2EgetLibVersion2(u32 type)
{
	return (PluginVersion | (PS2E_PAD_VERSION << 16));
}

/* PAD functions */

s32 CALLBACK PADinit(u32 flags)
{
	if(logf == NULL)
	{
		logf = fopen("./logs/padLog.txt", "w");
	}

	return 0;
}

s32 CALLBACK PADopen(void *pDsp)
{
	LoadConfig();

	memcpy(Cmd40Buf, Cmd40Data, sizeof(Cmd40Buf));
	memcpy(Cmd41Buf, Cmd41Data, sizeof(Cmd41Buf));
	memcpy(Cmd42Buf, Cmd42Data, sizeof(Cmd42Buf));
	memcpy(Cmd43Buf, Cmd43Data, sizeof(Cmd43Buf));
	memcpy(Cmd44Buf, Cmd44Data, sizeof(Cmd44Buf));
	memcpy(Cmd45Buf, Cmd45Data, sizeof(Cmd45Buf));
	memcpy(Cmd46Buf, Cmd46Data, sizeof(Cmd46Buf));
	memcpy(Cmd47Buf, Cmd47Data, sizeof(Cmd47Buf));
	memcpy(Cmd4CBuf, Cmd4CData, sizeof(Cmd4CBuf));
	memcpy(Cmd4DBuf, Cmd4DData, sizeof(Cmd4DBuf));
	memcpy(Cmd4FBuf, Cmd4FData, sizeof(Cmd4FBuf));

	BtnMask[0][0] = 0xFF;
	BtnMask[0][1] = 0xFF;
	BtnMask[0][2] = 0x03;
	BtnMask[0][3] = 0x00;
	BtnMask[1][0] = 0xFF;
	BtnMask[1][1] = 0xFF;
	BtnMask[1][2] = 0x03;
	BtnMask[1][3] = 0x00;

	CurPad = 0;
	CurCmd = 0;
	CurByte = 0;
	CmdLen = 0;

	PadID[0] = 0x41;
	PadID[1] = 0x41;
	
	EscapeMode[0] = 0;
	EscapeMode[1] = 0;

	return Input_Open(pDsp);
}

void CALLBACK PADclose()
{
	Input_Close();
}

void CALLBACK PADshutdown()
{
	if(logf != NULL)
	{
		fclose(logf);
		logf = NULL;
	}
}

keyEvent * CALLBACK PADkeyEvent()
{
	return Input_KeyEvent();
}

u8 CALLBACK PADstartPoll(int pad)
{
	CurPad = (pad-1);
	CurByte = 0;

	Log("Start poll: command = %02X, reply = FF\n", pad);

	return 0xFF;
}

inline u8 getPollCmdLen()
{
	switch(PadID[CurPad])
	{
	case 0x41: return 4;
	case 0x73: return 8;
	case 0x79: return 20;
	default: return 0;
	}
}

/* Dualshock II reference: http://docs.google.com/View?docid=ddbmmwds_5cw4pk3 */
u8 _PADpoll(u8 value)
{
	if(CurByte == 0)
	{
		CurCmd = value;
		CurByte++;

		switch(CurCmd)
		{
		case 0x40:			/* Initialize pressure sensor */
			{
				CmdLen = 8;
				CmdBuf = Cmd40Buf[CurPad];
			}
			return 0xF3;

		case 0x41:			/* Get available polling results */
			{
				CmdLen = 8;
				CmdBuf = Cmd41Buf[CurPad];

				if(PadID[CurPad] == 0x41)
				{
					CmdBuf[2] = 0x00;
					CmdBuf[3] = 0x00;
					CmdBuf[4] = 0x00;
					CmdBuf[5] = 0x00;
				}
				else
				{
					CmdBuf[2] = BtnMask[CurPad][0];
					CmdBuf[3] = BtnMask[CurPad][1];
					CmdBuf[4] = BtnMask[CurPad][2];
					CmdBuf[5] = BtnMask[CurPad][3];
				}
			}
			return 0xF3;

		case 0x42:			/* Controller poll */
			{
				CmdLen = getPollCmdLen();
				CmdBuf = Cmd42Buf[CurPad];

				Input_Poll(CmdBuf, CurPad, CmdLen);
				
				EscapeMode[CurPad] = 0;
			}
			return PadID[CurPad];

		case 0x43:			/* Controller poll and Escape */
			{
				CmdLen = (EscapeMode[CurPad] ? 8 : getPollCmdLen());
				CmdBuf = Cmd43Buf[CurPad];

				Input_Poll(CmdBuf, CurPad, CmdLen);
			}
			return (EscapeMode[CurPad] ? 0xF3 : PadID[CurPad]);

		case 0x44:			/* Set major mode (Dualshock/Digital) */
			{
				CmdLen = 8;
				CmdBuf = Cmd44Buf[CurPad];
			}
			return 0xF3;

		case 0x45:			/* Read extended status 1 */
			{
				CmdLen = 8;
				CmdBuf = Cmd45Buf[CurPad];

				CmdBuf[4] = (((PadID[CurPad] & 0xF0) == 0x70) ? 0x01 : 0x00);
			}
			return 0xF3;

		case 0x46:			/* Read constant 1 */
			{
				CmdLen = 8;
				CmdBuf = Cmd46Buf[CurPad];
			}
			return 0xF3;

		case 0x47:			/* Read constant 2 */
			{
				CmdLen = 8;
				CmdBuf = Cmd47Buf[CurPad];
			}
			return 0xF3;

		case 0x4C:			/* Read constant 3 */
			{
				CmdLen = 8;
				CmdBuf = Cmd4CBuf[CurPad];
			}
			return 0xF3;

		case 0x4D:			/* Specify polling command format */
			{
				CmdLen = 8;
				CmdBuf = Cmd4DBuf[CurPad];
			}
			return 0xF3;

		case 0x4F:			/* Specify polling result format */
			{
				CmdLen = 8;
				CmdBuf = Cmd4FBuf[CurPad];

				PadID[CurPad] = 0x79;
			}
			return 0xF3;

		default:
			{
				printf("MegaPad: AAAAAAAAAAARRRRRRRRGGGGGGGGGGHHHHHHHHH!!!!!!!!!! UNKNOWN PAD COMMAND %02X\n", CurCmd);
				CmdLen = 1;
			}
			return 0x00;
		}
	}

	switch(CurCmd)
	{
	case 0x43:
		{
			if(CurByte == 2)
			{
				EscapeMode[CurPad] = (value == 1);
			}
		}
		break;

	case 0x44:
		{
			if(CurByte == 2)
			{
				PadID[CurPad] = ((value == 1) ? 0x73 : 0x41);
			}
		}
		break;

	case 0x46:
		{
			if(CurByte == 2)
			{
				if(value == 0x00)
				{
					CmdBuf[4] = 0x01;
					CmdBuf[5] = 0x02;
					CmdBuf[6] = 0x00;
					CmdBuf[7] = 0x0A;
				}
				else if(value == 0x01)
				{
					CmdBuf[4] = 0x01;
					CmdBuf[5] = 0x01;
					CmdBuf[6] = 0x01;
					CmdBuf[7] = 0x14;
				}
			}
		}
		break;

	case 0x4C:
		{
			if(CurByte == 2)
			{
				if(value == 0x00)
				{
					CmdBuf[5] = 0x04;
				}
				else if(value == 0x01)
				{
					CmdBuf[5] = 0x07;
				}
			}
		}
		break;

	case 0x4F:
		{
			if((CurByte >= 2) && (CurByte <= 5))
			{
				BtnMask[CurPad][CurByte-2] = value;
			}
		}
		break;
	}

	if(CurByte >= CmdLen) return 0x00;
	return CmdBuf[CurByte++];
}

u8 CALLBACK PADpoll(u8 value)
{
	u8 ret = _PADpoll(value);
	Log("Poll: command = %02X, reply = %02X\n", value, ret);
	return ret;
}

u32 CALLBACK PADquery()
{
	return 3;
}

void CALLBACK PADconfigure()
{
	Input_Configure();
}

void CALLBACK PADabout()
{
	MsgBox("MegaPad plugin 2.0.0\nPAD plugin for PCSX2, by NHerv");
}

s32 CALLBACK PADtest()
{
	return 0;
}
