#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <stdlib.h>
#include <stdio.h>
#define DIRECTINPUT_VERSION 0x0800
#include <dinput.h>
#include "PAD.h"
#include "Win32.h"
#include "resource.h"

HINSTANCE hInst;

LPDIRECTINPUT8			di8 = NULL;
LPDIRECTINPUTDEVICE8	di8keyboard = NULL;
LPDIRECTINPUTDEVICE8	di8joystick[5] = {NULL, NULL, NULL, NULL, NULL};
DIDEVCAPS				di8joycaps[5];
int						di8numjoys = 0;

keyEvent keyev;
u8 keybufOld[256];
u8 keybufNew[256];

/* DirectInput code */

BOOL CALLBACK AxesEnumCB(LPCDIDEVICEOBJECTINSTANCE instance, LPVOID param)
{
	DIPROPRANGE dipr;

	dipr.diph.dwSize = sizeof(DIPROPRANGE);
	dipr.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	dipr.diph.dwHow = DIPH_BYID;
	dipr.diph.dwObj = instance->dwType;
	dipr.lMin = -128;
	dipr.lMax = 127;

	((LPDIRECTINPUTDEVICE8)param)->SetProperty(DIPROP_RANGE, &dipr.diph);

	return DIENUM_CONTINUE;
}

static int curjoy = 0;
BOOL CALLBACK JoyEnumCB(LPCDIDEVICEINSTANCE instance, LPVOID param)
{
	if(curjoy == 5)
	{
		di8numjoys = 5;
		return DIENUM_STOP;
	}

	HRESULT hr;

	hr = di8->CreateDevice(GUID_Joystick, &di8joystick[curjoy], NULL);
	if(FAILED(hr))
	{
		di8joystick[curjoy] = NULL;
		return DIENUM_CONTINUE;
	}

	hr = di8joystick[curjoy]->SetDataFormat(&c_dfDIJoystick);
	if(FAILED(hr))
	{
		di8joystick[curjoy]->Release(); di8joystick[curjoy] = NULL;
		return DIENUM_CONTINUE;
	}

	hr = di8joystick[curjoy]->SetCooperativeLevel((HWND)param, (DISCL_FOREGROUND | DISCL_EXCLUSIVE));
	if(FAILED(hr))
	{
		di8joystick[curjoy]->Release(); di8joystick[curjoy] = NULL;
		return DIENUM_CONTINUE;
	}

	di8joycaps[curjoy].dwSize = sizeof(DIDEVCAPS);
	hr = di8joystick[curjoy]->GetCapabilities(&di8joycaps[curjoy]);
	if(FAILED(hr))
	{
		di8joystick[curjoy]->Release(); di8joystick[curjoy] = NULL;
		return DIENUM_CONTINUE;
	}

	hr = di8joystick[curjoy]->EnumObjects(AxesEnumCB, di8joystick[curjoy], DIDFT_AXIS);
	if(FAILED(hr))
	{
		di8joystick[curjoy]->Release(); di8joystick[curjoy] = NULL;
		return DIENUM_CONTINUE;
	}

	curjoy++;
	di8numjoys = curjoy;

	printf("-----------------------------------------\n");
	printf("MegaPad: joystick %i:\n", curjoy);
	printf("\t%s\n", instance->tszInstanceName);
	printf("\t%i buttons\n", di8joycaps[curjoy-1].dwButtons);
	printf("\t%i POVs\n", di8joycaps[curjoy-1].dwPOVs);
	printf("\t%i axes\n", di8joycaps[curjoy-1].dwAxes);
	printf("\tForce feedback: %s\n", ((di8joycaps[curjoy-1].dwFlags & DIDC_FORCEFEEDBACK) ? "yes":"no"));

	return DIENUM_CONTINUE;
}

BOOL DInputInit(HWND hwnd)
{
	HRESULT hr;

	hr = DirectInput8Create(hInst, DIRECTINPUT_VERSION, IID_IDirectInput8, (void**)&di8, NULL);
	if(FAILED(hr))
	{
		printf("MegaPad: error: failed to create the DirectInput8 object!\n");
		di8 = NULL;
		return FALSE;
	}



	hr = di8->CreateDevice(GUID_SysKeyboard, &di8keyboard, NULL);
	if(FAILED(hr))
	{
		printf("MegaPad: error: failed to create the DirectInput8 keyboard object!\n");
		di8keyboard = NULL;
		di8->Release(); di8 = NULL;
		return FALSE;
	}

	hr = di8keyboard->SetDataFormat(&c_dfDIKeyboard);
	if(FAILED(hr))
	{
		printf("MegaPad: error: failed to set data format for the DirectInput8 keyboard object!\n");
		di8keyboard->Release(); di8keyboard = NULL;
		di8->Release(); di8 = NULL;
		return FALSE;
	}

	hr = di8keyboard->SetCooperativeLevel(hwnd, (DISCL_FOREGROUND | DISCL_NONEXCLUSIVE));
	if(FAILED(hr))
	{
		printf("MegaPad: error: failed to set cooperative level for the DirectInput8 keyboard object!\n");
		di8keyboard->Release(); di8keyboard = NULL;
		di8->Release(); di8 = NULL;
		return FALSE;
	}



	di8numjoys = 0;
	curjoy = 0;

	hr = di8->EnumDevices(DI8DEVCLASS_GAMECTRL, JoyEnumCB, (void*)hwnd, DIEDFL_ATTACHEDONLY);
	if(FAILED(hr))
	{
		printf("MegaPad: error: failed to launch enumeration of joystick objects!\n");
		di8keyboard->Unacquire(); di8keyboard->Release(); di8keyboard = NULL;
		di8->Release(); di8 = NULL;
		return FALSE;
	}

	printf("-----------------------------------------\n");
	printf("MegaPad: found %i joysticks\n", di8numjoys);

	return TRUE;
}

void DInputShutdown()
{
	int i;

	for(i = 0; i < di8numjoys; i++)
	{
		if(di8joystick[i])
		{
			di8joystick[i]->Unacquire(); di8joystick[i]->Release(); di8joystick[i] = NULL;
		}
	}

	if(di8keyboard)
	{
		di8keyboard->Unacquire(); di8keyboard->Release(); di8keyboard = NULL;
	}

	if(di8)
	{
		di8->Release(); di8 = NULL;
	}
}


s32 Input_Open(void *param)
{
	if(!IsWindow(*(HWND*)param))
		return -1;

	memset(keybufOld, 0, sizeof(keybufOld));
	memset(keybufNew, 0, sizeof(keybufNew));

	if(!DInputInit(*(HWND*)param))
		return -1;

	return 0;
}

void Input_Close()
{
	DInputShutdown();
}

/* Key event handling */

keyEvent * Input_KeyEvent()
{
	int i;
	HRESULT hr;

	di8keyboard->Acquire();
	hr = di8keyboard->GetDeviceState(sizeof(keybufNew), (void*)&keybufNew);
	if(FAILED(hr))
		return NULL;

	for(i = 0; i < 256; i++)
	{
		if((keybufNew[i] & 0x80) ^ (keybufOld[i] & 0x80))
		{
			if(i == DIK_INSERT)
				keyev.key = VK_INSERT;
			else if(i == DIK_ESCAPE)
				keyev.key = VK_ESCAPE;
			else
				keyev.key = MapVirtualKey(i, 3);

			if(keybufNew[i] & 0x80)
				keyev.event = KEYPRESS;
			else
				keyev.event = KEYRELEASE;

			memcpy(keybufOld, keybufNew, sizeof(keybufOld));
			return &keyev;
		}
	}

	memcpy(keybufOld, keybufNew, sizeof(keybufOld));
	return NULL;
}

/* PS2 pad emulation */

void Input_Poll(u8 *buf, u8 pad, u8 len)
{
	int i;
	u16 btns = 0xFFFF;
	u8 rx = 0x80, ry = 0x80, lx = 0x80, ly = 0x80;
	u8 btn_press[12] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

	for(i = 0; i < 25; i++)
	{
		u32 v = Config.PadConfig[pad].buttons[i];

		switch(v & 0xFF000000)
		{
		case 0x01000000:
			{
				HRESULT hr;
				u8 keybuf[256];

				di8keyboard->Acquire();
				hr = di8keyboard->GetDeviceState(sizeof(keybuf), (void*)&keybuf);
				if(!FAILED(hr))
				{
					if(keybuf[(v >> 8) & 0xFF] & 0x80)
					{
						if(i < 16)
						{
							btns &= ~(1 << i);
							if(i >= 4)
								btn_press[i-4] = 255;
						}
						else
						{
							switch(i)
							{
							case 16:
								ly = 0x00;
								break;
							case 17:
								lx = 0xFF;
								break;
							case 18:
								ly = 0xFF;
								break;
							case 19:
								lx = 0x00;
								break;

							case 20:
								ry = 0x00;
								break;
							case 21:
								rx = 0xFF;
								break;
							case 22:
								ry = 0xFF;
								break;
							case 23:
								rx = 0x00;
								break;
							}
						}
					}
				}
			}
			break;

		case 0x02000000:
		case 0x03000000:
		case 0x04000000:
			{
				int jn = ((v >> 16) & 0xFF);
				HRESULT hr;
				DIJOYSTATE joystate;

				di8joystick[jn]->Acquire();
				hr = di8joystick[jn]->GetDeviceState(sizeof(joystate), (void*)&joystate);
				if(!FAILED(hr))
				{
					switch(v & 0xFF000000)
					{
					case 0x02000000:
						{
							if(joystate.rgbButtons[(v >> 8) & 0xFF] & 0x80)
							{
								if(i < 16)
								{
									btns &= ~(1 << i);
									if(i >= 4)
										btn_press[i-4] = 255;
								}
								else
								{
									switch(i)
									{
									case 16:
										ly = 0x00;
										break;
									case 17:
										lx = 0xFF;
										break;
									case 18:
										ly = 0xFF;
										break;
									case 19:
										lx = 0x00;
										break;

									case 20:
										ry = 0x00;
										break;
									case 21:
										rx = 0xFF;
										break;
									case 22:
										ry = 0xFF;
										break;
									case 23:
										rx = 0x00;
										break;
									}
								}
							}
						}
						break;

					case 0x03000000:
						{
							if((joystate.rgdwPOV[(v >> 8) & 0xFF] / 9000) == (v & 0xFF))
							{
								if(i < 16)
								{
									btns &= ~(1 << i);
									if(i >= 4)
										btn_press[i-4] = 255;
								}
								else
								{
									switch(i)
									{
									case 16:
										ly = 0x00;
										break;
									case 17:
										lx = 0xFF;
										break;
									case 18:
										ly = 0xFF;
										break;
									case 19:
										lx = 0x00;
										break;

									case 20:
										ry = 0x00;
										break;
									case 21:
										rx = 0xFF;
										break;
									case 22:
										ry = 0xFF;
										break;
									case 23:
										rx = 0x00;
										break;
									}
								}
							}
						}
						break;

					case 0x04000000:
						{
							int raxis = ((u32*)&joystate.lX)[(v >> 8) & 0xFF];
							int axis = 0;
							int press = 0;
							int dir = 2;

							if(raxis > 0)
							{
								dir = 0;
								axis = raxis;
								press = ((raxis * 2) + 1);
							}
							else if(raxis < 0)
							{
								dir = 1;
								axis = (-raxis - 1);
								press = ((-raxis * 2) - 1);
							}

							if(dir == (v & 0xFF))
							{
								if(i < 16)
								{
									btns &= ~(1 << i);
									if(i >= 4)
										btn_press[i-4] = press;
								}
								else
								{
									switch(i)
									{
									case 16:
										ly = (0x80 - axis);
										break;
									case 17:
										lx = (0x80 + axis);
										break;
									case 18:
										ly = (0x80 + axis);
										break;
									case 19:
										lx = (0x80 - axis);
										break;

									case 20:
										ry = (0x80 - axis);
										break;
									case 21:
										rx = (0x80 + axis);
										break;
									case 22:
										ry = (0x80 + axis);
										break;
									case 23:
										rx = (0x80 - axis);
										break;
									}
								}
							}
						}
						break;
					}
				}
			}
			break;
		}
	}

	buf[2] = (btns & 0xFF);
	buf[3] = (btns >> 8);

	if(len >= 8)
	{
		buf[4] = rx;
		buf[5] = ry;
		buf[6] = lx;
		buf[7] = ly;
	}

	if(len == 20)
	{
		buf[8] = btn_press[1];
		buf[9] = btn_press[3];
		buf[10] = btn_press[0];
		buf[11] = btn_press[2];
		buf[12] = btn_press[8];
		buf[13] = btn_press[9];
		buf[14] = btn_press[10];
		buf[15] = btn_press[11];
		buf[16] = btn_press[6];
		buf[17] = btn_press[7];
		buf[18] = btn_press[4];
		buf[19] = btn_press[5];
	}
}

/* Config dialog */

void FillDialog(HWND hwnd, int p)
{
	int i;

	CheckDlgButton(hwnd, IDC_ENABLEPAD, (Config.PadConfig[p].enable ? BST_CHECKED:BST_UNCHECKED));
	CheckDlgButton(hwnd, IDC_ENABLEFF, (Config.PadConfig[p].enable_dsII ? BST_CHECKED:BST_UNCHECKED));

	for(i = 0; i < 25; i++)
	{
		char str[64];
		u32 v = Config.PadConfig[p].buttons[i];

		switch(v & 0xFF000000)
		{
		case 0x00000000:
			{
				sprintf(str, "None");
			}
			break;

		case 0x01000000:
			{
				HRESULT hr;
				char kn[32];
				DIPROPSTRING dips;

				dips.diph.dwHeaderSize = sizeof(dips.diph);
				dips.diph.dwSize = sizeof(dips);
				dips.diph.dwHow = DIPH_BYOFFSET;
				dips.diph.dwObj = ((v >> 8) & 0xFF);

				hr = di8keyboard->GetProperty(DIPROP_KEYNAME, &dips.diph);

				if(FAILED(hr))
					sprintf(str, "DI Key #%i", i);
				else
					sprintf(str, "%ws", dips.wsz);
			}
			break;

		case 0x02000000:
			{
				sprintf(str, "Joy %i, button %i", ((v >> 16) & 0xFF)+1, ((v >> 8) & 0xFF)+1);
			}
			break;

		case 0x03000000:
			{
				char *pov_dirs[4] = {"up", "right", "down", "left"};
				sprintf(str, "Joy %i, POV %i, %s", ((v >> 16) & 0xFF)+1, ((v >> 8) & 0xFF)+1, pov_dirs[v & 0x03]);
			}
			break;

		case 0x04000000:
			{
				HRESULT hr;
				char *axis_dirs[2] = {"max", "min"};
				DIDEVICEOBJECTINSTANCE objinst;

				objinst.dwSize = sizeof(objinst);
				hr = di8joystick[(v >> 16) & 0xFF]->GetObjectInfo(&objinst, (DIDFT_ABSAXIS | DIDFT_MAKEINSTANCE((v >> 8) & 0xFF)), DIPH_BYID);

				if(FAILED(hr))
					sprintf(str, "Joy %i, axis %i, %s", ((v >> 16) & 0xFF)+1, ((v >> 8) & 0xFF)+1, axis_dirs[v & 0x01]);
				else
					sprintf(str, "Joy %i, %s, %s", ((v >> 16) & 0xFF)+1, objinst.tszName, axis_dirs[v & 0x01]);
			}
			break;
		}

		SetWindowText(GetDlgItem(hwnd, IDC_BTNINFO1+i), str);
	}

	CheckDlgButton(hwnd, IDC_LOGGING, (Config.logging ? BST_CHECKED:BST_UNCHECKED));
}

static int lockedbtn = -1;
INT_PTR CALLBACK CfgDlgProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	switch(msg)
	{
	case WM_INITDIALOG:
		{
			TCITEM tab;

			tab.mask = TCIF_TEXT;
			tab.pszText = "Pad 1";
			TabCtrl_InsertItem(GetDlgItem(hwnd, IDC_TAB), 0, &tab);

			tab.mask = TCIF_TEXT;
			tab.pszText = "Pad 2";
			TabCtrl_InsertItem(GetDlgItem(hwnd, IDC_TAB), 1, &tab);
			
			DInputInit(hwnd);

			LoadConfig();

			FillDialog(hwnd, 0);
		}
		return TRUE;

	case WM_CLOSE:
	case WM_DESTROY:
		{
			if(lockedbtn > -1)
			{
				KillTimer(hwnd, 0xBEEF);
				lockedbtn = -1;
			}

			DInputShutdown();

			EndDialog(hwnd, TRUE);
		}
		return TRUE;

	case WM_COMMAND:
		{
			int p = TabCtrl_GetCurSel(GetDlgItem(hwnd, IDC_TAB));
			int control = LOWORD(wparam);

			if((control >= IDC_BTNMAP1) && (control <= IDC_BTNMAP25))
			{
				if(lockedbtn > -1) EnableWindow(GetDlgItem(hwnd, lockedbtn), TRUE);
				lockedbtn = control;
				EnableWindow(GetDlgItem(hwnd, control), FALSE);
				SetTimer(hwnd, 0xBEEF, 10, NULL);
			}
			else
			switch(control)
			{
			case IDC_ENABLEPAD:
				{
					Config.PadConfig[p].enable = (IsDlgButtonChecked(hwnd, IDC_ENABLEPAD) == BST_CHECKED);
				}
				return TRUE;

			case IDC_ENABLEFF:
				{
					Config.PadConfig[p].enable_dsII = (IsDlgButtonChecked(hwnd, IDC_ENABLEFF) == BST_CHECKED);
				}
				return TRUE;

			case IDC_LOGGING:
				{
					Config.logging = (IsDlgButtonChecked(hwnd, IDC_LOGGING) == BST_CHECKED);
				}
				return TRUE;

			case IDOK:
				{
					SaveConfig();
				}
			case IDCANCEL:
				{
					SendMessage(hwnd, WM_CLOSE, 0, 0);
				}
				return TRUE;
			}
			
		}
		return TRUE;

	case WM_NOTIFY:
		{
			if(wparam == IDC_TAB)
			{
				FillDialog(hwnd, TabCtrl_GetCurSel(GetDlgItem(hwnd, IDC_TAB)));
			}
		}
		return TRUE;

	case WM_TIMER:
		{
			if(wparam == 0xBEEF)
			{
				int p = TabCtrl_GetCurSel(GetDlgItem(hwnd, IDC_TAB));
				int b = (lockedbtn-IDC_BTNMAP1);
				int i, j;
				u8 keybuf[256];

				HRESULT hr;

				di8keyboard->Acquire();
				hr = di8keyboard->GetDeviceState(sizeof(keybuf), (void*)&keybuf);
				if(!FAILED(hr))
				{
					for(i = 0; i < 256; i++)
					{
						/* Prevent the use of hotkeys */
						if((i >= DIK_F1) && (i <= DIK_F12)) continue;
						if(i == DIK_INSERT) continue;

						if(keybuf[i] & 0x80)
						{
							if(i == DIK_BACK)
							{
								Config.PadConfig[p].buttons[b] = 0x00000000;
								SetWindowText(GetDlgItem(hwnd, lockedbtn+26), "None");
							}
							else if(i != DIK_ESCAPE)
							{
								char kn[32];
								DIPROPSTRING dips;

								dips.diph.dwHeaderSize = sizeof(dips.diph);
								dips.diph.dwSize = sizeof(dips);
								dips.diph.dwHow = DIPH_BYOFFSET;
								dips.diph.dwObj = i;

								hr = di8keyboard->GetProperty(DIPROP_KEYNAME, &dips.diph);

								if(FAILED(hr))
									sprintf(kn, "DI Key #%i", i);
								else
									sprintf(kn, "%ws", dips.wsz);

								Config.PadConfig[p].buttons[b] = (0x01000000 | ((i & 0xFF) << 8));
								SetWindowText(GetDlgItem(hwnd, lockedbtn+26), kn);
							}

							EnableWindow(GetDlgItem(hwnd, lockedbtn), TRUE);
							KillTimer(hwnd, 0xBEEF);
							lockedbtn = -1;
							return TRUE;
						}
					}
				}

				for(j = 0; j < di8numjoys; j++)
				{
					int k;
					DIJOYSTATE joystate;

					di8joystick[j]->Acquire();
					hr = di8joystick[j]->GetDeviceState(sizeof(joystate), (void*)&joystate);
					if(FAILED(hr))
						continue;

					for(k = 0; k < di8joycaps[j].dwButtons; k++)
					{
						if(joystate.rgbButtons[k] & 0x80)
						{
							char bn[32];

							sprintf(bn, "Joy %i, button %i", j+1, k+1);

							Config.PadConfig[p].buttons[b] = (0x02000000 | ((j & 0xFF) << 16) | ((k & 0xFF) << 8));
							SetWindowText(GetDlgItem(hwnd, lockedbtn+26), bn);
							EnableWindow(GetDlgItem(hwnd, lockedbtn), TRUE);
							KillTimer(hwnd, 0xBEEF);
							lockedbtn = -1;
							return TRUE;
						}
					}

					for(k = 0; k < di8joycaps[j].dwPOVs; k++)
					{
						if(joystate.rgdwPOV[k] != -1)
						{
							char *pov_dirs[4] = {"up", "right", "down", "left"};
							char bn[32];

							sprintf(bn, "Joy %i, POV %i, %s", j+1, k+1, pov_dirs[joystate.rgdwPOV[k] / 9000]);

							Config.PadConfig[p].buttons[b] = (0x03000000 | ((j & 0xFF) << 16) | ((k & 0xFF) << 8) | ((joystate.rgdwPOV[k] / 9000) & 0xFF));
							SetWindowText(GetDlgItem(hwnd, lockedbtn+26), bn);
							EnableWindow(GetDlgItem(hwnd, lockedbtn), TRUE);
							KillTimer(hwnd, 0xBEEF);
							lockedbtn = -1;
							return TRUE;
						}
					}

					for(k = 0; k < 8; k++)
					{
						int axis = ((u32*)&joystate.lX)[k];

						if(axis > 64)
						{
							char bn[32];
							DIDEVICEOBJECTINSTANCE objinst;

							objinst.dwSize = sizeof(objinst);
							hr = di8joystick[j]->GetObjectInfo(&objinst, (DIDFT_ABSAXIS | DIDFT_MAKEINSTANCE(k)), DIPH_BYID);

							if(FAILED(hr))
								sprintf(bn, "Joy %i, axis %i, max", j+1, k+1);
							else
								sprintf(bn, "Joy %i, %s, max", j+1, objinst.tszName);

							Config.PadConfig[p].buttons[b] = (0x04000000 | ((j & 0xFF) << 16) | ((k & 0xFF) << 8) | 0x00);
							SetWindowText(GetDlgItem(hwnd, lockedbtn+26), bn);
							EnableWindow(GetDlgItem(hwnd, lockedbtn), TRUE);
							KillTimer(hwnd, 0xBEEF);
							lockedbtn = -1;
							return TRUE;
						}

						if(axis < -64)
						{
							char bn[32];
							DIDEVICEOBJECTINSTANCE objinst;

							objinst.dwSize = sizeof(objinst);
							hr = di8joystick[j]->GetObjectInfo(&objinst, (DIDFT_ABSAXIS | DIDFT_MAKEINSTANCE(k)), DIPH_BYID);

							if(FAILED(hr))
								sprintf(bn, "Joy %i, axis %i, min", j+1, k+1);
							else
								sprintf(bn, "Joy %i, %s, min", j+1, objinst.tszName);

							Config.PadConfig[p].buttons[b] = (0x04000000 | ((j & 0xFF) << 16) | ((k & 0xFF) << 8) | 0x01);
							SetWindowText(GetDlgItem(hwnd, lockedbtn+26), bn);
							EnableWindow(GetDlgItem(hwnd, lockedbtn), TRUE);
							KillTimer(hwnd, 0xBEEF);
							lockedbtn = -1;
							return TRUE;
						}
					}
				}
			}
		}
		return TRUE;
	}

	return FALSE;
}

void Input_Configure()
{
	DialogBox(hInst, MAKEINTRESOURCE(IDD_CFGDLG), HWND_DESKTOP, CfgDlgProc);
}

void MsgBox(char *fmt, ...)
{
	va_list list;
	char tmp[152];

	va_start(list, fmt);
	vsprintf(tmp, fmt, list);
	va_end(list);

	MessageBox(HWND_DESKTOP, tmp, "MegaPad", MB_OK);
}

BOOL APIENTRY DllMain(HINSTANCE hInstance, DWORD reason, LPVOID)
{
	switch(reason)
	{
	case DLL_PROCESS_ATTACH:
	case DLL_THREAD_ATTACH: hInst = hInstance; break;
	default: break;
	}

	return TRUE;
}
