//////////////////////////////////////////////////////////////////////////////
// DCTO9PDESASS.C - bote de dialogue pour le desassembleur
// Author   : Daniel Coulom - danielcoulom@gmail.com
// Web site : http://dcto9p.free.fr
// Created  : December 2007
//
// This file is part of DCTO9P v11.
// 
// DCTO9P v11 is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// DCTO9P v11 is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with DCTO9P v11.  If not, see <http://www.gnu.org/licenses/>.
//
//////////////////////////////////////////////////////////////////////////////

#include <SDL/SDL.h>
#include <SDL/SDL_ttf.h> 
#include <stdio.h>
#include <string.h>
#include "dcto9pglobal.h"

TTF_Font *mono10 = NULL;   //police d'ecriture mono taille 9
int startaddress = 0xf000; //adresse de debut du desassemblage
int nextaddress;           //adresse de la deuxieme instruction desassemblee
char string[256];    

button desassbutton[DESASSBUTTON_MAX] = {
{"[prev]",  10, 30, 0, 0, 90}, //0x00 
{"[next]",  10, 54, 0, 0, 91}, //0x01 
{"[prev]",  28, 30, 0, 0, 90}, //0x02 
{"[next]",  28, 54, 0, 0, 91}, //0x03 
{"[prev]",  46, 30, 0, 0, 90}, //0x04 
{"[next]",  46, 54, 0, 0, 91}, //0x05
{"[prev]",  64, 30, 0, 0, 90}, //0x06 
{"[next]",  64, 54, 0, 0, 91}, //0x07
{"[debut]", 10, 70, 0, 0, 98}, //0x08
{"[suite]", 10, 95, 0, 0, 99}  //0x09
};

extern int language;
extern int dialog;             //0 ou nboite de dialogue affichee
extern SDL_Surface *dialogbox; //surface d'affichage dialogbox
extern char *msg[LANG_MAX][MSG_MAX]; //messages en plusieurs langues
extern SDL_Surface *buttonsurface[][2];
extern const int blanc;
extern const SDL_Color textnoir;
extern SDL_Surface *textbox;

extern void Drawtextbox(SDL_Surface *surf, char *string, SDL_Rect rect, int c);
extern void SDL_error(int n);

//Affichage d'une ligne desassemblee /////////////////////////////////////////
void Drawdesass(SDL_Rect rect)
{
 SDL_Rect textrect;    
 int r;
 TTF_SetFontStyle(mono10, TTF_STYLE_NORMAL);
 SDL_FillRect(dialogbox, &rect, blanc);
 SDL_FreeSurface(textbox);
 textbox = TTF_RenderText_Blended(mono10, string, textnoir);
 if(textbox == NULL) {SDL_error(61); return;}
 textrect.x = -2; textrect.w = rect.w - 4;
 textrect.y = 0; textrect.h = rect.h;
 r = SDL_BlitSurface(textbox, &textrect, dialogbox, &rect);
 if(r < 0) SDL_error(62);
}

//Affichage du desassemblage a l'adresse startaddress /////////////////////////
void Displaydesass(int x)
{
 SDL_Rect rect; 
 SDL_Rect textrect;    
 int i, r;
 extern int Dasm6809(char *string, int a);
 TTF_SetFontStyle(mono10, TTF_STYLE_NORMAL);
 //adresse
 rect.x = 10; rect.y = 40; rect.w = 70; rect.h = 13;
 SDL_FillRect(dialogbox, &rect, blanc);
 sprintf(string, "%1x  %1x  %1x  %1x",
        (startaddress & 0xf000) >> 12, (startaddress & 0x0f00) >> 8,
        (startaddress & 0x00f0) >> 4, (startaddress & 0x000f)); 
 SDL_FreeSurface(textbox);
 textbox = TTF_RenderText_Blended(mono10, string, textnoir);
 if(textbox == NULL) {SDL_error(63); return;}
 textrect.x = -4; textrect.w = rect.w - 4;
 textrect.y = 0; textrect.h = rect.h;
 r = SDL_BlitSurface(textbox, &textrect, dialogbox, &rect);
 if(r < 0) SDL_error(64);
 //desassemblage
 rect.x = 90; rect.y = 15; rect.w = 300; rect.h = 15;
 for(i = 0; i < 20; i++)
 {
  rect.y += 15;     
  x = Dasm6809(string, x);
  if(i == 0) nextaddress = x;     
  Drawdesass(rect); 
 }
}

//Cration de la boite de dialogue du desassembleur ///////////////////////////
void Desass()
{
 SDL_Rect rect;
 int i;
 extern int pause6809;
 extern void Createdialogbox(int w, int h);
 extern void Initbuttonbackground(int n, int w, int h);
 pause6809 = 1;
 Createdialogbox(405, 345);
 //titre
 rect.x = 10; rect.w = dialogbox->w - 32;
 rect.y = 5; rect.h = 15;
 Drawtextbox(dialogbox, msg[language][32], rect, 13);
 //ajout du texte sur les boutons
 rect.x = 2; rect.y = 2; rect.w = 66; rect.h = 16;
 Initbuttonbackground(98, 70, 20);
 Initbuttonbackground(99, 70, 20);
 Drawtextbox(buttonsurface[98][0], msg[language][44], rect, 4); 
 Drawtextbox(buttonsurface[98][1], msg[language][44], rect, 4); 
 Drawtextbox(buttonsurface[99][0], msg[language][45], rect, 4); 
 Drawtextbox(buttonsurface[99][1], msg[language][45], rect, 4); 
 //dessin des boutons
 for(i = 0; i < DESASSBUTTON_MAX; i++)
 {
  rect.x = desassbutton[i].x; rect.y = desassbutton[i].y;
  SDL_BlitSurface(buttonsurface[desassbutton[i].n][0], NULL, dialogbox, &rect);
 }
 //affichage du desassemblage
 Displaydesass(startaddress);
 dialog = 5;     
 pause6809 = 0;
}     

//Traitement des clics des boutons de desassemblage ///////////////////////////
void Desassclick()
{
 SDL_Rect rect;
 int i, x, y;    
 extern int xmouse, ymouse;
 extern int dialog;
 extern SDL_Rect dialogrect; 
 extern void Displayscreen();

 //recherche du bouton du clic
 for(i = 0; i < DESASSBUTTON_MAX; i++)
 {
  x = dialogrect.x + desassbutton[i].x;     
  y = dialogrect.y + desassbutton[i].y;     
  if(xmouse > x) if(xmouse < (x + desassbutton[i].w))
  if(ymouse > y) if(ymouse < (y + desassbutton[i].h))
  break;
 }
 if(i >= DESASSBUTTON_MAX) return;
 //dessin du bouton enfonce
 rect.x = desassbutton[i].x; rect.y = desassbutton[i].y;
 SDL_BlitSurface(buttonsurface[desassbutton[i].n][1], NULL, dialogbox, &rect);
 Displayscreen();
 //traitement en fonction du bouton
 switch(i)
 {
  case  0: x = startaddress = (startaddress - 0x1000) & 0xffff;
           break;
  case  1: x = startaddress = (startaddress + 0x1000) & 0xffff;
           break;
  case  2: x = startaddress = (startaddress - 0x100) & 0xffff;
           break;
  case  3: x = startaddress = (startaddress + 0x100) & 0xffff;
           break;
  case  4: x = startaddress = (startaddress - 0x10) & 0xffff;
           break;
  case  5: x = startaddress = (startaddress + 0x10) & 0xffff;
           break;
  case  6: x = startaddress = (startaddress - 0x1) & 0xffff;
           break;
  case  7: x = startaddress = (startaddress + 0x1) & 0xffff;
           break;
  case  8: x = startaddress;           
           break;
  case  9: x = nextaddress;
           break;
 } 
 //dessin du bouton relache
 Displaydesass(x); SDL_Delay(200);
 SDL_BlitSurface(buttonsurface[desassbutton[i].n][0], NULL, dialogbox, &rect);
}
